/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceFileUI
extends AbstractChangeable
implements SelectionListener {
    private Button _sentToFileCheckBox;
    private Label _fileLabel;
    private Text _file;
    private Button _browseLocation;
    private Label _note;

    public Composite createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 2;
        layout.marginHeight = 25;
        layout.verticalSpacing = 6;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createHorizontalFill();
        result.setLayoutData((Object)data);
        this._sentToFileCheckBox = new Button(result, 32);
        this._sentToFileCheckBox.setText(UIPlugin.getResourceString("STR_SEND_TO_FILE"));
        this._sentToFileCheckBox.setToolTipText(UIPlugin.getResourceString("STR_SEND_TO_FILE_TOOPTIP"));
        data = new GridData();
        data.horizontalSpan = 3;
        this._sentToFileCheckBox.setLayoutData((Object)data);
        this._fileLabel = new Label(result, 0);
        this._fileLabel.setText(UIPlugin.getResourceString("PROFILE_FILE"));
        this._file = new Text(result, 2048);
        this._file.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._browseLocation = new Button(result, 0);
        this._browseLocation.setText(UIPlugin.getResourceString("BROWSE2"));
        this._note = new Label(result, 0);
        this._note.setText(UIPlugin.getResourceString("PROFILE_FILE_NOTE"));
        data = new GridData();
        data.horizontalSpan = 3;
        this._note.setLayoutData((Object)data);
        this._sentToFileCheckBox.addSelectionListener((SelectionListener)this);
        this._browseLocation.addSelectionListener((SelectionListener)this);
        this._file.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                TraceFileUI.this.changed();
            }

            public void keyReleased(KeyEvent e) {
                TraceFileUI.this.changed();
            }
        });
        this.initData();
        WorkbenchHelp.setHelp((Control)this._sentToFileCheckBox, (String)(UIPlugin.getPluginId() + ".sttf0000"));
        WorkbenchHelp.setHelp((Control)this._file, (String)(UIPlugin.getPluginId() + ".sttf0001"));
        return result;
    }

    public String getFile() {
        return this._file.getText();
    }

    public void setFile(String file) {
        this._file.setText(file);
    }

    public Button getExternalBox() {
        return this._sentToFileCheckBox;
    }

    public Text getFileText() {
        return this._file;
    }

    public boolean getSelection() {
        return this._sentToFileCheckBox.getSelection();
    }

    private void initData() {
        this._sentToFileCheckBox.setSelection(false);
        this.setEnabled(false);
        this._file.setText("");
    }

    public void setEnabled(boolean enable) {
        this._fileLabel.setEnabled(enable);
        this._file.setEnabled(enable);
        this._file.setEditable(enable);
        this._browseLocation.setEnabled(enable);
        this._note.setEnabled(enable);
    }

    public void setVisible(boolean enable) {
        this._sentToFileCheckBox.setVisible(enable);
        this._fileLabel.setVisible(enable);
        this._file.setVisible(enable);
        this._browseLocation.setVisible(enable);
        this._note.setVisible(enable);
    }

    private void showResourceDialog() {
        Shell shell = UIPlugin.getActiveWorkbenchWindow().getShell();
        String osName = System.getProperty("os.name");
        String oldFile = this._file.getText();
        String newFile = "";
        FileDialog dlg = new FileDialog(shell);
        dlg.setFilterExtensions(new String[]{"*.trcxml", "*"});
        dlg.open();
        String fileName = dlg.getFileName();
        if (fileName != null && !fileName.equals("")) {
            String result;
            if (fileName.indexOf(".") < 0) {
                fileName = fileName + ".trcxml";
            }
            String classpath = dlg.getFilterPath();
            if (osName != null && osName.startsWith("Windows") && classpath.endsWith(":")) {
                classpath = classpath + "\\";
            }
            newFile = classpath + File.separator + fileName;
            this._file.setText(newFile);
            File tempFile = new File(newFile.trim());
            if (tempFile.exists() && ((result = this.queryOverwrite(newFile.trim())).equals("NO") || result.equals("CANCEL"))) {
                if (newFile.equalsIgnoreCase(oldFile)) {
                    this._file.setText("");
                } else {
                    this._file.setText(oldFile);
                }
            }
        }
    }

    public String queryOverwrite(String pathString) {
        Path path = new Path(pathString);
        String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? MessageFormat.format(UIPlugin.getResourceString("PROFILE_FILE_APPEND_QUESTION"), pathString) : MessageFormat.format(UIPlugin.getResourceString("PROFILE_FILE_APPEND_NAMEPATH_QUESTION"), path.lastSegment(), path.removeLastSegments(1).toOSString());
        final MessageDialog dialog = new MessageDialog(this._browseLocation.getShell(), UIPlugin.getResourceString("QUESTION_DIALOG_TITLE"), null, messageString, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        String[] response = new String[]{"YES", "NO", "CANCEL"};
        this._browseLocation.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._sentToFileCheckBox) {
            this.setEnabled(this._sentToFileCheckBox.getSelection());
        } else if (e.widget == this._browseLocation) {
            this.showResourceDialog();
        }
        this.changed();
    }
}

