/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.filters;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.IFilterQueryProvider;
import org.eclipse.hyades.trace.ui.filters.IFilterViewer;
import org.eclipse.hyades.trace.ui.filters.internal.actions.FiltersSelectionAction;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;

public abstract class FilterTraceViewer
extends TraceViewer
implements IFilterViewer {
    private FilterInformationManager _fi;
    private IFilterQueryProvider _fqp;
    private String _contentDescription = null;
    private boolean _internalCall = false;

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.removeAll();
        this._fi = FilterInformationManager.instance(this);
        tbm.add((IAction)new FiltersSelectionAction(this._fi));
    }

    public void dispose() {
        if (this._fqp != null) {
            this._fqp.viewerDisposed();
        }
        this._fqp = null;
        super.dispose();
    }

    public void setFilterQueryProvider(IFilterQueryProvider filterQueryProvider) {
        this._fqp = filterQueryProvider;
    }

    public SimpleSearchQuery getCurrentFilter() {
        return this._fqp.getCurrentFilter();
    }

    public SimpleSearchQuery standardQuery() {
        return this._fqp.standardQuery();
    }

    public SimpleSearchQuery advancedQuery() {
        return this._fqp.advancedQuery();
    }

    public void updateAdvancedQuery(SimpleSearchQuery query, int advancedTabSelectionIndex) {
        this._fqp.updateAdvancedQuery(query, advancedTabSelectionIndex);
    }

    public void updateFilterAppliedDescription() {
        String filterAppliedName = this._fqp != null && this._fqp.getCurrentFilter() != null ? this._fqp.getCurrentFilter().getName() : UIPlugin.getResourceString("STR_ST_FILTER_NAME_APPLIED_NO_FILTER");
        if (this._contentDescription == null) {
            this._contentDescription = "";
        }
        String filterStr = TString.change(UIPlugin.getResourceString("STR_ST_FILTER_NAME_APPLIED_PREFIX"), "%1", filterAppliedName);
        this._internalCall = true;
        this.setContentDescription(this._contentDescription + "  (" + filterStr + " )");
        this._internalCall = false;
    }

    protected void setContentDescription(String description) {
        if (this._internalCall) {
            super.setContentDescription(description);
        } else {
            this._contentDescription = description;
            this.updateFilterAppliedDescription();
        }
    }
}

