/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.preferences;

import java.util.Set;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceViewOptionsUI;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceViewPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TraceViewOptionsUI _options;

    public TraceViewPreferencePage() {
        this.setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".tvpp0000"));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this._options = new TraceViewOptionsUI();
        this._options.createControl(composite);
        return composite;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return UIPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        store.setValue("display_projects", false);
        this._options.initializeValues();
    }

    public boolean performOk() {
        this.storeValues();
        UIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IWorkbenchWindow window = UIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage[] persps = window.getPages();
        int idx = 0;
        while (idx < persps.length) {
            IWorkbenchPage page;
            IViewPart view;
            if (persps[idx].getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective") && (view = (page = persps[idx]).findView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer")) != null) {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    public void run() {
                        PDProjectExplorer viewer = (PDProjectExplorer)view;
                        Tree tree = ((TreeViewer)viewer.getViewer()).getTree();
                        Set visible = UIUtil.getVisibleViewerNodes((TreeViewer)((TreeViewer)viewer.getViewer()));
                        tree.setRedraw(false);
                        TraceViewPreferencePage.this._options.storeValues();
                        viewer.updateActionBars();
                        viewer.refresh();
                        UIUtil.setVisibleViewerNodes((TreeViewer)((TreeViewer)viewer.getViewer()), (Set)visible);
                        tree.setRedraw(true);
                    }
                });
            }
            ++idx;
        }
    }
}

