/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceNodeUI;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.ui.internal.wizard.NewNodeWizard;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewNodeWizardPage
extends WizardPage
implements ModifyListener {
    protected TRCMonitor fMonitor;
    protected Object fNodeFile;
    protected TRCNode fNode;
    protected TraceLocationUI _locationUI;
    protected TraceNodeUI _nodeUI;

    public NewNodeWizardPage(String name) {
        super(name);
    }

    public NewNodeWizardPage(String name, TRCMonitor monitor, INavigator viewer) {
        super(name);
        this.setTitle(UIPlugin.getResourceString("CREATE_NEW_NODE"));
        this.setDescription(UIPlugin.getResourceString("CREATE_NEW_NODE_DESC"));
        this.fMonitor = monitor;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        content.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 500;
        content.setLayoutData((Object)gd);
        this._locationUI = new TraceLocationUI();
        this._locationUI.createControl(content);
        this._locationUI.setEnabled(false);
        this._nodeUI = new TraceNodeUI();
        this._nodeUI.createControl(content);
        this._nodeUI.getNodeNameUI().addModifyListener((ModifyListener)this);
        this._nodeUI.getAddressUI().addModifyListener((ModifyListener)this);
        this._nodeUI.getPortNumberUI().addModifyListener((ModifyListener)this);
        this._nodeUI.getHourUI().addModifyListener((ModifyListener)this);
        this._nodeUI.getMinUI().addModifyListener((ModifyListener)this);
        this._nodeUI.getSecUI().addModifyListener((ModifyListener)this);
        this._nodeUI.getMicSecUI().addModifyListener((ModifyListener)this);
        this.setPageComplete(false);
        this.setControl((Control)content);
        IResource selection = HyadesUtil.getSelectionFolder(((NewNodeWizard)this.getWizard()).getViewer());
        if (selection != null) {
            this._locationUI.setLocation(selection.getFullPath().toOSString());
        }
        if (this.fMonitor != null) {
            this._locationUI.setMonitor(this.fMonitor.getName());
        }
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".nhwp0000"));
    }

    public boolean finish() {
        String name = this._nodeUI.getNodeNameUI().getText().trim();
        String address = this._nodeUI.getAddressUI().getText().trim();
        String portNumber = this._nodeUI.getPortNumberUI().getText().trim();
        TRCNode node = null;
        node = !name.equals("") ? PDCoreUtil.createNode(this.fMonitor, name, portNumber) : PDCoreUtil.createNode(this.fMonitor, address, portNumber);
        if (node != null) {
            node.setDeltaTime(this._nodeUI.getDeltaTime());
        }
        return true;
    }

    public Object getNode() {
        return this.fNode;
    }

    private boolean pageComplete() {
        String name = this._nodeUI.getNodeNameUI().getText().trim();
        String address = this._nodeUI.getAddressUI().getText().trim();
        String port = this._nodeUI.getPortNumberUI().getText().trim();
        String hour = this._nodeUI.getHourUI().getText().trim();
        String min = this._nodeUI.getMinUI().getText().trim();
        String sec = this._nodeUI.getSecUI().getText().trim();
        String micsec = this._nodeUI.getMicSecUI().getText().trim();
        return !(name.equals("") && address.equals("") || Integer.parseInt(port) < 0 || !hour.equals("") && Integer.parseInt(hour) < 0 || !min.equals("") && (Integer.parseInt(min) < 0 || Integer.parseInt(min) >= 60) || !sec.equals("") && (Integer.parseInt(sec) < 0 || Integer.parseInt(sec) >= 60) || !micsec.equals("") && (Integer.parseInt(micsec) < 0 || Integer.parseInt(micsec) >= 1000000));
    }

    public void modifyText(ModifyEvent event) {
        String message;
        String fileName = null;
        this.setPageComplete(true);
        String name = this._nodeUI.getNodeNameUI().getText().trim();
        String address = this._nodeUI.getAddressUI().getText().trim();
        String port = this._nodeUI.getPortNumberUI().getText().trim();
        if (event.widget == this._nodeUI.getNodeNameUI()) {
            fileName = name;
            this.setPageComplete(this.pageComplete());
        } else if (event.widget == this._nodeUI.getAddressUI()) {
            fileName = address;
            this.setPageComplete(this.pageComplete());
            fileName = "[" + fileName + "]";
        } else if (event.widget == this._nodeUI.getPortNumberUI()) {
            try {
                int value = Integer.parseInt(port);
                if (value < 0) {
                    this.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                    this.setPageComplete(this.pageComplete());
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(this.pageComplete());
            }
            catch (NumberFormatException nfe) {
                this.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                this.setPageComplete(false);
            }
        } else if (event.widget == this._nodeUI.getHourUI()) {
            try {
                int minValue = Integer.parseInt(this._nodeUI.getHourUI().getText().trim());
                if (minValue < 0) {
                    String message2 = StringUtil.change((String)UIPlugin.getResourceString("INVALID_DELTA_FORMAT"), (String)"%1", (String)"0");
                    message2 = StringUtil.change((String)message2, (String)"%2", (String)"999");
                    this.setErrorMessage(message2);
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(this.pageComplete());
            }
            catch (NumberFormatException e) {
                if (this._nodeUI.getHourUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                message = StringUtil.change((String)UIPlugin.getResourceString("INVALID_DELTA_FORMAT"), (String)"%1", (String)"0");
                message = StringUtil.change((String)message, (String)"%2", (String)"999");
                this.setErrorMessage(message);
                this.setPageComplete(false);
            }
        } else if (event.widget == this._nodeUI.getMinUI()) {
            try {
                int minValue = Integer.parseInt(this._nodeUI.getMinUI().getText().trim());
                if (minValue < 0 || minValue > 59) {
                    String message3 = StringUtil.change((String)UIPlugin.getResourceString("INVALID_DELTA_FORMAT"), (String)"%1", (String)"0");
                    message3 = StringUtil.change((String)message3, (String)"%2", (String)"59");
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(this.pageComplete());
            }
            catch (NumberFormatException e) {
                if (this._nodeUI.getMinUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                message = StringUtil.change((String)UIPlugin.getResourceString("INVALID_DELTA_FORMAT"), (String)"%1", (String)"0");
                message = StringUtil.change((String)message, (String)"%2", (String)"59");
                this.setPageComplete(false);
            }
        } else if (event.widget == this._nodeUI.getSecUI()) {
            try {
                int minValue = Integer.parseInt(this._nodeUI.getSecUI().getText().trim());
                if (minValue < 0 || minValue > 59) {
                    String message4 = StringUtil.change((String)UIPlugin.getResourceString("INVALID_DELTA_FORMAT"), (String)"%1", (String)"0");
                    message4 = StringUtil.change((String)message4, (String)"%2", (String)"59");
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(this.pageComplete());
            }
            catch (NumberFormatException e) {
                if (this._nodeUI.getSecUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                message = StringUtil.change((String)UIPlugin.getResourceString("INVALID_DELTA_FORMAT"), (String)"%1", (String)"0");
                message = StringUtil.change((String)message, (String)"%2", (String)"59");
                this.setPageComplete(false);
            }
        } else if (event.widget == this._nodeUI.getMicSecUI()) {
            try {
                int micsecValue = Integer.parseInt(this._nodeUI.getMicSecUI().getText().trim());
                if (micsecValue < 0 || micsecValue > 1000000) {
                    String message5 = StringUtil.change((String)UIPlugin.getResourceString("INVALID_DELTA_FORMAT"), (String)"%1", (String)"0");
                    message5 = StringUtil.change((String)message5, (String)"%2", (String)"999999");
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(this.pageComplete());
            }
            catch (NumberFormatException e) {
                if (this._nodeUI.getMicSecUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                message = StringUtil.change((String)UIPlugin.getResourceString("INVALID_DELTA_FORMAT"), (String)"%1", (String)"0");
                message = StringUtil.change((String)message, (String)"%2", (String)"999999");
                this.setPageComplete(false);
            }
        }
        if (this.isPageComplete()) {
            this.setErrorMessage(null);
            EList nodes = this.fMonitor.getNodes();
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                TRCNode node = (TRCNode)i.next();
                if (node.eIsProxy() || !node.getName().equals(fileName)) continue;
                String msg = UIPlugin.getResourceString("NODE_ALD_EXIST");
                msg = TString.change(msg, "%1", fileName);
                msg = TString.change(msg, "%2", this.fMonitor.getName());
                this.setErrorMessage(msg);
                this.setPageComplete(false);
                return;
            }
        }
    }
}

