/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ColumnData;
import org.eclipse.hyades.log.ui.internal.util.DoubleCList;
import org.eclipse.hyades.log.ui.internal.util.LogAnalyzerUI;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CBESortUI
extends LogAnalyzerUI {
    private DoubleCList _doubleList;
    private ArrayList _sourceList = new ArrayList();
    private ArrayList _targetList = new ArrayList();
    private ArrayList _pdSortData = new ArrayList();
    private Text _sortString;
    private Composite composite;

    public CBESortUI(IPreferenceStore store) {
        super(store);
    }

    public Control createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout());
        GridData data = GridUtil.createFill();
        data.widthHint = 370;
        this.composite.setLayoutData((Object)data);
        Label description = new Label(this.composite, 0);
        description.setLayoutData((Object)GridUtil.createHorizontalFill());
        description.setText(LogUIPlugin.getResourceString("SORT_DIALOG_DESCR"));
        this._doubleList = new DoubleCList(this.composite, 0, "", LogUIPlugin.getResourceString("SORT_SOURCE_LIST_DESCR"), LogUIPlugin.getResourceString("SORT_TARGET_LIST_DESCR"));
        this._sortString = new Text(this.composite, 578);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 3;
        data.heightHint = 30;
        this._sortString.setLayoutData((Object)data);
        this._sortString.setEditable(false);
        this._doubleList.addSelectionListener(this);
        return this.composite;
    }

    public boolean storeValues() {
        this._doubleList.removeSelectionListener(this);
        return this.applyValues(this._store);
    }

    public boolean applyValues(IPreferenceStore store) {
        String uiPrefString = this.getPreferenceString();
        store.setValue("pd_sort_log_options", uiPrefString);
        return !store.getString("pd_sort_log_options").equals(uiPrefString);
    }

    public boolean hasSortChanged() {
        return !this._store.getString("pd_sort_log_options").equals(this.getPreferenceString());
    }

    public String getPreferenceString() {
        this._pdSortData.clear();
        Object[] source = this._doubleList.getSourceItems().toArray();
        Object[] target = this._doubleList.getTargetItems().toArray();
        int idx = 0;
        while (idx < source.length) {
            this._pdSortData.add(new ColumnData(source[idx].toString(), false));
            ++idx;
        }
        int kdx = 0;
        while (kdx < target.length) {
            this._pdSortData.add(new ColumnData(target[kdx].toString(), true));
            ++kdx;
        }
        return ColumnData.getPreferenceString(this._pdSortData);
    }

    protected void populateList() {
        this._sourceList.clear();
        this._targetList.clear();
        ColumnData sortItem = null;
        Object data = null;
        int idx = 0;
        while (idx < this._pdSortData.size()) {
            sortItem = (ColumnData)this._pdSortData.get(idx);
            if (sortItem.visible()) {
                this._targetList.add(sortItem.name());
            } else {
                this._sourceList.add(sortItem.name());
            }
            ++idx;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        this.setSortString();
    }

    private void setSortString() {
        String sort = "";
        StringBuffer sortBuffer = new StringBuffer();
        Object[] target = this._doubleList.getTargetItems().toArray();
        int idx = 0;
        while (idx < target.length) {
            sortBuffer.append(", ");
            sortBuffer.append(target[idx].toString());
            ++idx;
        }
        String criteria = LogUIPlugin.getResourceString("STR_SORT_CRITERIA");
        if (sortBuffer.length() > 0) {
            sortBuffer.insert(1, criteria);
            sortBuffer.insert(criteria.length() + 1, "<");
            sortBuffer.append(">");
            sort = sortBuffer.substring(1);
        } else {
            sortBuffer.append(LogUIPlugin.getResourceString("STR_SORT_CRITERIA"));
            sortBuffer.append("<>");
            sort = sortBuffer.toString();
        }
        this._sortString.setText(sort);
    }

    public void initializeValues(boolean defaultValue) {
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        String pdSort = defaultValue ? store.getDefaultString("pd_sort_log_options") : store.getString("pd_sort_log_options");
        this.createColumnDataFromString(pdSort, this._pdSortData);
        this.populateList();
        this._doubleList.removeAll();
        this._doubleList.initializeSourceList(this._sourceList);
        this._doubleList.initializeTargetList(this._targetList);
        this.setSortString();
    }
}

