/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.HashMap;
import java.util.List;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFilterProvider;
import org.eclipse.hyades.log.ui.internal.util.CBEAdvFilterUI;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.FilterOptionsUI;
import org.eclipse.hyades.log.ui.internal.util.LogFilterCriteria;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class FiltersDialog
extends Dialog {
    private CBEAdvFilterUI _filters;
    private FilterOptionsUI _options;
    private static final int _restoreDefaultsButtonId = 1025;
    private Composite optionsComposite;
    private boolean showOptions = false;
    private ILogFilterProvider logFilterProvider = null;
    private LogFilterCriteria criteria = null;
    private String _title;

    public FiltersDialog(Shell shell, String windowTitle, Image windowImage, ILogFilterProvider logFilterProvider, boolean showOptions) {
        super(shell);
        this._title = windowTitle;
        Window.setDefaultImage((Image)windowImage);
        this.logFilterProvider = logFilterProvider;
        this.showOptions = showOptions;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        result.setLayoutData((Object)data);
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        this._filters = new CBEAdvFilterUI(this.showOptions ? 1 : 0, LogUIPlugin.getDefault().getPreferenceStore());
        this._filters.createControl(result);
        this._filters.initializeValues(false);
        this._options = new FilterOptionsUI();
        this.optionsComposite = this._options.createControl(result);
        this.initializeOptionsComposite();
        if (this.showOptions) {
            WorkbenchHelp.setHelp((Control)result, (String)ContextIds.LOGINTER_VIEW_DIALOG_FILTER);
        } else {
            WorkbenchHelp.setHelp((Control)result, (String)ContextIds.ACTLOG_VIEW_DIALOG_FILTER);
        }
        return result;
    }

    private void initializeOptionsComposite() {
        this.optionsComposite.setVisible(this.showOptions);
        if (this.showOptions) {
            this._options.initializeValues(false);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, LogUIPlugin.getResourceString("STR_COL_DLG_RESTORE_DEFAULTS"), false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this._filters.initializeValues(true);
            this._options.initializeValues(true);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        boolean filterChanged = this._filters.storeValues();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("correlated", this._options.getShowCorrelationButton().getSelection() ? "1" : "0");
        if (this.showOptions && !LogUIPlugin.getDefault().getPreferenceStore().getString("pd_filter_show_correlation_only").equals(options.get("correlated"))) {
            filterChanged = true;
        }
        if (this.showOptions) {
            this._options.storeValues();
        }
        this.criteria = new LogFilterCriteria();
        List filters = this._filters.getFilterList().getFilters();
        int s = filters.size();
        this.criteria.setFilters(filters.toArray(new IFilterElement[s]));
        this.criteria.setFilterOptions(options);
        if (this.logFilterProvider != null && filterChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(5, this.logFilterProvider));
        }
        super.okPressed();
    }
}

