/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.filters.BasicFeatureFilterAttribute;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.ui.HyadesUIPlugin;

public class CreationTimeFeatureFilterAttribute
extends BasicFeatureFilterAttribute {
    public CreationTimeFeatureFilterAttribute(String id, String displayText, EStructuralFeature feature) {
        super(id, displayText, feature, new RelationalOperators[]{RelationalOperators.get((int)2), RelationalOperators.get((int)5), RelationalOperators.get((int)1), RelationalOperators.get((int)0), RelationalOperators.get((int)4), RelationalOperators.get((int)3)}, false);
    }

    public CreationTimeFeatureFilterAttribute(String id, String displayText) {
        this(id, displayText, (EStructuralFeature)CBEPackage.eINSTANCE.getCBECommonBaseEvent_CreationTime());
    }

    private String getDateToMicroSeconds(String value) {
        String beValue = null;
        SimpleDateFormat dateFormat = null;
        String endOfValue = value.substring(20);
        dateFormat = endOfValue.indexOf("+") > 0 || endOfValue.indexOf("-") > 0 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSz");
        try {
            Date date = dateFormat.parse(value);
            beValue = Double.toString(date.getTime() * 1000L);
        }
        catch (Exception e) {
            HyadesUIPlugin.logError((Throwable)e);
        }
        return beValue;
    }

    private String getMicroSecondsToDate(String rawValue) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SZ");
        Date date = new Date(new Double(Double.valueOf(rawValue) / 1000.0).longValue());
        return dateFormat.format(date);
    }

    protected String getValueFromDisplayValue(String value) {
        return this.getDateToMicroSeconds(value);
    }

    protected String getDisplayValue(String value) {
        return this.getMicroSecondsToDate(value);
    }

    public String defaultValue() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SZ");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public String validate(String operator, String value) {
        String[] values = this.getValues(value);
        int i = 0;
        while (i < values.length) {
            if (this.getDateToMicroSeconds(values[i]) == null) {
                String errorMsg = TString.change((String)UIPlugin.getResourceString((String)"STR_ST_FILTER_INVALID_TYPE_FOR_ATTRIBUTE"), (String)"%1", (String)values[i]);
                errorMsg = TString.change((String)errorMsg, (String)"%2", (String)this.displayText());
                return errorMsg;
            }
            ++i;
        }
        return null;
    }
}

