/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.cbe.impl.CBEPackageImpl;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.trace.ui.internal.filters.ModelUtils;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportLogFiltersStandardUI
extends FiltersStandardTabUI {
    public static final String RANGE_BY_EVENTCOUNT_OR_SECONDSCOUNT_BINARY_EXPR_NAME = "internal.rangeByEventCountOrSecondsCount";
    public static final String EVENTCOUNT_OPERAND_NAME = "internal.events";
    public static final String SECONDSCOUNT_OPERAND_NAME = "internal.seconds";
    private static EAttribute ATTRIBUTE_SEVERITY_CONTROL = CBEPackageImpl.init().getCBECommonBaseEvent_Severity();
    private static String[] VALUES_SEVERITY_ERROR = new String[]{"50", "70"};
    private static String[] VALUES_SEVERITY_WARNING = new String[]{"30", "49"};
    private static String[] VALUES_SEVERITY_INFORMATION = new String[]{"0", "29"};
    private static EAttribute ATTRIBUTE_CREATION_TIME = CBEPackageImpl.init().getCBECommonBaseEvent_CreationTime();
    private static EClass ATTRIBUTE_EVENTS = CBEPackageImpl.init().getCBECommonBaseEvent();
    private static EAttribute[] comboAttributes = new EAttribute[]{CBEPackageImpl.init().getCBECommonBaseEvent_CreationTime()};
    private static RelationalOperators OPERATOR_GT = RelationalOperators.get((int)1);
    private static RelationalOperators OPERATOR_LT = RelationalOperators.get((int)0);
    private static RelationalOperators OPERATOR_BETWEEN = RelationalOperators.get((int)8);
    private Combo orderCombo;
    private Text lengthText;
    private Combo typeOfDurationCombo;
    private Button errorSeverityControl;
    private Button warningSeverityControl;
    private Button informationSeverityControl;
    private Button filterByTimeOrEventsControl;
    private Button filterBySeverityControl;

    public Control createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout());
        Composite timeEventsContainer = this.createCompositeWithNumberColumns(content, 1);
        this.filterByTimeOrEventsControl = new Button(timeEventsContainer, 32);
        this.filterByTimeOrEventsControl.setLayoutData((Object)new GridData());
        this.filterByTimeOrEventsControl.setText(LogUIPlugin.getResourceString("STR_FILTER_BY_EVENTS_ONLY_LABEL"));
        this.filterByTimeOrEventsControl.setSelection(true);
        this.filterByTimeOrEventsControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportLogFiltersStandardUI.this.filterByTimeEventsUpdate();
            }
        });
        Composite comboBoxContainers = this.createCompositeWithNumberColumns(timeEventsContainer, 4);
        Label showLabel = new Label(comboBoxContainers, 1);
        showLabel.setText(LogUIPlugin.getResourceString("STR_FILTER_BY_SHOW"));
        this.orderCombo = new Combo(comboBoxContainers, 2056);
        this.orderCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.orderCombo.add(LogUIPlugin.getResourceString("STR_FILTER_BY_COMBO_ORDER1"));
        this.orderCombo.add(LogUIPlugin.getResourceString("STR_FILTER_BY_COMBO_ORDER2"));
        this.orderCombo.select(0);
        this.orderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.lengthText = new Text(comboBoxContainers, 2048);
        this.lengthText.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.lengthText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent key) {
                if (!ImportLogFiltersStandardUI.this.isInt(ImportLogFiltersStandardUI.this.lengthText.getText().trim())) {
                    ImportLogFiltersStandardUI.this.setError(LogUIPlugin.getResourceString("STR_FILTER_NOT_VALID_INTEGER"));
                } else {
                    ImportLogFiltersStandardUI.this.noError();
                }
            }
        });
        this.typeOfDurationCombo = new Combo(comboBoxContainers, 2056);
        this.typeOfDurationCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.typeOfDurationCombo.add(LogUIPlugin.getResourceString("STR_FILTER_BY_COMBO_EVENTS"));
        this.typeOfDurationCombo.add(LogUIPlugin.getResourceString("STR_FILTER_BY_COMBO_SECONDS"));
        this.typeOfDurationCombo.add(LogUIPlugin.getResourceString("STR_FILTER_BY_COMBO_MINUTES"));
        this.typeOfDurationCombo.add(LogUIPlugin.getResourceString("STR_FILTER_BY_COMBO_HOURS"));
        this.typeOfDurationCombo.select(0);
        this.typeOfDurationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        Composite filterBySeverityContainer = this.createCompositeWithNumberColumns(content, 1);
        this.filterBySeverityControl = new Button(filterBySeverityContainer, 32);
        this.filterBySeverityControl.setLayoutData((Object)new GridData());
        this.filterBySeverityControl.setText(LogUIPlugin.getResourceString("STR_FILTER_BY_SEVERITY_LABEL"));
        this.filterBySeverityControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportLogFiltersStandardUI.this.filterBySeverityControlUpdate();
            }
        });
        Composite severityTypeContainer = this.createCompositeWithNumberColumns(filterBySeverityContainer, 2);
        Label showLabel2 = new Label(severityTypeContainer, 0);
        showLabel2.setText(LogUIPlugin.getResourceString("STR_FILTER_BY_SEVERITY_SHOW"));
        this.errorSeverityControl = new Button(severityTypeContainer, 32);
        this.errorSeverityControl.setLayoutData((Object)new GridData());
        this.errorSeverityControl.setText(LogUIPlugin.getResourceString("STR_FILTER_BY_SEVERITY_ERRORS"));
        this.errorSeverityControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        Label blankLabel1 = new Label(severityTypeContainer, 0);
        this.warningSeverityControl = new Button(severityTypeContainer, 32);
        this.warningSeverityControl.setLayoutData((Object)new GridData());
        this.warningSeverityControl.setText(LogUIPlugin.getResourceString("STR_FILTER_BY_SEVERITY_WARNINGS"));
        this.warningSeverityControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        Label blankLabel2 = new Label(severityTypeContainer, 0);
        this.informationSeverityControl = new Button(severityTypeContainer, 32);
        this.informationSeverityControl.setLayoutData((Object)new GridData());
        this.informationSeverityControl.setText(LogUIPlugin.getResourceString("STR_FILTER_BY_SEVERITY_INFORMATION"));
        this.informationSeverityControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        return content;
    }

    private Composite createCompositeWithNumberColumns(Composite parent, int numColumns) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)GridUtil.createHorizontalFill());
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        container.setLayout((Layout)layout);
        return container;
    }

    private void initializeTimeOrEvents(SimpleSearchQuery filter) {
        this.filterByTimeOrEventsControl.setSelection(false);
        this.lengthText.setText("10");
        if (filter.getWhereExpression() != null && filter.getWhereExpression() instanceof LogicalExpression) {
            LogicalExpression logicalExpression = (LogicalExpression)filter.getWhereExpression();
            EList filterElements = logicalExpression.getArguments();
            int i = 0;
            while (i < filterElements.size()) {
                BinaryExpression be;
                Object filterElement = filterElements.get(i);
                if (filterElement instanceof BinaryExpression && RANGE_BY_EVENTCOUNT_OR_SECONDSCOUNT_BINARY_EXPR_NAME.equals((be = (BinaryExpression)filterElement).getName())) {
                    this.filterByTimeOrEventsControl.setSelection(true);
                    Operand leftOperand = be.getLeftOperand();
                    RelationalOperators operator = be.getOperator();
                    SimpleOperand rightOperand = (SimpleOperand)be.getRightOperands().get(0);
                    if (RelationalOperators.get((int)0).equals(operator)) {
                        this.orderCombo.select(1);
                    } else {
                        this.orderCombo.select(0);
                    }
                    int value = Integer.parseInt(rightOperand.getValue().toString());
                    if (EVENTCOUNT_OPERAND_NAME.equals(leftOperand.getName())) {
                        this.typeOfDurationCombo.select(0);
                    } else if (value % 3600 == 0) {
                        this.typeOfDurationCombo.select(3);
                        value /= 3600;
                    } else if (value % 60 == 0) {
                        this.typeOfDurationCombo.select(2);
                        value /= 60;
                    } else {
                        this.typeOfDurationCombo.select(1);
                    }
                    if (rightOperand.getValue() != null) {
                        this.lengthText.setText(new Integer(value).toString());
                    }
                }
                ++i;
            }
        }
        this.filterByTimeEventsUpdate();
    }

    public void initializeFrom(SimpleSearchQuery filter) {
        this.filterBySeverityControl.setSelection(false);
        this.errorSeverityControl.setSelection(false);
        this.warningSeverityControl.setSelection(false);
        this.informationSeverityControl.setSelection(false);
        this.initializeTimeOrEvents(filter);
        if (filter.getWhereExpression() != null && filter.getWhereExpression() instanceof LogicalExpression) {
            LogicalExpression logicalExpression = (LogicalExpression)filter.getWhereExpression();
            EList filterElements = logicalExpression.getArguments();
            int i = 0;
            while (i < filterElements.size()) {
                Object filterElement = filterElements.get(i);
                if (filterElement instanceof LogicalExpression) {
                    this.filterBySeverityControl.setSelection(true);
                    EList arguments = ((LogicalExpression)filterElement).getArguments();
                    int j = 0;
                    while (j < arguments.size()) {
                        BinaryExpression be = (BinaryExpression)arguments.get(j);
                        EStructuralFeature feature = ((SimpleOperand)be.getLeftOperand()).getFeature();
                        RelationalOperators operator = be.getOperator();
                        String value = ((SimpleOperand)be.getRightOperands().get(0)).getRawValue();
                        if (feature.equals(ATTRIBUTE_SEVERITY_CONTROL)) {
                            if (VALUES_SEVERITY_ERROR[0].equals(value)) {
                                this.errorSeverityControl.setSelection(true);
                            } else if (VALUES_SEVERITY_WARNING[0].equals(value)) {
                                this.warningSeverityControl.setSelection(true);
                            } else if (VALUES_SEVERITY_INFORMATION[0].equals(value)) {
                                this.informationSeverityControl.setSelection(true);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.filterBySeverityControlUpdate();
    }

    private Double convertFromSeconds(Double seconds) {
        return seconds;
    }

    private Double convertToSeconds(Double time) {
        return time;
    }

    private Double getNumber(String str) {
        return new Double(Double.parseDouble(str));
    }

    private boolean isNumber(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private int getIntInSeconds(String str) {
        int i = Integer.parseInt(str);
        if (this.typeOfDurationCombo.getSelectionIndex() == 2) {
            return i * 60;
        }
        if (this.typeOfDurationCombo.getSelectionIndex() == 3) {
            return i * 3600;
        }
        return i;
    }

    private boolean isInt(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private void applyTimeOrEvents(LogicalExpression logicalExpression) {
        if (this.filterByTimeOrEventsControl.getSelection()) {
            BinaryExpression be = ExtensionsFactory.eINSTANCE.createBinaryExpression();
            be.setName(RANGE_BY_EVENTCOUNT_OR_SECONDSCOUNT_BINARY_EXPR_NAME);
            SimpleOperand leftOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
            if (this.typeOfDurationCombo.getSelectionIndex() == 0) {
                leftOperand.setName(EVENTCOUNT_OPERAND_NAME);
            } else {
                leftOperand.setName(SECONDSCOUNT_OPERAND_NAME);
            }
            be.setLeftOperand((Operand)leftOperand);
            if (this.orderCombo.getSelectionIndex() == 1) {
                be.setOperator(RelationalOperators.get((int)0));
            } else {
                be.setOperator(RelationalOperators.get((int)1));
            }
            SimpleOperand rightOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
            rightOperand.setValue((Object)new Integer(this.getIntInSeconds(this.lengthText.getText().trim())));
            be.getRightOperands().add((Object)rightOperand);
            logicalExpression.getArguments().add((Object)be);
        }
    }

    public SimpleSearchQuery performApply() {
        SimpleSearchQuery filter = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
        this.applyTimeOrEvents(logicalExpression);
        if (this.filterBySeverityControl.getSelection()) {
            LogicalExpression severityLogicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
            severityLogicalExpression.setOperator(LogicalOperators.OR_LITERAL);
            EList arguments = severityLogicalExpression.getArguments();
            if (this.errorSeverityControl.getSelection()) {
                arguments.add((Object)ModelUtils.createBinaryExpression((EStructuralFeature)ATTRIBUTE_SEVERITY_CONTROL, (RelationalOperators)OPERATOR_BETWEEN, (String[])VALUES_SEVERITY_ERROR, (boolean)false));
            }
            if (this.warningSeverityControl.getSelection()) {
                arguments.add((Object)ModelUtils.createBinaryExpression((EStructuralFeature)ATTRIBUTE_SEVERITY_CONTROL, (RelationalOperators)OPERATOR_BETWEEN, (String[])VALUES_SEVERITY_WARNING, (boolean)false));
            }
            if (this.informationSeverityControl.getSelection()) {
                arguments.add((Object)ModelUtils.createBinaryExpression((EStructuralFeature)ATTRIBUTE_SEVERITY_CONTROL, (RelationalOperators)OPERATOR_BETWEEN, (String[])VALUES_SEVERITY_INFORMATION, (boolean)false));
            }
            if (arguments.size() == 0) {
                severityLogicalExpression.setOperator(LogicalOperators.AND_LITERAL);
                arguments.add((Object)ModelUtils.createBinaryExpression((EStructuralFeature)ATTRIBUTE_SEVERITY_CONTROL, (RelationalOperators)OPERATOR_GT, (String)"0", (boolean)false));
                arguments.add((Object)ModelUtils.createBinaryExpression((EStructuralFeature)ATTRIBUTE_SEVERITY_CONTROL, (RelationalOperators)OPERATOR_LT, (String)"0", (boolean)false));
            }
            logicalExpression.getArguments().add((Object)severityLogicalExpression);
        }
        filter.setWhereExpression((WhereExpression)logicalExpression);
        return filter;
    }

    private void filterBySeverityControlUpdate() {
        boolean filterBySeverity = this.filterBySeverityControl.getSelection();
        this.errorSeverityControl.setEnabled(filterBySeverity);
        this.warningSeverityControl.setEnabled(filterBySeverity);
        this.informationSeverityControl.setEnabled(filterBySeverity);
    }

    private void filterByTimeEventsUpdate() {
        boolean filterByTimeOrEvents = this.filterByTimeOrEventsControl.getSelection();
        this.orderCombo.setEnabled(filterByTimeOrEvents);
        this.lengthText.setEnabled(filterByTimeOrEvents);
        this.typeOfDurationCombo.setEnabled(filterByTimeOrEvents);
    }
}

