/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.FeatureNode;
import org.eclipse.hyades.log.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.log.ui.internal.util.LogFilterCriteria;
import org.eclipse.hyades.log.ui.internal.util.RecordFilterSearchUtil;
import org.eclipse.hyades.log.ui.internal.util.SortElement;
import org.eclipse.hyades.log.ui.internal.util.Sorter;
import org.eclipse.hyades.log.ui.internal.util.TerminalNode;
import org.eclipse.hyades.log.ui.internal.util.TreeNode;
import org.eclipse.hyades.log.ui.internal.views.LogViewer;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEDefaultEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.cbe.util.LogQueryBuilder;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria;
import org.eclipse.hyades.models.hierarchy.util.ISortElement;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.models.hierarchy.util.internal.QueryUtils;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.filters.internal.dialogs.FilterUIUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.widgets.Shell;

public class LogContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private int _visible = 0;
    private int _total = 0;
    private ViewForm _viewer;
    private String _title = LogUIPlugin.getResourceString("STR_LOG_PANE_TITLE");
    private Sorter sorter;
    private LogViewer _logViewer;
    private RecordFilterSearchUtil recordFilterSearch = null;
    private int _currentPage = 0;
    private int _totalPages = 0;
    private int PAGE_SIZE = 100;
    private final String ASSOCIATED_EVENTS = "associatedEvents";
    private List sortAttributes;
    private String filters;
    private List filterTableElements;
    private int _visible_roots;
    private int _total_roots;
    private List allElements;
    private boolean filterSevOne;
    private boolean filterSevTwo;
    private boolean filterSevThree;
    private boolean pageActionCalled = false;
    private Query query;
    private IAction analyzeAction;
    private ILogFilterCriteria criteria;
    private CorrelationContainerProxy input;
    private boolean bAnalyzed = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$hyades$models$hierarchy$AbstractDefaultEvent;

    public LogContentProvider(ViewForm viewer, LogViewer logViewer) {
        this._viewer = viewer;
        this._logViewer = logViewer;
        this.recordFilterSearch = new RecordFilterSearchUtil();
    }

    public void dispose() {
        this.reset();
        this.recordFilterSearch = null;
        this._viewer = null;
        this._logViewer = null;
    }

    public Object[] getChildren(Object parentElement) {
        return this.getElementsAll(parentElement).toArray();
    }

    public List getPageList(Object inputElement) {
        PerfUtil p = new PerfUtil("getPageList", true);
        ArrayList pagedList = new ArrayList();
        String pgSize = HierarchyPlugin.getPlugin().getPluginPreferences().getString("VIEW_PAGE_SIZE");
        if (pgSize != null) {
            try {
                this.PAGE_SIZE = Integer.parseInt(pgSize);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.isModelChanged() || this.prepareFiltersAndSortAttributes()) {
            this.rebuildAllElements(inputElement);
            this._visible_roots = this._visible;
            this._total_roots = this._total;
            this._totalPages = this._visible / this.PAGE_SIZE;
            this._totalPages = this._visible % this.PAGE_SIZE > 0 && this._visible > 0 ? this._totalPages + 1 : this._totalPages;
            this._currentPage = Math.max(1, this._currentPage);
            this._currentPage = Math.min(this._totalPages, this._currentPage);
            if (this._visible < this.PAGE_SIZE || this._visible == 0) {
                return this.allElements;
            }
            int startPos = (this._currentPage - 1) * this.PAGE_SIZE;
            int endPos = Math.min(this._currentPage * this.PAGE_SIZE, this._visible);
            int i = startPos;
            while (i < endPos) {
                Object element = this.allElements.get(i);
                pagedList.add(element);
                ++i;
            }
        } else {
            this._visible = this._visible_roots;
            this._total = this._total_roots;
            this._totalPages = this._visible / this.PAGE_SIZE;
            this._totalPages = this._visible % this.PAGE_SIZE > 0 && this._visible > 0 ? this._totalPages + 1 : this._totalPages;
            this._currentPage = Math.max(1, this._currentPage);
            this._currentPage = Math.min(this._totalPages, this._currentPage);
            if (this._visible < this.PAGE_SIZE || this._visible == 0) {
                return this.allElements;
            }
            int startPos = (this._currentPage - 1) * this.PAGE_SIZE;
            int endPos = Math.min(this._currentPage * this.PAGE_SIZE, this._visible);
            int i = startPos;
            while (i < endPos) {
                Object element = this.allElements.get(i);
                pagedList.add(element);
                ++i;
            }
        }
        p.stopAndPrintStatus();
        return pagedList;
    }

    protected void analyze() {
        block2: {
            if (this.analyzeAction == null || this.bAnalyzed) break block2;
            try {
                this.analyzeAction.run();
            }
            catch (Exception e) {
                LogUIPlugin.log(e);
            }
        }
    }

    public void setAnalyzed(boolean newValue) {
        this.bAnalyzed = newValue;
    }

    public void setAnalyzeAction(IAction r) {
        this.analyzeAction = r;
    }

    public Object[] getElements(Object inputElement) {
        List pagedList = this.getPageList(inputElement);
        this.setTitle();
        this.updatePageActions();
        this.analyze();
        return pagedList.toArray();
    }

    public boolean isInputXMI(Object inputElement) {
        List agentProxies = (List)HyadesUtil.getLogAgents((EObject)((EObject)inputElement));
        int s = agentProxies.size();
        TRCAgentProxy proxy = null;
        TRCAgent agent = null;
        int i = 0;
        while (i < s) {
            proxy = (TRCAgentProxy)agentProxies.get(i);
            agent = (TRCAgent)proxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
            if (agent != null && EcoreUtil.getURI((EObject)agent).path().endsWith("xmi")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void rebuildAllElements(Object inputElement) {
        if (!(inputElement instanceof EObject)) {
            this.allElements = new ArrayList();
            this._visible = 0;
            this._total = 0;
            return;
        }
        List agentProxies = (List)HyadesUtil.getLogAgents((EObject)((EObject)inputElement));
        if (this.isInputXMI(inputElement)) {
            this.rebuildAllElementsXMI(agentProxies.toArray(new TRCAgentProxy[agentProxies.size()]));
        } else {
            this.rebuildAllElementsSQL(agentProxies);
        }
    }

    private SimpleSearchQuery getQueryForSQL(List agentProxies) {
        SimpleSearchQuery filter = this._logViewer.getCurrentFilter();
        if (filter == null) {
            filter = QueryUtils.getEmptyQuery();
        } else if (filter instanceof TimeBasedCorrelationQuery) {
            SimpleSearchQuery tbcq = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
            tbcq.setCount(filter.isCount());
            tbcq.setDistinct(filter.isDistinct());
            tbcq.setMaxElements(filter.getMaxElements());
            tbcq.setName(filter.getName());
            tbcq.setStartWith(filter.getStartWith());
            tbcq.setWhereExpression(filter.getWhereExpression());
            tbcq.getOutputElements().addAll((Collection)filter.getOutputElements());
            tbcq.getOrderByExpresions().addAll((Collection)filter.getOrderByExpresions());
            tbcq.getSources().addAll((Collection)filter.getSources());
            tbcq.getSubQuery().addAll((Collection)filter.getSubQuery());
            filter = tbcq;
        }
        SimpleOperand Operand2 = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        Operand2.setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
        filter.getOutputElements().add((Object)Operand2);
        int s = agentProxies.size();
        int i = 0;
        while (i < s) {
            block7: {
                EObject inputObject;
                block6: {
                    inputObject = (EObject)agentProxies.get(i);
                    if (!(inputObject instanceof TRCAgentProxy)) break block6;
                    TRCAgent agent = (TRCAgent)((TRCAgentProxy)inputObject).eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
                    if (agent == null) break block7;
                    String uri = EcoreUtil.getURI((EObject)agent).toString();
                    if (filter.getSources().contains((Object)uri)) break block7;
                    filter.getSources().add((Object)uri);
                    break block7;
                }
                if (inputObject instanceof CorrelationContainerProxy) {
                    Iterator iter = ((CorrelationContainerProxy)inputObject).getCorrelatedAgents().iterator();
                    while (iter.hasNext()) {
                        TRCAgentProxy agentProxy = (TRCAgentProxy)iter.next();
                        TRCAgent agent = (TRCAgent)agentProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
                        if (agent == null) continue;
                        String uri = EcoreUtil.getURI((EObject)agent).toString();
                        if (filter.getSources().contains((Object)uri)) continue;
                        filter.getSources().add((Object)uri);
                    }
                }
            }
            ++i;
        }
        filter.setDistinct(true);
        filter.getOrderByExpresions().addAll((Collection)LogQueryBuilder.createOrderByClause((EClass)CBEPackage.eINSTANCE.getCBECommonBaseEvent(), (ISortElement[])this.getFilterCriteria().getSortColumns()));
        return filter;
    }

    private void rebuildAllElementsSQL(List agentProxies) {
        try {
            List countList;
            if (agentProxies.size() == 0) {
                this.allElements = new ArrayList();
                this._visible = 0;
                this._total = 0;
                return;
            }
            Iterator iter = agentProxies.iterator();
            while (iter.hasNext()) {
                TRCAgentProxy element = (TRCAgentProxy)iter.next();
                element.getAgent();
            }
            this.query = FilterUIUtil.ENABLE_NEW_FILTERING && FilterUIUtil.ENABLE_NEW_FILTERING_FOR_SQL ? this.getQueryForSQL(agentProxies) : LogQueryBuilder.createQuery((List)agentProxies, (ILogFilterCriteria)this.getFilterCriteria());
            if (this.query == null) {
                this.allElements = new ArrayList();
                this._visible = 0;
                this._total = 0;
                return;
            }
            SimpleSearchQuery countAllQuery = (SimpleSearchQuery)EcoreUtil.copy((EObject)this.query);
            countAllQuery.setCount(true);
            QueryResult queryResult = LogQueryBuilder.executeQuery((Query)this.query, (ResourceSet)HierarchyResourceSetImpl.getInstance());
            this._visible = 0;
            this._total = 0;
            if (queryResult == null) {
                this.allElements = new ArrayList();
                this._visible = 0;
                this._total = 0;
                return;
            }
            ResultEntry resultEntry = null;
            if (queryResult.getResultEntries().size() > 0) {
                resultEntry = (ResultEntry)queryResult.getResultEntries().get(0);
                this.allElements = (List)resultEntry.getValue();
                this._visible = this.allElements.size();
            }
            countAllQuery.setWhereExpression(null);
            countAllQuery.getOrderByExpresions().clear();
            queryResult = LogQueryBuilder.executeQuery((Query)countAllQuery, (ResourceSet)HierarchyResourceSetImpl.getInstance());
            if (queryResult == null) {
                this.allElements = new ArrayList();
                this._visible = 0;
                this._total = 0;
                return;
            }
            if (queryResult.getResultEntries().size() > 0 && (countList = (List)(resultEntry = (ResultEntry)queryResult.getResultEntries().get(0)).getValue()).size() > 0) {
                this._total = (Integer)countList.get(0);
            }
        }
        catch (Exception e) {
            LogUIPlugin.log(e);
            Status errorStatus = new Status(4, "org.eclipse.core.resources", 566, e.getLocalizedMessage(), (Throwable)e);
            ErrorDialog.openError((Shell)LogUIPlugin.getActiveWorkbenchShell(), (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)LogUIPlugin.getResourceString("ERROR_LOADING_LOG_RECORDS"), (IStatus)errorStatus);
            this.allElements = new ArrayList();
            this._visible = 0;
            this._total = 0;
        }
    }

    private void rebuildAllElementsXMI(Object inputElement) {
        this.allElements = this.getElementsAll(inputElement);
        ((ArrayList)this.allElements).trimToSize();
    }

    private boolean isModelChanged() {
        if (this.allElements == null || this._logViewer.isHandlingRefresh()) {
            this.prepareFiltersAndSortAttributes();
            return true;
        }
        return false;
    }

    private void updatePageActions() {
        try {
            this.pageActionCalled = false;
            this._logViewer.getPageUpAction().setEnabled(this._currentPage - 1 > 0);
            this._logViewer.getPageDownAction().setEnabled(this._totalPages - this._currentPage > 0);
            this._logViewer.getGotPageAction().setEnabled(this._totalPages > 1);
        }
        catch (Exception e) {}
    }

    public List getElementsAll(Object element) {
        ArrayList<TerminalNode> wlist = new ArrayList<TerminalNode>();
        this._visible = 0;
        this._total = 0;
        if (element instanceof TRCAgentProxy) {
            this.getAgentRecords((TRCAgentProxy)element, wlist);
        } else if (element instanceof TRCAgentProxy[]) {
            this.getAgentRecords((TRCAgentProxy[])element, wlist);
        } else if (element instanceof EObject && ((EObject)element).eClass().getEPackage() == CBEPackage.eINSTANCE) {
            this.getFeatureNodes((EObject)element, wlist);
        } else if (element instanceof FeatureNode) {
            this.getFeatureNodeElements((FeatureNode)element, wlist);
        } else if (element instanceof TreeNode && ((TreeNode)element).getElement() instanceof List && ((List)((TreeNode)element).getElement()).size() > 0) {
            List elements = (List)((TreeNode)element).getElement();
            int s = elements.size();
            DecoratingLabelProvider labelProvider = (DecoratingLabelProvider)this._logViewer.getLogPage().getView().getViewer().getLabelProvider();
            int i = 0;
            while (i < s) {
                wlist.add(new TerminalNode(element, (EObject)elements.get(i), labelProvider.getText(elements.get(i))));
                ++i;
            }
        }
        return wlist;
    }

    public boolean hasChildren(Object element) {
        boolean result = false;
        if (element instanceof EObject && ((EObject)element).eClass().getEPackage() == CBEPackage.eINSTANCE) {
            EClass eClass = ((EObject)element).eClass();
            Iterator iter = eClass.getEAllStructuralFeatures().iterator();
            while (iter.hasNext()) {
                Object refs;
                EStructuralFeature feature = (EStructuralFeature)iter.next();
                if ((!(feature instanceof EReference) || feature.getFeatureID() == 3) && (!(feature instanceof EAttribute) || !feature.isMany() || feature.getEType().getInstanceClass() == (class$java$lang$String == null ? LogContentProvider.class$("java.lang.String") : class$java$lang$String)) || (refs = ((EObject)element).eGet(feature, true)) == null) continue;
                if (refs instanceof EList) {
                    if (((EList)refs).size() <= 0) continue;
                    result = true;
                } else {
                    result = true;
                }
                break;
            }
        } else if (element instanceof FeatureNode) {
            EStructuralFeature feature = ((FeatureNode)element).getFeature();
            EObject cElem = ((FeatureNode)element).getElement();
            if (feature instanceof EReference) {
                Object ref;
                EList refs;
                if (feature.getName() == "associatedEvents") {
                    return true;
                }
                result = feature.isMany() ? (refs = (EList)cElem.eGet(feature, true)).size() > 0 : (ref = cElem.eGet(feature, true)) != null;
            }
        } else if (element instanceof TerminalNode) {
            result = false;
        } else if (element instanceof TreeNode) {
            if (((TreeNode)element).getElement() instanceof List) {
                return ((List)((TreeNode)element).getElement()).size() > 0;
            }
            return false;
        }
        return result;
    }

    public Object getParent(Object element) {
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = newInput instanceof CorrelationContainerProxy ? (CorrelationContainerProxy)newInput : null;
        this.reset();
    }

    private void reset() {
        this.filters = null;
        this.sortAttributes = null;
        this.filterTableElements = null;
        this.allElements = null;
        this._currentPage = 0;
        this._totalPages = 0;
        this.pageActionCalled = false;
    }

    public boolean isDeleted(Object element) {
        return false;
    }

    private void updateSeverity() {
        if (this.filters == null) {
            return;
        }
        this.filterSevOne = true;
        this.filterSevTwo = true;
        this.filterSevThree = true;
        int idx = this.filters.indexOf(32);
        if (idx == -1) {
            return;
        }
        this.filterSevOne = this.filters.charAt(idx - 1) == '1';
        if ((idx = this.filters.indexOf(32, idx + 1)) == -1) {
            return;
        }
        this.filterSevTwo = this.filters.charAt(idx - 1) == '1';
        if ((idx = this.filters.indexOf(32, idx + 1)) == -1) {
            return;
        }
        this.filterSevThree = this.filters.charAt(idx - 1) == '1';
    }

    private List getFilteredRecords(List pdList) {
        if (this.sortAttributes != null && this.sortAttributes.size() > 0) {
            Collections.sort(pdList, this.getLogSorter(this.sortAttributes));
        }
        ArrayList data = new ArrayList();
        if ((this.filters == null || this.filters.equals("")) && this.filterTableElements == null) {
            int i = 0;
            while (i < pdList.size()) {
                data.add(pdList.get(i));
                ++i;
            }
            this._total += pdList.size();
            this._visible += pdList.size();
            return data;
        }
        int i = 0;
        while (i < pdList.size()) {
            Object entry = pdList.get(i);
            try {
                short sev = ((CBECommonBaseEvent)entry).getSeverity();
                if ((sev >= 50 && sev <= 70 && this.filterSevOne || sev >= 30 && sev < 50 && this.filterSevTwo || sev >= 0 && sev < 30 && this.filterSevThree) && this.isAdvancedFilterAppliedTo((CBECommonBaseEvent)entry)) {
                    data.add(entry);
                    ++this._visible;
                }
            }
            catch (ClassCastException e) {
                data.add(entry);
                ++this._visible;
            }
            ++this._total;
            ++i;
        }
        return data;
    }

    private boolean isAdvancedFilterAppliedTo(CBECommonBaseEvent entry) {
        if (this.filterTableElements != null) {
            int s = this.filterTableElements.size();
            return this.recordFilterSearch.isAdvFilterApply((EObject)entry, this.filterTableElements.toArray(new IFilterElement[s]));
        }
        return true;
    }

    private boolean prepareFiltersAndSortAttributes() {
        List sortAttributes1 = this.parsePreferenceString("pd_sort_log_options");
        String filters1 = LogUIPlugin.getDefault().getPreferenceStore().getString("pd_sev_options");
        List filterTableElements1 = FilterTableElement.createFilterTableElementFromString(LogUIPlugin.getDefault().getPreferenceStore().getString("pd_adv_filter_options"));
        if (this.sortAttributes != null && !this.sortAttributes.equals(sortAttributes1) || sortAttributes1 != null && !sortAttributes1.equals(this.sortAttributes)) {
            return this.swapFiltersAndSortAttributes(sortAttributes1, filters1, filterTableElements1);
        }
        if (this.filters != null && !this.filters.equals(filters1) || filters1 != null && !filters1.equals(this.filters)) {
            return this.swapFiltersAndSortAttributes(sortAttributes1, filters1, filterTableElements1);
        }
        if (this.filterTableElements != null && !this.filterTableElements.equals(filterTableElements1) || filterTableElements1 != null && !filterTableElements1.equals(this.filterTableElements)) {
            return this.swapFiltersAndSortAttributes(sortAttributes1, filters1, filterTableElements1);
        }
        return false;
    }

    private boolean swapFiltersAndSortAttributes(List sortAttributes1, String filters1, List filterTableElements1) {
        this.sortAttributes = sortAttributes1;
        this.filters = filters1;
        this.filterTableElements = filterTableElements1;
        this.updateSeverity();
        return true;
    }

    private void setTitle() {
        String[] variables = new String[]{"" + this._visible, "" + this._total, "" + this._currentPage, "" + this._totalPages};
        String title = this._title + " " + LogUIPlugin.getResourceString("STR_SHOW_INFO", variables);
        ((CLabel)this._viewer.getTopLeft()).setText(title);
        this._logViewer.updateFilterAppliedDescription();
    }

    public ILogFilterCriteria getFilterCriteria() {
        int i;
        int s = 0;
        if (this.criteria == null) {
            this.criteria = new LogFilterCriteria();
        }
        if (this.filterTableElements != null) {
            int analyzedFilterIndex = -1;
            s = this.filterTableElements.size();
            i = 0;
            while (i < s) {
                if (((FilterTableElement)this.filterTableElements.get(i)).getAttribute().equals("analyzed")) {
                    analyzedFilterIndex = i;
                    break;
                }
                ++i;
            }
            if (analyzedFilterIndex > -1) {
                if (s > 1) {
                    IFilterElement[] filter = new FilterTableElement[s - 1];
                    int index = 0;
                    int i2 = 0;
                    while (i2 < s) {
                        if (i2 != analyzedFilterIndex) {
                            filter[index++] = (FilterTableElement)this.filterTableElements.get(i2);
                        }
                        ++i2;
                    }
                    this.criteria.setFilters(filter);
                } else {
                    this.criteria.setFilters(new IFilterElement[0]);
                }
            } else {
                this.criteria.setFilters(this.filterTableElements.toArray(new IFilterElement[s]));
            }
        } else {
            this.criteria.setFilters(new IFilterElement[0]);
        }
        s = this.sortAttributes.size();
        ISortElement[] sortElements = null;
        if (s > 0) {
            sortElements = new ISortElement[s];
            i = 0;
            while (i < s) {
                sortElements[i] = new SortElement((String)this.sortAttributes.get(i), true);
                ++i;
            }
            this.criteria.setSortColumns(sortElements);
        } else {
            this.criteria.setSortColumns(new ISortElement[0]);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("sev1", this.filterSevOne ? "1" : "0");
        options.put("sev2", this.filterSevTwo ? "1" : "0");
        options.put("sev3", this.filterSevThree ? "1" : "0");
        this.criteria.setFilterOptions(options);
        return this.criteria;
    }

    public Query getQuery() {
        return this.query;
    }

    private List parsePreferenceString(String option) {
        ArrayList<String> newSortAttributes = null;
        String firstSort = "";
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        String sortData = LogUIPlugin.getDefault().getPreferenceStore().getString(option);
        if (sortData != null) {
            int i = sortData.indexOf(" ");
            String column = "";
            int j = 0;
            newSortAttributes = new ArrayList<String>();
            while (i != -1) {
                column = sortData.substring(0, i);
                j = column.indexOf(":");
                if (j > -1 && column.substring(j + 1).equals("1")) {
                    newSortAttributes.add(this.firstCharToUpperCase(column.substring(0, j)));
                }
                sortData = sortData.substring(i + 1);
                i = sortData.indexOf(" ");
            }
            int k = sortData.indexOf(":");
            if (k > -1 && sortData.substring(k + 1).equals("1")) {
                newSortAttributes.add(this.firstCharToUpperCase(sortData.substring(0, k)));
            }
        }
        return newSortAttributes;
    }

    private String firstCharToUpperCase(String name) {
        char c;
        char[] charName = name.toCharArray();
        charName[0] = c = Character.toUpperCase(charName[0]);
        return new String(charName);
    }

    private Sorter getLogSorter(List sortAttributes) {
        if (this.sorter == null) {
            this.sorter = new Sorter(sortAttributes);
        }
        this.sorter.setAttributes(sortAttributes);
        return this.sorter;
    }

    private void getAgentRecords(TRCAgentProxy agentProxy, List wlist) {
        this.getAgentRecords(new TRCAgentProxy[]{agentProxy}, wlist);
    }

    private void getAgentRecords(TRCAgentProxy[] agents, List wlist) {
        ArrayList logRecords = new ArrayList();
        ArrayList<TRCAgent> agList = new ArrayList<TRCAgent>();
        this._total = 0;
        int i = 0;
        while (i < agents.length) {
            if (agents[i] != null && agents[i].getAgent() != null) {
                if (FilterUIUtil.ENABLE_NEW_FILTERING) {
                    this._total += agents[i].getAgent().getDefaultEvents().size();
                    agList.add(agents[i].getAgent());
                } else {
                    logRecords.addAll(agents[i].getAgent().getDefaultEvents());
                }
            }
            ++i;
        }
        if (FilterUIUtil.ENABLE_NEW_FILTERING) {
            List result = this._logViewer.getFilteredLogRecords(agList);
            this._visible = result.size();
            wlist.addAll(result);
            if (this.sortAttributes != null && this.sortAttributes.size() > 0) {
                Collections.sort(wlist, this.getLogSorter(this.sortAttributes));
            }
        } else {
            wlist.addAll(this.getFilteredRecords(logRecords));
            logRecords.clear();
        }
    }

    private void getFeatureNodes(EObject element, List wlist) {
        try {
            EClass eClass = element.eClass();
            if (this.allElements instanceof ArrayList) {
                this.generateAssociatedEvents(element, wlist);
            }
            Iterator iter = eClass.getEAllStructuralFeatures().iterator();
            while (iter.hasNext()) {
                Object refs;
                EStructuralFeature feature = (EStructuralFeature)iter.next();
                if (feature.getContainerClass().equals(class$org$eclipse$hyades$models$hierarchy$AbstractDefaultEvent == null ? LogContentProvider.class$("org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent") : class$org$eclipse$hyades$models$hierarchy$AbstractDefaultEvent) || (!(feature instanceof EReference) || feature.getFeatureID() == 3) && (!(feature instanceof EAttribute) || !feature.isMany() || feature.getEType().getInstanceClass() == (class$java$lang$String == null ? LogContentProvider.class$("java.lang.String") : class$java$lang$String)) || (refs = element.eGet(feature, true)) == null) continue;
                if (refs instanceof EList) {
                    if (((EList)refs).size() <= 0) continue;
                    wlist.add(new FeatureNode(element, feature));
                    continue;
                }
                wlist.add(new FeatureNode(element, feature));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            wlist.clear();
        }
    }

    private void generateAssociatedEvents(EObject element, List wlist) {
        EMap correlations;
        EReference associatedEvents = null;
        if (element instanceof CBEDefaultEvent && ((CBEDefaultEvent)element).getAgent() != null) {
            boolean hasInternalCorrelations = false;
            EList internalCorrelations = ((CBEDefaultEvent)element).getAgent().getAgentProxy().getInternalCorrelations();
            int s = internalCorrelations.size();
            CorrelationContainerProxy container = null;
            int i = 0;
            while (i < s) {
                EMap correlations2;
                container = (CorrelationContainerProxy)internalCorrelations.get(i);
                if (container.getCorrelationContainer() != null && (correlations2 = container.getCorrelationContainer().getCorrelations()) != null && correlations2.get((Object)element) != null) {
                    hasInternalCorrelations = true;
                    break;
                }
                ++i;
            }
            if (hasInternalCorrelations) {
                associatedEvents = EcoreFactory.eINSTANCE.createEReference();
                associatedEvents.setName("associatedEvents");
                wlist.add(new FeatureNode(element, (EStructuralFeature)associatedEvents));
            }
        }
        if (this.input != null && this.input.getCorrelationContainer() != null && (correlations = this.input.getCorrelationContainer().getCorrelations()) != null && correlations.get((Object)element) != null && associatedEvents == null) {
            associatedEvents = EcoreFactory.eINSTANCE.createEReference();
            associatedEvents.setName("associatedEvents");
            wlist.add(new FeatureNode(element, (EStructuralFeature)associatedEvents));
        }
    }

    private void getFeatureNodeElements(FeatureNode element, List wlist) {
        block16: {
            try {
                EStructuralFeature feature = element.getFeature();
                EObject cElem = element.getElement();
                if (!(feature instanceof EReference)) break block16;
                if (feature.getName() == "associatedEvents") {
                    EMap correlations;
                    int s;
                    EList internalCorrelations = ((CBEDefaultEvent)cElem).getAgent().getAgentProxy().getInternalCorrelations();
                    ArrayList<CorrelationEngine> corrEngines = null;
                    if (internalCorrelations != null && (s = internalCorrelations.size()) > 0) {
                        CorrelationContainerProxy container = null;
                        corrEngines = new ArrayList<CorrelationEngine>();
                        int i = 0;
                        while (i < s) {
                            EMap correlations2;
                            container = (CorrelationContainerProxy)internalCorrelations.get(i);
                            if (container.getCorrelationContainer() != null && (correlations2 = container.getCorrelationContainer().getCorrelations()) != null && correlations2.get((Object)cElem) != null && !wlist.contains(container.getCorrelationEngine()) && !corrEngines.contains(container.getCorrelationEngine())) {
                                wlist.add(new TreeNode((EObject)container.getCorrelationEngine(), correlations2.get((Object)cElem)));
                                corrEngines.add(container.getCorrelationEngine());
                            }
                            ++i;
                        }
                    }
                    if (this.input != null && this.input.getCorrelationContainer() != null && (correlations = this.input.getCorrelationContainer().getCorrelations()) != null && correlations.get((Object)cElem) != null && !wlist.contains(this.input.getCorrelationEngine())) {
                        if (corrEngines == null) {
                            corrEngines = new ArrayList();
                        }
                        if (!corrEngines.contains(this.input.getCorrelationEngine())) {
                            wlist.add(new TreeNode((EObject)this.input.getCorrelationEngine(), correlations.get((Object)cElem)));
                        }
                    }
                    return;
                }
                if (feature.isMany()) {
                    EList refs = (EList)cElem.eGet(feature, true);
                    if (((EReference)feature).isContainment()) {
                        wlist.addAll(refs);
                    } else {
                        int index = 0;
                        EObject elem = null;
                        String label = "";
                        Iterator iter = refs.iterator();
                        while (iter.hasNext()) {
                            elem = (EObject)iter.next();
                            EStructuralFeature f = elem.eClass().getEStructuralFeature(12);
                            label = f == CBEPackage.eINSTANCE.getCBECommonBaseEvent_Msg() ? (String)elem.eGet(f) : ((f = elem.eClass().getEStructuralFeature(2)) == CBEPackage.eINSTANCE.getCBEDefaultEvent_ExtensionName() ? (String)elem.eGet(f) : elem.eClass().getName());
                            wlist.add(new TerminalNode(element.getElement(), elem, label));
                            ++index;
                        }
                    }
                } else {
                    EObject ref = (EObject)cElem.eGet(feature);
                    if (((EReference)feature).isContainment()) {
                        wlist.add(ref);
                    } else {
                        wlist.add(new TerminalNode(element.getElement(), ref, ref.eClass().getName()));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean pageUp() {
        if (this._currentPage > 1) {
            --this._currentPage;
        }
        this.pageActionCalled = true;
        return this._currentPage != 1;
    }

    public boolean pageDown() {
        if (this._currentPage < this._totalPages) {
            ++this._currentPage;
        }
        this.pageActionCalled = true;
        return this._currentPage != this._totalPages;
    }

    public boolean goToPage(int pageNr) {
        if (pageNr > 0 && pageNr <= this._totalPages) {
            this._currentPage = pageNr;
        }
        this.pageActionCalled = true;
        return this._currentPage != this._totalPages;
    }

    public int getTotalPages() {
        return this._totalPages;
    }

    public boolean revealObject(EObject record) {
        if (this.allElements == null) {
            return false;
        }
        int index = this.allElements.indexOf(record);
        if (index == -1) {
            return false;
        }
        int _prevPage = this._currentPage;
        int newPage = ++index / this.PAGE_SIZE;
        newPage = index % this.PAGE_SIZE > 0 && index > 0 ? newPage + 1 : newPage;
        this.goToPage(newPage);
        return newPage != _prevPage;
    }

    public List getCachedElements() {
        return this.allElements;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ReferenceList
    extends AbstractList {
        ArrayList agentURIs = new ArrayList();
        ArrayList references = new ArrayList();

        public int size() {
            return this.references.size();
        }

        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }

        private Object getRealObject(int i) {
            try {
                Object o = this.references.get(i);
                if (o != null && o instanceof ReferenceInfo) {
                    ReferenceInfo referenceInfo = (ReferenceInfo)this.references.get(i);
                    TRCAgent agent = (TRCAgent)HierarchyResourceSetImpl.getInstance().getEObject((URI)this.agentURIs.get(referenceInfo.agentIndex), true);
                    o = agent.getDefaultEvents().get(referenceInfo.defaultEventIndex);
                }
                return o;
            }
            catch (Exception e) {
                return null;
            }
        }

        public void clear() {
            int expectedModCount = this.modCount;
            this.agentURIs.clear();
            this.references.clear();
            if (expectedModCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            ++this.modCount;
        }

        public Object get(int index) {
            return this.getRealObject(index);
        }

        public void add(int index, Object o) {
            try {
                int expectedModCount = this.modCount;
                if (o instanceof CBEDefaultEvent) {
                    CBEDefaultEvent defaultEvent = (CBEDefaultEvent)o;
                    int defaultEventIndex = ((EList)defaultEvent.eContainer().eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgent_DefaultEvents())).indexOf((Object)defaultEvent);
                    URI uri = EcoreUtil.getURI((EObject)defaultEvent.eContainer());
                    int agentIndex = this.agentURIs.indexOf(uri);
                    if (agentIndex == -1) {
                        this.agentURIs.add(uri);
                        agentIndex = this.agentURIs.size() - 1;
                    }
                    ReferenceInfo referenceInfo = new ReferenceInfo(agentIndex, defaultEventIndex);
                    this.references.add(index, referenceInfo);
                } else {
                    this.references.add(index, o);
                }
                if (expectedModCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error " + e.getLocalizedMessage() + " when adding object:" + o);
            }
        }

        public Object set(int index, Object o) {
            Object res = this.getRealObject(index);
            try {
                int expectedModCount = this.modCount;
                if (o instanceof CBEDefaultEvent) {
                    CBEDefaultEvent defaultEvent = (CBEDefaultEvent)o;
                    int defaultEventIndex = ((EList)defaultEvent.eContainer().eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgent_DefaultEvents())).indexOf((Object)defaultEvent);
                    URI uri = EcoreUtil.getURI((EObject)defaultEvent.eContainer());
                    int agentIndex = this.agentURIs.indexOf(uri);
                    if (agentIndex == -1) {
                        this.agentURIs.add(uri);
                        agentIndex = this.agentURIs.size() - 1;
                    }
                    ReferenceInfo referenceInfo = new ReferenceInfo(agentIndex, defaultEventIndex);
                    this.references.set(index, referenceInfo);
                } else {
                    this.references.set(index, o);
                }
                if (expectedModCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error " + e.getLocalizedMessage() + " when adding object:" + o);
            }
            return res;
        }

        public Object remove(int index) {
            int expectedModCount = this.modCount;
            Object res = this.getRealObject(index);
            this.references.remove(index);
            if (expectedModCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            return res;
        }

        public int indexOf(Object o) {
            int expectedModCount = this.modCount;
            int i = 0;
            while (i < this.references.size()) {
                if (o == this.getRealObject(i)) {
                    if (expectedModCount != this.modCount) {
                        throw new ConcurrentModificationException();
                    }
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void trimToSize() {
            this.agentURIs.trimToSize();
            this.references.trimToSize();
        }

        static class ReferenceInfo {
            protected byte agentIndex;
            protected int defaultEventIndex;

            public ReferenceInfo(int agentIndex, int index) {
                this.agentIndex = (byte)agentIndex;
                this.defaultEventIndex = index;
            }
        }
    }
}

