/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;

public class LocalLogParserLoader
implements Log {
    private Hashtable parserParameters = null;
    private Parser parser = null;
    private XMLLoader xmlLoader = null;
    private boolean first = true;
    public static final int TRACE_LEVEL = 0;
    public static final int DEBUG_LEVEL = 1;
    public static final int INFO_LEVEL = 2;
    public static final int WARN_LEVEL = 3;
    public static final int ERROR_LEVEL = 4;
    public static final int FATAL_LEVEL = 5;
    private int loggingLevel;

    public LocalLogParserLoader(Parser parser, Hashtable parserParameters) {
        this.parser = parser;
        this.parserParameters = parserParameters;
        this.loggingLevel = 0;
    }

    public void setXMLLoader(XMLLoader xmlLoader) {
        this.xmlLoader = xmlLoader;
    }

    public void startParsing() throws LogParserException {
        this.parser.setUserInput(this.parserParameters);
        this.parser.parse((Log)this);
    }

    public void setParserLogger(Log logParser) {
        this.parser.setParserLogger(logParser);
    }

    public Log getParserLogger() {
        return this.parser.getParserLogger();
    }

    private void logXMLToModel(String xml) {
        byte[] xmlLogEntryBytes = null;
        try {
            xmlLogEntryBytes = xml.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException u) {
            xmlLogEntryBytes = xml.getBytes();
        }
        this.xmlLoader.loadEvent(xmlLogEntryBytes, xmlLogEntryBytes.length);
    }

    public boolean isTraceEnabled() {
        return this.loggingLevel <= 0;
    }

    public boolean isDebugEnabled() {
        return this.loggingLevel <= 1;
    }

    public boolean isInfoEnabled() {
        return this.loggingLevel <= 2;
    }

    public boolean isWarnEnabled() {
        return this.loggingLevel <= 3;
    }

    public boolean isErrorEnabled() {
        return this.loggingLevel <= 4;
    }

    public boolean isFatalEnabled() {
        return this.loggingLevel <= 5;
    }

    public void trace(Object record) {
        if (this.isTraceEnabled()) {
            this.logXMLToModel(EventFormatter.toCanonicalXMLString((CommonBaseEvent)EventHelpers.convertObjectToCommonBaseEvent((Object)record, (int)4), (boolean)true).concat(Constants.LINE_SEPARATOR));
        }
    }

    public void trace(Object record, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.logXMLToModel(EventFormatter.toCanonicalXMLString((CommonBaseEvent)EventHelpers.convertObjectToCommonBaseEvent((Object)record, (int)4), (boolean)true).concat(Constants.LINE_SEPARATOR));
        }
    }

    public void debug(Object record) {
        if (this.isDebugEnabled()) {
            this.logXMLToModel(EventFormatter.toCanonicalXMLString((CommonBaseEvent)EventHelpers.convertObjectToCommonBaseEvent((Object)record, (int)4), (boolean)true).concat(Constants.LINE_SEPARATOR));
        }
    }

    public void debug(Object record, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.logXMLToModel(EventFormatter.toCanonicalXMLString((CommonBaseEvent)EventHelpers.convertObjectToCommonBaseEvent((Object)record, (int)4), (boolean)true).concat(Constants.LINE_SEPARATOR));
        }
    }

    public void info(Object record) {
        if (this.isInfoEnabled()) {
            this.logXMLToModel(EventFormatter.toCanonicalXMLString((CommonBaseEvent)EventHelpers.convertObjectToCommonBaseEvent((Object)record, (int)4), (boolean)true).concat(Constants.LINE_SEPARATOR));
        }
    }

    public void info(Object record, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.logXMLToModel(EventFormatter.toCanonicalXMLString((CommonBaseEvent)EventHelpers.convertObjectToCommonBaseEvent((Object)record, (int)4), (boolean)true).concat(Constants.LINE_SEPARATOR));
        }
    }

    public void warn(Object record) {
        if (this.isWarnEnabled()) {
            this.logXMLToModel(EventFormatter.toCanonicalXMLString((CommonBaseEvent)EventHelpers.convertObjectToCommonBaseEvent((Object)record, (int)4), (boolean)true).concat(Constants.LINE_SEPARATOR));
        }
    }

    public void warn(Object record, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.logXMLToModel(EventFormatter.toCanonicalXMLString((CommonBaseEvent)EventHelpers.convertObjectToCommonBaseEvent((Object)record, (int)4), (boolean)true).concat(Constants.LINE_SEPARATOR));
        }
    }

    public void error(Object record) {
        if (this.isErrorEnabled()) {
            this.logXMLToModel(EventFormatter.toCanonicalXMLString((CommonBaseEvent)EventHelpers.convertObjectToCommonBaseEvent((Object)record, (int)4), (boolean)true).concat(Constants.LINE_SEPARATOR));
        }
    }

    public void error(Object record, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.logXMLToModel(EventFormatter.toCanonicalXMLString((CommonBaseEvent)EventHelpers.convertObjectToCommonBaseEvent((Object)record, (int)4), (boolean)true).concat(Constants.LINE_SEPARATOR));
        }
    }

    public void fatal(Object record) {
        if (this.isFatalEnabled()) {
            this.logXMLToModel(EventFormatter.toCanonicalXMLString((CommonBaseEvent)EventHelpers.convertObjectToCommonBaseEvent((Object)record, (int)4), (boolean)true).concat(Constants.LINE_SEPARATOR));
        }
    }

    public void fatal(Object record, Throwable throwable) {
        if (this.isFatalEnabled()) {
            this.logXMLToModel(EventFormatter.toCanonicalXMLString((CommonBaseEvent)EventHelpers.convertObjectToCommonBaseEvent((Object)record, (int)4), (boolean)true).concat(Constants.LINE_SEPARATOR));
        }
    }
}

