/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.control;

import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolFactory;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.action.CopyAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.CutAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.PasteAction;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolClipboard;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolMenuManager;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTableUtil;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolColumnDialog;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolDeleteColumnDialog;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolRowDialog;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPart;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPartExtended;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IValidateValueClass;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IValueClassFactory;
import org.eclipse.hyades.test.ui.datapool.internal.util.DatapoolUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.TypeChecker;
import org.eclipse.hyades.test.ui.datapool.internal.util.ValueClassMap;
import org.eclipse.hyades.test.ui.datapool.internal.util.ValueObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPartSite;

public class DatapoolTable
implements IMenuListener,
SelectionListener,
IDatapoolListener {
    private static final String START_LITERAL = "<Literal>";
    private static final String END_LITERAL = "</Literal>";
    private static final String TAG_DATA = "data";
    private static final String TAG_RECORD = "record";
    private static final String TAG_VARIABLE = "variable";
    private static final String TAG_VARIABLE_INDEX = "variableIndex";
    private static final String TAG_EQUIVALENCE_CLASS = "equivalenceClass";
    private static final String TAG_ROW_HEADER = "rowHeader";
    private static final int MAX_TABLE_WIDTH = 60;
    private static final int MAX_TABLE_HEIGHT = 60;
    private IDatapoolEquivalenceClass equivalenceClass;
    private int equivalenceClassIndex = -1;
    private IDatapool datapool;
    private Table table = null;
    private DatapoolTableUtil tableUtil = null;
    private TableViewer viewer = null;
    private Composite parent = null;
    private Menu contextMenu = null;
    private TableCursor cursor = null;
    private ControlEditor controlEditor = null;
    private IDatapoolPart datapoolPart = null;
    private IDatapoolFactory datapoolFactory = null;
    private CellEditor cellEditor = null;
    private ValueObject valueObject = null;
    private DatapoolMenuManager datapoolMenuManager = null;
    private boolean ignoreECNotification = false;
    private boolean controlKeyDown = false;
    private boolean altKeyDown = false;
    private boolean alreadySaved = false;
    private boolean isInputValid = true;
    private boolean showVariables = true;
    private boolean showRecords = true;
    private boolean isF2Mode = false;
    private CursorKeyAdapter cursorKeyListener;
    private CursorMouseAdapter cursorMouseListener;
    private CursorSelectionAdapter cursorSelectionListener;
    private CursorTraverseAdapter cursorTraverseListener;
    private String vendorID = null;
    private CutAction cutAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    protected SelectionListener headerListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            DatapoolTable.this.datapoolPart.notifyEdit();
            if (DatapoolTable.this.datapoolPart.isReadOnly()) {
                return;
            }
            DatapoolTable.this.clearCellEditor();
            TableColumn tableColumn = (TableColumn)event.widget;
            DatapoolTable.this.editColumnAux(tableColumn);
        }
    };
    private ControlListener resizeListener = new ControlAdapter(){

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
        }
    };
    protected ControlListener resizeColumnListener = new ControlAdapter(){

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            if (DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed() && DatapoolTable.this.table.getSelectionIndex() >= 0 && DatapoolTable.this.cursor.getColumn() >= 0) {
                DatapoolTable.this.cursor.setSelection(DatapoolTable.this.table.getSelectionIndex(), DatapoolTable.this.cursor.getColumn());
            }
        }
    };

    private void clearCellEditor() {
        this.clearCellEditor(this.cellEditor);
        this.cellEditor = null;
    }

    private void clearCellEditor(CellEditor cellEditor) {
        this.isF2Mode = false;
        if (cellEditor != null) {
            cellEditor.dispose();
            cellEditor = null;
        }
        if (this.valueObject != null) {
            this.valueObject = null;
        }
        if (this.cursor != null && !this.cursor.isDisposed()) {
            this.cursor.setFocus();
        }
    }

    public DatapoolTable(Composite parent, IDatapoolPart datapoolPart, IDatapool datapool, IDatapoolFactory datapoolFactory, String vendorID) {
        this.vendorID = vendorID;
        ValueClassMap.setVendorID(vendorID);
        IDatapoolEquivalenceClass ec = this.getDefaultEquivalenceClass(datapool);
        this.DatapoolTableConstructor(parent, datapoolPart, ec, datapoolFactory);
    }

    public DatapoolTable(Composite parent, IDatapoolPart datapoolPart, IDatapoolEquivalenceClass ec, IDatapoolFactory datapoolFactory, String vendorID) {
        this.vendorID = vendorID;
        ValueClassMap.setVendorID(vendorID);
        this.DatapoolTableConstructor(parent, datapoolPart, ec, datapoolFactory);
    }

    public DatapoolTable(Composite parent, IDatapoolPart datapoolPart, IDatapool datapool, IDatapoolFactory datapoolFactory) {
        IDatapoolEquivalenceClass ec = this.getDefaultEquivalenceClass(datapool);
        this.DatapoolTableConstructor(parent, datapoolPart, ec, datapoolFactory);
    }

    public DatapoolTable(Composite parent, IDatapoolPart datapoolPart, IDatapoolEquivalenceClass ec, IDatapoolFactory datapoolFactory) {
        this.DatapoolTableConstructor(parent, datapoolPart, ec, datapoolFactory);
    }

    private void DatapoolTableConstructor(Composite parent, IDatapoolPart datapoolPart, IDatapoolEquivalenceClass ec, IDatapoolFactory datapoolFactory) {
        if (parent == null || datapoolPart == null || datapoolFactory == null) {
            return;
        }
        this.setEquivalenceClass(ec);
        this.datapoolFactory = datapoolFactory;
        this.parent = new Composite(parent, 0);
        this.parent.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.parent.setLayout((Layout)layout);
        this.setWaitCursor();
        this.setVendorConfiguration();
        this.datapoolPart = datapoolPart;
        DatapoolClipboard.getInstance().setClipboard(datapoolPart.getClipboard());
        this.createTable(this.parent);
        this.tableUtil = new DatapoolTableUtil(this);
        this.createMenu();
        this.table.addSelectionListener((SelectionListener)this);
        if (this.equivalenceClass != null) {
            this.getDatapool().addDatapoolListener((IDatapoolListener)this);
        }
        this.datapoolMenuManager = new DatapoolMenuManager(this, this.vendorID, false, this.showVariables, this.showRecords);
        this.setMenuMode(this.datapoolMenuManager);
        this.unsetWaitCursor();
    }

    private void createMenu() {
        MenuManager menuMgr = new MenuManager("#DatapoolEditor");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.contextMenu = menuMgr.createContextMenu((Control)this.table);
        this.table.setMenu(this.contextMenu);
    }

    private void createTable(Composite parent) {
        this.table = new Table(parent, 67584);
        this.viewer = new TableViewer(this.table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 60;
        gd.heightHint = 60;
        this.table.setLayoutData((Object)gd);
        this.makeColumns();
        if (!this.isWithoutRows()) {
            this.makeRows();
        }
        this.createCursor();
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 262144 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (e.keyCode == 131072 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 262144 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 131072 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (DatapoolTable.this.table.getItemCount() != 0) {
                    TableItem[] selection = DatapoolTable.this.table.getSelection();
                    TableItem row = selection.length == 0 ? DatapoolTable.this.table.getItem(DatapoolTable.this.table.getTopIndex()) : selection[0];
                    DatapoolTable.this.table.showItem(row);
                    if (DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed()) {
                        DatapoolTable.this.cursor.setSelection(row, 0);
                        DatapoolTable.this.cursor.setVisible(true);
                        DatapoolTable.this.cursor.setFocus();
                    }
                }
            }
        });
        this.table.addMouseListener((MouseListener)new TableMouseAdapter());
        this.table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -3) {
                    TableItem[] selection = DatapoolTable.this.table.getSelection();
                    if (selection != null && selection.length > 0 && DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed()) {
                        try {
                            e.result = selection[0].getText(DatapoolTable.this.cursor.getColumn());
                        }
                        catch (Exception ex) {}
                    }
                } else {
                    e.result = DatapoolPlugin.getResourceString("W_DATATABLE");
                }
            }
        });
        if (this.equivalenceClass == null) {
            this.hideTable();
        }
    }

    private void createCursor() {
        if (this.equivalenceClass == null || this.equivalenceClass.getRecordCount() == 0) {
            return;
        }
        this.cursor = new TableCursor(this.table, 0);
        this.controlEditor = new ControlEditor((Composite)this.cursor);
        this.controlEditor.grabHorizontal = true;
        this.controlEditor.grabVertical = true;
        this.cursor.setMenu(this.contextMenu);
        this.cursor.addSelectionListener((SelectionListener)new CursorSelectionAdapter(this.cursor, this.cellEditor, this.datapoolPart));
        this.cursor.addKeyListener((KeyListener)new CursorKeyAdapter(this.cursor, this.cellEditor, this.datapoolPart));
        this.cursor.addTraverseListener((TraverseListener)new CursorTraverseAdapter());
        this.cursor.addMouseListener((MouseListener)new CursorMouseAdapter(this.cursor, this.cellEditor, this.datapoolPart));
        this.cursor.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                block2: {
                    TableItem[] selection = DatapoolTable.this.table.getSelection();
                    if (selection == null || selection.length <= 0 || DatapoolTable.this.cursor == null || DatapoolTable.this.cursor.isDisposed()) break block2;
                    try {
                        e.result = selection[0].getText(DatapoolTable.this.cursor.getColumn());
                    }
                    catch (Exception ex) {}
                }
            }
        });
        if (this.table.getItemCount() > 0) {
            this.table.select(0);
            if (this.table.getColumnCount() > 1) {
                this.cursor.setSelection(0, 1);
            } else {
                this.cursor.setSelection(0, 0);
            }
        }
    }

    private void resetCursor() {
        if (this.cursor == null || this.cursor.isDisposed()) {
            this.createCursor();
        } else if (this.table.getItemCount() > 0) {
            this.table.select(0);
            this.cursor.setSelection(0, 0);
            this.cursor.redraw();
        }
    }

    private void setWaitCursor() {
        if (this.parent == null) {
            return;
        }
        Display display = this.parent.getShell().getDisplay();
        Cursor waitCursor = new Cursor((Device)display, 1);
        this.setDisplayCursor(waitCursor);
    }

    private void unsetWaitCursor() {
        this.setDisplayCursor(null);
    }

    private void setDisplayCursor(Cursor c) {
        if (this.parent == null) {
            return;
        }
        Display display = this.parent.getShell().getDisplay();
        Shell[] shells = display.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setCursor(c);
            ++i;
        }
    }

    private void startCellEditing(TableItem row, int column) {
        IDatapoolCell[] cells = (IDatapoolCell[])row.getData(TAG_DATA);
        IDatapoolCell cell = cells[column - 1];
        IDatapoolVariable variable = (IDatapoolVariable)cell.getCellVariable();
        IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
        Object rawValue = cell.getCellValue();
        Object object = rawValue = rawValue == null ? "" : rawValue;
        if (suggestedType.getSuggestedType() == 3) {
            String[] stringArray = suggestedType.getEnumerationLiterals();
            if (stringArray != null && stringArray.length > 0) {
                this.cellEditor = new ComboBoxCellEditor((Composite)this.cursor, stringArray);
                if (rawValue instanceof String) {
                    ((CCombo)this.cellEditor.getControl()).setText((String)rawValue);
                    this.valueObject = new ValueObject(rawValue);
                }
            }
        } else if (suggestedType.getSuggestedType() == 2) {
            String[] boolList = new String[]{Boolean.toString(true), Boolean.toString(false)};
            this.cellEditor = new ComboBoxCellEditor((Composite)this.cursor, boolList, 8);
            ((CCombo)this.cellEditor.getControl()).setText((String)rawValue);
            this.valueObject = new ValueObject(rawValue);
        }
        if (this.cellEditor == null) {
            if (rawValue == null) {
                String typeName = suggestedType.getSuggestedClassName();
                rawValue = typeName == null || typeName.length() == 0 ? new String() : this.createEmptyCellObject(typeName);
            }
            this.valueObject = new ValueObject(rawValue);
            this.cellEditor = (CellEditor)this.valueObject.getPropertyDisplay((Composite)this.cursor);
        }
        if (this.cellEditor != null && this.cellEditor.getControl() != null) {
            this.cellEditor.getControl().addKeyListener((KeyListener)new TableCellKeyAdapter(this.cellEditor, this.valueObject, row, column));
            this.cellEditor.getControl().addTraverseListener((TraverseListener)new TableCellTraverseAdapter(this.cellEditor, this.valueObject, row, column));
            this.cellEditor.getControl().addPaintListener((PaintListener)new TableCellPaintAdapter());
            this.cellEditor.addListener((ICellEditorListener)new TableCellEditorAdapter(this.cellEditor, this.valueObject, row, column));
            this.controlEditor.setEditor(this.cellEditor.getControl());
            this.cellEditor.setValidator((ICellEditorValidator)new TableCellValidator(ValueClassMap.getValueValidatorClass(rawValue)));
            this.cellEditor.getControl().setBackground(Display.getCurrent().getSystemColor(25));
            this.cellEditor.getControl().setForeground(Display.getCurrent().getSystemColor(24));
            this.cellEditor.setFocus();
            if (this.cellEditor instanceof TextCellEditor) {
                String currentText = row.getText(column);
                ((Text)this.cellEditor.getControl()).setSelection(currentText.length());
            }
            this.datapoolPart.markDirty();
        }
    }

    private Object createEmptyCellObject(String typeName) {
        Object value;
        IValueClassFactory valueFactory = ValueClassMap.getValueClassFactory(typeName);
        if (valueFactory != null) {
            value = valueFactory.createEmptyObject();
        } else {
            try {
                Class<?> objectClass = Class.forName(typeName);
                Constructor<?> objectConstructor = objectClass.getConstructor(new Class[0]);
                value = objectConstructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                value = new String();
            }
        }
        return value;
    }

    private void applyEditingValue(boolean dispose) {
        if (this.cellEditor != null) {
            if (this.cursor != null && this.cursor.getColumn() > 0) {
                Object updatedValue = null;
                String newDescription = null;
                boolean update = true;
                TableItem selectedTableItem = this.cursor.getRow();
                int selectedColumnIndex = this.cursor.getColumn();
                if (selectedTableItem == null || selectedTableItem.isDisposed()) {
                    return;
                }
                IDatapoolCell[] rowData = (IDatapoolCell[])selectedTableItem.getData(TAG_DATA);
                IDatapoolCell cell = rowData[this.cursor.getColumn() - 1];
                IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)cell.getCellVariable().getSuggestedType();
                if (suggestedType.getSuggestedType() == 3 || suggestedType.getSuggestedType() == 2) {
                    updatedValue = ((CCombo)this.cellEditor.getControl()).getText();
                    newDescription = updatedValue.toString();
                } else if (this.valueObject == null) {
                    update = false;
                } else {
                    String oldDescription = this.valueObject.getDescription();
                    updatedValue = this.valueObject.updateObject();
                    newDescription = this.valueObject.getDescription();
                    if (newDescription == null && oldDescription == null || newDescription != null && newDescription.equals(oldDescription)) {
                        update = false;
                    }
                }
                if (update) {
                    cell.setCellValue(updatedValue);
                    selectedTableItem.setText(selectedColumnIndex, newDescription);
                    this.cursor.setSelection(this.table.getSelectionIndex(), selectedColumnIndex);
                    this.datapoolPart.markDirty();
                }
            }
            if (dispose) {
                this.clearCellEditor();
            }
        }
    }

    private void makeColumns() {
        this.makeHeaderColumn();
        IDatapool datapool = this.getDatapool();
        if (datapool == null) {
            return;
        }
        int i = 0;
        while (i < datapool.getVariableCount()) {
            TableColumn tableColumn = new TableColumn(this.table, 0, i + 1);
            IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(i);
            tableColumn.setResizable(true);
            String type = DatapoolUtil.getInstance().getVariableTypeInfo(variable);
            tableColumn.setText(variable.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + type);
            tableColumn.setData(TAG_VARIABLE, (Object)variable);
            tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(i));
            tableColumn.setWidth(100);
            tableColumn.addSelectionListener(this.headerListener);
            tableColumn.addControlListener(this.resizeColumnListener);
            ++i;
        }
    }

    private void makeHeaderColumn() {
        TableColumn recordTableColumn = new TableColumn(this.table, 0, 0);
        recordTableColumn.setResizable(true);
        recordTableColumn.setWidth(20);
        recordTableColumn.setData(TAG_VARIABLE, null);
        recordTableColumn.addControlListener(this.resizeColumnListener);
    }

    private void makeRows() {
        if (this.equivalenceClass == null) {
            return;
        }
        int j = 0;
        while (j < this.equivalenceClass.getRecordCount()) {
            org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)this.equivalenceClass.getRecord(j);
            int cellCount = record.getCellCount();
            IDatapool datapool = this.getDatapool();
            String[] rowContents = new String[datapool.getVariableCount() + 1];
            IDatapoolCell[] rowData = new IDatapoolCell[datapool.getVariableCount()];
            rowContents[0] = String.valueOf(j);
            int k = 0;
            while (k < cellCount) {
                IDatapoolCell cell = (IDatapoolCell)record.getCell(k);
                IDatapoolVariable cellVariable = (IDatapoolVariable)cell.getCellVariable();
                int index = this.findColumnIndex(cellVariable.getName());
                String cellValue = cell.getStringValue();
                ValueObject valueObject = new ValueObject(cell.getCellValue());
                if (valueObject != null) {
                    cellValue = valueObject.getDescription();
                }
                rowContents[index] = cellValue;
                rowData[index - 1] = cell;
                ++k;
            }
            TableItem item = new TableItem(this.table, 0);
            item.setText(rowContents);
            item.setData(TAG_DATA, (Object)rowData);
            item.setData(TAG_RECORD, (Object)record);
            item.setData(TAG_EQUIVALENCE_CLASS, (Object)this.equivalenceClass);
            ++j;
        }
    }

    private boolean isWithoutRows() {
        return this.equivalenceClass == null || this.equivalenceClass.getRecordCount() == 0;
    }

    private boolean isWithoutColumns() {
        if (this.equivalenceClass == null) {
            return true;
        }
        IDatapool datapool = this.getDatapool();
        return datapool.getVariableCount() == 0;
    }

    private int findColumnIndex(String name) {
        int i = 0;
        while (i < this.table.getColumnCount()) {
            TableColumn tableColumn = this.table.getColumn(i);
            IDatapoolVariable variable = (IDatapoolVariable)tableColumn.getData(TAG_VARIABLE);
            if (variable != null && name.equals(variable.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void widgetSelected(SelectionEvent e) {
        int selectedColumnIndex;
        int selectedRowIndex = this.table.getSelectionIndex();
        if (this.cursor != null && !this.cursor.isDisposed() && (selectedColumnIndex = this.cursor.getColumn()) >= 0) {
            this.cursor.setSelection(selectedRowIndex, selectedColumnIndex);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void menuAboutToShow(IMenuManager imenuMgr) {
        this.datapoolMenuManager.addActions(imenuMgr);
        this.setMenuMode(this.datapoolMenuManager);
    }

    private void setMenuMode(DatapoolMenuManager dpMenuManager) {
        if (dpMenuManager == null) {
            return;
        }
        int menuMode = 0;
        if (this.equivalenceClass == null) {
            menuMode = 5;
        } else {
            if (this.cursor != null && !this.cursor.isDisposed()) {
                menuMode = this.cursor.getColumn() == 0 ? 0 : 1;
            }
            if (this.table.getSelectionIndex() == -1) {
                menuMode = 2;
            }
            IDatapool datapool = this.getDatapool();
            if (this.equivalenceClass.getRecordCount() == 0) {
                menuMode = 4;
            }
            if (this.datapoolPart.isReadOnly()) {
                menuMode = 5;
            }
        }
        boolean isCutCopyPasteable = false;
        if (this.table.getSelectionCount() > 0 && this.tableUtil.getColumnCount() > 1) {
            isCutCopyPasteable = true;
        }
        dpMenuManager.setDisplayMode(menuMode, isCutCopyPasteable);
    }

    public void insertRowGroup() {
    }

    public void deleteRowGroup() {
    }

    public void editRowGroup() {
    }

    public void insertRow() {
        if (this.equivalenceClass == null) {
            return;
        }
        this.setWaitCursor();
        IDatapool datapool = this.getDatapool();
        int insertionIndex = this.table.getSelectionIndex() + 1;
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = this.equivalenceClass.constructRecord();
        this.equivalenceClass.insertRecord(record, insertionIndex);
        this.unsetWaitCursor();
    }

    public void deleteRow() {
        if (!this.showRecords) {
            return;
        }
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.setWaitCursor();
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
        int recordIndex = this.getRecordIndex(this.equivalenceClass, record);
        this.equivalenceClass.removeRecord(recordIndex);
        this.unsetWaitCursor();
    }

    public void editRow() {
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.editRowAux(tableItem);
    }

    private void editRowAux(TableItem tableItem) {
        if (!this.showRecords) {
            return;
        }
        if (this.getEquivalenceClass().getRecordCount() < 2) {
            return;
        }
        int rowIndex = this.table.getSelectionIndex();
        TableItem previousTableItem = null;
        if (rowIndex != 0) {
            previousTableItem = this.table.getItem(rowIndex - 1);
        }
        IDatapool datapool = this.getDatapool();
        DatapoolRowDialog dialog = new DatapoolRowDialog(Display.getCurrent().getActiveShell(), datapool, this.table, tableItem, previousTableItem, DatapoolPlugin.getResourceString("DATA_ROW_DLG_TITLE_EDIT"), false);
        if (dialog.open() == 0) {
            this.setWaitCursor();
            int equivalenceClassIndex = this.getEquivalenceClassIndex();
            org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
            int recordIndex = this.getRecordIndex(this.equivalenceClass, record);
            int insertionRecordIndex = dialog.getInsertionRecordIndex();
            if (recordIndex != insertionRecordIndex + 1) {
                if (insertionRecordIndex > recordIndex) {
                    this.equivalenceClass.moveRecord(recordIndex, insertionRecordIndex);
                } else {
                    this.equivalenceClass.moveRecord(recordIndex, insertionRecordIndex + 1);
                }
            }
            this.unsetWaitCursor();
        }
    }

    public void insertColumn() {
        if (!this.showVariables) {
            return;
        }
        int selectedColumnIndex = -1;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            selectedColumnIndex = this.cursor.getColumn();
        }
        TableColumn previousTableColumn = null;
        if (selectedColumnIndex > 0) {
            previousTableColumn = this.table.getColumn(selectedColumnIndex);
        }
        IDatapoolVariable previousVariable = null;
        if (previousTableColumn != null) {
            previousVariable = (IDatapoolVariable)previousTableColumn.getData(TAG_VARIABLE);
        }
        IDatapool datapool = this.getDatapool();
        DatapoolColumnDialog dialog = new DatapoolColumnDialog(Display.getCurrent().getActiveShell(), datapool, null, previousVariable, DatapoolPlugin.getResourceString("DATA_COL_DLG_TITLE_INS"));
        if (dialog.open() == 0) {
            this.setWaitCursor();
            IDatapoolVariable variable = datapool.constructVariable();
            variable.setName(dialog.getName());
            IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
            this.setVariableType(suggestedType, dialog.getType());
            variable.setSuggestedType(suggestedType);
            int insertionIndex = this.findColumnIndex(dialog.getInsertionVariableName());
            if (insertionIndex == -1) {
                insertionIndex = 0;
            }
            datapool.insertVariable(variable, insertionIndex);
            this.unsetWaitCursor();
            this.cursor.setSelection(this.table.getSelectionIndex() > -1 ? this.table.getSelectionIndex() : 0, insertionIndex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteColumn() {
        if (!this.showVariables) {
            return;
        }
        IDatapool datapool = this.getDatapool();
        if (this.cursor == null || this.cursor.isDisposed()) {
            if (this.table.getItemCount() != 0 || this.tableUtil.getColumnCount() <= 0) return;
            DatapoolDeleteColumnDialog dialog = new DatapoolDeleteColumnDialog(Display.getCurrent().getActiveShell(), datapool);
            if (dialog.open() != 0) return;
            this.setWaitCursor();
            String variableID = dialog.getDeletedVariableID();
            int variableIndex = datapool.getVariableIndexById(variableID);
            datapool.removeVariable(variableIndex);
            this.unsetWaitCursor();
            return;
        } else {
            int selectedColumnIndex = this.cursor.getColumn();
            int selectedRowIndex = this.table.getSelectionIndex();
            if (selectedColumnIndex < 1) {
                return;
            }
            this.setWaitCursor();
            TableColumn tableColumn = this.table.getColumn(selectedColumnIndex);
            IDatapoolVariable variable = (IDatapoolVariable)tableColumn.getData(TAG_VARIABLE);
            int variableIndex = datapool.getVariableIndexById(variable.getId());
            datapool.removeVariable(variableIndex);
            this.unsetWaitCursor();
        }
    }

    public void editColumn() {
        int selectedColumnIndex = this.cursor.getColumn();
        TableColumn tableColumn = this.table.getColumn(selectedColumnIndex);
        this.editColumnAux(tableColumn);
    }

    private void editColumnAux(TableColumn tableColumn) {
        if (!this.showVariables) {
            return;
        }
        IDatapool datapool = this.getDatapool();
        int columnIndex = this.table.indexOf(tableColumn);
        TableColumn previousTableColumn = null;
        if (columnIndex != 0) {
            previousTableColumn = this.table.getColumn(columnIndex - 1);
        }
        IDatapoolVariable previousVariable = null;
        if (previousTableColumn != null) {
            previousVariable = (IDatapoolVariable)previousTableColumn.getData(TAG_VARIABLE);
        }
        IDatapoolVariable variable = (IDatapoolVariable)tableColumn.getData(TAG_VARIABLE);
        DatapoolColumnDialog dialog = new DatapoolColumnDialog(Display.getCurrent().getActiveShell(), datapool, variable, previousVariable, DatapoolPlugin.getResourceString("DATA_COL_DLG_TITLE_EDIT"));
        if (dialog.open() == 0) {
            this.setWaitCursor();
            String name = dialog.getName();
            String type = dialog.getType();
            String insertionVariableID = dialog.getInsertionVariableID();
            String previousVariableID = new String();
            if (previousVariable != null) {
                previousVariableID = previousVariable.getId();
            }
            IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
            if (name.equals(variable.getName()) && type.equals(suggestedType.getSuggestedClassName()) && insertionVariableID.equals(previousVariableID)) {
                this.unsetWaitCursor();
                return;
            }
            variable.setName(dialog.getName());
            this.setVariableType(suggestedType, dialog.getType());
            variable.setSuggestedType(suggestedType);
            Integer variableIndex = (Integer)tableColumn.getData(TAG_VARIABLE_INDEX);
            int insertionIndex = this.findColumnIndex(dialog.getInsertionVariableName());
            if (insertionIndex == columnIndex - 1) {
                this.unsetWaitCursor();
                return;
            }
            if (insertionIndex == -1) {
                datapool.moveVariable(columnIndex - 1, 0);
            } else if (insertionIndex > columnIndex) {
                datapool.moveVariable(columnIndex - 1, insertionIndex - 1);
            } else {
                datapool.moveVariable(columnIndex - 1, insertionIndex);
            }
            this.unsetWaitCursor();
        }
    }

    public void clearCell() {
        this.clearCellEditor();
        if (this.cursor != null && !this.cursor.isDisposed() && this.cursor.getColumn() > 0) {
            TableItem selectedTableItem = this.cursor.getRow();
            int selectedColumnIndex = this.cursor.getColumn();
            if (selectedTableItem != null && !selectedTableItem.isDisposed()) {
                IDatapoolCell[] rowData = (IDatapoolCell[])selectedTableItem.getData(TAG_DATA);
                IDatapoolCell cell = rowData[this.cursor.getColumn() - 1];
                Object value = cell.getCellValue();
                if (value == null) {
                    return;
                }
                if (value instanceof String) {
                    if (((String)value).length() == 0) {
                        return;
                    }
                    value = new String();
                } else {
                    value = this.createEmptyCellObject(value.getClass().getName());
                }
                cell.setCellValue(value);
                selectedTableItem.setText(selectedColumnIndex, new ValueObject(value).getDescription());
                this.cursor.setSelection(this.table.getSelectionIndex(), selectedColumnIndex);
                this.cursor.redraw();
                this.datapoolPart.markDirty();
            }
        }
    }

    private IDatapoolCell[] getSelectedCells() {
        IDatapoolCell[] cells = new IDatapoolCell[]{};
        if (this.cursor != null && this.cursor.getColumn() > 0) {
            TableItem selectedTableItem = this.cursor.getRow();
            int selectedColumnIndex = this.cursor.getColumn();
            if (selectedTableItem != null && !selectedTableItem.isDisposed()) {
                IDatapoolCell[] rowData = (IDatapoolCell[])selectedTableItem.getData(TAG_DATA);
                IDatapoolCell cell = rowData[this.cursor.getColumn() - 1];
                cells = new IDatapoolCell[]{cell};
            }
        }
        return cells;
    }

    public void variableAdded(IDatapool datapool, int newVariableIndex) {
        int selectedRowIndex;
        TableColumn tableColumn = new TableColumn(this.table, 0, newVariableIndex + 1);
        IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(newVariableIndex);
        tableColumn.setResizable(true);
        String type = DatapoolUtil.getInstance().getVariableTypeInfo(variable);
        tableColumn.setText(variable.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + type);
        tableColumn.setData(TAG_VARIABLE, (Object)variable);
        tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(newVariableIndex));
        tableColumn.setWidth(100);
        tableColumn.addSelectionListener(this.headerListener);
        tableColumn.addControlListener(this.resizeColumnListener);
        this.tableUtil.insertColumn(tableColumn, newVariableIndex);
        if (this.cursor != null && !this.cursor.isDisposed() && (selectedRowIndex = this.table.getSelectionIndex()) >= 0) {
            this.table.setSelection(selectedRowIndex);
            this.cursor.setSelection(selectedRowIndex, newVariableIndex + 1);
            this.cursor.setFocus();
        }
        this.datapoolPart.markDirty();
    }

    public void variableRemoved(IDatapool datapool, int variableIndex) {
        this.tableUtil.deleteColumn(variableIndex + 1);
        if (this.cursor != null && !this.cursor.isDisposed()) {
            if (variableIndex >= 0) {
                int selectedRowIndex = this.table.getSelectionIndex();
                if (selectedRowIndex >= 0) {
                    this.table.select(selectedRowIndex);
                    this.cursor.setSelection(selectedRowIndex, variableIndex);
                }
            } else {
                this.table.deselectAll();
            }
        }
        this.datapoolPart.markDirty();
    }

    public void variableMoved(IDatapool datapool, int sourceVariableIndex, int targetVariableIndex) {
        int selectedIndex;
        this.tableUtil.moveColumn(sourceVariableIndex + 1, targetVariableIndex + 1);
        if (this.cursor != null && !this.cursor.isDisposed() && targetVariableIndex > 0 && (selectedIndex = this.table.getSelectionIndex()) >= 0) {
            this.table.select(selectedIndex);
            this.cursor.setSelection(selectedIndex, targetVariableIndex);
        }
        this.datapoolPart.markDirty();
    }

    public void variableChanged(IDatapool datapool, int variableIndex) {
        IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(variableIndex);
        int columnIndex = this.findColumnIndex(variable.getName());
        TableColumn tableColumn = this.table.getColumn(columnIndex);
        String type = DatapoolUtil.getInstance().getVariableTypeInfo(variable);
        tableColumn.setText(variable.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + type);
        tableColumn.setData(TAG_VARIABLE, (Object)variable);
        tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(variableIndex));
        this.datapoolPart.markDirty();
    }

    public void variableChanged(IDatapool datapool, int variableIndex, String oldName) {
        this.variableChanged(datapool, variableIndex);
    }

    public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex) {
        if (this.getEquivalenceClassIndex() == equivalenceClassIndex) {
            this.refreshRows();
        }
    }

    public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex, String oldName) {
    }

    public void equivalenceClassAdded(IDatapool datapool, int newEquivalenceClassIndex) {
    }

    public void equivalenceClassRemoved(IDatapool datapool, int equivalenceClassIndex) {
    }

    public void equivalenceClassMoved(IDatapool datapool, int sourceEquivalenceClassIndex, int targetEquivalenceClassIndex) {
        if (this.getEquivalenceClassIndex() == sourceEquivalenceClassIndex) {
            this.setEquivalenceClass((IDatapoolEquivalenceClass)datapool.getEquivalenceClass(targetEquivalenceClassIndex));
            this.refreshRows();
        }
    }

    public void recordAdded(IDatapool datapool, int equivalenceClassIndex, int newRecordIndex) {
        if (this.getEquivalenceClassIndex() == equivalenceClassIndex) {
            this.recordAdded(newRecordIndex);
        }
    }

    protected void recordAdded(int newRecordIndex) {
        if (this.equivalenceClass == null) {
            return;
        }
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)this.equivalenceClass.getRecord(newRecordIndex);
        String[] rowContents = new String[this.table.getColumnCount()];
        IDatapoolCell[] rowData = new IDatapoolCell[this.table.getColumnCount() - 1];
        rowContents[0] = String.valueOf(newRecordIndex);
        int i = 0;
        while (i < record.getCellCount()) {
            IDatapoolCell cell = (IDatapoolCell)record.getCell(i);
            org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable cellVariable = cell.getCellVariable();
            int index = this.findColumnIndex(cellVariable.getName());
            String cellValue = cell.getStringValue();
            ValueObject valueObject = new ValueObject(cell.getCellValue());
            if (valueObject != null) {
                cellValue = valueObject.getDescription();
            }
            rowContents[index] = cellValue;
            rowData[index - 1] = cell;
            ++i;
        }
        TableItem tableItem = new TableItem(this.table, 0, newRecordIndex);
        tableItem.setText(rowContents);
        tableItem.setData(TAG_DATA, (Object)rowData);
        tableItem.setData(TAG_RECORD, (Object)record);
        tableItem.setData(TAG_EQUIVALENCE_CLASS, (Object)this.equivalenceClass);
        this.repopulateRowLabels();
        if (this.table.getItemCount() == 1) {
            this.createCursor();
        }
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            this.table.setSelection(newRecordIndex);
            this.cursor.setSelection(newRecordIndex, this.cursor.getColumn());
            this.cursor.setFocus();
        }
        this.datapoolPart.markDirty();
    }

    public void recordRemoved(IDatapool datapool, int equivalenceClassIndex, int recordIndex) {
        if (this.getEquivalenceClassIndex() == equivalenceClassIndex) {
            this.recordRemoved(recordIndex);
        }
    }

    protected void recordRemoved(int recordIndex) {
        this.table.remove(recordIndex);
        this.repopulateRowLabels();
        this.datapoolPart.markDirty();
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            int tableSize = this.table.getItemCount();
            if (tableSize == 0) {
                this.table.deselectAll();
                return;
            }
            if (tableSize > recordIndex) {
                this.table.setSelection(recordIndex);
                this.cursor.setSelection(recordIndex, 0);
                return;
            }
            if (tableSize > recordIndex - 1) {
                this.table.setSelection(recordIndex - 1);
                this.cursor.setSelection(recordIndex - 1, 0);
            }
        }
    }

    public void recordMoved(IDatapool datapool, int equivalenceClassIndex, int sourceRecordIndex, int targetRecordIndex) {
        if (this.getEquivalenceClassIndex() == equivalenceClassIndex) {
            this.recordMoved(sourceRecordIndex, targetRecordIndex);
        }
    }

    protected void recordMoved(int sourceRecordIndex, int targetRecordIndex) {
        this.tableUtil.moveRow(sourceRecordIndex, targetRecordIndex);
        this.repopulateRowLabels();
        this.cursor.redraw();
        this.datapoolPart.markDirty();
    }

    public void cellChanged(IDatapool datapool, int equivalenceClassIndex, int recordIndex, int variableIndex) {
        if (this.getEquivalenceClassIndex() == equivalenceClassIndex) {
            this.cellChanged(recordIndex, variableIndex);
        }
    }

    protected void cellChanged(int recordIndex, int variableIndex) {
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)this.equivalenceClass.getRecord(recordIndex);
        IDatapoolVariable variable = (IDatapoolVariable)this.getDatapool().getVariable(variableIndex);
        IDatapoolCell cell = null;
        int i = 0;
        while (i < record.getCellCount()) {
            cell = (IDatapoolCell)record.getCell(i);
            if (cell.getCellVariable().equals(variable)) break;
            cell = null;
            ++i;
        }
        if (cell != null) {
            String cellValue = cell.getStringValue();
            ValueObject valueObject = new ValueObject(cell.getCellValue());
            if (valueObject != null) {
                cellValue = valueObject.getDescription();
            }
            String value = cellValue;
            TableItem tableItem = this.table.getItem(recordIndex);
            tableItem.setText(variableIndex + 1, value);
            this.cursor.setSelection(recordIndex, variableIndex + 1);
            this.datapoolPart.markDirty();
        }
        this.datapoolPart.markDirty();
    }

    public void equivalenceClassReordered(IDatapool datapool, int equivalenceClassIndex) {
        if (this.getEquivalenceClassIndex() == equivalenceClassIndex) {
            this.equivalenceClassReordered();
        }
    }

    protected void equivalenceClassReordered() {
        boolean changed = false;
        int i = 0;
        while (i < this.equivalenceClass.getRecordCount()) {
            org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)this.equivalenceClass.getRecord(i);
            int oldTableRowIndex = this.findRowIndex(record);
            if (oldTableRowIndex != i) {
                this.tableUtil.swapRow(oldTableRowIndex, i);
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.datapoolPart.markDirty();
        }
    }

    public void recordChanged(IDatapool datapool, int EquivClassIndex, int recordIndex) {
    }

    public void save(IDatapool datapool) {
        this.alreadySaved = true;
    }

    private int findRowIndex(org.eclipse.hyades.edit.datapool.IDatapoolRecord record) {
        int i = 0;
        while (i < this.equivalenceClass.getRecordCount()) {
            org.eclipse.hyades.edit.datapool.IDatapoolRecord currentRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)this.equivalenceClass.getRecord(i);
            if (currentRecord.equals(record)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void repopulateRowLabels() {
        int i = 0;
        while (i < this.equivalenceClass.getRecordCount()) {
            TableItem tableItem = this.table.getItem(i);
            tableItem.setText(0, String.valueOf(i));
            ++i;
        }
    }

    private int getRecordIndex(IDatapoolEquivalenceClass equivalenceClass, org.eclipse.hyades.edit.datapool.IDatapoolRecord record) {
        int i = 0;
        while (i < equivalenceClass.getRecordCount()) {
            IDatapoolRecord compRecord = equivalenceClass.getRecord(i);
            if (compRecord.equals(record)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected Object[] createCells(IDatapool datapool) {
        Object[] cells = new Object[datapool.getVariableCount()];
        int i = 0;
        while (i < datapool.getVariableCount()) {
            cells[i] = new String();
            ++i;
        }
        return cells;
    }

    private void setVendorConfiguration() {
        block5: {
            if (this.vendorID == null) {
                return;
            }
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.hyades.test.ui.datapool.vendorConfigurationExtension");
            if (extensionPoint == null) break block5;
            try {
                IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
                int i = 0;
                while (i < extensionPoints.length) {
                    String extVendorID = extensionPoints[i].getAttribute("vendorID");
                    if (this.vendorID.equals(extVendorID)) {
                        String strShowEC = extensionPoints[i].getAttribute("showEquivalenceClassCommands");
                        Boolean boolShowEC = Boolean.valueOf(strShowEC);
                        String strShowVar = extensionPoints[i].getAttribute("showVariableCommands");
                        Boolean boolShowVar = Boolean.valueOf(strShowVar);
                        this.showVariables = boolShowVar;
                        String strShowRec = extensionPoints[i].getAttribute("showRecordCommands");
                        Boolean boolShowRec = Boolean.valueOf(strShowRec);
                        this.showRecords = boolShowVar;
                    }
                    ++i;
                }
            }
            catch (Exception e) {}
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private void setVariableType(IDatapoolSuggestedType suggestedType, String type) {
        if (suggestedType == null) {
            return;
        }
        if (TypeChecker.getInstance().isBoolean(type)) {
            suggestedType.setSuggestedType(2);
        } else if (TypeChecker.getInstance().isNumber(type)) {
            suggestedType.setSuggestedType(1);
        } else if (TypeChecker.getInstance().isString(type)) {
            suggestedType.setSuggestedType(0);
        } else if (TypeChecker.getInstance().isEnumeration(type)) {
            suggestedType.setSuggestedType(3);
        } else {
            suggestedType.setSuggestedType(4);
        }
        suggestedType.setSuggestedClassName(type);
    }

    public void save() {
        IDatapool datapool = this.getDatapool();
        this.datapoolFactory.save(datapool);
        this.alreadySaved = true;
    }

    public void dispose() {
        this.clearCellEditor();
        if (this.cursor != null && !this.cursor.isDisposed()) {
            this.cursor.dispose();
        }
        if (this.contextMenu != null && !this.contextMenu.isDisposed()) {
            this.contextMenu.dispose();
        }
        if (this.table != null && !this.table.isDisposed()) {
            this.table.dispose();
        }
        if (this.viewer != null) {
            this.viewer = null;
        }
        if (this.getDatapool() != null) {
            this.getDatapool().removeDatapoolListener((IDatapoolListener)this);
        }
        this.equivalenceClass = null;
        this.datapool = null;
        this.equivalenceClassIndex = -1;
        this.tableUtil = null;
        this.datapoolPart = null;
        this.datapoolFactory = null;
        this.vendorID = null;
        this.controlEditor = null;
        this.cutAction = null;
        this.copyAction = null;
        this.pasteAction = null;
    }

    public IDatapool getDatapool() {
        return this.datapool;
    }

    private void connectCutCopyPasteActions(IDatapoolPart part) {
        IWorkbenchPartSite site;
        if (part instanceof IDatapoolPartExtended && (site = ((IDatapoolPartExtended)part).getEditorPart().getSite()) != null) {
            if (this.cutAction == null) {
                this.cutAction = new CutAction((ISelectionProvider)this.getViewer(), this);
            }
            if (this.copyAction == null) {
                this.copyAction = new CopyAction((ISelectionProvider)this.getViewer(), this);
            }
            if (this.pasteAction == null) {
                this.pasteAction = new PasteAction((ISelectionProvider)this.getViewer(), this);
            }
            IKeyBindingService keyBindingService = site.getKeyBindingService();
            keyBindingService.registerAction((IAction)this.cutAction);
            keyBindingService.registerAction((IAction)this.copyAction);
            keyBindingService.registerAction((IAction)this.pasteAction);
        }
    }

    public void cut() {
        if (this.isF2Mode) {
            this.cellEditor.performCut();
        } else {
            DatapoolClipboard.getInstance().clear();
            int columnIndex = -1;
            if (this.cursor != null && !this.cursor.isDisposed()) {
                columnIndex = this.cursor.getColumn();
            }
            if (columnIndex == -1) {
                return;
            }
            if (columnIndex == 0) {
                this.cutRecords();
            } else {
                this.cutCell();
            }
        }
    }

    public void copy() {
        if (this.isF2Mode) {
            this.cellEditor.performCopy();
        } else {
            DatapoolClipboard.getInstance().clear();
            int columnIndex = -1;
            if (this.cursor != null && !this.cursor.isDisposed()) {
                columnIndex = this.cursor.getColumn();
            }
            if (columnIndex == -1) {
                return;
            }
            if (columnIndex == 0) {
                this.copyRecords();
            } else {
                this.copyCell();
            }
        }
    }

    public void paste() {
        block6: {
            try {
                if (this.isF2Mode) {
                    this.cellEditor.performPaste();
                    break block6;
                }
                int columnIndex = -1;
                if (this.cursor != null && !this.cursor.isDisposed()) {
                    columnIndex = this.cursor.getColumn();
                }
                if (columnIndex == -1) {
                    return;
                }
                if (columnIndex == 0) {
                    this.pasteRecords();
                    break block6;
                }
                this.pasteCell();
            }
            catch (Exception e) {}
        }
    }

    private void cutRecords() {
        TableItem[] tableItems = this.table.getSelection();
        if (tableItems == null || this.table.getSelectionCount() == 0) {
            return;
        }
        int i = 0;
        while (i < tableItems.length) {
            this.cutRecord(tableItems[i]);
            ++i;
        }
        DatapoolClipboard.getInstance().update();
    }

    private void cutRecord(TableItem item) {
        this.copyRecord(item);
        this.clearRecord(item);
    }

    private void clearRecord(TableItem item) {
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)item.getData(TAG_RECORD);
        if (record == null || record.getCellCount() == 0) {
            return;
        }
        int cellCount = record.getCellCount();
        int i = 0;
        while (i < cellCount) {
            IDatapoolCell cell = (IDatapoolCell)record.getCell(i);
            cell.setCellValue(null);
            item.setText(i + 1, new String());
            ++i;
        }
        this.datapoolPart.markDirty();
    }

    private void cutCell() {
        this.copyCell();
        this.clearCell();
    }

    private void copyRecords() {
        TableItem[] tableItems = this.table.getSelection();
        if (tableItems == null || this.table.getSelectionCount() == 0) {
            return;
        }
        int i = 0;
        while (i < tableItems.length) {
            this.copyRecord(tableItems[i]);
            ++i;
        }
        DatapoolClipboard.getInstance().update();
    }

    private void copyRecord(TableItem item) {
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)item.getData(TAG_RECORD);
        if (record == null || record.getCellCount() == 0) {
            return;
        }
        DatapoolClipboard.getInstance().addRecordData(record);
    }

    private void copyCell() {
        int rowIndex = -1;
        TableItem row = null;
        int columnIndex = -1;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        columnIndex = this.cursor.getColumn();
        row = this.cursor.getRow();
        if (row != null) {
            rowIndex = this.table.indexOf(row);
        }
        if (columnIndex == -1 || rowIndex == -1 || row == null) {
            return;
        }
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)row.getData(TAG_RECORD);
        IDatapoolCell cell = (IDatapoolCell)record.getCell(columnIndex - 1);
        DatapoolClipboard.getInstance().addCellData(cell);
        DatapoolClipboard.getInstance().update();
    }

    private void pasteRecords() {
        TableItem[] tableItems = this.table.getSelection();
        if (tableItems == null || this.table.getSelectionCount() == 0) {
            return;
        }
        this.pasteRecords(tableItems);
    }

    private void pasteRecords(TableItem[] tableItems) {
        if (this.table.getColumnCount() <= 1) {
            return;
        }
        tableItems = this.table.getSelection();
        if (tableItems == null || this.table.getSelectionCount() == 0) {
            return;
        }
        boolean isEmpty = true;
        int i = 0;
        while (i < tableItems.length) {
            int j = 1;
            while (j < this.table.getColumnCount()) {
                if (tableItems[i].getText(j).length() > 0) {
                    isEmpty = false;
                    break;
                }
                ++j;
            }
            if (!isEmpty) break;
            ++i;
        }
        if (!isEmpty) {
            Object[] messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_PASTE_OVERWRITE")};
            String message = MessageFormat.format("{0}", messageElements);
            MessageDialog overwriteDialog = new MessageDialog(this.parent.getShell(), DatapoolPlugin.getResourceString("PASTE_TEXT"), null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            if (overwriteDialog.open() != 0) {
                return;
            }
        }
        TableItem firstItem = tableItems[0];
        int firstItemIndex = this.table.indexOf(firstItem);
        Object[] recordDataSet = DatapoolClipboard.getInstance().getRecordDataSet();
        if (recordDataSet == null || recordDataSet.length == 0) {
            Object cellData = DatapoolClipboard.getInstance().getCellData();
            if (cellData != null) {
                this.pasteDataToCell(cellData, firstItem, 1);
            }
            return;
        }
        int i2 = 0;
        while (i2 < recordDataSet.length) {
            Object[] recordData;
            if (firstItemIndex + i2 < this.table.getItemCount() && (recordData = (Object[])recordDataSet[i2]) != null) {
                TableItem tableItem = this.table.getItem(firstItemIndex + i2);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
                int j = 0;
                while (j < recordData.length) {
                    if (j < record.getCellCount()) {
                        this.pasteDataToCell(recordData[j], tableItem, j + 1);
                    }
                    ++j;
                }
            }
            ++i2;
        }
    }

    private void pasteCell() {
        int rowIndex = -1;
        TableItem row = null;
        int columnIndex = -1;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        columnIndex = this.cursor.getColumn();
        row = this.cursor.getRow();
        if (row != null) {
            rowIndex = this.table.indexOf(row);
        }
        if (columnIndex == -1 || rowIndex == -1 || row == null) {
            return;
        }
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)row.getData(TAG_RECORD);
        IDatapoolCell cell = (IDatapoolCell)record.getCell(columnIndex - 1);
        Object cellValue = DatapoolClipboard.getInstance().getCellData();
        if (cellValue != null) {
            String cellStringValue = this.setCellValue(cellValue, cell);
            row.setText(columnIndex, cellStringValue);
            this.cursor.setSelection(this.table.getSelectionIndex(), columnIndex);
            this.datapoolPart.markDirty();
            this.cursor.redraw();
            return;
        }
        Object[] recordData = DatapoolClipboard.getInstance().getRecordDataSet();
        if (recordData != null) {
            if (columnIndex == 1) {
                this.pasteRecords(new TableItem[]{row});
                this.cursor.redraw();
                return;
            }
            if (columnIndex > 1) {
                String message = DatapoolPlugin.getResourceString("DATA_PASTE_DIFF_SIZE");
                MessageDialog warningDialog = new MessageDialog(this.parent.getShell(), DatapoolPlugin.getResourceString("PASTE_TEXT"), null, message, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
                warningDialog.open();
                return;
            }
        }
    }

    private void pasteDataToCell(Object data, TableItem tableItem, int index) {
        org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
        if (index - 1 < record.getCellCount()) {
            IDatapoolCell cell = (IDatapoolCell)record.getCell(index - 1);
            String cellValue = this.setCellValue(data, cell);
            tableItem.setText(index, cellValue);
            this.datapoolPart.markDirty();
        }
    }

    private String setCellValue(Object data, IDatapoolCell cell) {
        cell.setCellValue(data);
        String cellValue = cell.getStringValue();
        ValueObject valueObject = new ValueObject(cell.getCellValue());
        if (valueObject != null) {
            cellValue = valueObject.getDescription();
        }
        return cellValue;
    }

    public IDatapoolPart getIDatapoolPart() {
        return this.datapoolPart;
    }

    public void refresh() {
        this.refresh(this.equivalenceClass);
    }

    public void refresh(IDatapool datapool) {
        this.refresh(this.getDefaultEquivalenceClass(datapool));
    }

    public void refresh(IDatapoolEquivalenceClass ec) {
        if (this.equivalenceClass == ec) {
            return;
        }
        this.setWaitCursor();
        if (this.equivalenceClass != null && this.equivalenceClass != ec) {
            ((IDatapool)this.equivalenceClass.getDatapool()).removeDatapoolListener((IDatapoolListener)this);
        }
        if (ec != null && ec != this.equivalenceClass) {
            ((IDatapool)ec.getDatapool()).addDatapoolListener((IDatapoolListener)this);
        }
        this.setEquivalenceClass(ec);
        if (ec == null) {
            this.hideTable();
        } else {
            this.restoreTable();
            this.refreshColumns();
            this.refreshRows();
            this.resetCursor();
        }
        this.unsetWaitCursor();
    }

    private void hideTable() {
        this.table.setVisible(false);
        this.table.setEnabled(false);
        this.table.setHeaderVisible(false);
    }

    private void restoreTable() {
        this.table.setEnabled(true);
        this.table.setVisible(true);
        this.table.setHeaderVisible(true);
    }

    private void refreshColumns() {
        TableItem selectedItem;
        IDatapool datapool = this.getDatapool();
        int newColumnCount = datapool.getVariableCount();
        int oldColumnCount = this.tableUtil.getColumnCount() - 1;
        if (this.cursor != null && !this.cursor.isDisposed() && (selectedItem = this.cursor.getRow()) != null) {
            int selectedColumnIndex = this.cursor.getColumn();
            if (selectedColumnIndex > newColumnCount) {
                this.cursor.setSelection(selectedItem, newColumnCount);
            } else {
                this.cursor.setSelection(selectedItem, selectedColumnIndex);
            }
        }
        if (oldColumnCount > newColumnCount) {
            int numberToDelete = oldColumnCount - newColumnCount;
            int i = 0;
            while (i < numberToDelete) {
                this.tableUtil.deleteColumn(newColumnCount + 1);
                ++i;
            }
        }
        int i = 0;
        while (i < newColumnCount) {
            int index = i + 1;
            TableColumn tableColumn = null;
            if (index < this.tableUtil.getColumnCount()) {
                tableColumn = this.table.getColumn(index);
            } else {
                tableColumn = new TableColumn(this.table, 0, index);
                tableColumn.setWidth(100);
                tableColumn.addSelectionListener(this.headerListener);
                tableColumn.addControlListener(this.resizeColumnListener);
            }
            IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(i);
            tableColumn.setResizable(true);
            String type = DatapoolUtil.getInstance().getVariableTypeInfo(variable);
            tableColumn.setText(variable.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + type);
            tableColumn.setData(TAG_VARIABLE, (Object)variable);
            tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(i));
            ++i;
        }
    }

    private void refreshRows() {
        TableItem selectedItem;
        int oldRowCount = this.table.getItemCount();
        int rowIndex = 0;
        int i = 0;
        while (i < this.equivalenceClass.getRecordCount()) {
            org.eclipse.hyades.edit.datapool.IDatapoolRecord record = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)this.equivalenceClass.getRecord(i);
            int cellCount = record.getCellCount();
            int variableCount = this.getDatapool().getVariableCount();
            String[] rowContents = new String[variableCount + 1];
            IDatapoolCell[] rowData = new IDatapoolCell[variableCount];
            rowContents[0] = String.valueOf(i);
            int k = 0;
            while (k < cellCount) {
                IDatapoolCell cell = (IDatapoolCell)record.getCell(k);
                IDatapoolVariable cellVariable = (IDatapoolVariable)cell.getCellVariable();
                int index = this.findColumnIndex(cellVariable.getName());
                String cellValue = cell.getStringValue();
                ValueObject valueObject = new ValueObject(cell.getCellValue());
                if (valueObject != null) {
                    cellValue = valueObject.getDescription();
                }
                rowContents[index] = cellValue;
                rowData[index - 1] = cell;
                ++k;
            }
            TableItem item = null;
            item = rowIndex < this.table.getItemCount() ? this.table.getItem(rowIndex) : new TableItem(this.table, 0);
            item.setText(rowContents);
            item.setData(TAG_DATA, (Object)rowData);
            item.setData(TAG_RECORD, (Object)record);
            item.setData(TAG_EQUIVALENCE_CLASS, (Object)this.equivalenceClass);
            ++rowIndex;
            ++i;
        }
        try {
            if (this.cursor == null || this.cursor.isDisposed()) {
                this.createCursor();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int newRowCount = rowIndex;
        if (this.cursor != null && !this.cursor.isDisposed() && (selectedItem = this.cursor.getRow()) != null) {
            int selectedColumnIndex = this.cursor.getColumn();
            int selectedRowIndex = this.table.indexOf(selectedItem);
            if (selectedRowIndex > newRowCount - 1) {
                if (newRowCount - 1 < 0) {
                    this.table.deselectAll();
                    if (this.cursor != null && !this.cursor.isDisposed()) {
                        this.cursor.dispose();
                    }
                } else {
                    this.table.setSelection(newRowCount - 1);
                    this.cursor.setSelection(newRowCount - 1, selectedColumnIndex);
                }
            } else {
                this.cursor.setSelection(selectedRowIndex, selectedColumnIndex);
            }
        }
        if (oldRowCount > newRowCount) {
            int numberToDelete = oldRowCount - newRowCount;
            int i2 = 0;
            while (i2 < numberToDelete) {
                this.table.remove(newRowCount);
                ++i2;
            }
        }
    }

    private IDatapoolEquivalenceClass getDefaultEquivalenceClass(IDatapool datapool) {
        if (datapool == null) {
            return null;
        }
        int newECIndex = datapool.getDefaultEquivalenceClassIndex();
        if (newECIndex == -1) {
            if (datapool.getEquivalenceClassCount() == 0) {
                datapool.appendEquivalenceClass(datapool.constructEquivalenceClass());
            }
            newECIndex = 0;
        }
        return (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(newECIndex);
    }

    private void setEquivalenceClass(IDatapoolEquivalenceClass ec) {
        if (this.equivalenceClass == ec) {
            return;
        }
        this.equivalenceClass = ec;
        if (ec == null) {
            this.datapool = null;
            this.equivalenceClassIndex = -1;
        } else {
            this.datapool = (IDatapool)ec.getDatapool();
            this.equivalenceClassIndex = this.datapool.getEquivalenceClassIndexById(ec.getId());
        }
    }

    private int getEquivalenceClassIndex() {
        return this.equivalenceClassIndex;
    }

    public IDatapoolEquivalenceClass getEquivalenceClass() {
        return this.equivalenceClass;
    }

    class TableMouseAdapter
    implements MouseListener {
        TableMouseAdapter() {
        }

        public void mouseDoubleClick(MouseEvent event) {
        }

        public void mouseDown(MouseEvent event) {
        }

        public void mouseUp(MouseEvent event) {
            if (event.button == 3) {
                if (DatapoolTable.this.contextMenu == null || DatapoolTable.this.contextMenu.isDisposed()) {
                    DatapoolTable.this.createMenu();
                }
                DatapoolTable.this.contextMenu.setEnabled(true);
                DatapoolTable.this.contextMenu.setVisible(true);
            }
        }
    }

    class CursorSelectionAdapter
    implements SelectionListener {
        private CellEditor editor = null;
        private TableCursor cursor = null;
        private IDatapoolPart datapoolPart = null;

        public CursorSelectionAdapter(TableCursor cursor, CellEditor cellEditor, IDatapoolPart datapoolPart) {
            this.editor = cellEditor;
            this.cursor = cursor;
            this.datapoolPart = datapoolPart;
        }

        public void widgetSelected(SelectionEvent event) {
            if (this.datapoolPart.isReadOnly()) {
                return;
            }
            DatapoolTable.this.clearCellEditor();
            if (!DatapoolTable.this.isInputValid) {
                return;
            }
            DatapoolTable.this.table.setSelection(new TableItem[]{this.cursor.getRow()});
            if (DatapoolTable.this.datapoolMenuManager != null) {
                DatapoolTable.this.setMenuMode(DatapoolTable.this.datapoolMenuManager);
            }
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }
    }

    class CursorMouseAdapter
    implements MouseListener {
        private CellEditor editor = null;
        private TableCursor cursor = null;
        private IDatapoolPart datapoolPart = null;

        public CursorMouseAdapter(TableCursor cursor, CellEditor cellEditor, IDatapoolPart datapoolPart) {
            this.editor = cellEditor;
            this.cursor = cursor;
            this.datapoolPart = datapoolPart;
        }

        public void mouseDoubleClick(MouseEvent event) {
            if (DatapoolTable.this.equivalenceClass == null) {
                return;
            }
            this.datapoolPart.notifyEdit();
            if (this.datapoolPart.isReadOnly()) {
                return;
            }
            TableItem row = this.cursor.getRow();
            int column = this.cursor.getColumn();
            if (column == 0) {
                DatapoolTable.this.editRowAux(row);
                return;
            }
            DatapoolTable.this.startCellEditing(row, column);
            if (DatapoolTable.this.cellEditor != null) {
                DatapoolTable.this.isF2Mode = true;
            }
        }

        public void mouseDown(MouseEvent event) {
            if (event.button != 1) {
                return;
            }
            DatapoolTable.this.clearCellEditor();
        }

        public void mouseUp(MouseEvent event) {
            if (event.button == 3) {
                DatapoolTable.this.contextMenu.setEnabled(true);
                DatapoolTable.this.contextMenu.setVisible(true);
            }
        }
    }

    class CursorKeyAdapter
    implements KeyListener {
        private CellEditor editor = null;
        private TableCursor cursor = null;
        private IDatapoolPart datapoolPart = null;

        public CursorKeyAdapter(TableCursor cursor, CellEditor cellEditor, IDatapoolPart datapoolPart) {
            this.editor = cellEditor;
            this.cursor = cursor;
            this.datapoolPart = datapoolPart;
        }

        public void keyPressed(KeyEvent e) {
            if (DatapoolTable.this.equivalenceClass == null) {
                return;
            }
            if (e.keyCode == 0x1000013 && (e.stateMask & 0x20000) != 0) {
                if (DatapoolTable.this.contextMenu == null || DatapoolTable.this.contextMenu.isDisposed()) {
                    DatapoolTable.this.createMenu();
                }
                DatapoolTable.this.contextMenu.setEnabled(true);
                DatapoolTable.this.contextMenu.setVisible(true);
                return;
            }
            if (e.keyCode == 65536) {
                DatapoolTable.this.altKeyDown = true;
            }
            if (e.keyCode == 262144) {
                DatapoolTable.this.controlKeyDown = true;
                DatapoolTable.this.connectCutCopyPasteActions(DatapoolTable.this.datapoolPart);
            }
            int selectedColumnIndex = this.cursor.getColumn();
            TableItem row = this.cursor.getRow();
            if (e.keyCode == 27 || e.keyCode == 13 || e.keyCode == 65536 || e.keyCode == 0x1000002 || e.keyCode == 0x1000001 || e.keyCode == 0x1000003 || e.keyCode == 0x1000004 || e.keyCode == 0x1000006 || e.keyCode == 0x1000005 || e.keyCode == 0x1000007 || e.keyCode == 0x1000008 || e.keyCode == 262144 || e.keyCode == 131072 || e.keyCode == 0x100000A || e.keyCode == 9 || e.keyCode >= 0x100000C && e.keyCode <= 0x1000015) {
                return;
            }
            this.datapoolPart.notifyEdit();
            if (this.datapoolPart.isReadOnly()) {
                return;
            }
            if (e.keyCode == 0x1000009 && (e.stateMask & 0x40000) != 0) {
                if (selectedColumnIndex > 0) {
                    DatapoolTable.this.insertColumn();
                }
                return;
            }
            if (e.keyCode == 127 && (e.stateMask & 0x40000) != 0) {
                if (selectedColumnIndex > 0) {
                    DatapoolTable.this.deleteColumn();
                }
                return;
            }
            if ((e.stateMask & 0x40000) != 0 || (e.stateMask & 0x10000) != 0) {
                return;
            }
            if (e.keyCode == 0x1000009) {
                if (selectedColumnIndex == 0) {
                    DatapoolTable.this.insertRow();
                }
                if (selectedColumnIndex <= 0) {
                    return;
                }
            }
            if (e.keyCode == 127) {
                if (selectedColumnIndex == 0) {
                    DatapoolTable.this.deleteRow();
                }
                if (selectedColumnIndex > 0) {
                    DatapoolTable.this.clearCell();
                }
                return;
            }
            char inputCharacter = e.character;
            if (selectedColumnIndex == 0) {
                DatapoolTable.this.editRowAux(row);
                return;
            }
            DatapoolTable.this.startCellEditing(row, selectedColumnIndex);
            if (DatapoolTable.this.cellEditor instanceof TextCellEditor) {
                if (e.keyCode == 8) {
                    DatapoolTable.this.cellEditor.setValue((Object)new String());
                } else if (e.keyCode == 0x100000B) {
                    String currentText = row.getText(selectedColumnIndex);
                    DatapoolTable.this.cellEditor.setValue((Object)currentText);
                    ((Text)DatapoolTable.this.cellEditor.getControl()).setSelection(currentText.length());
                    DatapoolTable.this.isF2Mode = true;
                } else {
                    String characterValue = String.valueOf(inputCharacter);
                    if (DatapoolTable.this.cellEditor.getValidator() != null && DatapoolTable.this.cellEditor.getValidator().isValid((Object)characterValue) != null) {
                        DatapoolTable.this.isInputValid = false;
                    }
                    DatapoolTable.this.cellEditor.setValue((Object)characterValue);
                    ((Text)DatapoolTable.this.cellEditor.getControl()).setSelection(2);
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 262144) {
                DatapoolTable.this.controlKeyDown = false;
                return;
            }
            if (DatapoolTable.this.altKeyDown) {
                DatapoolTable.this.altKeyDown = false;
                return;
            }
            if (e.keyCode == 0x1000009 && (e.stateMask & 0x40000) != 0) {
                int selectedColumnIndex = this.cursor.getColumn();
                if (selectedColumnIndex > 0) {
                    DatapoolTable.this.insertColumn();
                }
                return;
            }
        }
    }

    class TableCellTraverseAdapter
    extends AbstractTraverseAdapter {
        private CellEditor editor;
        private ValueObject valueObject;
        private int row;
        private int column;

        private TableCellTraverseAdapter(CellEditor editor, ValueObject valueObject, TableItem row, int column) {
            this.editor = editor;
            this.valueObject = valueObject;
            this.row = DatapoolTable.this.table.indexOf(row);
            this.column = column;
        }

        public void keyTraversed(TraverseEvent e) {
            super.keyTraversed(e);
            if (e.detail == 64 || e.detail == 32) {
                if (DatapoolTable.this.isF2Mode) {
                    return;
                }
                e.doit = false;
                this.preTraverse();
                if (e.keyCode == 0x1000004) {
                    this.traverseRight();
                }
                if (e.keyCode == 0x1000003) {
                    this.traverseLeft();
                }
                if (e.keyCode == 0x1000001) {
                    this.traverseUp();
                }
                if (e.keyCode == 0x1000002) {
                    this.traverseDown();
                }
            }
        }

        protected void preTraverse() {
            if (this.valueObject != null) {
                DatapoolTable.this.applyEditingValue(true);
            }
        }

        protected int getColumn() {
            return this.column;
        }

        protected int getRow() {
            return this.row;
        }

        protected TableCursor getCursor() {
            return DatapoolTable.this.cursor;
        }
    }

    private class CursorTraverseAdapter
    extends AbstractTraverseAdapter {
        private CursorTraverseAdapter() {
        }

        protected int getColumn() {
            return DatapoolTable.this.cursor.getColumn();
        }

        protected int getRow() {
            return DatapoolTable.this.table.indexOf(DatapoolTable.this.cursor.getRow());
        }

        protected TableCursor getCursor() {
            return DatapoolTable.this.cursor;
        }
    }

    abstract class AbstractTraverseAdapter
    implements TraverseListener {
        private AbstractTraverseAdapter() {
        }

        protected void preTraverse() {
        }

        protected abstract TableCursor getCursor();

        protected abstract int getColumn();

        protected abstract int getRow();

        public void keyTraversed(TraverseEvent e) {
            if (!DatapoolTable.this.isInputValid || DatapoolTable.this.cursor == null || DatapoolTable.this.cursor.isDisposed()) {
                e.doit = false;
                return;
            }
            if (e.detail == 16 || e.detail == 8 || e.detail == 4) {
                e.doit = false;
                this.preTraverse();
                if (e.detail == 16) {
                    if (this.getColumn() + 1 == DatapoolTable.this.tableUtil.getColumnCount()) {
                        DatapoolTable.this.insertColumn();
                    } else {
                        this.traverseRight();
                    }
                }
                if (e.detail == 8) {
                    this.traverseLeft();
                }
                if (e.detail == 4) {
                    if (this.getRow() + 1 == DatapoolTable.this.table.getItemCount()) {
                        DatapoolTable.this.insertRow();
                    }
                    this.traverseDown();
                }
            }
        }

        protected void traverseRight() {
            if (this.getColumn() + 1 < DatapoolTable.this.tableUtil.getColumnCount()) {
                DatapoolTable.this.cursor.setSelection(this.getRow(), this.getColumn() + 1);
            }
        }

        protected void traverseLeft() {
            if (this.getColumn() > 0) {
                DatapoolTable.this.cursor.setSelection(this.getRow(), this.getColumn() - 1);
            }
        }

        protected void traverseUp() {
            if (this.getRow() > 0) {
                DatapoolTable.this.table.setSelection(this.getRow() - 1);
                DatapoolTable.this.cursor.setSelection(this.getRow() - 1, this.getColumn());
            }
        }

        protected void traverseDown() {
            int newRowIndex = this.getRow() + 1;
            if (newRowIndex < DatapoolTable.this.table.getItemCount()) {
                DatapoolTable.this.table.setSelection(newRowIndex);
                DatapoolTable.this.cursor.setSelection(newRowIndex, this.getColumn());
            }
        }
    }

    class TableCellValidator
    implements ICellEditorValidator {
        IValidateValueClass validator = null;

        public TableCellValidator(IValidateValueClass validator) {
            this.validator = validator;
        }

        public String isValid(Object value) {
            if (this.validator == null) {
                return null;
            }
            if (this.validator.checkValue(value)) {
                return null;
            }
            Error error = this.validator.getError();
            if (error != null) {
                return error.toString();
            }
            return "Error";
        }
    }

    class TableCellKeyAdapter
    implements KeyListener {
        private CellEditor editor = null;
        private ValueObject valueObject = null;
        private TableItem row = null;
        private int rowIndex = -1;
        private int column = -1;

        public TableCellKeyAdapter(CellEditor cellEditor, ValueObject valueObject, TableItem row, int column) {
            this.editor = cellEditor;
            this.valueObject = valueObject;
            this.row = row;
            this.column = column;
            if (row != null) {
                this.rowIndex = DatapoolTable.this.table.indexOf(row);
            }
        }

        public void keyPressed(KeyEvent e) {
            if (DatapoolTable.this.equivalenceClass == null) {
                return;
            }
            if (e.character == '\r') {
                if (!DatapoolTable.this.isInputValid) {
                    e.doit = false;
                    return;
                }
                return;
            }
            if (e.keyCode == 0x1000013 && (e.stateMask & 0x20000) != 0) {
                if (DatapoolTable.this.contextMenu == null || DatapoolTable.this.contextMenu.isDisposed()) {
                    DatapoolTable.this.createMenu();
                }
                DatapoolTable.this.contextMenu.setEnabled(true);
                DatapoolTable.this.contextMenu.setVisible(true);
                return;
            }
            if (!(DatapoolTable.this.isF2Mode || e.keyCode != 0x1000002 && e.keyCode != 0x1000001 && e.keyCode != 0x1000003 && e.keyCode != 0x1000004)) {
                if (!DatapoolTable.this.isInputValid) {
                    e.doit = false;
                    return;
                }
                DatapoolTable.this.applyEditingValue(true);
                if (DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed()) {
                    if (e.keyCode == 0x1000002 && this.rowIndex + 1 < DatapoolTable.this.table.getItemCount()) {
                        DatapoolTable.this.table.setSelection(this.rowIndex + 1);
                        DatapoolTable.this.cursor.setSelection(this.rowIndex + 1, this.column);
                    }
                    if (e.keyCode == 0x1000001 && this.rowIndex > 0) {
                        DatapoolTable.this.table.setSelection(this.rowIndex - 1);
                        DatapoolTable.this.cursor.setSelection(this.rowIndex - 1, this.column);
                    }
                    if (e.keyCode == 0x1000004 && this.column + 1 < DatapoolTable.this.tableUtil.getColumnCount()) {
                        DatapoolTable.this.cursor.setSelection(this.rowIndex, this.column + 1);
                    }
                    if (e.keyCode == 0x1000003 && this.column > 0) {
                        DatapoolTable.this.cursor.setSelection(this.rowIndex, this.column - 1);
                    }
                    DatapoolTable.this.cursor.setFocus();
                }
                return;
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == '\u001b') {
                DatapoolTable.this.clearCellEditor(this.editor);
                return;
            }
            if (!(e.keyCode != 0x1000002 && e.keyCode != 0x1000001 && e.keyCode != 0x1000003 && e.keyCode != 0x1000004 || DatapoolTable.this.isInputValid)) {
                e.doit = false;
                return;
            }
        }
    }

    class TableCellPaintAdapter
    implements PaintListener {
        TableCellPaintAdapter() {
        }

        public void paintControl(PaintEvent event) {
            if (!DatapoolTable.this.isInputValid) {
                this.drawPolyline(event.gc, (Widget)event.getSource());
            } else {
                event.gc.drawPolyline(new int[0]);
            }
        }

        private void drawPolyline(GC gc, Widget widget) {
            if (gc == null) {
                return;
            }
            Rectangle rect = gc.getClipping();
            String str = "";
            if (widget instanceof Text) {
                str = ((Text)widget).getText();
            } else if (widget instanceof CCombo) {
                str = ((CCombo)widget).getText();
            } else if (widget instanceof Combo) {
                str = ((Combo)widget).getText();
            } else {
                return;
            }
            int offset = 2;
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (!Character.isWhitespace(c)) break;
                offset += gc.getAdvanceWidth(c);
                ++i;
            }
            int length = gc.textExtent((String)str.trim()).x;
            Point left = new Point(offset, 0);
            Point right = new Point(length + offset + 2, 0);
            gc.setForeground(Display.getCurrent().getSystemColor(3));
            int[] polyline = this.computePolyline(left, right, rect.height);
            gc.drawPolyline(polyline);
        }

        private int[] computePolyline(Point left, Point right, int height) {
            int WIDTH = 4;
            int HEIGHT = 2;
            int leftX = left.x;
            int peeks = (right.x - left.x) / 4;
            int length = (2 * peeks + 1) * 2;
            if (length < 0) {
                return new int[0];
            }
            int[] coordinates = new int[length];
            int bottom = left.y + height - 1;
            int top = bottom - 2;
            int i = 0;
            while (i < peeks) {
                int index = 4 * i;
                coordinates[index] = leftX + 4 * i;
                coordinates[index + 1] = bottom;
                coordinates[index + 2] = coordinates[index] + 2;
                coordinates[index + 3] = top;
                ++i;
            }
            coordinates[length - 2] = left.x + 4 * peeks;
            coordinates[length - 1] = bottom;
            return coordinates;
        }
    }

    class TableCellEditorAdapter
    implements ICellEditorListener {
        private CellEditor editor = null;
        private ValueObject valueObject = null;
        private TableItem row = null;
        private int rowIndex = -1;
        private int column = -1;

        public TableCellEditorAdapter(CellEditor cellEditor, ValueObject valueObject, TableItem row, int column) {
            this.editor = cellEditor;
            this.valueObject = valueObject;
            this.row = row;
            this.column = column;
            if (row != null) {
                this.rowIndex = DatapoolTable.this.table.indexOf(row);
            }
        }

        public void applyEditorValue() {
            DatapoolTable.this.isF2Mode = false;
            if (!DatapoolTable.this.isInputValid) {
                return;
            }
            DatapoolTable.this.applyEditingValue(true);
        }

        public void cancelEditor() {
            DatapoolTable.this.isF2Mode = false;
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            if (!newValidState) {
                DatapoolTable.this.isInputValid = false;
            } else {
                DatapoolTable.this.isInputValid = true;
            }
            this.editor.getControl().redraw();
        }
    }
}

