/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.util;

import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDisplayValueClass;
import org.eclipse.hyades.test.ui.datapool.internal.util.ValueClassMap;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ValueObject {
    private Object theObject;
    private IDisplayValueClass valueClass;
    private String description;
    private String property;
    private Object display;
    private Object dialogDisplay;

    public ValueObject(Object theObject) {
        this.theObject = theObject;
        this.valueClass = ValueClassMap.getSWTValueDisplayClass(theObject);
        this.description = null;
    }

    public Object getObject() {
        return this.theObject;
    }

    public void setObject(Object newObject) {
        this.theObject = newObject;
        this.description = null;
    }

    public Object getPropertyDisplay(Composite parent) {
        Control control;
        if (this.display != null && this.display instanceof CellEditor && (control = ((CellEditor)this.display).getControl()) != null && !control.isDisposed()) {
            return this.display;
        }
        if (this.valueClass != null) {
            this.display = this.valueClass.getPropertyDisplay(this.theObject, parent, true);
            return this.display;
        }
        return null;
    }

    public Object getDialogDisplay(Composite parent, boolean isEditable) {
        return null;
    }

    public Object updateObject() {
        if (this.valueClass != null && this.display != null) {
            this.theObject = this.valueClass.getUpdatedObject(this.theObject, this.display);
            this.description = this.valueClass.getPropertyDescription(this.theObject);
        }
        return this.theObject;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.valueClass != null ? this.valueClass.getPropertyDescription(this.theObject) : (this.theObject != null ? this.theObject.toString() : new String());
        }
        return this.description;
    }
}

