/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.FormattingException;
import org.eclipse.hyades.logging.events.cbe.TemplateContentHandler;
import org.eclipse.hyades.logging.events.cbe.impl.AbstractEventFactoryHome;
import org.eclipse.hyades.logging.events.cbe.impl.TemplateContentHandlerImpl;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;

public class EventXMLFileEventFactoryHomeImpl
extends AbstractEventFactoryHome {
    public static final String XML_FILE_EXTENSION = ".event.xml";

    public ContentHandler resolveContentHandler() {
        return new TemplateContentHandlerImpl();
    }

    public InputStream resolveTemplateXMLFileInputStream(final String string) {
        InputStream inputStream = null;
        if (string != null && string.trim().length() > 0) {
            try {
                inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return this.getClass().getClassLoader().getResourceAsStream(string);
                    }
                });
            }
            catch (Throwable throwable) {
                try {
                    inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return ClassLoader.getSystemClassLoader().getResourceAsStream(string);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    try {
                        inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
                            }
                        });
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
            }
        }
        return inputStream;
    }

    public ContentHandler createContentHandler(String string) {
        if (string != null && string.trim().length() > 0) {
            int n;
            InputStream inputStream = this.resolveTemplateXMLFileInputStream(string.concat(XML_FILE_EXTENSION));
            if (inputStream != null) {
                try {
                    CommonBaseEvent[] commonBaseEventArray = EventFormatter.eventsFromCanonicalXMLDoc(inputStream);
                    if (commonBaseEventArray != null && commonBaseEventArray.length > 0 && commonBaseEventArray[0] != null) {
                        TemplateContentHandler templateContentHandler = (TemplateContentHandler)this.resolveContentHandler();
                        templateContentHandler.setTemplateEvent(commonBaseEventArray[0]);
                        return templateContentHandler;
                    }
                }
                catch (FormattingException formattingException) {
                    // empty catch block
                }
            }
            if ((n = string.lastIndexOf(46)) != -1) {
                return this.createContentHandler(string.substring(0, n));
            }
        }
        return null;
    }
}

