/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportTraceRange
implements SelectionListener,
ModifyListener {
    private Label _regionLabel;
    private Button _wholeFileBtn;
    private Button _inRangeBtn;
    private Label _startLabel;
    private Text _startText;
    private Label _ofFileLabel1;
    private Label _ofFileLabel2;
    private Label _stopLabel;
    private Text _stopText;
    private double startValue = 0.0;
    private double stopValue = 100.0;
    private FiltersStandardTabUI _tabUI;

    public ImportTraceRange(FiltersStandardTabUI tabUI) {
        this._tabUI = tabUI;
    }

    public void createControl(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setText(TraceUIPlugin.getString("FILTER_RANGE_OPTION_STR"));
        Composite optionGroup = new Composite((Composite)composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 7;
        layout.verticalSpacing = 5;
        optionGroup.setLayout((Layout)layout);
        GridData gd = GridUtil.createFill();
        optionGroup.setLayoutData((Object)gd);
        this._wholeFileBtn = new Button(optionGroup, 16);
        gd = new GridData();
        gd.horizontalSpan = 7;
        this._wholeFileBtn.setLayoutData((Object)gd);
        this._wholeFileBtn.setText(TraceUIPlugin.getString("FILTER_RANGE_COMPLETE_STR"));
        this._inRangeBtn = new Button(optionGroup, 16);
        this._inRangeBtn.setText(TraceUIPlugin.getString("FILTER_RANGE_PARTIAL_STR"));
        this._startLabel = new Label(optionGroup, 0);
        this._startLabel.setText(TraceUIPlugin.getString("FILTER_RANGE_FROM_STR"));
        this._startText = new Text(optionGroup, 2048);
        gd = new GridData();
        gd.widthHint = 30;
        this._startText.setLayoutData((Object)gd);
        this._ofFileLabel1 = new Label(optionGroup, 0);
        this._ofFileLabel1.setText(TraceUIPlugin.getString("FILTER_RANGE_PERCENT_STR"));
        this._stopLabel = new Label(optionGroup, 0);
        this._stopLabel.setText(TraceUIPlugin.getString("FILTER_RANGE_TO_STR"));
        this._stopText = new Text(optionGroup, 2048);
        gd = new GridData();
        gd.widthHint = 30;
        this._stopText.setLayoutData((Object)gd);
        this._ofFileLabel2 = new Label(optionGroup, 0);
        this._ofFileLabel2.setText(TraceUIPlugin.getString("FILTER_RANGE_PERCENT_STR"));
        this._wholeFileBtn.addSelectionListener((SelectionListener)this);
        this._inRangeBtn.addSelectionListener((SelectionListener)this);
        this._startText.addModifyListener((ModifyListener)this);
        this._stopText.addModifyListener((ModifyListener)this);
        this.initData();
    }

    private void initData() {
        this._wholeFileBtn.setSelection(true);
        this._startText.setText(String.valueOf(this.startValue));
        this._stopText.setText(String.valueOf(this.stopValue));
        this.setRangeInputEnable(false);
    }

    public Button getWholeFileBtn() {
        return this._wholeFileBtn;
    }

    public Button getInRangeBtn() {
        return this._inRangeBtn;
    }

    public boolean getWholeFileSelection() {
        return this._wholeFileBtn.getSelection();
    }

    public boolean getInRangeSelection() {
        return this._inRangeBtn.getSelection();
    }

    public double getStartRange() {
        return this.startValue;
    }

    public double getStopRange() {
        return this.stopValue;
    }

    public String checkRegionValue() {
        if (this._startText.getText().trim().equals("") || this._stopText.getText().trim().equals("")) {
            return TraceUIPlugin.getString("FILTER_RANGE_CANNOT_EMPTY_VALUE");
        }
        try {
            this.startValue = Double.parseDouble(this._startText.getText().trim());
            this.stopValue = Double.parseDouble(this._stopText.getText().trim());
            if (this.startValue > this.stopValue) {
                return TraceUIPlugin.getString("FILTER_RANGE_START_LARGER_STOP");
            }
            if (this.startValue == this.stopValue) {
                return TraceUIPlugin.getString("FILTER_RANGE_CANNOT_SAME");
            }
            if (this.startValue < 0.0 || this.startValue > 100.0 || this.stopValue < 0.0 || this.stopValue > 100.0) {
                return TraceUIPlugin.getString("FILTER_RANGE_INVALID_IMPORT_RANGE");
            }
            return null;
        }
        catch (NumberFormatException nfe) {
            return TraceUIPlugin.getString("FILTER_RANGE_INVALID_IMPORT_RANGE");
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this._startText || e.widget == this._stopText) {
            this._tabUI.setError(this.checkRegionValue());
        }
    }

    public void setRangeInputEnable(boolean enable) {
        this._startLabel.setEnabled(enable);
        this._startText.setEnabled(enable);
        this._ofFileLabel1.setEnabled(enable);
        this._stopLabel.setEnabled(enable);
        this._stopText.setEnabled(enable);
        this._ofFileLabel2.setEnabled(enable);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._wholeFileBtn) {
            this.setRangeInputEnable(false);
            this.startValue = 0.0;
            this.stopValue = 100.0;
            this._tabUI.noError();
        } else if (e.widget == this._inRangeBtn) {
            this.setRangeInputEnable(true);
            this._tabUI.setError(this.checkRegionValue());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

