/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.filters.FilterTraceViewer;
import org.eclipse.hyades.trace.views.adapter.internal.MultiLevelStatisticPage;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.part.IPage;

public abstract class MultiLevelStatisticViewer
extends FilterTraceViewer {
    protected Action _packageLevel;
    protected Action _classLevel;
    protected Action _openSource;
    protected Action _chooseColumns;
    protected Action _printColumns;

    public abstract String getViewTitle();

    public abstract TraceViewerPage createPage(EObject var1);

    public void setCheckedLevels(MultiLevelStatisticPage page, int newLevel) {
        if (page.getView().getLevel() == newLevel) {
            page.getView().updateButtons();
        } else {
            page.getView().setLevel(newLevel);
            page.getView().updateButtons();
            page.getView().redrawTable();
        }
    }

    public EObject getObjectToView(EObject selObject) {
        if (selObject == null) {
            return selObject;
        }
        if (selObject instanceof TRCProcessProxy) {
            int nbOfAgents = 0;
            TRCAgentProxy a = null;
            EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
            int idx = 0;
            while (idx < agents.size()) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (agent != null && !agent.eIsProxy() && agent.getType().equals("Profiler")) {
                    ++nbOfAgents;
                    a = agent;
                }
                ++idx;
            }
            if (nbOfAgents == 1) {
                return a;
            }
        }
        return selObject;
    }

    public void dispose() {
        Enumeration pages = this._pages.elements();
        while (pages.hasMoreElements()) {
            IPage page = (IPage)pages.nextElement();
            if (!(page instanceof MultiLevelStatisticPage)) continue;
            ((MultiLevelStatisticPage)page).dispose();
        }
        this.setActionsNull();
        if (this.fContextMenu != null) {
            this.fContextMenu.dispose();
        }
        this.fContextMenu = null;
        super.dispose();
    }

    protected void setActionsNull() {
        this._classLevel = null;
        this._packageLevel = null;
        this._openSource = null;
    }

    public void setFocus() {
        MultiLevelStatisticPage page = (MultiLevelStatisticPage)this.getCurrentPage();
        if (page != null) {
            page.setFocus();
        }
    }

    protected void getLevelActions(Vector actions) {
        String strPackageLevel = TraceUIPlugin.getString("STR_ST_PACKAGE_LEVEL");
        this._packageLevel = new Action(strPackageLevel){

            public void run() {
                MultiLevelStatisticPage page = (MultiLevelStatisticPage)MultiLevelStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    MultiLevelStatisticViewer.this.revertChecked(MultiLevelStatisticViewer.this._packageLevel);
                    return;
                }
                MultiLevelStatisticViewer.this.setCheckedLevels(page, 1);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._packageLevel.setText(strPackageLevel);
        TracePluginImages.setImageDescriptors((IAction)this._packageLevel, "lcl16", "package_obj.gif");
        this._packageLevel.setDescription(strPackageLevel);
        this._packageLevel.setToolTipText(strPackageLevel);
        this._packageLevel.setEnabled(true);
        this._packageLevel.setChecked(true);
        String strClassLevel = TraceUIPlugin.getString("STR_ST_CLASS_LEVEL");
        this._classLevel = new Action(strClassLevel){

            public void run() {
                MultiLevelStatisticPage page = (MultiLevelStatisticPage)MultiLevelStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    MultiLevelStatisticViewer.this.revertChecked(MultiLevelStatisticViewer.this._classLevel);
                    return;
                }
                MultiLevelStatisticViewer.this.setCheckedLevels(page, 2);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._classLevel.setText(strClassLevel);
        TracePluginImages.setImageDescriptors((IAction)this._classLevel, "lcl16", "class.gif");
        this._classLevel.setDescription(strClassLevel);
        this._classLevel.setToolTipText(strClassLevel);
        this._classLevel.setEnabled(true);
        actions.addElement(new Separator());
        actions.addElement(this._packageLevel);
        actions.addElement(this._classLevel);
    }

    protected void getActions(Vector actions) {
        String openSourceStr = TraceUIPlugin.getString("STR_SOURCE");
        this._openSource = new Action(openSourceStr){

            public void run() {
                MultiLevelStatisticPage page = (MultiLevelStatisticPage)MultiLevelStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(page.getMOFObject()).getFirstElement());
            }
        };
        this._openSource.setText(openSourceStr);
        TracePluginImages.setImageDescriptors((IAction)this._openSource, "tool16", "opensource_co.gif");
        this._openSource.setDescription(openSourceStr);
        this._openSource.setToolTipText(openSourceStr);
        this._openSource.setEnabled(false);
        String strPrintColumns = TraceUIPlugin.getString("STR_ST_PRINT_COL");
        this._printColumns = new Action(strPrintColumns){

            public void run() {
                MultiLevelStatisticPage page = (MultiLevelStatisticPage)MultiLevelStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.getView().getPrintColumnsAction().run();
            }
        };
        this._printColumns.setText(strPrintColumns);
        TracePluginImages.setImageDescriptors((IAction)this._printColumns, "lcl16", "htmlexport_co.gif");
        this._printColumns.setDescription(strPrintColumns);
        this._printColumns.setToolTipText(strPrintColumns);
        this._printColumns.setEnabled(true);
        String strChooseColumns = TraceUIPlugin.getString("STR_ST_COL_SETTINGS");
        this._chooseColumns = new Action(strChooseColumns){

            public void run() {
                MultiLevelStatisticPage page = (MultiLevelStatisticPage)MultiLevelStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                MultiLevelStatisticView view = page.getView();
                view.getChooseColumnsAction(view.getColumnDataList(), view.getColumnsPreferencesKey()).run();
            }
        };
        this._chooseColumns.setText(strChooseColumns);
        TracePluginImages.setImageDescriptors((IAction)this._chooseColumns, "lcl16", "choosecolumn_co.gif");
        this._chooseColumns.setDescription(strChooseColumns);
        this._chooseColumns.setToolTipText(strChooseColumns);
        this._chooseColumns.setEnabled(true);
        actions.addElement(this._openSource);
        actions.addElement(new Separator());
        actions.addElement(this._chooseColumns);
        actions.addElement(this._printColumns);
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        super.makeActions();
        this.initializedMenu(true);
        Vector<Separator> actions = new Vector<Separator>();
        actions.addElement(new Separator());
        this.getLevelActions(actions);
        actions.addElement(new Separator());
        this.getActions(actions);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        int i = 0;
        while (i < actions.size()) {
            if (actions.elementAt(i) instanceof IContributionItem) {
                tbm.add((IContributionItem)actions.elementAt(i));
            } else if (actions.elementAt(i) instanceof IAction) {
                tbm.add((IAction)actions.elementAt(i));
            }
            ++i;
        }
        this.getViewSite().getActionBars().updateActionBars();
    }

    public Action getClassLevel() {
        return this._classLevel;
    }

    public Action getPackageLevel() {
        return this._packageLevel;
    }

    public Action openSource() {
        return this._openSource;
    }

    protected void revertChecked(Action action) {
        action.setChecked(!action.isChecked());
    }

    public String[] getFilterScope() {
        String[] scope = new String[]{"ProfilingAgentScope"};
        return scope;
    }

    public void filterUpdated() {
        TraceViewerPage page = (TraceViewerPage)this.getCurrentPage();
        if (page != null) {
            if (this.fPartVisible) {
                page.refreshPage();
            } else {
                this.fForceRefresh = true;
            }
        }
    }
}

