/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.filters.internal.dialogs.FilterUIUtil;
import org.eclipse.hyades.trace.views.internal.FilteringUtil;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.trace.views.util.internal.CoverageAnalysis;
import org.eclipse.hyades.trace.views.util.internal.CoverageLeaf;
import org.eclipse.hyades.trace.views.util.internal.CoverageUtil;

public class CoverageFolder
extends Coverage {
    private int methods;
    private int methodsHit;
    private ArrayList childs;
    private SimpleSearchQuery _filter;

    public CoverageFolder(CoverageAnalysis analysis, Coverage parent, SimpleSearchQuery filter) {
        super(analysis, parent);
        this.childs = new ArrayList();
        this._filter = filter;
    }

    public CoverageFolder(CoverageAnalysis analysis, Coverage parent, CoverageFolder from, SimpleSearchQuery filter) {
        super(analysis, parent);
        this.methods = from.getMethods();
        this.methodsHit = from.getMethodsHit();
        this.setCalls(from.getCalls());
        this.childs = null;
    }

    public void parse(EList list) {
        int i = 0;
        while (i < list.size()) {
            EObject echild = (EObject)list.get(i);
            if (echild instanceof TRCMethod) {
                CoverageLeaf child = this.analysis.FindCoverageLeaf(this, echild);
                child.parse(echild);
            } else {
                List reslist;
                BasicEList subList = null;
                if (echild instanceof TRCClass && !CoverageUtil.isFiltered((TRCClass)echild)) {
                    if (FilterUIUtil.ENABLE_NEW_FILTERING) {
                        subList = new BasicEList();
                        reslist = FilteringUtil.getFilteredMethods(this._filter, (EObject)((TRCClass)echild));
                        if (reslist == null || reslist.size() == 0) {
                            reslist = ((TRCClass)echild).getMethods();
                        }
                        subList.addAll((Collection)reslist);
                    } else {
                        subList = ((TRCClass)echild).getMethods();
                    }
                } else if (echild instanceof TRCPackage) {
                    if (FilterUIUtil.ENABLE_NEW_FILTERING) {
                        subList = new BasicEList();
                        reslist = FilteringUtil.getFilteredClasses(this._filter, (EObject)((TRCPackage)echild));
                        if (reslist == null || reslist.size() == 0) {
                            reslist = ((TRCPackage)echild).getClasses();
                        }
                        subList.addAll((Collection)reslist);
                    } else {
                        subList = ((TRCPackage)echild).getClasses();
                    }
                }
                if (subList != null) {
                    CoverageFolder child = this.analysis.FindCoverageFolder(this, echild);
                    child.parse((EList)subList);
                }
            }
            ++i;
        }
    }

    public void compute() {
        this.methods = 0;
        this.methodsHit = 0;
        int i = 0;
        while (i < this.getChilds().size()) {
            Coverage child = (Coverage)this.childs.get(i);
            if (child instanceof CoverageFolder) {
                ((CoverageFolder)child).compute();
                this.methods += child.getMethods();
                this.methodsHit += child.getMethodsHit();
                this.setCalls(this.getCalls() + child.getCalls());
            } else {
                ++this.methods;
                if (child.getCalls() > 0) {
                    ++this.methodsHit;
                    this.setCalls(this.getCalls() + child.getCalls());
                }
            }
            ++i;
        }
    }

    public int getMethods() {
        return this.methods;
    }

    public int getMethodsHit() {
        return this.methodsHit;
    }

    public int getMethodsMissed() {
        return this.methods - this.methodsHit;
    }

    public ArrayList getChilds() {
        return this.childs;
    }

    public void setChilds(ArrayList childs) {
        this.childs = childs;
    }

    public double getPercentage() {
        if (this.getMethods() == 0) {
            return 0.0;
        }
        return (double)this.getMethodsHit() / (double)this.getMethods();
    }
}

