/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.ui.internal.util.OpenJavaSource;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class OpenSource {
    public static void openSource(Object selection) {
        if (selection != null && selection instanceof EObject) {
            EObject eObj = (EObject)selection;
            final String pattern = OpenSource.getPattern(eObj);
            final int javaType = OpenSource.getType(eObj);
            if (pattern != null && javaType != -1) {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    public void run() {
                        if (!OpenJavaSource.openSource((String)pattern, (int)javaType, (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (boolean)true)) {
                            MessageDialog.openInformation((Shell)UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UIPlugin.getResourceString((String)"STR_TRACE_MSG"), (String)HyadesUtil.change((String)UIPlugin.getResourceString((String)"STR_SOURCE_NOT_FOUND_INFO_"), (String)"%1", (String)pattern));
                        }
                    }
                });
                return;
            }
        }
        MessageDialog.openInformation((Shell)UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UIPlugin.getResourceString((String)"STR_TRACE_MSG"), (String)UIPlugin.getResourceString((String)"STR_EMPTY_SOURCE_NOT_FOUND_INFO_"));
    }

    public static IFile getSourceFile(EObject obj) {
        if (obj != null) {
            String pattern = OpenSource.getPattern(obj);
            int javaType = OpenSource.getType(obj);
            if (pattern != null && javaType != -1) {
                return OpenJavaSource.getSourceFile((String)pattern, (int)javaType, null);
            }
        }
        return null;
    }

    private static String getPattern(Object selection) {
        TRCObjectReference obj;
        if (selection == null || selection instanceof TRCPackage) {
            return null;
        }
        if (selection instanceof TRCMethodInvocation) {
            selection = ((TRCMethodInvocation)selection).getMethod();
        }
        if (selection instanceof TRCMethod) {
            TRCMethod trcMethod = (TRCMethod)selection;
            if ((trcMethod.getModifier() & 0x80) != 0) {
                TRCClass clas = trcMethod.getDefiningClass();
                String packName = clas.getPackage().getName();
                if (packName.equals("")) {
                    return clas.getName() + trcMethod.getSignature();
                }
                return clas.getPackage().getName() + "." + clas.getName() + trcMethod.getSignature();
            }
            TRCClass clas = trcMethod.getDefiningClass();
            String packName = clas.getPackage().getName();
            if (packName.equals("")) {
                return clas.getName() + "." + trcMethod.getName() + trcMethod.getSignature();
            }
            return clas.getPackage().getName() + "." + clas.getName() + "." + trcMethod.getName() + trcMethod.getSignature();
        }
        if (selection instanceof TRCObjectReference) {
            obj = (TRCObjectReference)selection;
            selection = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display") == 0 ? obj.getOwner() : obj.getTarget();
        }
        if (selection instanceof TRCObject) {
            obj = (TRCObject)selection;
            selection = obj.getIsA() == obj.getProcess().getClassClass() ? OpenSource.findClassType((TRCObject)obj) : obj.getIsA();
        }
        if (selection instanceof TRCClass) {
            TRCClass clas = (TRCClass)selection;
            String packName = clas.getPackage().getName();
            if (packName.equals("")) {
                return clas.getName();
            }
            return clas.getPackage().getName() + "." + clas.getName();
        }
        return null;
    }

    private static int getType(Object selection) {
        TRCMethod trcMethod;
        if (selection == null || selection instanceof TRCPackage) {
            return -1;
        }
        if (selection instanceof TRCMethodInvocation) {
            selection = ((TRCMethodInvocation)selection).getMethod();
        }
        int javaType = selection instanceof TRCMethod ? (((trcMethod = (TRCMethod)selection).getModifier() & 0x80) != 0 ? 3 : 1) : 0;
        return javaType;
    }

    private static Object findClassType(TRCObject obj) {
        Iterator iter1 = obj.getProcess().getPackages().iterator();
        while (iter1.hasNext()) {
            TRCPackage aPackage = (TRCPackage)iter1.next();
            Iterator iter2 = aPackage.getClasses().iterator();
            while (iter2.hasNext()) {
                TRCClass aClass = (TRCClass)iter2.next();
                Iterator iter3 = aClass.getClassObjects().iterator();
                while (iter3.hasNext()) {
                    TRCObject aObject = (TRCObject)iter3.next();
                    if (aObject != obj) continue;
                    return aClass;
                }
            }
        }
        return obj.getIsA();
    }
}

