/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.trace;

import java.util.HashMap;
import org.eclipse.hyades.execution.trace.TraceCorrelator;
import org.eclipse.hyades.execution.trace.util.ProfilerImpl;
import org.eclipse.hyades.execution.trace.util.RecordClassDef;
import org.eclipse.hyades.execution.trace.util.RecordMethodAccess;
import org.eclipse.hyades.execution.trace.util.RecordMethodDef;
import org.eclipse.hyades.execution.trace.util.RecordObjAlloc;
import org.eclipse.hyades.execution.trace.util.RecordParameterDef;
import org.eclipse.hyades.execution.trace.util.RecordThreadStart;
import org.eclipse.hyades.execution.trace.util.RecordVariable;
import org.eclipse.hyades.execution.trace.util.Utilities;

public class TraceLogger
extends ProfilerImpl {
    private static final String DISTRIBUTED_TRACE_PROFILER = "Distributed Trace Profiler";
    private static final String TYPE_PROFILER = "Profiler";
    private static TraceLogger _profiler = null;
    private HashMap methodCollection = new HashMap();
    private HashMap classCollection = new HashMap();
    private HashMap objectCollection = new HashMap();
    private HashMap parameterCollection = new HashMap();
    private HashMap threadCollection = new HashMap();
    static /* synthetic */ Class class$org$eclipse$hyades$execution$trace$TraceLogger;

    private TraceLogger() {
        super(DISTRIBUTED_TRACE_PROFILER, TYPE_PROFILER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TraceLogger getInstance() {
        Class clazz = class$org$eclipse$hyades$execution$trace$TraceLogger == null ? (class$org$eclipse$hyades$execution$trace$TraceLogger = TraceLogger.class$("org.eclipse.hyades.execution.trace.TraceLogger")) : class$org$eclipse$hyades$execution$trace$TraceLogger;
        synchronized (clazz) {
            if (_profiler == null) {
                _profiler = new TraceLogger();
            }
        }
        return _profiler;
    }

    public void monitorInactive() {
        super.monitorInactive();
        this.classCollection.clear();
        this.methodCollection.clear();
        this.objectCollection.clear();
        this.parameterCollection.clear();
        this.threadCollection.clear();
    }

    public void logCorrelator(String eventType, TraceCorrelator self, TraceCorrelator partner) {
        int objRef;
        RecordObjAlloc objAlloc;
        Thread threadKey = Thread.currentThread();
        RecordThreadStart threadStart = (RecordThreadStart)this.threadCollection.get(threadKey);
        if (threadStart == null) {
            threadStart = new RecordThreadStart();
            threadStart.setTime(Utilities.getCurrentTimeStamp());
            this.threadCollection.put(threadKey, threadStart);
            this.write(threadStart.toString());
        }
        int threadIdRef = threadStart.getThreadId();
        String className = self.getClazz().getName();
        RecordClassDef classDef = (RecordClassDef)this.classCollection.get(className);
        if (classDef == null) {
            classDef = new RecordClassDef(className);
            classDef.setTime(Utilities.getCurrentTimeStamp());
            classDef.setThreadIdRef(threadIdRef);
            this.classCollection.put(className, classDef);
            this.write(classDef.toString());
        }
        if ((objAlloc = (RecordObjAlloc)this.objectCollection.get(new Integer(objRef = self.getObject()))) == null) {
            objAlloc = new RecordObjAlloc();
            objAlloc.setTime(Utilities.getCurrentTimeStamp());
            objAlloc.setClassIdRef(classDef.getClassId());
            objAlloc.setThreadIdRef(threadIdRef);
            this.objectCollection.put(new Integer(objRef), objAlloc);
            this.write(objAlloc.toString());
        }
        String methodName = self.getInvokedMethod().toString();
        String methodSignature = Utilities.getInvokedMethodSignature(self.getParmClasses(), self.getReturnClass() == null ? null : Utilities.getJniNotation(self.getReturnClass()));
        String methodKey = className + "#" + methodName + methodSignature;
        RecordMethodDef methodDef = (RecordMethodDef)this.methodCollection.get(methodKey);
        if (methodDef == null) {
            methodDef = new RecordMethodDef(methodName, methodSignature, classDef.getClassId());
            this.methodCollection.put(methodKey, methodDef);
            this.write(methodDef.toString());
        }
        String[] parameterNames = self.getParmNames();
        Class[] parameterClasses = self.getParmClasses();
        Object[] parameterValues = self.getParmValues();
        int listLength = parameterNames == null || parameterClasses == null || parameterValues == null || parameterNames.length != parameterClasses.length || parameterClasses.length != parameterValues.length ? 0 : parameterNames.length;
        int[] parameterIds = new int[listLength];
        int i = 0;
        while (i < listLength) {
            String parameterKey = Integer.toString(methodDef.getMethodId()) + "@" + Integer.toString(i);
            RecordParameterDef parameterDef = (RecordParameterDef)this.parameterCollection.get(parameterKey);
            if (parameterDef == null) {
                parameterDef = new RecordParameterDef(parameterClasses[i], methodDef.getMethodId(), i);
                parameterDef.setName(parameterNames[i]);
                this.parameterCollection.put(parameterKey, parameterDef);
                this.write(parameterDef.toString());
            }
            parameterIds[i] = parameterDef.getParameterId();
            ++i;
        }
        RecordMethodAccess methodAccess = new RecordMethodAccess(eventType, methodDef.getMethodId(), objAlloc.getObjId());
        methodAccess.setTime(Utilities.getCurrentTimeStamp());
        methodAccess.setSequenceCounter(self.getOperationCounter());
        methodAccess.setTicket(Long.toString(self.getApplicationCounter()));
        methodAccess.setParameterList(parameterIds, parameterClasses, parameterValues);
        methodAccess.setThreadIdRef(threadIdRef);
        self.setAgentIdRef(this.getAgentId());
        self.setProcessIdRef(this.getProcessId());
        self.setNodeIdRef(this.getNodeId());
        self.setThreadIdRef(threadIdRef);
        if (!(partner == null || partner.getAgentIdRef() == null || self.getAgentIdRef().equals(partner.getAgentIdRef()) || eventType != "methodReceive" && eventType != "methodReturn")) {
            methodAccess.setRemoteContext(partner.getNodeIdRef(), partner.getProcessIdRef(), partner.getAgentIdRef(), partner.getThreadIdRef(), partner.getApplicationCounter(), partner.getOperationCounter());
        }
        if (eventType == "methodExit" && self.getReturnClass() != null && self.getReturnClass() != Void.TYPE) {
            methodAccess.setReturnValue(new RecordVariable("returnValue", 0, self.getReturnClass(), self.getReturnValue()));
        }
        this.write(methodAccess.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

