/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.sdb.internal.util.SymptomDBSearchDialog;

public class SymptomDBTextSearch {
    private SDBRuntime root;
    private Object[] start = null;
    private int[] startIndex = null;
    private int[] index = null;
    SymptomDBSearchDialog sd;

    public SymptomDBTextSearch(SymptomDBSearchDialog p_sd) {
        this.sd = p_sd;
        this.startIndex = new int[]{-1, -1, -1, -1, -1};
        this.index = new int[]{-1, -1, -1, -1, -1};
    }

    public void initialize(SDBRuntime root, Object[] p_start) {
        this.root = root;
        this.setIndex(-1, -1, -1, -1, -1);
        this.setStartIndex(-1, -1, -1, -1, this.startIndex[4]);
        this.lookForStartNode(p_start);
    }

    public Object[] search(String pattern, int direction, boolean bCaseSensitive) {
        if (this.startIndex == null) {
            this.setStartIndex(-1, -1, -1, -1, -1);
            this.lookForStartNode(this.start);
        }
        if (this.startIndex[1] == -1 && direction > 0) {
            this.setIndex(0, 0, 0, 0, this.startIndex[4]);
            return this.searchDown(pattern, bCaseSensitive);
        }
        if (this.startIndex[1] == -1 && direction < 0) {
            this.startIndex[0] = -1;
            this.setIndex(this.startIndex[0], this.startIndex[1], this.startIndex[2], this.startIndex[3], this.startIndex[4]);
            return this.searchUp(pattern, bCaseSensitive);
        }
        if (this.startIndex[2] == -1 && direction > 0) {
            this.setIndex(0, this.startIndex[1], 0, 0, this.startIndex[4]);
            return this.searchDown(pattern, bCaseSensitive);
        }
        if (this.startIndex[2] == -1 && direction < 0) {
            this.setIndex(0, this.startIndex[1], -1, -1, this.startIndex[4]);
            return this.searchUp(pattern, bCaseSensitive);
        }
        if (this.startIndex[3] == -1 && direction > 0) {
            this.setIndex(0, this.startIndex[1], this.startIndex[2], 0, this.startIndex[4]);
            return this.searchDown(pattern, bCaseSensitive);
        }
        if (this.startIndex[3] == -1 && direction < 0) {
            this.setIndex(0, this.startIndex[1], this.startIndex[2], -1, this.startIndex[4]);
            return this.searchUp(pattern, bCaseSensitive);
        }
        if (direction > 0) {
            this.setIndex(0, this.startIndex[1], this.startIndex[2], this.startIndex[3], this.startIndex[4]);
            return this.searchDown(pattern, bCaseSensitive);
        }
        this.setIndex(0, this.startIndex[1], this.startIndex[2], this.startIndex[3], this.startIndex[4]);
        return this.searchUp(pattern, bCaseSensitive);
    }

    private void lookForStartNode(Object[] p_start) {
        this.start = p_start;
        this.startIndex[4] = this.start[4] != null && this.start[4] instanceof Integer ? (Integer)this.start[4] : -1;
        if (this.start[0] == null) {
            this.startIndex[0] = -1;
            return;
        }
        this.startIndex[0] = 0;
        if (this.start[1] == null) {
            return;
        }
        EList symptoms = this.root.getSymptoms();
        this.startIndex[1] = symptoms.indexOf((Object)((SDBSymptom)this.start[1]));
        if (this.start[2] == null) {
            this.startIndex[2] = -1;
            return;
        }
        SDBSymptom symptom = (SDBSymptom)this.start[1];
        EList solutions = symptom.getSolutions();
        this.startIndex[2] = solutions.indexOf((Object)((SDBSolution)this.start[2]));
        if (this.start[3] == null) {
            this.startIndex[3] = -1;
            return;
        }
        SDBSolution sol = (SDBSolution)this.start[2];
        EList directives = sol.getDirectives();
        this.startIndex[3] = directives.indexOf((Object)((SDBDirective)this.start[3]));
    }

    private String stringForDisplay(String s) {
        return this.sd.fixText(s);
    }

    private int searchPatternIn(String pattern, String target, int startFrom, boolean bCaseSensitive, boolean searchDown) {
        if (bCaseSensitive) {
            if (searchDown) {
                return this.stringForDisplay(target).indexOf(pattern, startFrom + 1);
            }
            return this.stringForDisplay(target).lastIndexOf(pattern, startFrom >= 0 ? startFrom - 1 : target.length());
        }
        target = target.toLowerCase();
        pattern = pattern.toLowerCase();
        if (searchDown) {
            return this.stringForDisplay(target).indexOf(pattern, startFrom + 1);
        }
        return this.stringForDisplay(target).lastIndexOf(pattern, startFrom >= 0 ? startFrom - 1 : target.length());
    }

    private Object[] searchDown(String pattern, boolean bCaseSensitive) {
        int searchIndex = -1;
        String nl = SymptomDBSearchDialog.getFieldSeparator();
        if (this.startIndex[0] < 0 || this.startIndex[1] < 0) {
            searchIndex = this.searchPatternIn(pattern, this.root.getName() + nl + this.root.getSymptomUrl() + nl + this.root.getLocalExternalFileLocation() + nl + this.root.getDescription(), this.startIndex[4], bCaseSensitive, true);
            if (searchIndex >= 0) {
                this.setStartIndex(0, -1, -1, -1, searchIndex);
                this.setStartObject(this.root, null, null, null, searchIndex, searchIndex + pattern.length());
                return this.start;
            }
            this.startIndex[4] = -1;
        }
        EList symptoms = this.root.getSymptoms();
        int k = this.index[2];
        int l = this.index[3];
        int i = this.index[1];
        while (i >= 0 && i < symptoms.size()) {
            SDBSymptom symptom = (SDBSymptom)symptoms.get(i);
            if (i != this.startIndex[1] || i == this.startIndex[1] && this.startIndex[2] == -1) {
                String searchStr = symptom.getDescription() + nl;
                String mnl = System.getProperties().getProperty("line.separator");
                EList patterns = symptom.getPatterns();
                int j = 0;
                while (j < patterns.size()) {
                    SDBMatchPattern match = (SDBMatchPattern)patterns.get(j);
                    searchStr = searchStr + match.getValue() + mnl;
                    ++j;
                }
                searchIndex = this.searchPatternIn(pattern, searchStr, this.startIndex[4], bCaseSensitive, true);
                if (searchIndex >= 0) {
                    this.setStartIndex(0, i, -1, -1, searchIndex);
                    this.setStartObject(this.root, symptom, null, null, searchIndex, searchIndex + pattern.length());
                    return this.start;
                }
                this.startIndex[4] = -1;
            }
            EList solutions = symptom.getSolutions();
            while (k >= 0 && k < solutions.size()) {
                SDBSolution sol = (SDBSolution)solutions.get(k);
                if (i != this.startIndex[1] || k != this.startIndex[2] || this.startIndex[3] == -1) {
                    searchIndex = this.searchPatternIn(pattern, sol.getDescription(), this.startIndex[4], bCaseSensitive, true);
                    if (searchIndex >= 0) {
                        this.setStartIndex(0, i, k, -1, searchIndex);
                        this.setStartObject(this.root, symptom, sol, null, searchIndex, searchIndex + pattern.length());
                        return this.start;
                    }
                    this.startIndex[4] = -1;
                }
                EList directives = sol.getDirectives();
                while (l >= 0 && l < directives.size()) {
                    SDBDirective dir = (SDBDirective)directives.get(l);
                    searchIndex = this.searchPatternIn(pattern, dir.getDescription() + nl + dir.getDirectiveString(), this.startIndex[4], bCaseSensitive, true);
                    if (searchIndex >= 0) {
                        this.setStartIndex(0, i, k, l, searchIndex);
                        this.setStartObject(this.root, symptom, sol, dir, searchIndex, searchIndex + pattern.length());
                        return this.start;
                    }
                    this.startIndex[4] = -1;
                    ++l;
                }
                l = 0;
                ++k;
            }
            k = 0;
            ++i;
        }
        this.setStartObject(null, null, null, null, -1, -1);
        return this.start;
    }

    private Object[] searchUp(String pattern, boolean bCaseSensitive) {
        int searchIndex = -1;
        String nl = SymptomDBSearchDialog.getFieldSeparator();
        EList symptoms = this.root.getSymptoms();
        int i = this.index[1];
        while (i >= 0 && i < symptoms.size()) {
            SDBSymptom symptom = (SDBSymptom)symptoms.get(i);
            EList solutions = symptom.getSolutions();
            int k = solutions.size() - 1;
            if (i == this.index[1] && this.index[2] >= -1) {
                k = this.index[2];
            }
            while (k >= 0 && k < solutions.size()) {
                SDBSolution sol = (SDBSolution)solutions.get(k);
                EList directives = sol.getDirectives();
                int l = directives.size() - 1;
                if (i == this.index[1] && k == this.index[2] && this.index[3] >= -1) {
                    l = this.index[3];
                }
                while (l >= 0 && l < directives.size()) {
                    SDBDirective dir = (SDBDirective)directives.get(l);
                    if (i != this.startIndex[1] || k != this.startIndex[2] || this.startIndex[3] != -1) {
                        String searchStr = dir.getDescription() + nl + dir.getDirectiveString();
                        searchIndex = this.searchPatternIn(pattern, searchStr, this.startIndex[4], bCaseSensitive, false);
                        if (searchIndex >= 0) {
                            this.setStartIndex(0, i, k, l, searchIndex);
                            this.setStartObject(this.root, symptom, sol, dir, searchIndex, searchIndex + pattern.length());
                            return this.start;
                        }
                        this.startIndex[4] = -1;
                    }
                    --l;
                }
                searchIndex = this.searchPatternIn(pattern, sol.getDescription(), this.startIndex[4], bCaseSensitive, false);
                if (searchIndex >= 0) {
                    this.setStartIndex(0, i, k, -1, searchIndex);
                    this.setStartObject(this.root, symptom, sol, null, searchIndex, searchIndex + pattern.length());
                    return this.start;
                }
                this.startIndex[4] = -1;
                --k;
            }
            String searchStr = symptom.getDescription() + nl;
            String mnl = System.getProperties().getProperty("line.separator");
            EList patterns = symptom.getPatterns();
            int j = 0;
            while (j < patterns.size()) {
                SDBMatchPattern match = (SDBMatchPattern)patterns.get(j);
                searchStr = searchStr + match.getValue() + mnl;
                ++j;
            }
            searchIndex = this.searchPatternIn(pattern, searchStr, this.startIndex[4], bCaseSensitive, false);
            if (searchIndex >= 0) {
                this.setStartIndex(0, i, -1, -1, searchIndex);
                this.setStartObject(this.root, symptom, null, null, searchIndex, searchIndex + pattern.length());
                return this.start;
            }
            this.startIndex[4] = -1;
            --i;
        }
        searchIndex = this.searchPatternIn(pattern, this.root.getName() + nl + this.root.getSymptomUrl() + nl + this.root.getLocalExternalFileLocation() + nl + this.root.getDescription(), this.startIndex[4], bCaseSensitive, false);
        if (searchIndex >= 0) {
            this.setStartIndex(0, -1, -1, -1, searchIndex);
            this.setStartObject(this.root, null, null, null, searchIndex, searchIndex + pattern.length());
            return this.start;
        }
        this.startIndex[4] = -1;
        this.setStartObject(null, null, null, null, -1, -1);
        return this.start;
    }

    private void setStartIndex(int i0, int i1, int i2, int i3, int i4) {
        this.startIndex[0] = i0;
        this.startIndex[1] = i1;
        this.startIndex[2] = i2;
        this.startIndex[3] = i3;
        this.startIndex[4] = i4;
    }

    private void setIndex(int i0, int i1, int i2, int i3, int i4) {
        this.index[0] = i0;
        this.index[1] = i1;
        this.index[2] = i2;
        this.index[3] = i3;
        this.index[4] = i4;
    }

    private void setStartObject(Object s0, Object s1, Object s2, Object s3, int s4, int s5) {
        this.start[0] = s0;
        this.start[1] = s1;
        this.start[2] = s2;
        this.start[3] = s3;
        this.start[4] = new Integer(s4);
        this.start[5] = new Integer(s5);
    }
}

