/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.editor.EditorSynchronizer;
import org.eclipse.hyades.ui.internal.editor.PageContainerEditorPart;
import org.eclipse.hyades.ui.internal.editor.action.ActionHandlerListener;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.util.IRefreshable;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public abstract class HyadesEditorPart
extends PageContainerEditorPart
implements IRefreshable,
ISelectionListener {
    private int defaultTabHeight;
    private Object editorObject;
    private IAssociationDescriptor editorDescriptor;
    private IEditorExtension editorExtension;
    private ListenerList selectionChangedListeners = new ListenerList();
    private EditorSynchronizer editorSynchronizer;

    public void dispose() {
        if (this.editorSynchronizer != null) {
            this.editorSynchronizer.dispose();
            this.editorSynchronizer = null;
        }
        this.getSite().setSelectionProvider(null);
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
        this.selectionChangedListeners.clear();
        if (this.editorExtension != null) {
            this.editorExtension.dispose();
            this.editorExtension = null;
        }
        this.editorDescriptor = null;
        this.editorObject = null;
        super.dispose();
    }

    public final IAssociationDescriptor getEditorDescriptor() {
        return this.editorDescriptor;
    }

    public final IEditorExtension getEditorExtension() {
        return this.editorExtension;
    }

    public void setEditorObject(Object editorObject) {
        this.editorObject = editorObject;
        this.firePropertyChange(517);
    }

    public Object getEditorObject() {
        return this.editorObject;
    }

    public int addPage(Control control) {
        int ret = super.addPage(control);
        this.adjustContainer();
        return ret;
    }

    public int addPage(IEditorPart editor, IEditorInput input) throws PartInitException {
        int ret = super.addPage(editor, input);
        this.adjustContainer();
        return ret;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.notifyPageChange(newPageIndex);
    }

    public void setActivePage(int pageIndex) {
        boolean pageChanged = this.getActivePage() != pageIndex;
        super.setActivePage(pageIndex);
        if (pageChanged) {
            this.notifyPageChange(pageIndex);
        }
    }

    protected void notifyPageChange(int newPageIndex) {
        if (this.editorExtension == null) {
            return;
        }
        if (this.editorExtension.pageActivated(newPageIndex)) {
            this.fileSelection(this.getSelection());
        }
    }

    public void removePage(int pageIndex) {
        super.removePage(pageIndex);
        this.adjustContainer();
    }

    protected void adjustContainer() {
        if (this.getContainer() instanceof CTabFolder) {
            int currentTabHeight = ((CTabFolder)this.getContainer()).getTabHeight();
            if (currentTabHeight > 0) {
                this.defaultTabHeight = currentTabHeight;
            }
            ((CTabFolder)this.getContainer()).setTabHeight(this.getPageCount() == 1 ? 0 : this.defaultTabHeight);
        }
    }

    protected final void createPages() {
        if (this.editorSynchronizer == null) {
            this.setTitle(HyadesUIPlugin.getString("EDT_HYADES_TTL"));
            String resource = "";
            FileEditorInput editorFile = EditorSynchronizer.getEditorFile(this.getEditorInput());
            if (editorFile != null) {
                resource = editorFile.getPath().toString();
                try {
                    editorFile.getFile().refreshLocal(0, null);
                }
                catch (CoreException e) {
                    HyadesUIPlugin.logError(e);
                }
            }
            String text = HyadesUIPlugin.getString("_ERROR_RES_NOT_EXIST", resource);
            HyadesUIPlugin.logError(text);
            Label label = new Label(this.getContainer(), 0);
            label.setText(text);
            this.addPage((Control)label);
            return;
        }
        if (this.editorExtension != null) {
            this.editorExtension.createPages();
        } else {
            this.setTitle(HyadesUIPlugin.getString("EDT_HYADES_TTL"));
            String text = HyadesUIPlugin.getString("EDT_HYADES_TXT");
            HyadesUIPlugin.logError(text);
            Label label = new Label(this.getContainer(), 0);
            label.setText(text);
            label.setBackground(Display.getCurrent().getSystemColor(3));
            this.addPage((Control)label);
        }
        if (this.getTitle() == null && this.editorDescriptor != null && this.editorDescriptor.getName() != null) {
            this.setTitle(this.editorDescriptor.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(IProgressMonitor monitor) {
        if (this.editorExtension != null) {
            this.editorSynchronizer.setResourceChangeListenerEnabled(false);
            try {
                this.editorSynchronizer.validateEdit();
                this.editorExtension.doSave(monitor);
                this.editorSynchronizer.editorSaved();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                monitor.setCanceled(this.isDirty());
                this.editorSynchronizer.setResourceChangeListenerEnabled(true);
                this.firePropertyChange(257);
                throw throwable;
            }
            monitor.setCanceled(this.isDirty());
            this.editorSynchronizer.setResourceChangeListenerEnabled(true);
            this.firePropertyChange(257);
            {
            }
        }
    }

    public void doSaveAs() {
        if (this.editorExtension != null) {
            this.editorExtension.doSaveAs();
        }
    }

    public void gotoMarker(IMarker marker) {
        if (this.editorExtension != null) {
            this.editorExtension.gotoMarker(marker);
        }
    }

    public boolean isSaveAsAllowed() {
        if (this.editorExtension != null) {
            this.editorExtension.isSaveAsAllowed();
        }
        return false;
    }

    public boolean isDirty() {
        if (this.editorExtension != null) {
            if (this.editorExtension.isDirty()) {
                return true;
            }
            if (this.editorExtension.checkPagesDirtyState()) {
                return super.isDirty();
            }
        }
        return false;
    }

    public void refreshContent(Object data) {
        if (this.editorExtension != null) {
            this.editorExtension.refreshContent(data);
            if (this.editorExtension.refreshPages()) {
                int i = 0;
                while (i < this.getPageCount()) {
                    IEditorPart page = this.getEditor(i);
                    if (page == null) {
                        page = this.getControl(i);
                    }
                    if (page instanceof IRefreshable) {
                        ((IRefreshable)page).refreshContent(data);
                    }
                    ++i;
                }
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (site != null && site.getRegisteredName() != null) {
            this.setTitle(site.getRegisteredName());
        } else {
            this.setTitle("");
        }
        if (!input.exists()) {
            return;
        }
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPostSelectionListener((ISelectionListener)this);
        this.editorDescriptor = this.identifyEditorDescriptor(input);
        if (this.editorDescriptor != null) {
            if (this.cloneExtensionDefinitions()) {
                this.editorDescriptor = this.editorDescriptor.copy();
            }
            this.editorExtension = (IEditorExtension)this.editorDescriptor.createImplementationClassInstance();
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        if (this.editorExtension != null) {
            this.editorExtension.init(this);
        }
        this.enableEditActions();
        this.enableFileSynchronization();
    }

    protected void enableEditActions() {
        ActionHandlerListener.DEFAULT.connectPart((IWorkbenchPart)this);
    }

    protected void enableFileSynchronization() {
        this.editorSynchronizer = new EditorSynchronizer((IEditorPart)this);
    }

    protected boolean cloneExtensionDefinitions() {
        return true;
    }

    protected abstract IAssociationDescriptor identifyEditorDescriptor(IEditorInput var1) throws PartInitException;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.getEditorExtension() != null) {
            return this.getEditorExtension().getSelection();
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (!UIUtil.areEquals(this.getSelection(), selection) && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (this.getEditorExtension() != null) {
                this.getEditorExtension().setSelection(structuredSelection);
            }
            this.updateStatusLine(structuredSelection);
        }
        this.fileSelection(selection);
    }

    protected void fileSelection(ISelection selection) {
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        int maxi = listeners.length;
        while (i < maxi) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
            ++i;
        }
    }

    protected void updateStatusLine(IStructuredSelection structuredSelection) {
        String msg = this.getStatusLineMessage(structuredSelection);
        this.getEditorSite().getActionBars().getStatusLineManager().setMessage(msg);
    }

    protected String getStatusLineMessage(IStructuredSelection structuredSelection) {
        if (this.getEditorExtension() != null) {
            return this.getEditorExtension().getStatusLineMessage(structuredSelection);
        }
        return null;
    }

    public IEditorPart getEditorPart() {
        return this;
    }

    public Object getAdapter(Class adapterClass) {
        Object adapter;
        if (this.editorExtension != null && (adapter = this.editorExtension.getAdapter(adapterClass)) != null) {
            return adapter;
        }
        return super.getAdapter(adapterClass);
    }

    public boolean isReadOnly() {
        if (this.editorSynchronizer == null) {
            return false;
        }
        return EditorSynchronizer.isReadOnly(this.editorSynchronizer.getEditorFile());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != this && this.editorExtension != null) {
            this.editorExtension.selectionChanged(part, selection);
        }
    }
}

