/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.extension.INavigatorLayout;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;

public abstract class Navigator
extends ViewPart
implements INavigator,
IPartListener,
ISelectionChangedListener,
KeyListener,
IMenuListener,
IOpenListener,
ISelectionListener {
    protected static final String SET_LINK_TO_EDITOR = "LINK_NAVIGATOR_TO_EDITOR";
    protected static final String TAG_SELECTION = "selection";
    protected static final String TAG_ELEMENT = "element";
    protected static final String TAG_STORE_VALUE = "storeValue";
    protected static final String TAG_FACTORY_ID = "factoryID";
    private static final String ID_POPUP_MENU = "#NavigatorPopupMenu";
    protected INavigatorLayout layout;
    private StructuredViewer structuredViewer;
    private Object initialViewerInput;
    private IDialogSettings settings;
    private IMemento memento;
    private NavigatorActionGroup actionGroup;
    private boolean linkingEnabled;
    private static Navigator activeNavigator;
    private String navigatorID;
    static /* synthetic */ Class class$org$eclipse$ui$IPersistableElement;

    public Navigator(String id) {
        this.navigatorID = id;
    }

    public String getID() {
        return this.navigatorID;
    }

    public INavigatorLayout getLayout() {
        return this.layout;
    }

    public void dispose() {
        this.getViewer().removeOpenListener((IOpenListener)this);
        this.getViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.getViewSite().getPage().removePartListener((IPartListener)this);
        if (!this.getViewer().getControl().isDisposed()) {
            this.getViewer().getControl().removeKeyListener((KeyListener)this);
        }
        if (this.getActionGroup() != null) {
            this.getActionGroup().dispose();
        }
        this.initialViewerInput = null;
        this.structuredViewer = null;
        this.settings = null;
        this.actionGroup = null;
        super.dispose();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
        site.getPage().addPostSelectionListener((ISelectionListener)this);
        IDialogSettings viewsSettings = this.getPlugin().getDialogSettings();
        this.settings = viewsSettings.getSection(this.getStoreSection());
        if (this.settings == null) {
            this.settings = viewsSettings.addNewSection(this.getStoreSection());
            this.initSettings();
        } else {
            this.loadSettings();
        }
    }

    protected void initSettings() {
    }

    public boolean isInitialized() {
        return this.getViewSite() != null;
    }

    protected IDialogSettings getSettings() {
        return this.settings;
    }

    protected void loadSettings() {
        this.setLinkingEnabled(this.getSettings().getBoolean(SET_LINK_TO_EDITOR));
    }

    public abstract String getStoreSection();

    protected NavigatorActionGroup getActionGroup() {
        return this.actionGroup;
    }

    protected void setActionGroup(NavigatorActionGroup actionGroup) {
        this.actionGroup = actionGroup;
    }

    protected abstract void createActions();

    public void createPartControl(Composite parent) {
        this.structuredViewer = this.createViewer(parent);
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.getViewer().addOpenListener((IOpenListener)this);
        this.getViewer().getControl().addKeyListener((KeyListener)this);
        this.initContextMenu();
        IContentProvider provider = this.getViewer().getContentProvider();
        this.getViewer().setContentProvider(provider);
        this.getViewer().setInput(this.createViewerInput());
        this.initialViewerInput = this.getViewer().getInput();
        this.createActions();
        if (this.getActionGroup() != null) {
            this.getActionGroup().fillActionBars(this.getViewSite().getActionBars());
        }
        this.updateActionBars(this.getStructuredSelection());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        this.getSite().getPage().addPartListener((IPartListener)this);
        String helpContextId = this.getHelpContextId();
        if (helpContextId != null) {
            WorkbenchHelp.setHelp((Control)this.getViewer().getControl(), (String)helpContextId);
        }
        if (this.memento != null) {
            this.loadMemento(this.memento);
            this.memento = null;
        }
    }

    protected String getHelpContextId() {
        return null;
    }

    protected void loadMemento(IMemento memento) {
        this.loadSelection(memento);
    }

    protected void loadSelection(IMemento memento) {
        IMemento selectionMemento = memento.getChild(TAG_SELECTION);
        if (selectionMemento == null) {
            return;
        }
        List selection = this.loadElements(selectionMemento);
        if (!selection.isEmpty()) {
            this.selectReveal((ISelection)new StructuredSelection(selection));
        }
    }

    protected void initContextMenu() {
        MenuManager menuMgr = new MenuManager(ID_POPUP_MENU);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.getViewer());
    }

    protected abstract Object createViewerInput();

    protected Object getInitialViewerInput() {
        return this.initialViewerInput;
    }

    protected abstract StructuredViewer createViewer(Composite var1);

    public StructuredViewer getViewer() {
        return this.structuredViewer;
    }

    public void setFocus() {
        this.getViewer().getControl().setFocus();
    }

    public void setLayout(INavigatorLayout newLayout) {
        this.layout = newLayout;
        this.getViewer().setLabelProvider((IBaseLabelProvider)newLayout.getLabelProvider());
        this.getViewer().setContentProvider(newLayout.getContentProvider());
    }

    public void selectReveal(ISelection selection) {
        IStructuredSelection structuredSelection = this.convertToViewer(selection);
        if (structuredSelection.isEmpty()) {
            return;
        }
        if (this.getViewer() == null || this.getViewer().getControl() == null || this.getViewer().getControl().isDisposed()) {
            return;
        }
        if (!UIUtil.areEquals((ISelection)this.getStructuredSelection(), (ISelection)structuredSelection)) {
            this.getViewer().setSelection((ISelection)structuredSelection, true);
        }
    }

    protected IStructuredSelection convertFromViewer(ISelection selection) {
        if (selection != null && selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    protected IStructuredSelection convertToViewer(ISelection selection) {
        if (selection != null && selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public IStructuredSelection getStructuredSelection() {
        if (this.getViewer() == null) {
            return StructuredSelection.EMPTY;
        }
        return this.convertFromViewer(this.getViewer().getSelection());
    }

    public boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public void setLinkingEnabled(boolean enabled) {
        IEditorPart editor;
        this.linkingEnabled = enabled;
        this.getSettings().put(SET_LINK_TO_EDITOR, enabled);
        if (enabled && (editor = this.getSite().getPage().getActiveEditor()) != null) {
            this.editorActivated(editor);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (this.isLinkingEnabled() && part instanceof IEditorPart) {
            this.editorActivated((IEditorPart)part);
        }
        if (part instanceof Navigator) {
            activeNavigator = (Navigator)part;
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (part instanceof Navigator) {
            activeNavigator = (Navigator)part;
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (activeNavigator == part) {
            activeNavigator = null;
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public boolean isActiveNavigator() {
        return activeNavigator == this;
    }

    protected abstract boolean editorActivated(IEditorPart var1);

    protected abstract void linkToEditor(IStructuredSelection var1);

    public void updateTitle() {
        String viewName = this.getConfigurationElement().getAttribute("name");
        this.setPartName(viewName);
        this.setTitleToolTip("");
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() == this.structuredViewer) {
            IStructuredSelection structuredSelection = this.convertFromViewer(event.getSelection());
            this.updateActionBars(structuredSelection);
            this.updateStatusLine(structuredSelection);
            if (!structuredSelection.isEmpty() && this.isLinkingEnabled()) {
                this.linkToEditor(structuredSelection);
            }
        }
    }

    protected void updateActionBars(IStructuredSelection structuredSelection) {
        NavigatorActionGroup group = this.getActionGroup();
        if (group != null) {
            group.setContext(new ActionContext((ISelection)structuredSelection));
            group.updateActionBars();
        }
    }

    protected void updateStatusLine(IStructuredSelection structuredSelection) {
        String msg = this.getStatusLineMessage(structuredSelection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(msg);
    }

    protected String getStatusLineMessage(IStructuredSelection structuredSelection) {
        int size = structuredSelection.size();
        if (size > 1) {
            return HyadesUIPlugin.getString("STS_LNE_MULTI", Integer.toString(size));
        }
        return null;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.saveSelection(memento);
    }

    protected void saveSelection(IMemento memento) {
        IStructuredSelection structuredSelection = this.convertFromViewer(this.getViewer().getSelection());
        if (structuredSelection.isEmpty()) {
            return;
        }
        IMemento selectionMemento = memento.createChild(TAG_SELECTION);
        Iterator i = structuredSelection.iterator();
        while (i.hasNext()) {
            this.saveElement(selectionMemento, i.next());
        }
    }

    protected void saveElement(IMemento memento, Object element) {
        IPersistableElement persistableElement = null;
        persistableElement = element instanceof IPersistableElement ? (IPersistableElement)element : (element instanceof IAdaptable ? (IPersistableElement)((IAdaptable)element).getAdapter(class$org$eclipse$ui$IPersistableElement == null ? (class$org$eclipse$ui$IPersistableElement = Navigator.class$("org.eclipse.ui.IPersistableElement")) : class$org$eclipse$ui$IPersistableElement) : (IPersistableElement)Platform.getAdapterManager().getAdapter(element, class$org$eclipse$ui$IPersistableElement == null ? (class$org$eclipse$ui$IPersistableElement = Navigator.class$("org.eclipse.ui.IPersistableElement")) : class$org$eclipse$ui$IPersistableElement));
        if (persistableElement == null) {
            return;
        }
        IMemento elementMemento = memento.createChild(TAG_ELEMENT);
        elementMemento.putString(TAG_FACTORY_ID, persistableElement.getFactoryId());
        persistableElement.saveState(elementMemento);
    }

    protected List loadElements(IMemento memento) {
        ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>();
        IMemento[] elementMementos = memento.getChildren(TAG_ELEMENT);
        int i = 0;
        int maxi = elementMementos.length;
        while (i < maxi) {
            IAdaptable element;
            IElementFactory elementFactory;
            String factoryId = elementMementos[i].getString(TAG_FACTORY_ID);
            if (factoryId != null && (elementFactory = CoreUtil.getElementFactory(factoryId)) != null && (element = elementFactory.createElement(elementMementos[i])) != null) {
                elements.add(element);
            }
            ++i;
        }
        return elements;
    }

    public void keyPressed(KeyEvent event) {
        NavigatorActionGroup group;
        if (event.widget == this.getViewer().getControl() && (group = this.getActionGroup()) != null) {
            group.handleKeyPressed(event);
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void menuAboutToShow(IMenuManager manager) {
        IStructuredSelection selection = this.convertFromViewer(this.getViewer().getSelection());
        NavigatorActionGroup group = this.getActionGroup();
        if (group != null) {
            group.setContext(new ActionContext((ISelection)selection));
            group.fillContextMenu(manager);
        }
    }

    public void open(OpenEvent event) {
        if (event.getViewer() == this.getViewer()) {
            IStructuredSelection structuredSelection = this.convertFromViewer(event.getSelection());
            NavigatorActionGroup group = this.getActionGroup();
            if (group != null) {
                this.getActionGroup().runDefaultAction(structuredSelection);
            }
        }
    }

    public void handleChange(int type) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == this) {
            return;
        }
        if (part instanceof IEditorPart && !this.isLinkingEnabled()) {
            return;
        }
        this.selectReveal(selection);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

