/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.util.IDisposable;

public class ResourceBundleManager
implements IDisposable {
    private List resourceBundles = this.createResourceBundleList();

    public void dispose() {
        this.resourceBundles.clear();
    }

    protected List createResourceBundleList() {
        return new ArrayList();
    }

    public boolean add(ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            return false;
        }
        return this.resourceBundles.add(resourceBundle);
    }

    public boolean add(int index, ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            return false;
        }
        this.resourceBundles.add(index, resourceBundle);
        return true;
    }

    public boolean remove(ResourceBundle resourceBundle) {
        return this.resourceBundles.remove(resourceBundle);
    }

    public ResourceBundle remove(int resourceBundleIndex) {
        return (ResourceBundle)this.resourceBundles.remove(resourceBundleIndex);
    }

    public void clear() {
        this.resourceBundles.clear();
    }

    public Iterator iterator() {
        return this.resourceBundles.iterator();
    }

    public int size() {
        return this.resourceBundles.size();
    }

    public String getString(String key) throws NullPointerException, MissingResourceException {
        MissingResourceException missingResourceException = null;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            try {
                return ((ResourceBundle)i.next()).getString(key);
            }
            catch (MissingResourceException e) {
                missingResourceException = e;
            }
        }
        throw missingResourceException;
    }

    public String getString(String key, String arg) throws NullPointerException, MissingResourceException {
        return StringUtil.replace(this.getString(key), "%1", arg);
    }

    public String getString(String key, String[] args) throws NullPointerException, MissingResourceException {
        String ret = this.getString(key);
        int i = args.length;
        while (i > 0) {
            ret = StringUtil.replace(ret, "%" + i, args[i - 1]);
            --i;
        }
        return ret;
    }
}

