// ****************************************************************************
// * Copyright (c) 2005 IBM Corporation and others.
// * All rights reserved. This program and the accompanying materials 
// * are made available under the terms of the Eclipse Public License v1.0
// * which accompanies this distribution, and is available at
// * http://www.eclipse.org/legal/epl-v10.html
// * $Id: main.js,v 1.3 2005/02/16 22:24:05 qiyanli Exp $
// * 
// * Contributors:
// *     IBM Corporation - initial implementation
// ****************************************************************************

		<!-- hide
		
		//global variables -----------------------------------
		var selectedFontImg = "font8";
		var selectedFontSize = 8;
		
		var selectedColorBox;
		var popWin;
		
		var previewed = false;		
		
		//event functions -------------------------------------

		// reset the widget styles back to the stored values
		function doReset() {			
			if (previewed) {
				self.opener.resetStyles();
			}			
		}// doReset()	
		
		// for a preview, the widget does not store the values
		function doPreview() {
			previewed = true;			
			self.opener.updateStyles(grabStyles(), previewed);							
		}// doPreview()	

		function setDefault() {
			// reset standard preferences to defaults
			selectedFontIM = "font8";
			selectedEnabled = false;
					
			document.widgetPrefs.fontface[0].selected = true;
			document.widgetPrefs.fontStyle[0].selected = true;
			
			updateSampleTextSize(8,'font8');			
			
			selectedColorBox = "fontColor";
			updateDataColor('#000000');
						
			//reset preferences local to widget to defaults
			selectedColorBox = "dataColor1";
			if(document.widgetPrefs.dataColor1) {
				// translatable
				document.widgetPrefs.dataColorPattern1.value = "Seaside";
				updateDataColor('#003399');
			}
			
			if (document.widgetPrefs.shapes) {
				document.widgetPrefs.shapes.checked = true;
			}
			
			if(document.widgetPrefs.values)	{
				document.widgetPrefs.values.checked = false;
			}
			else if(document.widgetPrefs.actual) {
				document.widgetPrefs.actual.checked = true;
			}
				
			if(document.widgetPrefs.percentage) document.widgetPrefs.percentage.checked = true;			
		}//setDefault()
		
		
		// initialize the values with the graphic's current values:
		// current[0] = palette identifer, e.g., "ZZ1"
		// current[1] = font size, e.g., "8"
		// current[2] = font, e.g., "font-weight:normal;font-style:normal; font-family:arial; fill:#000000;"
		// current[3] =	shape, e.g., "circleshape", "all", etc. OR "none"
		// current[4] = show values, "1" OR "0" 
		// current[5] = show percents, "1" OR "0" 
		// current[6] = palette first colour, e.g., "#003399"
		function setCurrent() {				
			var current = self.opener.getCurrentValues();				
			if (current == null) {				
			  return;
			}			
			var index = 0;				
			var currentPaletteName = current[0];	 
			var fontSize = current[1];
			var fontStyle = current[2].slice(0, current[2].indexOf(" font-family"));			
			var fontFace = current[2].slice((current[2].indexOf("font-family:") + 12), current[2].indexOf("; fill"));				
			var fontColor = current[2].substring(current[2].indexOf("#"), current[2].length - 1);
			
			// reset standard preferences to defaults - what about these?
			selectedFontIM = 'font' + fontSize;
			selectedEnabled = false;
			
			// palette name, first colour
			selectedColorBox = "dataColor1";			
			if(document.widgetPrefs.dataColor1) {	
				// translatable				
				switch(currentPaletteName) {
					case "ZZ1": 
					  currentPaletteName = "Seaside";
					  break;
				 	case "ZZ2": 				 		
					  currentPaletteName = "Summer";
					  break;
					case "ZZ3": 
					  currentPaletteName = "Earth";
					  break;
					case "ZZ4": 
					  currentPaletteName = "Spring";
					  break;
					case "ZZ5": 
					  currentPaletteName = "Harvest";
					  break;
					case "ZZ6": 
					  currentPaletteName = "Pastel";
					  break;
					default:					  
					  break;
					
				}					
				document.widgetPrefs.dataColorPattern1.value = currentPaletteName; // is this the id or name?
				if (currentPaletteName == "Statistics") {
					updateDataColor("#D3D3D3");
				}	
				else {	
					updateDataColor(current[6]);
				}
			}			
					
			//font size - needed to update font size image selection
			updateSampleTextSize(fontSize,'font' + fontSize);
						
			// font style		
			switch (fontStyle) {				
				case "font-weight:normal; font-style:normal;":
					index = 0;
					break;
				case "font-weight:normal; font-style:italic;":	
					index = 1;
					break;				
				case "font-weight:bold; font-style:normal;":					
					index = 2;	
					break;			
				case "font-weight:bold; font-style:italic;":	
					index = 3;
					break;
				default:	
					index = 0;
					break;
			}						
			document.widgetPrefs.fontStyle[index].selected = true;
						
			// font face
			var currentFont = fontFace.split(',');			
			var count = 0;
			index = -1;
			while (index == -1 && count < currentFont.length) {
				switch (currentFont[count].toLowerCase()) {
					case "arial":
						index = 0;
						break;
					case "baskerville":						
						index = 1;
						break;
					case "comic sans ms":	
						index = 2;
						break;
					case "georgia":	
						index = 3;
						break;
					case "gil sans":	
						index = 4;
						break;
					case "helvetica":	
						index = 5;
						break;
					case "lucida sans unicode":	
						index = 6;
						break;
					case "news gothic":	
						index = 7;
						break;
					case "times new roman":	
						index = 8;
						break;
					case "verdana":	
						index = 9;
						break;
					case "utopia":	
						index = 10;
						break;
					default:	
					//	index = 0;
						break;
				}			
				++count;
			}
			
			document.widgetPrefs.fontface[index].selected = true;
									
			// font color
			selectedColorBox = "fontColor";
			updateDataColor(fontColor);
			
			if (current[3] == "1") {
				if (document.widgetPrefs.shapes) {
					document.widgetPrefs.shapes.checked = true;	
				}
			} else {
				if (document.widgetPrefs.shapes) {
					document.widgetPrefs.shapes.checked = false;
				}
			}
			
			
			// values/actual and percentages
			if (current[4] == "1") {
				if(document.widgetPrefs.values)	{
					document.widgetPrefs.values.checked = true;
				}	
				else if(document.widgetPrefs.actual) {
					document.widgetPrefs.actual.checked = true;
				}	
			}
			else {
				if(document.widgetPrefs.values)	{
					document.widgetPrefs.values.checked = false;
				}	
				else if(document.widgetPrefs.actual) {
					document.widgetPrefs.actual.checked = false;
				}	
			}
			
			// percentages
			if (current[5] == "1") {
				if(document.widgetPrefs.percentage) document.widgetPrefs.percentage.checked = true;
			}
			else {
				if(document.widgetPrefs.percentage) document.widgetPrefs.percentage.checked = false;
			}				
			
		}//setCurrent()
		
		function updateDataColor (hex) { 
		
				hideLayer(selectedColorBox + "_layer");
				
				var pattern = selectedColorBox;
				var whichform = document.getElementById(pattern);
				whichform.style.backgroundColor=hex; 	
							
		}//updateColor
		
		
		function openWindow(winName,w,h)  {
			if (popWin)
				popWin.close();
				
			params = "height=" + h + ",width=" + w + ",top=100,left=100,screenx=100,screeny=100,toolbar=no,scrollbar=no";
			popWin = window.open(winName,"newWindow",params);	
		}//openWindow
		
		
		
		function showLayer(layer) {
			var block = document.getElementById(layer);
	   		block.style.display = "block";
		}//showLayer
		
		
		function hideLayer(layer) {
			var block = document.getElementById(layer);
			block.style.display = "none";
		}//hideLayer
		
		
		function updateSampleTextSize(fontpt,fontImg) {
			
			selectedFontSize = fontpt; //added by us
			
			eval("document." + selectedFontImg).src = "images/" + selectedFontImg.substring(4) + "pt_Off.gif";
			eval("document." + fontImg).src = "images/" + fontpt + "pt_On.gif";
			
			selectedFontImg = fontImg;
	
		}//updateSampleTextSize

		
		function toHex(dec) {
			var i = 0
			var j = 0
			hexChars = "0123456789ABCDEF"
			if (dec > 255) {
				return null
			}
			i = dec % 16
			j = (dec-i) / 16
			result = hexChars.charAt(j)
			result += hexChars.charAt(i)
			return result
		}//toHex -- algorithim courtesy of Framfab
		
		function toRGB(hex) {
		
			if (hex.length < 0 || hex.length > 2 ||
				hexChars.indexOf(hex.charAt(0)) < 0 ||
				hexChars.indexOf(hex.charAt(1)) < 0)
					return null;
					
			rgb = (parseInt(hex.substring(0,1),16) * 16) +  parseInt(hex.substring(1),16);
			
			return rgb;
		}

		function writeColorPanel(hexValue) {
			var totalSteps = 5;
			//write table header and inital hexvalue
			document.write("<table border='0' cellspacing='0' cellpadding='0'>\n<tr>");					
			document.write('<td width="60" height="5" bgcolor="#' + hexValue + '"><img src="images/spacer.gif" width="60" height="13"></td>');
			
			var startRed = toRGB(hexValue.substring(0,2));
			var startGreen = toRGB(hexValue.substring(2,2));
			var startBlue = toRGB(hexValue.substring(4,2));

			for (i=0; i<4; i++) {

				// we calculate the next decimal RGB values	
				nextRed = (((256-startRed)/totalSteps) * i);
				nextGreen = (((256-startGreen)/totalSteps) * i);
				nextBlue = (((256-startBlue)/totalSteps) * i);

				// then we spit it out as a hex string again
				outputHex = toHex(nextRed) + toHex(nextGreen) + toHex(nextBlue);
				document.write('<td width="5" height="5" bgcolor="#' + outputHex + '"><img src="images/spacer.gif" width="13" height="13"></td>');
	
				// start hex values saved as current steps values to continue gradiation
				startRed = toHex(nextRed);
				startGreen = toHex(nextGreen);
				startBlue = toHex(nextBlue);						
				
			}

			// last value always white
			document.write('<td width="5" height="5" bgcolor="#FFFFFF"><img src="images/spacer.gif" width="13" height="13"></td>');
			//close table
			document.write("</tr>\n</table>");
		}//writeColorPanel
		
		
		
		function highlightColorRow(colorRow,on) {
			var cRow = document.getElementById(colorRow); 
			if (on) {
					cRow.style.backgroundColor = "#000099";
			} else {
					cRow.style.backgroundColor = "#FFFFFF";	
			}
		}//highlightColorRow
		
		function submitForm() {
			//no need to store font size attributes - see "selectedFontSize"
					
			//store the color attributes
			widgetPrefs.fontColor.value = widgetPrefs.fontColor.style.backgroundColor;

			if (document.widgetPrefs.dataColor1) {
				widgetPrefs.dataColor1.value = widgetPrefs.dataColor1.style.backgroundColor;
			}			
			
			previewed = false;
			self.opener.updateStyles(grabStyles(), previewed);
			self.window.close();	
		}//submitForm()
		
		// grab font properties
		function grabFontStyle() {
			var fontText = '';
			var tmpFontStyle = '';			
			var fontStyle = '';			
			var fontFamily = '';			
			var fontColor = '';
			
			// font style
			tmpFontStyle=document.widgetPrefs.fontStyle.options[document.widgetPrefs.fontStyle.selectedIndex].value;	
			
			// normal style
			fontStyle = "font-weight:normal; font-style:normal;";
			if (tmpFontStyle == "italic") {
				fontStyle = "font-weight:normal; font-style:italic;";	
			} else if (tmpFontStyle == "bold_italic") {
				fontStyle = "font-weight:bold; font-style:italic;";	
			} else if (tmpFontStyle == "bold") {
				fontStyle = "font-weight:bold; font-style:normal;"	
			} 
						
			// font family
			fontFamily = " font-family:" + document.widgetPrefs.fontface.options[document.widgetPrefs.fontface.selectedIndex].value + ";";
							
			// font color 
			fontColor = " fill:" + document.widgetPrefs.fontColor.style.backgroundColor  + ";";;
						
			// Append all font styles into a string			
			fontText = fontStyle + fontFamily + fontColor;
					
			return fontText;			
		}	
		
		// get percentage - only used in piechart
		function grabPercentage() {
			var tmpPercentage = document.widgetPrefs.percentage;

			if (tmpPercentage) {
				if (tmpPercentage.checked) {
					return "1";
				}
				else {
					return "0";
				}
			} else {
				return "0";
			}

		}
		
		
		// return an array of styles {palette, font, shape, showValues, showPercentage}
		function grabStyles() {
			var allStyles = new Array(6);
			
			// palette
			var paletteName = "none";
		
			// this is a temporary measure, not work with translation
			if (document.widgetPrefs.dataColorPattern1) {
				paletteName = document.widgetPrefs.dataColorPattern1.value;
				// translatable
				switch(paletteName) {
					case "Seaside": 
					  paletteName = "ZZ1";
					  break;
				 	case "Summer": 
					  paletteName = "ZZ2";
					  break;
					case "Earth": 
					  paletteName = "ZZ3";
					  break;
					case "Spring": 
					  paletteName = "ZZ4";
					  break;
					case "Harvest": 
					  paletteName = "ZZ5";
					  break;
					case "Pastel": 
					  paletteName = "ZZ6";
					  break;
					default:					  
					  break;
					
				}
			}
			
			// font size
			var fontSize = selectedFontSize;			
			// font
			var fontStyle = grabFontStyle();		
			// shape
			var showShapes = "1";
			if (document.widgetPrefs.shapes) {
				showShapes = (document.widgetPrefs.shapes.checked == true ? "1" : "0");
			} 
			
			// showValue
			var showValue = "0";
			if (document.widgetPrefs.values) { 
				showValue = (document.widgetPrefs.values.checked == true ? "1" : "0");
			} else if (document.widgetPrefs.actual) { 
				showValue = (document.widgetPrefs.actual.checked == true ? "1" : "0");
			}
			
			// showPercentage
			var showPercentage = grabPercentage();
		
			allStyles[0] = paletteName;
			allStyles[1] = fontSize;
			allStyles[2] = fontStyle;
			allStyles[3] = showShapes;
			allStyles[4] = showValue;
			allStyles[5] = showPercentage;

			return allStyles;
		}

		// add the colour palettes to the table	
		function addPalettes(){
			var palettes = self.opener.getPalettes();
					
			for (var i = 0; i < palettes.length; i++){
				var p = palettes[i];				
				customPattern(p);
			}
				
			listener();
			
		}// addPalettes()

				
		function customPattern(p){		
//			var arrayCount = p.length;
			var paletteName = p[p.length - 1];	
			// convert ids back to display names 
			switch(paletteName) {
					case "ZZ1": 
					  paletteName = "Seaside";
					  break;
				 	case "ZZ2": 				 		
					  paletteName = "Summer";
					  break;
					case "ZZ3": 
					  paletteName = "Earth";
					  break;
					case "ZZ4": 
					  paletteName = "Spring";
					  break;
					case "ZZ5": 
					  paletteName = "Harvest";
					  break;
					case "ZZ6": 
					  paletteName = "Pastel";
					  break;
					default:					  
					  break;
					
			}		
		
			var colorDiv = document.getElementById("custom");
	
			parentTable = document.createElement("TABLE");
  			parentTable.id ="parentTable";
			parentTable.cellPadding = "1";
			parentTable.cellSpacing = "0";
			parentTable.border = "0";
  		
			parentTableBody = document.createElement("TBODY");
			parentRow = document.createElement("TR");
			parentCell = document.createElement("TD");
		                    
			highliteDiv = document.createElement("DIV");
	
 			colorTable = document.createElement("TABLE");
			colorTable.cellPadding = "0";
			colorTable.cellSpacing = "1";
  			colorTable.border = "0px";
			colorTable.style.border = "solid";
			colorTable.style.borderWidth = "1px";
			colorTable.style.borderColor = "black";
			highliteDiv.appendChild(colorTable);		
		
  			colorTableBody = document.createElement("TBODY");
			colorTable.appendChild(colorTableBody);		
		
    		row = document.createElement("TR");
			colorTableBody.appendChild(row);
		
			cellOne = document.createElement("TD");
			cellOne.id = paletteName;
			cellOne.style.backgroundColor = p[0];
			cellOne.style.width = "182px";
			cellOne.style.height = "13px";
			spacer1 = document.createElement("img");
			// depends on images dir remaining under preferences dir
			spacer1.src = "images/spacer.gif";		
			cellOne.appendChild(spacer1);
			row.appendChild(cellOne);		
		
    		for (j = 1; j < p.length -1; j++){
 	     		cell = document.createElement("TD");
				cell.style.backgroundColor = p[j];
				cell.style.width = "13px";
				cell.style.height = "13px";
				// same thing as above
				spacer = document.createElement("img");	
				spacer.src = "images/spacer.gif";
				cell.appendChild(spacer);
 	     		row.appendChild(cell);
			}
			
			if (p.length - 1 < 15) {
				var extras = 15 - p.length + 1;
				for (j = 0 ; j < extras; j++){
 	     			cell = document.createElement("TD");
					cell.style.backgroundColor = "silver";
					cell.style.width = "13px";
					cell.style.height = "13px";
					// same thing as above
					spacer = document.createElement("img");	
					spacer.src = "images/spacer.gif";
					cell.appendChild(spacer);
 	     			row.appendChild(cell);
				}
			}
			parentCell.appendChild(highliteDiv);
			parentRow.appendChild(parentCell);
			parentTableBody.appendChild(parentRow);
			parentTable.appendChild(parentTableBody);		
			colorDiv.appendChild(parentTable);			

		} // customPattern()


		function iePatternEvents(e){
			var pickedDataColor = e.srcElement.style.backgroundColor;	
	
			if (e.type=="mouseover") {
				document.widgetPrefs.dataColorPattern1.value= e.srcElement.id;
			}

			if (e.type=="click"){
				updateDataColor(pickedDataColor);		
				var block = document.getElementById("dataColor1_layer");
				block.style.display = "none";
			}
			
		} // iePatternEvents()


		function nsPatternEvents(e){	
			var targetNode = e.target;
			var pickedDataColor = targetNode.style.backgroundColor;
		
			if (e.type=="mouseover") {	
				document.widgetPrefs.dataColorPattern1.value= targetNode.id;
			}
			
			if (e.type=="click"){
				updateDataColor(pickedDataColor);
				var block = document.getElementById("dataColor1_layer");
				block.style.display = "none";
			}
				
		} // nsPatternEvents()



		function listener(){	
			var custom = document.getElementById("custom");
		
			if (custom.addEventListener){
				custom.addEventListener("mouseover",nsPatternEvents,false);
				custom.addEventListener("click",nsPatternEvents,false);
				return true;	
			}
			else if (custom.attachEvent){
				var ie = custom.attachEvent("onmouseover",iePatternEvents); 
				custom.attachEvent("onclick",iePatternEvents);
				return ie;
			}
		} // listener()
		
		

		// -->
		
