/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.http.TestHttpImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.ResourceBundleManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class TestHttpPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.hyades.test.http";
    private static TestHttpPlugin instance;
    private ResourceBundleManager resourceBundleManager;
    private ResourceBundle resourceBundle;

    public TestHttpPlugin() {
        instance = this;
    }

    public static TestHttpPlugin getInstance() {
        return instance;
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.resourceBundleManager = new ResourceBundleManager();
        this.resourceBundleManager.add(this.getResourceBundle());
        this.resourceBundleManager.add(HyadesUIPlugin.getInstance().getResourceBundle());
        this.resourceBundleManager.add(TestUIPlugin.getInstance().getResourceBundle());
        this.resourceBundleManager.add(TestCommonPlugin.getInstance().getResourceBundle());
        super.start(bundleContext);
        try {
            TestHttpImages.INSTANCE.initialize(new URL(this.getBundle().getEntry("/"), "icons/full/"), this.getImageRegistry());
        }
        catch (Exception exception) {
            TestHttpPlugin.logError(exception);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.resourceBundleManager.dispose();
        instance = null;
        super.stop(bundleContext);
    }

    public ResourceBundle getResourceBundle() {
        block2: {
            if (this.resourceBundle != null) break block2;
            try {
                this.resourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
            }
            catch (Exception exception) {
                this.resourceBundle = null;
            }
        }
        return this.resourceBundle;
    }

    public static String getID() {
        return PLUGIN_ID;
    }

    public static void logError(Throwable throwable) {
        Status status = new Status(1, TestHttpPlugin.getID(), 0, throwable.toString(), throwable);
        TestHttpPlugin.getInstance().getLog().log((IStatus)status);
    }

    public static void logError(String string) {
        TestHttpPlugin.logError(new Throwable(string));
    }

    public static void logInfo(String string) {
        Status status = new Status(3, TestHttpPlugin.getID(), 0, string, new Throwable(string));
        TestHttpPlugin.getInstance().getLog().log((IStatus)status);
    }

    public static String getString(String string) throws NullPointerException, MissingResourceException {
        return TestHttpPlugin.instance.resourceBundleManager.getString(string);
    }

    public static String getString(String string, String string2) throws NullPointerException, MissingResourceException {
        return TestHttpPlugin.instance.resourceBundleManager.getString(string, string2);
    }

    public static String getString(String string, String[] stringArray) throws NullPointerException, MissingResourceException {
        return TestHttpPlugin.instance.resourceBundleManager.getString(string, stringArray);
    }
}

