/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.junit.editor;

import org.eclipse.hyades.models.common.facades.behavioral.IProperty;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsFactory;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.util.HttpConstants;
import org.eclipse.hyades.test.http.internal.util.RequestHelper;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class HttpHeaderViewer
implements SelectionListener,
IDisposable {
    private static final String[] COLUMNS = new String[]{"STRING", "STRING"};
    private TableViewer tableViewer;
    private Button btnAdd;
    private Button btnRename;
    private Button btnRemove;
    private Button btnUp;
    private Button btnDown;
    private RequestHelper requestHelper;
    private boolean readOnly;

    public void dispose() {
        this.requestHelper = null;
    }

    public void createControl(Composite composite, WidgetFactory widgetFactory) {
        Composite composite2 = widgetFactory.createComposite(composite, 0);
        GridData gridData = GridDataUtil.createFill();
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        widgetFactory.createLabel(composite2, TestHttpPlugin.getString("Headers_Label"));
        this.createTable(composite2, widgetFactory);
    }

    private void createButtons(Composite composite, WidgetFactory widgetFactory) {
        this.btnAdd = widgetFactory.createButton(composite, TestHttpPlugin.getString("label.Add"), 8);
        this.btnAdd.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.btnAdd.setEnabled(false);
        this.btnRename = widgetFactory.createButton(composite, TestHttpPlugin.getString("label.Update"), 8);
        this.btnRename.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.btnRename.setEnabled(false);
        this.btnRemove = widgetFactory.createButton(composite, TestHttpPlugin.getString("label.Remove"), 8);
        this.btnRemove.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.btnRemove.setEnabled(false);
        this.btnUp = widgetFactory.createButton(composite, TestHttpPlugin.getString("LBL_UP"), 8);
        GridData gridData = GridDataUtil.createHorizontalFill();
        gridData.verticalAlignment = 8;
        this.btnUp.setLayoutData((Object)gridData);
        this.btnUp.setEnabled(false);
        this.btnDown = widgetFactory.createButton(composite, TestHttpPlugin.getString("LBL_DOWN"), 8);
        gridData = GridDataUtil.createHorizontalFill();
        gridData.verticalAlignment = 8;
        this.btnDown.setLayoutData((Object)gridData);
        this.btnDown.setEnabled(false);
    }

    private Control createTable(Composite composite, WidgetFactory widgetFactory) {
        Composite composite2 = widgetFactory.createComposite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 10;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        this.createTableViewer(composite2, widgetFactory);
        Composite composite3 = widgetFactory.createComposite(composite2, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData = new GridData(1040);
        composite3.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        this.createButtons(composite3, widgetFactory);
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnRename.addSelectionListener((SelectionListener)this);
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnUp.addSelectionListener((SelectionListener)this);
        this.btnDown.addSelectionListener((SelectionListener)this);
        return composite2;
    }

    private void createTableViewer(Composite composite, WidgetFactory widgetFactory) {
        Table table = widgetFactory.createTable(composite, 65540);
        this.tableViewer = new TableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)GridDataUtil.createFill());
        table.computeSize(-1, -1);
        TableLayout tableLayout = new TableLayout();
        CellEditor[] cellEditorArray = new CellEditor[COLUMNS.length];
        TableColumn tableColumn = new TableColumn(table, 0x804000);
        tableColumn.setText(TestHttpPlugin.getString("ENV_NAME"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        cellEditorArray[0] = new TextCellEditor((Composite)table);
        TableColumn tableColumn2 = new TableColumn(table, 16384);
        tableColumn2.setText(TestHttpPlugin.getString("ENV_VALUE"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        cellEditorArray[1] = new TextCellEditor((Composite)table);
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setColumnProperties(COLUMNS);
        this.tableViewer.setContentProvider((IContentProvider)new HeaderContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new HeaderLabelProvider());
        this.tableViewer.getTable().addSelectionListener((SelectionListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (!this.isReadOnly() && this.requestHelper != null) {
            int n;
            if (selectionEvent.widget == this.btnAdd) {
                HeaderDialog headerDialog = new HeaderDialog(this.btnAdd.getShell(), null);
                if (headerDialog.open() == 0) {
                    BVRProperty bVRProperty = headerDialog.getProperty();
                    this.requestHelper.addHeader((IProperty)bVRProperty);
                    this.tableViewer.add((Object)bVRProperty);
                    this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)bVRProperty));
                }
            } else if (selectionEvent.widget == this.btnRemove) {
                int n2 = this.tableViewer.getTable().getSelectionIndex();
                if (n2 >= 0) {
                    IProperty iProperty = (IProperty)this.tableViewer.getTable().getItem(n2).getData();
                    this.requestHelper.removeHeader(iProperty);
                    this.tableViewer.getTable().remove(n2);
                    int n3 = n2 = n2 < this.tableViewer.getTable().getItemCount() ? n2 : this.tableViewer.getTable().getItemCount() - 1;
                    if (n2 >= 0) {
                        this.tableViewer.getTable().select(n2);
                    }
                }
            } else if (selectionEvent.widget == this.btnRename) {
                Object object;
                IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tableViewer.getSelection();
                if (iStructuredSelection.size() > 0 && (object = iStructuredSelection.getFirstElement()) instanceof BVRProperty) {
                    HeaderDialog headerDialog = new HeaderDialog(this.btnRename.getShell(), (BVRProperty)object);
                    headerDialog.open();
                    if (headerDialog.getReturnCode() == 0) {
                        this.tableViewer.update(object, null);
                    }
                }
            } else if (selectionEvent.widget == this.btnUp) {
                int n4 = this.tableViewer.getTable().getSelectionIndex();
                if (n4 > 0) {
                    IProperty iProperty = (IProperty)this.tableViewer.getTable().getItem(n4).getData();
                    IProperty iProperty2 = (IProperty)this.tableViewer.getTable().getItem(n4 - 1).getData();
                    this.requestHelper.swapHeaders(iProperty, iProperty2);
                    this.tableViewer.refresh();
                    this.tableViewer.getTable().select(n4 - 1);
                }
            } else if (selectionEvent.widget == this.btnDown && (n = this.tableViewer.getTable().getSelectionIndex()) < this.tableViewer.getTable().getItemCount() - 1) {
                IProperty iProperty = (IProperty)this.tableViewer.getTable().getItem(n).getData();
                IProperty iProperty3 = (IProperty)this.tableViewer.getTable().getItem(n + 1).getData();
                this.requestHelper.swapHeaders(iProperty, iProperty3);
                this.tableViewer.refresh();
                this.tableViewer.getTable().select(n + 1);
            }
        }
        this.btnAdd.setEnabled(this.requestHelper != null);
        boolean bl = this.requestHelper != null && !this.tableViewer.getSelection().isEmpty();
        this.btnRemove.setEnabled(bl);
        this.btnRename.setEnabled(bl);
        this.btnUp.setEnabled(bl && this.tableViewer.getTable().getSelectionIndex() > 0);
        this.btnDown.setEnabled(bl && this.tableViewer.getTable().getSelectionIndex() < this.tableViewer.getTable().getItemCount() - 1);
    }

    public void setInput(RequestHelper requestHelper) {
        this.requestHelper = requestHelper;
        this.setEnabled(requestHelper != null);
        this.tableViewer.setInput((Object)requestHelper);
        this.btnAdd.setEnabled(requestHelper != null);
        boolean bl = requestHelper != null && !this.tableViewer.getSelection().isEmpty();
        this.btnDown.setEnabled(bl);
        this.btnRemove.setEnabled(bl);
        this.btnRename.setEnabled(bl);
        this.btnUp.setEnabled(bl);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setEnabled(boolean bl) {
        this.btnAdd.setEnabled(bl);
        this.btnDown.setEnabled(bl);
        this.btnRemove.setEnabled(bl);
        this.btnRename.setEnabled(bl);
        this.btnUp.setEnabled(bl);
    }

    public void clearTable() {
        this.tableViewer.getTable().removeAll();
    }

    protected static class HeaderUI
    implements ModifyListener {
        private CCombo nameCombo;
        private Text valueText;
        private Shell shell;
        private Listener listener;

        public HeaderUI(Shell shell) {
            this.shell = shell;
        }

        public Composite createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            gridLayout.verticalSpacing = 10;
            gridLayout.horizontalSpacing = 5;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = GridDataUtil.createFill();
            gridData.horizontalIndent = 5;
            composite2.setLayoutData((Object)gridData);
            Label label = new Label(composite2, 0);
            label.setText(TestHttpPlugin.getString("ENV_NAME"));
            this.nameCombo = new CCombo(composite2, 0x800800);
            this.nameCombo.setLayoutData((Object)GridDataUtil.createHorizontalFill());
            this.nameCombo.setItems(HttpConstants.getAllHeaders());
            this.nameCombo.setFocus();
            this.nameCombo.addModifyListener((ModifyListener)this);
            label = new Label(composite2, 0);
            label.setText(TestHttpPlugin.getString("ENV_VALUE"));
            this.valueText = new Text(composite2, 2882);
            this.valueText.setLayoutData((Object)GridDataUtil.createFill());
            this.valueText.addModifyListener((ModifyListener)this);
            return composite2;
        }

        public String getValue() {
            return this.valueText.getText().trim();
        }

        public String getName() {
            return this.nameCombo.getText().trim();
        }

        public void modifyText(ModifyEvent modifyEvent) {
            this.notifyListener();
        }

        public void setValue(String string) {
            if (string != null) {
                this.valueText.setText(string);
            } else {
                this.valueText.setText("");
            }
        }

        public void setName(String string) {
            if (string != null) {
                this.nameCombo.setText(string);
            } else {
                this.nameCombo.setText("");
            }
        }

        public void registerListener(Listener listener) {
            this.listener = listener;
        }

        public void notifyListener() {
            if (this.listener != null) {
                this.listener.handleEvent(null);
            }
        }
    }

    protected static class HeaderDialog
    extends Dialog
    implements Listener {
        private BVRProperty property;
        private HeaderUI propertyUI;

        public HeaderDialog(Shell shell, BVRProperty bVRProperty) {
            super(shell);
            this.property = bVRProperty;
        }

        protected Control createDialogArea(Composite composite) {
            this.getShell().setText(TestHttpPlugin.getString("Headers_Label"));
            Composite composite2 = new Composite(composite, 0);
            GridData gridData = GridDataUtil.createFill();
            gridData.heightHint = 250;
            gridData.widthHint = 400;
            composite2.setLayoutData((Object)gridData);
            composite2.setLayout((Layout)new GridLayout());
            this.propertyUI = new HeaderUI(this.getShell());
            Composite composite3 = this.propertyUI.createControl(composite2);
            if (this.property != null) {
                this.propertyUI.setName(this.property.getName());
                this.propertyUI.setValue(this.property.getValue());
            }
            return composite3;
        }

        protected Control createButtonBar(Composite composite) {
            Control control = super.createButtonBar(composite);
            this.propertyUI.registerListener(this);
            if (this.property == null) {
                this.getButton(0).setEnabled(false);
            }
            return control;
        }

        protected void okPressed() {
            if (this.property == null) {
                this.property = Common_Behavior_InteractionsFactory.eINSTANCE.createBVRProperty();
            }
            this.property.setName(this.propertyUI.getName());
            this.property.setValue(this.propertyUI.getValue());
            super.okPressed();
        }

        public BVRProperty getProperty() {
            return this.property;
        }

        public void handleEvent(Event event) {
            this.getButton(0).setEnabled(!this.propertyUI.getName().equals(""));
        }
    }

    protected static class HeaderLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected HeaderLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof BVRProperty) {
                BVRProperty bVRProperty = (BVRProperty)object;
                if (n == 0) {
                    return bVRProperty.getName();
                }
                if (n == 1) {
                    return bVRProperty.getValue();
                }
            }
            return "";
        }
    }

    protected static class HeaderContentProvider
    implements IStructuredContentProvider {
        protected HeaderContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            if (object instanceof RequestHelper) {
                return ((RequestHelper)object).getHeaders();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

