/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.reports.hitrate;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.http.internal.reports.HttpAbstractReport;
import org.eclipse.hyades.test.http.internal.reports.hitrate.HitRateData;

public class HitRateReport
extends HttpAbstractReport {
    protected long startTime = -1L;
    protected long stopTime = -1L;

    public HitRateReport(TPFExecutionResult tPFExecutionResult) {
        super(tPFExecutionResult);
    }

    protected void finishReport() {
        if (HttpAbstractReport.list.size() > 1) {
            HitRateData.setTestElapsedTime(this.stopTime - this.startTime);
            HttpAbstractReport.list.add(new HitRateData.OverallHitRate());
        }
    }

    protected void setupReport() {
        HitRateData.resetCounter();
    }

    protected void processMessageEvent(TPFMessageEvent tPFMessageEvent) {
        String string = tPFMessageEvent.getText();
        int n = string.indexOf("Time:");
        if (n != -1) {
            String string2 = string.substring(string.indexOf("ResponseURL:") + "ResponseURL:".length(), n).trim();
            String string3 = string.substring(n + "Time:".length(), string.length());
            string3 = string3.substring(0, string3.indexOf("\n")).trim();
            HitRateData hitRateData = (HitRateData)this.findPage(string2);
            if (hitRateData == null) {
                hitRateData = new HitRateData(string2);
                HttpAbstractReport.list.add(hitRateData);
            }
            hitRateData.addHit(new Long(string3));
        }
    }

    protected void processTypedEvent(TPFTypedEvent tPFTypedEvent) {
        if (tPFTypedEvent.getType() == TPFExecutionType.STOP_LITERAL) {
            this.stopTime = tPFTypedEvent.getTimestamp();
        } else if (this.startTime == -1L) {
            this.startTime = tPFTypedEvent.getTimestamp();
        }
    }
}

