/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.internal.wizard;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachine;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.wizard.EnvironmentVariableViewer;
import org.eclipse.hyades.test.common.internal.wizard.RunWizard;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.ui.EMFContentProvider;
import org.eclipse.hyades.test.ui.util.DeploymentUtil;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class RunLocationPage
extends WizardPage
implements Listener {
    protected AbstractTreeViewer hostViewer;
    private Button filterButton;
    private HostsContentProvider contentProvider;
    private URI initialLocationURI;
    private EnvironmentVariableViewer environmentVariableViewer;
    private boolean showEvironmentVariableViewer;
    private TPFTestSuite testSuite;
    private CFGArtifact testSuiteArtifact;
    private TPFDeployment deployment;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public RunLocationPage(boolean bl) {
        super("node");
        this.setTitle(TestUIPlugin.getString((String)"RUN_WTITLE"));
        this.setDescription(TestUIPlugin.getString((String)"RUN_NODED"));
        this.showEvironmentVariableViewer = bl;
    }

    public void dispose() {
        if (this.showEvironmentVariableViewer) {
            this.environmentVariableViewer.dispose();
        }
        super.dispose();
    }

    public void setInitialLocationURI(URI uRI) {
        this.initialLocationURI = uRI;
    }

    public void createControl(Composite composite) {
        Label label;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 100;
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        this.filterButton = new Button(composite2, 32);
        this.filterButton.setText(TestUIPlugin.getString((String)"SHOW_FOLDERS"));
        this.filterButton.addListener(13, (Listener)this);
        this.createViewer(composite2);
        TPFTest tPFTest = ((RunWizard)this.getWizard()).getTest();
        if (tPFTest instanceof TPFTestSuite) {
            this.testSuite = (TPFTestSuite)tPFTest;
        } else if (tPFTest instanceof TPFTestCase) {
            this.testSuite = ((TPFTestCase)tPFTest).getTestSuite();
        }
        if (this.showEvironmentVariableViewer) {
            label = new Label(composite2, 0);
            label.setText(TestUIPlugin.getString((String)"LBL_ENV_SETS"));
            this.environmentVariableViewer = new EnvironmentVariableViewer((TPFTest)this.testSuite);
            this.environmentVariableViewer.createControl(composite2);
        }
        this.hostViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        ((Tree)this.hostViewer.getControl()).addListener(13, (Listener)this);
        if (this.initialLocationURI == null) {
            ((TreeViewer)this.hostViewer).expandToLevel(2);
        } else {
            label = null;
            try {
                label = this.getResourceSet().getEObject(this.initialLocationURI, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (label != null && label instanceof CFGLocation) {
                this.hostViewer.setSelection((ISelection)new StructuredSelection((Object)label));
                this.setDeployment();
            }
        }
        this.setControl((Control)composite2);
        this.setPageComplete(this.deployment != null);
        WorkbenchHelp.setHelp((Control)composite2, (String)(TestCommonPlugin.getID() + ".addb0005"));
        WorkbenchHelp.setHelp((Control)this.filterButton, (String)(TestCommonPlugin.getID() + ".addb0006"));
        WorkbenchHelp.setHelp((Control)this.hostViewer.getControl(), (String)(TestCommonPlugin.getID() + ".addb0007"));
    }

    public void handleEvent(Event event) {
        if (event.type == 13) {
            if (event.widget == this.filterButton) {
                this.contentProvider.setFilter(this.filterButton.getSelection() ? 4 : 2);
                ISelection iSelection = this.hostViewer.getSelection();
                this.hostViewer.refresh();
                if (!iSelection.isEmpty()) {
                    this.hostViewer.setSelection(iSelection, true);
                }
            }
            this.setDeployment();
        }
        this.setPageComplete(this.getDeployment() != null);
    }

    protected StructuredViewer createViewer(Composite composite) {
        Tree tree = new Tree(composite, 67588);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        tree.setLayoutData((Object)gridData);
        this.contentProvider = new HostsContentProvider();
        this.hostViewer = new TreeViewer(tree);
        this.hostViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.hostViewer.setLabelProvider((IBaseLabelProvider)new HostsLabelProvider(true));
        this.contentProvider.setFilter(2);
        ViewerSorter viewerSorter = new ViewerSorter(){

            public void sort(Viewer viewer, Object[] objectArray) {
                if (objectArray.length > 0) {
                    super.sort(viewer, objectArray);
                }
            }

            public int category(Object object) {
                if (object instanceof IResource) {
                    return 0;
                }
                return 10;
            }
        };
        this.hostViewer.setSorter(viewerSorter);
        return this.hostViewer;
    }

    protected ITreeContentProvider initializeContentProvider() {
        EMFContentProvider eMFContentProvider = new EMFContentProvider(this.getResourceSet());
        EMFContentProvider.ElementDescription elementDescription = new EMFContentProvider.ElementDescription("testsuite");
        elementDescription.getEClassifiers().add(Common_TestprofilePackage.eINSTANCE.getTPFSUT());
        eMFContentProvider.addElementDescription(elementDescription);
        return eMFContentProvider;
    }

    public ResourceSet getResourceSet() {
        return ((RunWizard)this.getWizard()).getResourceSet();
    }

    public TPFDeployment getDeployment() {
        return this.deployment;
    }

    public CFGArtifact getTestSuiteArtifact() {
        if (this.testSuiteArtifact == null && this.testSuite != null && this.deployment != null) {
            this.testSuiteArtifact = DeploymentUtil.associateTestAsset((CFGClass)this.testSuite, (TPFDeployment)this.deployment).getArtifact();
        }
        return this.testSuiteArtifact;
    }

    public void setDeployment() {
        ISelection iSelection = this.hostViewer.getSelection();
        if (iSelection != null && !iSelection.isEmpty()) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            CFGLocation cFGLocation = null;
            if (object != null && object instanceof TPFDeployment) {
                this.deployment = (TPFDeployment)object;
            } else if (object != null && object instanceof CFGLocation) {
                Object object2 = object;
                Object object3 = null;
                while (!(object3 instanceof TPFDeployment)) {
                    object2 = object3 = this.contentProvider.getParent(object2);
                }
                this.deployment = (TPFDeployment)object3;
                cFGLocation = (CFGLocation)object;
            }
            if (this.deployment == null) {
                return;
            }
            this.testSuiteArtifact = DeploymentUtil.associateTestAsset((CFGClass)this.testSuite, (TPFDeployment)this.deployment).getArtifact();
        }
        if (this.environmentVariableViewer != null) {
            this.environmentVariableViewer.setInput(this.testSuiteArtifact);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class HostsLabelProvider
    extends LabelProvider {
        private Hashtable ovelayCache;
        private boolean useImages;

        public HostsLabelProvider(boolean bl) {
            this.useImages = bl;
            this.ovelayCache = new Hashtable();
        }

        public Image getImage(Object object) {
            IWorkbenchAdapter iWorkbenchAdapter;
            if (!this.useImages || object == null) {
                return null;
            }
            if (object instanceof TPFDeployment) {
                return TestUIImages.INSTANCE.getImage("deployment_obj.gif");
            }
            if (object instanceof CFGMachineConstraint) {
                return HyadesUIImages.INSTANCE.getImage("node_obj.gif");
            }
            if (object instanceof CFGLocation) {
                return TestUIImages.INSTANCE.getImage("location_obj.gif");
            }
            if (object instanceof IAdaptable && (iWorkbenchAdapter = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = RunLocationPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
                return iWorkbenchAdapter.getImageDescriptor(object).createImage();
            }
            return null;
        }

        public String getText(Object object) {
            IWorkbenchAdapter iWorkbenchAdapter;
            if (object == null) {
                return "";
            }
            String string = null;
            if (object instanceof TPFDeployment) {
                string = ((TPFDeployment)object).getName();
            } else if (object instanceof CFGLocation) {
                string = ((CFGLocation)object).getName();
            } else if (object instanceof IAdaptable && (iWorkbenchAdapter = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = RunLocationPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
                string = iWorkbenchAdapter.getLabel(object);
            }
            if (string == null) {
                string = object.toString();
            }
            return string;
        }

        public void dispose() {
            if (this.ovelayCache != null) {
                Iterator iterator = this.ovelayCache.values().iterator();
                while (iterator.hasNext()) {
                    Image image = (Image)iterator.next();
                    image.dispose();
                }
                this.ovelayCache.clear();
            }
            super.dispose();
        }
    }

    private class HostsContentProvider
    implements ITreeContentProvider {
        public static final int FILTER_FOLDERS = 2;
        public static final int SHOW_ALL = 4;
        private int filter;
        private ArrayList list = new ArrayList();

        public int getFilter() {
            return this.filter;
        }

        public void setFilter(int n) {
            this.filter = n;
        }

        public void dispose() {
            this.list.clear();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object getParent(Object object) {
            if (object instanceof IResource) {
                return ((IResource)object).getParent();
            }
            if (object instanceof EObject) {
                EObject eObject = (EObject)object;
                if (eObject instanceof CFGMachine) {
                    return eObject.eContainer();
                }
                if (eObject instanceof CFGMachineConstraint && RunLocationPage.this.hostViewer != null && ((TreeViewer)RunLocationPage.this.hostViewer).getTree() != null && ((TreeViewer)RunLocationPage.this.hostViewer).getTree().getSelection() != null && ((TreeViewer)RunLocationPage.this.hostViewer).getTree().getSelection().length > 0) {
                    TreeItem treeItem = ((TreeViewer)RunLocationPage.this.hostViewer).getTree().getSelection()[0].getParentItem();
                    if (treeItem == null) {
                        return null;
                    }
                    Object object2 = treeItem.getData();
                    if (object2 != null && object2 instanceof TPFDeployment) {
                        return object2;
                    }
                }
                switch (this.filter) {
                    case 4: {
                        return EMFUtil.getParent((Resource)eObject.eResource());
                    }
                }
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            return this.getChildren(object).length > 0;
        }

        public Object[] getElements(Object object) {
            if (object instanceof IWorkspaceRoot) {
                if (this.getFilter() == 2) {
                    this.list.clear();
                    IProject[] iProjectArray = ((IWorkspaceRoot)object).getProjects();
                    int n = 0;
                    while (n < iProjectArray.length) {
                        Object[] objectArray = this.getChildren(iProjectArray[n]);
                        int n2 = 0;
                        while (n2 < objectArray.length) {
                            this.list.add(objectArray[n2]);
                            ++n2;
                        }
                        ++n;
                    }
                    return this.list.toArray();
                }
                return ((IWorkspaceRoot)object).getProjects();
            }
            return this.getChildren(object);
        }

        public Object[] getChildren(Object object) {
            if (object instanceof IContainer) {
                UniqueEList uniqueEList = new UniqueEList();
                IResource[] iResourceArray = null;
                try {
                    iResourceArray = ((IContainer)object).members();
                }
                catch (CoreException coreException) {
                    TestUIPlugin.logError((Throwable)coreException);
                    return new Object[0];
                }
                int n = 0;
                int n2 = iResourceArray.length;
                while (n < n2) {
                    Object[] objectArray;
                    if (iResourceArray[n].getType() != 1) {
                        if (this.filter == 2) {
                            objectArray = this.getChildren(iResourceArray[n]);
                            int n3 = 0;
                            while (n3 < objectArray.length) {
                                uniqueEList.add(objectArray[n3]);
                                ++n3;
                            }
                        } else {
                            uniqueEList.add(iResourceArray[n]);
                        }
                    } else {
                        objectArray = (Object[])iResourceArray[n];
                        if ("deploy".equals(objectArray.getFileExtension())) {
                            EObject[] eObjectArray = EMFUtil.load((ResourceSet)RunLocationPage.this.getResourceSet(), (IFile)((IFile)iResourceArray[n]));
                            int n4 = 0;
                            while (n4 < eObjectArray.length) {
                                EObject eObject = eObjectArray[n4];
                                if (eObject instanceof TPFDeployment) {
                                    uniqueEList.add(eObject);
                                }
                                ++n4;
                            }
                        }
                    }
                    ++n;
                }
                return uniqueEList.toArray();
            }
            if (object instanceof Resource) {
                return ((Resource)object).getContents().toArray();
            }
            if (object instanceof TPFDeployment) {
                UniqueEList uniqueEList = new UniqueEList();
                if (((TPFDeployment)object).getLocations().size() == 0) {
                    uniqueEList.addAll(((TPFDeployment)object).getRefLocations());
                } else {
                    uniqueEList.addAll(((TPFDeployment)object).getLocations());
                }
                return uniqueEList.toArray();
            }
            return new Object[0];
        }
    }
}

