/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.logging.adapter.util.MultipleFilesReader;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl;
import org.eclipse.hyades.logging.parsers.IParser;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public abstract class Parser
implements IParser {
    protected static final String UNKNOWN_HOST = "Unknown Host";
    public static final int defaultArraySize = 50;
    protected int MessageArraySize = 50;
    protected CommonBaseEvent[] messages;
    protected int arrayIndex;
    protected int recordCount = 0;
    protected Locale fileLocale = null;
    protected String charset = null;
    protected String originLocale;
    protected String localHostId;
    protected String localHostIdFormat;
    protected String localHostName;
    protected String file_path;
    protected RandomAccessFile logFile = null;
    protected String curLine = "";
    protected static EventFactory eventFactory = new SimpleEventFactoryHomeImpl().getEventFactory("org.eclipse.hyades.logging.parsers.Parser");
    protected Log logger;
    private Log parserLogger = null;
    protected long totalSize = 0L;
    protected long processedSize = 0L;
    protected long curLineNumber = 0L;
    protected static String EOL_CHARS = System.getProperty("line.separator");
    protected static char EOL_LAST_CHAR = (char)(System.getProperty("os.name", "Windows").equals("z/OS") || System.getProperty("os.name", "Windows").equals("OS/390") ? 21 : (int)EOL_CHARS.charAt(EOL_CHARS.length() - 1));
    protected MultipleFilesReader mfr = null;
    protected File tmpFile = null;
    protected static String prefix = "hgla";

    public void parse(Log argLogger) throws LogParserException {
        try {
            this.logger = argLogger;
            this.preParse();
            CommonBaseEvent[] msgArray = this.parseNext();
            while (msgArray != null) {
                int i = 0;
                while (i < msgArray.length) {
                    if (msgArray[i] != null) {
                        this.logger.trace((Object)msgArray[i]);
                    }
                    ++i;
                }
                msgArray = this.parseNext();
            }
            this.postParse();
        }
        catch (Throwable e) {
            this.postParse();
            LogParserException lpe = new LogParserException(e);
            lpe.fillInStackTrace();
            throw lpe;
        }
    }

    public abstract CommonBaseEvent[] parseNext() throws LogParserException;

    public abstract String getName();

    public abstract String getVersion();

    public CommonBaseEvent[] getMessages() {
        return this.messages;
    }

    public void preParse() throws LogParserException {
        this.getLocalHostId();
        this.originLocale = this.getLocale();
    }

    public void setUserInput(Hashtable table) throws LogParserException {
        this.setConfiguration(table);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setConfiguration(Hashtable table) throws LogParserException {
        this.file_path = null;
        try {
            this.tmpFile = File.createTempFile(prefix, null);
            this.tmpFile.deleteOnExit();
            this.logFile = new RandomAccessFile(this.tmpFile, "rws");
        }
        catch (Exception e) {
            this.logFile = null;
        }
        try {
            this.file_path = (String)table.get("file_path");
            if (this.file_path != null) {
                File file;
                String dirPath = (String)table.get("directory");
                String fName = (String)table.get("fileName");
                if (fName != null || fName.length() > 0 && dirPath != null && dirPath.length() > 0) {
                    dirPath = ParserConstants.FILE_SEPARATOR_CHARACTER == '/' ? dirPath.replace('\\', ParserConstants.FILE_SEPARATOR_CHARACTER) : dirPath.replace('/', ParserConstants.FILE_SEPARATOR_CHARACTER);
                } else {
                    this.file_path = ParserConstants.FILE_SEPARATOR_CHARACTER == '/' ? this.file_path.replace('\\', ParserConstants.FILE_SEPARATOR_CHARACTER) : this.file_path.replace('/', ParserConstants.FILE_SEPARATOR_CHARACTER);
                    fName = this.file_path.substring(this.file_path.lastIndexOf(ParserConstants.FILE_SEPARATOR_CHARACTER) + 1);
                    dirPath = this.file_path.substring(0, this.file_path.indexOf(fName) - 1);
                }
                if (fName == null || dirPath == null) {
                    throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_INVALID_FILE_NAME_ERROR_", this.file_path));
                }
                File dir = new File(dirPath);
                if (!dir.exists() || !dir.isDirectory()) {
                    throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_INVALID_FILE_NAME_ERROR_", this.file_path));
                }
                this.mfr = new MultipleFilesReader(dirPath, fName, this.logFile);
                this.mfr.init();
                if (this.mfr.size() <= 1) {
                    if (this.mfr.size() != 1) throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_INVALID_FILE_NAME_ERROR_", this.file_path));
                    this.file_path = this.mfr.getNext();
                } else {
                    this.file_path = this.tmpFile.getAbsolutePath();
                    this.mfr.loadConsolidatedFile();
                }
                if (this.logFile != null) {
                    try {
                        this.logFile.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.logFile = null;
                }
                if (!(file = new File(this.file_path)).isFile()) {
                    throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_INVALID_FILE_NAME_ERROR_", this.file_path));
                }
                if (!file.canRead()) {
                    throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_CANNOT_READ_FILE_ERROR_", this.file_path));
                }
                this.totalSize = file.length();
                this.logFile = new RandomAccessFile(file, "r");
            }
            this.charset = (String)table.get("characater_set");
            this.fileLocale = (Locale)table.get("locale");
            Integer array_size = (Integer)table.get("array_size");
            if (array_size != null) {
                this.MessageArraySize = array_size;
            }
            this.messages = new CommonBaseEvent[this.MessageArraySize];
            int i = 0;
            while (i < this.MessageArraySize) {
                this.messages[i] = eventFactory.createCommonBaseEvent();
                ++i;
            }
            return;
        }
        catch (Throwable t) {
            ParserUtilities.exceptionHandler(t, ParserUtilities.getResourceString("REMOTE_LOG_PARSER_CONFIG_PARAMETER_ERROR_"));
        }
    }

    protected void increaseMsgArraySize() {
        CommonBaseEvent[] tempArray = new CommonBaseEvent[++this.MessageArraySize];
        System.arraycopy(this.messages, 0, tempArray, 0, this.messages.length);
        this.messages = tempArray;
        this.messages[this.MessageArraySize - 1] = eventFactory.createCommonBaseEvent();
    }

    protected void getLocalHostId() {
        try {
            this.localHostId = InetAddress.getLocalHost().getHostAddress();
            this.localHostIdFormat = this.localHostId.indexOf(58) != -1 ? "IPV6" : "IPV4";
        }
        catch (Exception e) {
            this.localHostId = UNKNOWN_HOST;
            this.localHostIdFormat = "None";
        }
        try {
            this.localHostName = InetAddress.getByName(this.localHostId).getHostName();
        }
        catch (Exception e) {
            this.localHostName = null;
        }
    }

    protected String getLocale() {
        String originLanguage = null;
        String originRegion = null;
        if (this.fileLocale != null) {
            originLanguage = this.fileLocale.getLanguage();
            originRegion = this.fileLocale.getCountry();
        } else {
            originLanguage = System.getProperty("user.language");
            originRegion = System.getProperty("user.region");
        }
        if (originLanguage != null && originRegion != null) {
            return originLanguage.concat("-").concat(originRegion);
        }
        return "";
    }

    protected boolean isNum(String line, int pos) {
        try {
            return Character.isDigit(line.charAt(pos));
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isNum(String line, int pos, int num) {
        int i = 0;
        while (i < num) {
            if (!this.isNum(line, pos + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isLet(String line, int pos) {
        try {
            return Character.isLetter(line.charAt(pos));
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isLet(String line, int pos, int num) {
        int i = 0;
        while (i < num) {
            if (!this.isLet(line, pos + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isChar(String line, int pos, char c) {
        try {
            return line.charAt(pos) == c;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void postParse() throws LogParserException {
        try {
            if (this.logFile != null) {
                this.logFile.close();
            }
            this.tmpFile.delete();
        }
        catch (Exception e) {
            ParserUtilities.exceptionHandler(e, "");
        }
    }

    protected String readALine() throws LogParserException {
        try {
            byte[] buffer = new byte[1024];
            int bufferSize = 0;
            int singleByte = 0;
            block2: while ((singleByte = this.logFile.read()) != -1) {
                if (singleByte == EOL_LAST_CHAR) {
                    if (EOL_CHARS.length() > 1 && bufferSize > 0) {
                        int k = EOL_CHARS.length() - 2;
                        while (k >= 0) {
                            if ((byte)EOL_CHARS.charAt(k) != buffer[bufferSize - 1]) break block2;
                            buffer[--bufferSize] = 0;
                            --k;
                        }
                        break;
                    }
                    if (bufferSize <= 0 || EOL_LAST_CHAR != '\n' || buffer[bufferSize - 1] != 13) break;
                    buffer[--bufferSize] = 0;
                    break;
                }
                if (bufferSize == buffer.length) {
                    byte[] tempBuffer = new byte[buffer.length + 1024];
                    System.arraycopy(buffer, 0, tempBuffer, 0, bufferSize);
                    buffer = tempBuffer;
                }
                buffer[bufferSize++] = (byte)singleByte;
            }
            if (bufferSize > 0 || bufferSize == 0 && singleByte != -1) {
                ++this.curLineNumber;
                this.processedSize += (long)bufferSize;
                return new String(buffer, 0, bufferSize, this.charset);
            }
        }
        catch (IOException i) {
            throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_CANNOT_READ_FILE_ERROR_", this.file_path), i);
        }
        return null;
    }

    protected String readLine() {
        try {
            return this.readALine();
        }
        catch (LogParserException e) {
            return null;
        }
    }

    protected static ExtendedDataElement createStringEDE(String name, String value) {
        ExtendedDataElement extendedDataElement = eventFactory.createExtendedDataElement();
        extendedDataElement.setName(name);
        int valuesLength = 0;
        if (value != null && (valuesLength = value.trim().length()) > 1024) {
            extendedDataElement.setTypeAsInt(16);
            ArrayList<String> valuesParts = new ArrayList<String>();
            int counter = 0;
            while (counter < valuesLength) {
                valuesParts.add(value.substring(counter, Math.min(counter + 1024, valuesLength)));
                counter += 1024;
            }
            extendedDataElement.setValues(valuesParts.toArray(new String[valuesParts.size()]));
        } else {
            extendedDataElement.setTypeAsInt(7);
            extendedDataElement.setValues(new String[]{value});
        }
        return extendedDataElement;
    }

    public Log getParserLogger() {
        return this.parserLogger;
    }

    public void setParserLogger(Log parserLogger) {
        this.parserLogger = parserLogger;
    }

    public void stop() {
    }

    public String getStatus() {
        return null;
    }

    public long getProcessedSize() {
        return this.processedSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }
}

