/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.IDetails;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditor;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.hyades.sdb.internal.util.SymptomDBSearchDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;

public class DBDetails
extends Composite
implements IDetails,
Listener,
FocusListener {
    private Text txtDBName;
    private Text txtURL;
    private Text txtExtLocation;
    private Text txtDescription;
    private boolean isDisplaying = false;
    private SymptomDBEditor editor;
    private SDBRuntime currentSel = null;
    private Widget wLastSelected;

    public DBDetails(RASWidgetFactory factory, Composite composite, int style) {
        super(composite, style);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 1;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        Label lblDBName = factory.createLabel(this, SDbPlugin.getResourceString("STR_SYPMTOMDBNAME_LABEL"), 0);
        this.txtDBName = factory.createText(this, "", 2);
        this.txtDBName.setLayoutData((Object)new GridData(768));
        this.txtDBName.setData((Object)new Integer(0));
        Label lblURL = factory.createLabel(this, SDbPlugin.getResourceString("STR_URL_LABEL"), 0);
        this.txtURL = factory.createText(this, "", 2);
        this.txtURL.setLayoutData((Object)new GridData(768));
        this.txtURL.setData((Object)new Integer(1));
        Label lblExtLocation = factory.createLabel(this, SDbPlugin.getResourceString("STR_EXTERNALLOC_LABEL"), 0);
        this.txtExtLocation = factory.createText(this, "", 2);
        this.txtExtLocation.setLayoutData((Object)new GridData(768));
        this.txtExtLocation.setData((Object)new Integer(2));
        Label lblDescription = factory.createLabel(this, SDbPlugin.getResourceString("STR_DESCRIPTION_LABEL"), 0);
        this.txtDescription = factory.createText(this, "", 770);
        GridData descLayout = new GridData(1808);
        this.txtDescription.setLayoutData((Object)descLayout);
        this.txtDescription.setData((Object)new Integer(3));
        WorkbenchHelp.setHelp((Control)this.txtDBName, (String)ContextIds.SYMDB_EDITOR_DETAILS_NAME);
        WorkbenchHelp.setHelp((Control)this.txtURL, (String)ContextIds.SYMDB_EDITOR_DETAILS_URL);
        WorkbenchHelp.setHelp((Control)this.txtExtLocation, (String)ContextIds.SYMDB_EDITOR_DETAILS_LOCATION);
        WorkbenchHelp.setHelp((Control)this.txtDescription, (String)ContextIds.SYMDB_EDITOR_DETAILS_DESCRIPTION);
        this.txtDBName.addListener(24, (Listener)this);
        this.txtURL.addListener(24, (Listener)this);
        this.txtExtLocation.addListener(24, (Listener)this);
        this.txtDescription.addListener(24, (Listener)this);
        this.txtDBName.addFocusListener((FocusListener)this);
        this.txtURL.addFocusListener((FocusListener)this);
        this.txtExtLocation.addFocusListener((FocusListener)this);
        this.txtDescription.addFocusListener((FocusListener)this);
        this.wLastSelected = null;
    }

    public void display(EObject object) {
        this.currentSel = (SDBRuntime)object;
        this.isDisplaying = true;
        this.txtDBName.setText(this.currentSel.getName() == null ? "" : this.currentSel.getName());
        this.txtURL.setText(this.currentSel.getSymptomUrl() == null ? "" : this.currentSel.getSymptomUrl());
        this.txtExtLocation.setText(this.currentSel.getLocalExternalFileLocation() == null ? "" : this.currentSel.getLocalExternalFileLocation());
        this.txtDescription.setText(this.currentSel.getDescription() == null ? "" : this.currentSel.getDescription());
        this.isDisplaying = false;
        this.wLastSelected = null;
    }

    public void init(SymptomDBEditor editor) {
        this.editor = editor;
    }

    public boolean updateCurrentSelection(EObject currentSelection) {
        this.currentSel = (SDBRuntime)currentSelection;
        this.currentSel.setName(this.txtDBName.getText());
        this.currentSel.setSymptomUrl(this.txtURL.getText());
        this.currentSel.setLocalExternalFileLocation(this.txtExtLocation.getText());
        this.currentSel.setDescription(this.txtDescription.getText());
        return false;
    }

    public void focusGained(FocusEvent e) {
        this.wLastSelected = e.widget;
    }

    public void focusLost(FocusEvent e) {
    }

    public void setFocusToTextBox() {
        this.setFocusToTextBox(0, this.txtDBName.getText().length());
    }

    public void setFocusToTextBox(int startIndex, int endIndex) {
        int nlLength = SymptomDBSearchDialog.getFieldSeparator().length();
        int strLength = 0;
        if (startIndex < strLength + this.txtDBName.getText().length()) {
            this.txtDBName.setSelection(startIndex - strLength, endIndex - strLength);
            this.wLastSelected = this.txtDBName;
            return;
        }
        if (startIndex < (strLength = strLength + this.txtDBName.getText().length() + nlLength) + this.txtURL.getText().length()) {
            this.txtURL.setSelection(startIndex - strLength, endIndex - strLength);
            this.wLastSelected = this.txtURL;
            return;
        }
        if (startIndex < (strLength = strLength + this.txtURL.getText().length() + nlLength) + this.txtExtLocation.getText().length()) {
            this.txtExtLocation.setSelection(startIndex - strLength, endIndex - strLength);
            this.wLastSelected = this.txtExtLocation;
            return;
        }
        strLength = strLength + this.txtExtLocation.getText().length() + nlLength;
        this.txtDescription.setSelection(startIndex - strLength, endIndex - strLength);
        this.wLastSelected = this.txtDescription;
    }

    public int getCursorPosition() {
        int nlLength = SymptomDBSearchDialog.getFieldSeparator().length();
        int strLength = 0;
        if (this.wLastSelected == this.txtDBName) {
            return strLength + SymptomDBSearchDialog.getCursorPosForSelection(this.txtDBName);
        }
        strLength = strLength + this.txtDBName.getText().length() + nlLength;
        if (this.wLastSelected == this.txtURL) {
            return strLength + SymptomDBSearchDialog.getCursorPosForSelection(this.txtURL);
        }
        strLength = strLength + this.txtURL.getText().length() + nlLength;
        if (this.wLastSelected == this.txtExtLocation) {
            return strLength + SymptomDBSearchDialog.getCursorPosForSelection(this.txtExtLocation);
        }
        strLength = strLength + this.txtExtLocation.getText().length() + nlLength;
        if (this.wLastSelected == this.txtDescription) {
            return strLength + SymptomDBSearchDialog.getCursorPosForSelection(this.txtDescription);
        }
        if (this.wLastSelected == null) {
            return -1;
        }
        return 0;
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        boolean status = false;
        if (this.currentSel != null && !this.isDisplaying) {
            switch ((Integer)source.getData()) {
                case 0: {
                    status = this.editor.validateState((Widget)this.txtDBName, this, this.currentSel.getName() == null ? "" : this.currentSel.getName());
                    break;
                }
                case 1: {
                    status = this.editor.validateState((Widget)this.txtURL, this, this.currentSel.getSymptomUrl() == null ? "" : this.currentSel.getSymptomUrl());
                    break;
                }
                case 2: {
                    status = this.editor.validateState((Widget)this.txtExtLocation, this, this.currentSel.getLocalExternalFileLocation() == null ? "" : this.currentSel.getLocalExternalFileLocation());
                    break;
                }
                case 3: {
                    status = this.editor.validateState((Widget)this.txtDescription, this, this.currentSel.getDescription() == null ? "" : this.currentSel.getDescription());
                }
            }
            if (status) {
                this.editor.updateUIDirtyStatus(true);
                this.editor.updateModelDirtyStatus(true);
            }
        }
    }
}

