/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.util;

import java.util.Locale;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.EditorPage;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditorDetailsPage;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.SymptomDBTextSearch;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class SymptomDBSearchDialog
extends Dialog
implements SelectionListener {
    private Text txtPattern;
    private Button chkCase;
    private Button btnFind;
    private Button btnCancel;
    private Button btnUp;
    private Button btnDown;
    private Label lblMessage;
    private SymptomDBTextSearch textSearch = null;
    private SDBRuntime root;
    private SymptomDBEditorDetailsPage page;
    private boolean enabled = true;
    private Text text;

    public SymptomDBSearchDialog(Shell parentShell, SDBRuntime root, SymptomDBEditorDetailsPage page) {
        super(parentShell);
        this.root = root;
        this.page = page;
        this.setShellStyle(2144);
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(SDbPlugin.getResourceString("STR_SEARCHDIALOG_TITLE"));
        Composite c = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        c.setLayout((Layout)layout);
        this.createPatternGroup(c);
        this.createButtonsGroup(c);
        this.createOptionsGroup(c);
        this.createFooter(c);
        this.btnFind.addSelectionListener((SelectionListener)this);
        this.btnCancel.addSelectionListener((SelectionListener)this);
        this.txtPattern.setFocus();
        this.txtPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SymptomDBSearchDialog.this.txtPattern.getText().length() == 0) {
                    SymptomDBSearchDialog.this.btnFind.setEnabled(false);
                } else if (SymptomDBSearchDialog.this.enabled) {
                    SymptomDBSearchDialog.this.btnFind.setEnabled(true);
                }
            }
        });
        return c;
    }

    private void createButtonsGroup(Composite c) {
        Composite buttons = new Composite(c, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData data = GridUtil.createHorizontalFill();
        data.verticalSpan = 2;
        data.verticalAlignment = 1;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)data);
        this.btnFind = new Button(buttons, 8);
        this.btnFind.setText(SDbPlugin.getResourceString("STR_FINDNEXT_LABEL"));
        data = new GridData();
        data.widthHint = Locale.getDefault().toString().equals("en_US") ? 75 : 100;
        this.btnFind.setLayoutData((Object)data);
        this.btnCancel = new Button(buttons, 8);
        this.btnCancel.setText(SDbPlugin.getResourceString("STR_CANCEL_LABEL"));
        data = new GridData();
        data.widthHint = Locale.getDefault().toString().equals("en_US") ? 75 : 100;
        this.btnCancel.setLayoutData((Object)data);
        Shell shell = c.getShell();
        if (shell != null) {
            shell.setDefaultButton(this.btnFind);
        }
        this.btnFind.setEnabled(false);
    }

    private void createPatternGroup(Composite c) {
        Composite pattern = new Composite(c, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        pattern.setLayoutData((Object)GridUtil.createHorizontalFill());
        pattern.setLayout((Layout)layout);
        Label lblPattern = new Label(pattern, 0);
        lblPattern.setText(SDbPlugin.getResourceString("STR_FINDWHAT_LABEL"));
        this.txtPattern = new Text(pattern, 2048);
        GridData data = new GridData(768);
        this.txtPattern.setLayoutData((Object)data);
        this.text = new Text(pattern, 0);
        this.text.setVisible(false);
        WorkbenchHelp.setHelp((Control)this.txtPattern, (String)ContextIds.SYMDB_EDITOR_FIND_WHAT);
    }

    private void createOptionsGroup(Composite c) {
        Composite options = new Composite(c, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        options.setLayout((Layout)layout);
        options.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.chkCase = new Button(options, 32);
        this.chkCase.setText(SDbPlugin.getResourceString("STR_MATCHCASE_LABEL"));
        this.chkCase.setLayoutData((Object)GridUtil.createHorizontalFill());
        WorkbenchHelp.setHelp((Control)this.chkCase, (String)ContextIds.SYMDB_EDITOR_FIND_CASE);
        Group direction = new Group(options, 0);
        layout = new GridLayout();
        layout.numColumns = Locale.getDefault().toString().equals("en_US") ? 2 : 1;
        direction.setText(SDbPlugin.getResourceString("STR_DIRECTION_LABEL"));
        direction.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalAlignment = 3;
        direction.setLayoutData((Object)data);
        this.btnUp = new Button((Composite)direction, 16);
        this.btnUp.setText(SDbPlugin.getResourceString("STR_DIR_UP_LABEL"));
        this.btnDown = new Button((Composite)direction, 16);
        this.btnDown.setText(SDbPlugin.getResourceString("STR_DIR_DOWN_LABEL"));
        this.btnDown.setSelection(true);
    }

    private void createFooter(Composite c) {
        this.lblMessage = new Label(c, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.lblMessage.setLayoutData((Object)data);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.btnCancel) {
            this.close();
        }
        if (e.widget == this.btnFind) {
            this.lblMessage.setText("");
            this.setSelection(this.getTextSearchEngine().search(this.txtPattern.getText(), this.btnDown.getSelection() ? 1 : -1, this.chkCase.getSelection()));
        }
    }

    private Object[] getStartNode() {
        TreeItem[] sel = this.page.getViewer().getTree().getSelection();
        Object[] start = new Object[]{null, null, null, null, null, null};
        if (sel.length > 0) {
            Object object = sel[0].getData();
            start[4] = new Integer(this.page.getCursorPosition(object));
            start[5] = new Integer(-1);
            if (object instanceof SDBRuntime) {
                start[0] = object;
            } else if (object instanceof SDBSymptom) {
                start[0] = this.root;
                start[1] = object;
            } else if (object instanceof SDBSolution) {
                start[0] = this.root;
                TreeItem parent = sel[0].getParentItem();
                if (parent != null) {
                    start[1] = sel[0].getParentItem().getData();
                    start[2] = sel[0].getData();
                }
            } else if (object instanceof SDBDirective) {
                TreeItem grand;
                start[0] = this.root;
                TreeItem parent = sel[0].getParentItem();
                if (parent != null && (grand = parent.getParentItem()) != null) {
                    start[1] = grand.getData();
                    start[2] = parent.getData();
                    start[3] = sel[0].getData();
                }
            }
        }
        return start;
    }

    public String fixText(String s) {
        this.text.setText(s);
        return this.text.getText();
    }

    public static String getFieldSeparator() {
        return Character.toString('\u2029');
    }

    public static int getCursorPosForSelection(Text txt) {
        if (txt.getSelection().x >= 0 && txt.getSelection().y >= 0) {
            if (txt.getSelection().x == txt.getSelection().y) {
                return txt.getSelection().x - 1;
            }
            return Math.min(txt.getSelection().x, txt.getSelection().y);
        }
        return -1;
    }

    public SymptomDBTextSearch getTextSearchEngine() {
        if (this.textSearch == null) {
            this.textSearch = new SymptomDBTextSearch(this);
        }
        this.root = (SDBRuntime)this.page.getTreeRoot();
        Object[] start = this.getStartNode();
        this.textSearch.initialize(this.root, start);
        return this.textSearch;
    }

    public void setTarget(EditorPage newPage) {
        this.page = (SymptomDBEditorDetailsPage)newPage;
    }

    public void enableButton(boolean newVal) {
        this.enabled = newVal;
        if (!newVal || newVal && this.txtPattern.getText().length() > 0) {
            this.btnFind.setEnabled(newVal);
        }
    }

    public Shell getParentShell() {
        return super.getParentShell();
    }

    private void setSelection(Object[] sel) {
        if (sel[0] == null) {
            this.lblMessage.setText(SDbPlugin.getResourceString("STR_STRING_NOT_FOUND"));
            return;
        }
        if (sel[4] instanceof Integer && sel[5] instanceof Integer) {
            this.page.setSelection(sel, (Integer)sel[4], (Integer)sel[5]);
        } else {
            this.page.setSelection(sel);
        }
    }

    public boolean close() {
        this.page.setDialog(null);
        return super.close();
    }
}

