/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ColumnData;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class LogAnalyzerUI
implements SelectionListener {
    private Button _moveUp;
    protected Button _moveDown;
    public Button _selAll;
    public Button _unselAll;
    private Label _description;
    private Label _label;
    public Label _labelMessage;
    private HashMap _map;
    protected ArrayList _pdData = new ArrayList();
    public Table _pdList;
    protected IPreferenceStore _store;
    private ArrayList listeners = new ArrayList(2);

    public LogAnalyzerUI(IPreferenceStore store) {
        this._store = store;
    }

    public Control createControl(Composite parent) {
        Composite result = this.createContainer(parent);
        this._description = new Label(result, 0);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this._description.setLayoutData((Object)data);
        this._map = new HashMap();
        this._pdList = this.createTable(result);
        Composite buttonWidget = new Composite(result, 0);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.horizontalIndent = 20;
        data.verticalAlignment = 4;
        buttonWidget.setLayoutData((Object)data);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 1;
        blayout.marginHeight = 25;
        buttonWidget.setLayout((Layout)blayout);
        this._moveUp = this.createButton(buttonWidget, LogUIPlugin.getResourceString("STR_COL_DLG_UP"));
        this._moveDown = this.createButton(buttonWidget, LogUIPlugin.getResourceString("STR_COL_DLG_DOWN"));
        this._selAll = this.createButton(buttonWidget, LogUIPlugin.getResourceString("STR_COL_DLG_SEL_ALL"));
        this._unselAll = this.createButton(buttonWidget, LogUIPlugin.getResourceString("STR_COL_DLG_USEL_ALL"));
        this._pdList.addSelectionListener((SelectionListener)this);
        this._moveUp.addSelectionListener((SelectionListener)this);
        this._moveDown.addSelectionListener((SelectionListener)this);
        this._selAll.addSelectionListener((SelectionListener)this);
        this._unselAll.addSelectionListener((SelectionListener)this);
        this._moveUp.setEnabled(false);
        this._moveDown.setEnabled(false);
        this._labelMessage = new Label(result, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 1;
        this._labelMessage.setLayoutData((Object)data);
        return result;
    }

    private Composite createContainer(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 15;
        result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        data.heightHint = 350;
        data.widthHint = 350;
        result.setLayoutData((Object)data);
        return result;
    }

    private Table createTable(Composite container) {
        Composite listGrp = new Composite(container, 0);
        listGrp.setLayoutData((Object)GridUtil.createFill());
        listGrp.setLayout((Layout)new GridLayout());
        Table _list = new Table(listGrp, 2336);
        GridData data = GridUtil.createFill();
        _list.setLayoutData((Object)data);
        return _list;
    }

    private Button createButton(Composite parent, String label) {
        Button btn = new Button(parent, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        btn.setLayoutData((Object)data);
        btn.setText(label);
        return btn;
    }

    protected void setDescription(String descr) {
        this._description.setText(descr);
    }

    protected void setLabel(String label) {
        this._label.setText(label);
    }

    protected void moveDown(int idx, Table _list) {
        TableItem item = _list.getItem(idx);
        ColumnData data = (ColumnData)item.getData();
        TableItem newitem = new TableItem(_list, 32, idx + 2);
        newitem.setChecked(item.getChecked());
        newitem.setText(item.getText());
        newitem.setData((Object)data);
        newitem.setGrayed(item.getGrayed());
        _list.remove(idx);
        _list.select(idx + 1);
    }

    protected void moveUp(int idx, Table _list) {
        TableItem item = _list.getItem(idx);
        ColumnData data = (ColumnData)item.getData();
        if (idx > 0) {
            TableItem previousItem = _list.getItem(idx - 1);
            ColumnData previousItemData = (ColumnData)previousItem.getData();
        }
        TableItem newitem = new TableItem(_list, 32, idx - 1);
        newitem.setChecked(item.getChecked());
        newitem.setText(item.getText());
        newitem.setData((Object)data);
        newitem.setGrayed(item.getGrayed());
        _list.remove(idx + 1);
        _list.select(idx - 1);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        int idx;
        this.notifyListeners(e);
        if (e.widget == this._moveUp) {
            idx = this._pdList.getSelectionIndex();
            if (idx > 0) {
                this.moveUp(idx, this._pdList);
            }
        } else if (e.widget == this._moveDown) {
            idx = this._pdList.getSelectionIndex();
            if (idx != -1 && idx < this._pdList.getItemCount() - 1) {
                this.moveDown(idx, this._pdList);
            }
        } else {
            if (e.widget == this._selAll) {
                int idx2 = 0;
                while (idx2 < this._pdList.getItemCount()) {
                    TableItem item = this._pdList.getItem(idx2);
                    item.setChecked(true);
                    ++idx2;
                }
                return;
            }
            if (e.widget == this._unselAll) {
                int idx3 = 0;
                while (idx3 < this._pdList.getItemCount()) {
                    TableItem item = this._pdList.getItem(idx3);
                    item.setChecked(false);
                    ++idx3;
                }
                return;
            }
        }
        idx = this._pdList.getSelectionIndex();
        ColumnData data = null;
        ColumnData previousData = null;
        if (idx > 0) {
            previousData = (ColumnData)this._pdList.getItem(idx - 1).getData();
        }
        if (idx != -1) {
            data = (ColumnData)this._pdList.getItem(idx).getData();
        }
        this._moveUp.setEnabled(data != null && previousData != null);
        this._moveDown.setEnabled(data != null && idx < this._pdList.getItemCount() - 1);
    }

    public void addListener(SelectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners(SelectionEvent e) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((SelectionListener)this.listeners.get(i)).widgetSelected(e);
            ++i;
        }
    }

    protected void createColumnDataFromString(String filter, ArrayList _data) {
        _data.clear();
        ArrayList list = ColumnData.createColumnDataFromString(filter);
        if (list != null) {
            _data.addAll(list);
        }
    }

    protected void loadColumnData(String _filter, ArrayList _data, Table _list, IPreferenceStore store) {
        store.setValue(_filter, this.getPreferenceString(_data, _list));
    }

    protected String getPreferenceString(ArrayList _data, Table _list) {
        _data.clear();
        int idx = 0;
        while (idx < _list.getItemCount()) {
            TableItem item = _list.getItem(idx);
            _data.add(new ColumnData(item.getText(), item.getChecked()));
            ++idx;
        }
        return ColumnData.getPreferenceString(_data);
    }

    protected abstract void populateList();

    public abstract boolean storeValues();

    public abstract void initializeValues(boolean var1);
}

