/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.List;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider;
import org.eclipse.hyades.log.ui.internal.util.CBEAdvFilterUI;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.LogFindCriteria;
import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.help.WorkbenchHelp;

public class SearchRecordDialog
extends Dialog
implements SelectionListener {
    private CBEAdvFilterUI _filters;
    private Button btnFind;
    private Button btnCancel;
    private Button btnUp;
    private Button btnDown;
    private Label lblMessage;
    private Tree tree;
    private String _title;
    private ILogFindProvider logFindProvider = null;

    public SearchRecordDialog(Shell shell, String windowTitle, Image windowImage, ILogFindProvider logFindProvider) {
        super(shell);
        this.setShellStyle(2096);
        this._title = windowTitle;
        Window.setDefaultImage((Image)windowImage);
        this.logFindProvider = logFindProvider;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createContents(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        c.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        c.setLayoutData((Object)data);
        this._filters = new CBEAdvFilterUI(2, LogUIPlugin.getDefault().getPreferenceStore());
        this._filters.createControl(c, LogUIPlugin.getResourceString("STR_FIND_CONTENT_LABEL"));
        Label hLine = new Label(c, 258);
        data = new GridData(768);
        hLine.setLayoutData((Object)data);
        Composite b = new Composite(c, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        b.setLayout((Layout)layout);
        data = GridUtil.createFill();
        b.setLayoutData((Object)data);
        this.createOptionsGroup(b);
        this.createButtonsGroup(b);
        this.createFooter(c);
        this.initializeFiltersAndButtons();
        this.btnFind.addSelectionListener((SelectionListener)this);
        this.btnCancel.addSelectionListener((SelectionListener)this);
        this._filters.getAddBtn().addSelectionListener((SelectionListener)this);
        this._filters.getRemoveBtn().addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)c, (String)ContextIds.ACTLOG_VIEW_DIALOG_SEARCH);
        WorkbenchHelp.setHelp((Control)this.btnUp, (String)ContextIds.ACTLOG_VIEW_DIALOG_SEARCH_UP);
        WorkbenchHelp.setHelp((Control)this.btnDown, (String)ContextIds.ACTLOG_VIEW_DIALOG_SEARCH_DOWN);
        return c;
    }

    private void initializeFiltersAndButtons() {
        if (this.logFindProvider != null) {
            String filters = this.logFindProvider.loadFindPreferenceString();
            this._filters.initializeFilters(filters);
            if (this.logFindProvider.loadFindDirection()) {
                this.btnDown.setSelection(true);
            } else {
                this.btnUp.setSelection(true);
            }
            this.btnFind.setEnabled(this._filters.getFilterList().getFilters().size() > 0);
        }
    }

    private void createOptionsGroup(Composite c) {
        Composite options = new Composite(c, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        options.setLayout((Layout)layout);
        options.setLayoutData((Object)GridUtil.createHorizontalFill());
        Group direction = new Group(options, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        direction.setText(LogUIPlugin.getResourceString("STR_DIRECTION_LABEL"));
        direction.setLayout((Layout)layout);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalAlignment = 1;
        direction.setLayoutData((Object)data);
        this.btnUp = new Button((Composite)direction, 16);
        this.btnUp.setText(LogUIPlugin.getResourceString("STR_DIR_UP_LABEL"));
        this.btnDown = new Button((Composite)direction, 16);
        this.btnDown.setText(LogUIPlugin.getResourceString("STR_DIR_DOWN_LABEL"));
    }

    private void createButtonsGroup(Composite c) {
        Composite buttons = new Composite(c, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalAlignment = 3;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)data);
        this.btnFind = new Button(buttons, 8);
        this.btnFind.setText(LogUIPlugin.getResourceString("STR_FINDNEXT_LABEL"));
        data = GridUtil.createHorizontalFill();
        this.btnFind.setLayoutData((Object)data);
        this.btnCancel = new Button(buttons, 8);
        this.btnCancel.setText(LogUIPlugin.getResourceString("STR_CANCEL_LABEL"));
        data = GridUtil.createHorizontalFill();
        this.btnCancel.setLayoutData((Object)data);
        Shell shell = c.getShell();
        if (shell != null) {
            shell.setDefaultButton(this.btnFind);
        }
    }

    private void createFooter(Composite c) {
        this.lblMessage = new Label(c, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.lblMessage.setLayoutData((Object)data);
    }

    public void updateMessage(String message) {
        if (!this.lblMessage.isDisposed()) {
            this.lblMessage.setText(message);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        int s;
        List filters;
        LogFindCriteria criteria;
        if (e.widget == this.btnCancel) {
            if (this.logFindProvider != null) {
                criteria = new LogFindCriteria();
                filters = this._filters.getFilterList().getFilters();
                s = filters.size();
                criteria.setFilters(filters.toArray(new IFilterElement[s]));
                criteria.setForwardDirection(this.btnDown.getSelection());
                this.logFindProvider.storeFindOptions(criteria);
            }
            this.close();
        }
        if (e.widget == this.btnFind) {
            this.lblMessage.setText("");
            criteria = new LogFindCriteria();
            filters = this._filters.getFilterList().getFilters();
            s = filters.size();
            criteria.setFilters(filters.toArray(new IFilterElement[s]));
            criteria.setForwardDirection(this.btnDown.getSelection());
            if (this.logFindProvider != null) {
                this.logFindProvider.findRecord(criteria);
            }
        }
        if (e.widget == this._filters.getAddBtn() || e.widget == this._filters.getRemoveBtn()) {
            this.btnFind.setEnabled(this._filters.getFilterList().getSize() > 0);
        }
    }
}

