/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileDetailsUI;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileElement;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserItem;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserUI;
import org.eclipse.hyades.log.ui.internal.wizards.LogSetDialog;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.hyades.log.ui.internal.wizards.ParserParameter;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.help.WorkbenchHelp;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImportLogWizardPage
extends WizardPage
implements SelectionListener {
    public static final int NEW_LOGSET = 0;
    public static final int OPEN_LOGSET = 1;
    public static final int EDIT_LOGSET = 2;
    public static final int RENAME_LOGSET = 3;
    private final String LOGSETS_KEY = "logsets";
    private final String LOGSET_TAG = "logset";
    private final String LOGELEMENT_TAG = "LogFileElement";
    private final String DEFAULT_LOGSET = LogUIPlugin.getResourceString("STR_IMPORT_DEFAULT_LOGSET");
    public static final int ADD = 4;
    public static final int EDIT = 5;
    public static final int BUTTON_WIDTH = 90;
    private LogParserUI _parserUI;
    private Table logsTable;
    private TableViewer fTableViewer;
    private List logElements = new ArrayList();
    private Button addBtn;
    private Button removeBtn;
    private Button editBtn;
    private Button newLogSetBtn;
    private Button openLogSetBtn;
    private Button editLogSetBtn;
    private LogFileElement selection;
    private LogFileDetailsUI dialog;
    private LogSetDialog logSetDialog;
    private Label logset_desc;
    private Label type_label;
    private LogSetManager lsMgr;
    private int dialog_type;

    public ImportLogWizardPage() {
        super("ImportLogWizardPage");
        this.setTitle(LogUIPlugin.getResourceString("LOG_PARSER_PAGE_TITLE"));
        this.setDescription(LogUIPlugin.getResourceString("LOG_PARSER_PAGE_DESC"));
        this.setImageDescriptor(LogUIPluginImages.getImageDescriptor("importactivitylog_wiz.gif"));
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayoutData((Object)GridUtil.createFill());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        this.logset_desc = new Label(result, 0);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this.logset_desc.setLayoutData((Object)data);
        this.logset_desc.setFont(JFaceResources.getBannerFont());
        Label logs_desc = new Label(result, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        logs_desc.setLayoutData((Object)data);
        logs_desc.setText(LogUIPlugin.getResourceString("STR_LOG_PDESC"));
        this.createLogTable(result);
        Composite buttonGrp = new Composite(result, 0);
        GridData btnData = GridUtil.createFill();
        GridLayout btnLayout = new GridLayout();
        btnLayout.numColumns = 1;
        btnData.verticalAlignment = 1;
        buttonGrp.setLayout((Layout)btnLayout);
        buttonGrp.setLayoutData((Object)btnData);
        int len = this.computeButtonsMinWidth((Control)result);
        this.createLogButtons(buttonGrp, len);
        this.createLogSetButtons(buttonGrp, len);
        this.type_label = new Label(result, 64);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        data.heightHint = 30;
        this.type_label.setLayoutData((Object)data);
        this.loadDefaultLogSet();
        this.setControl((Control)result);
        this.setPageComplete(false);
        WorkbenchHelp.setHelp((Control)parent, (String)(LogUIPlugin.getPluginId() + ".pp0000"));
        parent.setFocus();
    }

    protected void loadDefaultLogSet() {
        this.lsMgr = new LogSetManager();
        this.lsMgr.initDefault();
        this.lsMgr.loadLogSets();
    }

    private void createLogTable(Composite parent) {
        this.logsTable = new Table(parent, 68354);
        GridData tblData = GridUtil.createFill();
        tblData.heightHint = 75;
        tblData.widthHint = 330;
        this.logsTable.setLayoutData((Object)tblData);
        TableColumn column0 = new TableColumn(this.logsTable, 0);
        TableColumn column1 = new TableColumn(this.logsTable, 0);
        column1.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_HOST"));
        TableColumn column2 = new TableColumn(this.logsTable, 0);
        column2.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_PATH"));
        ColumnWeightData c0Layout = new ColumnWeightData(10, false);
        ColumnWeightData c1Layout = new ColumnWeightData(50, true);
        ColumnWeightData c2Layout = new ColumnWeightData(125, true);
        TableLayout tblLayout = new TableLayout();
        tblLayout.addColumnData((ColumnLayoutData)c0Layout);
        tblLayout.addColumnData((ColumnLayoutData)c1Layout);
        tblLayout.addColumnData((ColumnLayoutData)c2Layout);
        this.logsTable.setLayout((Layout)tblLayout);
        this.logsTable.setHeaderVisible(true);
        this.logsTable.setLinesVisible(true);
        this.fTableViewer = new TableViewer(this.logsTable);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.fTableViewer.setInput((Object)this.logElements);
        this.logsTable.addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this.logsTable, (String)(LogUIPlugin.getPluginId() + ".pp0000"));
    }

    private void createLogButtons(Composite parent, int len) {
        this.addBtn = new Button(parent, 8);
        this.addBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_ADD"));
        GridData btnData = GridUtil.createHorizontalFill();
        btnData.widthHint = len;
        btnData.horizontalAlignment = 2;
        this.addBtn.setLayoutData((Object)btnData);
        this.editBtn = new Button(parent, 8);
        this.editBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_EDIT"));
        btnData = GridUtil.createHorizontalFill();
        btnData.widthHint = len;
        btnData.horizontalAlignment = 2;
        this.editBtn.setLayoutData((Object)btnData);
        this.removeBtn = new Button(parent, 8);
        this.removeBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_REMOVE"));
        btnData = GridUtil.createHorizontalFill();
        btnData.widthHint = len;
        btnData.horizontalAlignment = 2;
        this.removeBtn.setLayoutData((Object)btnData);
        this.addBtn.addSelectionListener((SelectionListener)this);
        this.editBtn.addSelectionListener((SelectionListener)this);
        this.removeBtn.addSelectionListener((SelectionListener)this);
        this.updateButtons();
        WorkbenchHelp.setHelp((Control)this.addBtn, (String)(LogUIPlugin.getPluginId() + ".pp0010"));
        WorkbenchHelp.setHelp((Control)this.editBtn, (String)(LogUIPlugin.getPluginId() + ".pp0020"));
        WorkbenchHelp.setHelp((Control)this.removeBtn, (String)(LogUIPlugin.getPluginId() + ".pp0030"));
    }

    private void createLogSetButtons(Composite parent, int len) {
        Label space = new Label(parent, 0);
        GridData data = GridUtil.createVerticalFill();
        data.heightHint = 120;
        space.setLayoutData((Object)data);
        this.newLogSetBtn = new Button(parent, 8);
        this.newLogSetBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_NEW_SET"));
        GridData btnData = GridUtil.createHorizontalFill();
        btnData.widthHint = len;
        btnData.horizontalAlignment = 2;
        this.newLogSetBtn.setLayoutData((Object)btnData);
        this.openLogSetBtn = new Button(parent, 8);
        this.openLogSetBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_OPEN_SET"));
        btnData = GridUtil.createHorizontalFill();
        btnData.widthHint = len;
        btnData.horizontalAlignment = 2;
        this.openLogSetBtn.setLayoutData((Object)btnData);
        this.editLogSetBtn = new Button(parent, 8);
        this.editLogSetBtn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_EDIT_SET"));
        btnData = GridUtil.createHorizontalFill();
        btnData.widthHint = len;
        btnData.horizontalAlignment = 2;
        this.editLogSetBtn.setLayoutData((Object)btnData);
        this.newLogSetBtn.addSelectionListener((SelectionListener)this);
        this.openLogSetBtn.addSelectionListener((SelectionListener)this);
        this.editLogSetBtn.addSelectionListener((SelectionListener)this);
        this.updateButtons();
        WorkbenchHelp.setHelp((Control)this.newLogSetBtn, (String)(LogUIPlugin.getPluginId() + ".ls0000"));
        WorkbenchHelp.setHelp((Control)this.openLogSetBtn, (String)(LogUIPlugin.getPluginId() + ".ls0010"));
        WorkbenchHelp.setHelp((Control)this.editLogSetBtn, (String)(LogUIPlugin.getPluginId() + ".ls0020"));
    }

    private int computeButtonsMinWidth(Control control) {
        String sAdd = LogUIPlugin.getResourceString("STR_IMPORT_LOG_ADD");
        String sEdit = LogUIPlugin.getResourceString("STR_IMPORT_LOG_EDIT");
        String sRemove = LogUIPlugin.getResourceString("STR_IMPORT_LOG_REMOVE");
        int maxLen1 = Math.max(Math.max(sAdd.length(), sEdit.length()), sRemove.length());
        String sNewLogSet = LogUIPlugin.getResourceString("STR_IMPORT_LOG_NEW_SET");
        String sOpenLogSet = LogUIPlugin.getResourceString("STR_IMPORT_LOG_OPEN_SET");
        String sEditLogSet = LogUIPlugin.getResourceString("STR_IMPORT_LOG_EDIT_SET");
        int maxLen2 = Math.max(Math.max(sNewLogSet.length(), sOpenLogSet.length()), sEditLogSet.length());
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fm = gc.getFontMetrics();
        String locale = Locale.getDefault().toString();
        int chars = locale.equals("ja") || locale.equals("ko") || locale.equals("zh_CN") || locale.equals("zh_TW") ? Math.max(maxLen1, maxLen2) * 2 + 4 : Math.max(maxLen1, maxLen2) + 4;
        gc.dispose();
        return Math.max(Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)chars), 90);
    }

    private void updateButtons() {
        if (this.logElements.size() == 0) {
            this.editBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
            return;
        }
        this.editBtn.setEnabled(this.logsTable.getSelectionCount() > 0);
        this.removeBtn.setEnabled(this.logsTable.getSelectionCount() > 0);
    }

    public void refresh() {
        this.fTableViewer.refresh();
    }

    public boolean finish() {
        this.lsMgr.saveLogSets();
        return true;
    }

    public void dispose() {
        this.lsMgr.getLogSets().clear();
        this.lsMgr.getLogSetsClone().clear();
        super.dispose();
    }

    public void addElement(LogFileElement element) {
        this.logElements.add(element);
        ArrayList<LogFileElement> logList = (ArrayList<LogFileElement>)this.lsMgr.getLogSets().get(this.lsMgr.getDefaultLogSet());
        if (logList == null) {
            logList = new ArrayList<LogFileElement>();
            logList.add(element);
            this.lsMgr.getLogSets().put(this.lsMgr.getDefaultLogSet(), logList);
        } else {
            logList.add(element);
        }
    }

    public void removeElement(LogFileElement element) {
        this.logElements.remove(element);
        List logList = (List)this.lsMgr.getLogSets().get(this.lsMgr.getDefaultLogSet());
        if (logList != null) {
            logList.remove(element);
        }
    }

    public LogFileElement getSelectedElement() {
        return this.selection;
    }

    public void setSelectedElement(LogFileElement selection) {
        this.selection = selection;
    }

    public List getLogFileElements() {
        return this.logElements;
    }

    public boolean isPageComplete() {
        List elem = this.getLogFileElements();
        boolean complete = elem.size() > 0;
        Iterator iter = elem.iterator();
        while (iter.hasNext()) {
            LogFileElement element = (LogFileElement)iter.next();
            element.setValid(this.isLogElementValid(element));
            boolean bl = complete = complete && element.isValid();
        }
        return complete;
    }

    public LogFileDetailsUI getDialog(int type) {
        if (this.dialog == null || type != this.dialog_type) {
            this.dialog_type = type;
            this.dialog = new LogFileDetailsUI(this.getShell(), this, type);
        }
        return this.dialog;
    }

    public LogFileDetailsUI getDialog() {
        return this.dialog;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.addBtn) {
            this.selection = new LogFileElement();
            this.addElement(this.selection);
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.selection));
            this.getDialog(4).setWindowTitle(LogUIPlugin.getResourceString("STR_ADD_LOG_FILE"));
            if (this.getDialog(4).open() == 0) {
                this.refresh();
            } else {
                this.removeElement(this.selection);
            }
            this.dialog = null;
        } else if (e.widget == this.editBtn) {
            this.getDialog(5).setWindowTitle(LogUIPlugin.getResourceString("STR_EDIT_LOG_FILE"));
            if (this.getDialog(5).open() == 0) {
                this.refresh();
            }
            this.dialog = null;
        } else if (e.widget == this.removeBtn) {
            IStructuredSelection sel = (IStructuredSelection)this.fTableViewer.getSelection();
            if (!sel.isEmpty()) {
                Iterator iter = sel.iterator();
                while (iter.hasNext()) {
                    LogFileElement element = (LogFileElement)iter.next();
                    this.removeElement(element);
                }
            }
            this.type_label.setText("");
            this.refresh();
        } else if (e.widget == this.logsTable) {
            int index = this.logsTable.getSelectionIndex();
            this.selection = (LogFileElement)this.logElements.get(index);
            this.type_label.setText(this.selection.getParser().getDescription());
        } else if (e.widget == this.newLogSetBtn) {
            this.onNewLogSetAction();
        } else if (e.widget == this.openLogSetBtn) {
            this.onOpenLogSetAction();
        } else if (e.widget == this.editLogSetBtn) {
            this.onEditLogSetsAction();
        }
        this.setPageComplete(this.isPageComplete());
        this.updateButtons();
    }

    private void onNewLogSetAction() {
        this.logSetDialog = new LogSetDialog(this.getShell(), 0);
        this.logSetDialog.setLogSets(this.lsMgr.getLogSets());
        this.type_label.setText("");
        if (this.logSetDialog.open() == 0) {
            this.lsMgr.setDefaultLogSet(this.logSetDialog.getDefaultLogSet());
            this.lsMgr.getLogSets().put(this.lsMgr.getDefaultLogSet(), null);
            this.updateLogSetDescription(this.lsMgr.getDefaultLogSet());
            this.getLogFileElements().clear();
            this.refresh();
            this.setPageComplete(this.isPageComplete());
        }
    }

    private void onOpenLogSetAction() {
        this.logSetDialog = new LogSetDialog(this.getShell(), 1, this);
        this.logSetDialog.setLogSets(this.lsMgr.getLogSets());
        this.logSetDialog.setDefaultLogSet(this.lsMgr.getDefaultLogSet());
        if (this.logSetDialog.open() == 0 && this.logSetDialog.hasLogSetSelectionChanged()) {
            this.lsMgr.setDefaultLogSet(this.logSetDialog.getDefaultLogSet());
            this.updateLogSetDescription(this.logSetDialog.getDefaultLogSet());
            this.lsMgr.openLogSet(this.logSetDialog.getDefaultLogSet());
            this.setPageComplete(this.isPageComplete());
        }
    }

    private void onEditLogSetsAction() {
        this.logSetDialog = new LogSetDialog(this.getShell(), 2, this);
        this.logSetDialog.setLogSets(this.lsMgr.getLogSetsClone());
        this.logSetDialog.setDefaultLogSet(this.lsMgr.getDefaultLogSet());
        if (this.logSetDialog.open() == 0) {
            this.lsMgr.getLogSets().clear();
            this.lsMgr.getLogSets().putAll(this.logSetDialog.getLogSets());
            this.lsMgr.getLogSetsClone().clear();
            if (this.logSetDialog.getDefaultLogSet() == null) {
                this.lsMgr.setDefaultLogSet(this.DEFAULT_LOGSET);
                this.getLogFileElements().clear();
                this.refresh();
            } else if (this.logSetDialog.hasCurrentLogSetChanged()) {
                this.lsMgr.setDefaultLogSet(this.logSetDialog.getDefaultLogSet());
                this.lsMgr.openLogSet(this.logSetDialog.getDefaultLogSet());
            }
            this.setPageComplete(this.isPageComplete());
            this.updateLogSetDescription(this.lsMgr.getDefaultLogSet());
        }
    }

    public boolean isLogElementValid(LogFileElement elem) {
        return true;
    }

    public void initLocation() {
        this.dialog.initializeLocation();
    }

    public void updateLogSetDescription(String desc) {
        String text = LogUIPlugin.getResourceString("STR_IMPORT_LOG_SET_DESC");
        text = TString.change((String)text, (String)"%1", (String)desc);
        this.logset_desc.setText(text);
    }

    public LogSetManager getLogSetManager() {
        return this.lsMgr;
    }

    public class LogSetManager {
        private IPreferenceStore preferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        private String defaultLogSet;
        private Map logSetsList = new HashMap();
        private Map parsers = new HashMap();
        private Map logSetsClone;

        LogSetManager() {
        }

        public void initDefault() {
            this.defaultLogSet = ImportLogWizardPage.this.DEFAULT_LOGSET;
            this.loadParserRegistry();
        }

        public void loadLogSets() {
            String prefXML = this.preferenceStore.getString("logsets");
            if (prefXML.length() == 0) {
                this.logSetsList.put(ImportLogWizardPage.this.DEFAULT_LOGSET, null);
                ImportLogWizardPage.this.updateLogSetDescription(this.defaultLogSet);
                return;
            }
            Element prefElement = XMLUtil.loadDom((String)prefXML, (String)"logsets");
            if (prefElement == null) {
                this.logSetsList.put(ImportLogWizardPage.this.DEFAULT_LOGSET, null);
                ImportLogWizardPage.this.updateLogSetDescription(this.defaultLogSet);
                return;
            }
            NodeList logSetsNodeList = XMLUtil.getChildrenByName((Element)prefElement, (String)"logset");
            int i = 0;
            int maxi = logSetsNodeList.getLength();
            while (i < maxi) {
                if (logSetsNodeList.item(i) instanceof Element) {
                    this.loadLogSet((Element)logSetsNodeList.item(i));
                }
                ++i;
            }
            List logList = (List)this.logSetsList.get(this.defaultLogSet);
            if (logList != null) {
                ImportLogWizardPage.this.logElements.addAll(logList);
            }
            ImportLogWizardPage.this.updateLogSetDescription(this.defaultLogSet);
            ImportLogWizardPage.this.refresh();
        }

        private void loadLogSet(Element logSetElement) {
            if (XMLUtil.getValue((Element)logSetElement, (String)LogUIPlugin.getResourceString("STR_IMPORT_DEFAULT_LOGSET")).equals("1")) {
                this.defaultLogSet = XMLUtil.getValue((Element)logSetElement, (String)"name");
            }
            ArrayList<LogFileElement> logElements = new ArrayList<LogFileElement>();
            NodeList logNodeList = XMLUtil.getChildrenByName((Element)logSetElement, (String)"LogFileElement");
            Element element = null;
            int i = 0;
            int maxi = logNodeList.getLength();
            while (i < maxi) {
                if (logNodeList.item(i) instanceof Element) {
                    element = (Element)logNodeList.item(i);
                }
                logElements.add(this.loadElement(element));
                ++i;
            }
            this.logSetsList.put(XMLUtil.getValue((Element)logSetElement, (String)"name"), logElements);
        }

        private LogFileElement loadElement(Element prefElement) {
            LogFileElement logElement = new LogFileElement();
            logElement.setHost(XMLUtil.getValue((Element)prefElement, (String)"host"));
            String port = XMLUtil.getValue((Element)prefElement, (String)"port");
            logElement.setPort(port == null ? 10002 : Integer.parseInt(port));
            logElement.setMonitor(XMLUtil.getValue((Element)prefElement, (String)"monitor"));
            logElement.setProject(XMLUtil.getValue((Element)prefElement, (String)"project"));
            logElement.setValid(XMLUtil.getValue((Element)prefElement, (String)"isValid").equals("true"));
            String uri = XMLUtil.getValue((Element)prefElement, (String)"mergedAgent");
            logElement.setParser((LogParserItem)this.parsers.get(XMLUtil.getValue((Element)prefElement, (String)"parserId")));
            logElement.setUseLargeLogSupport("true".equals(XMLUtil.getValue((Element)prefElement, (String)"useLargeLogSupport")));
            NodeList filterNodes = XMLUtil.getChildrenByName((Element)prefElement, (String)"filter");
            if (filterNodes != null && filterNodes.getLength() > 0) {
                FilterInformationManager filterManager = FilterInformationManager.instance((String)"ImportLogScope");
                Element element = null;
                if (filterNodes.item(0) instanceof Element) {
                    element = (Element)filterNodes.item(0);
                    LogFileElement.Filter filter = new LogFileElement.Filter(logElement);
                    String filterName = element.getAttribute("name");
                    String filterType = element.getAttribute("type");
                    filter.setName(filterName);
                    filter.setType(filterType);
                    FilterQueries fq = filterManager.filter(filterName);
                    if (fq != null && fq.type().equals(filterType)) {
                        filter.setQuery(filterManager.createCombinedFilter(fq));
                    }
                    logElement.setFilter(filter);
                }
            }
            if (uri != null && uri.trim().length() > 0) {
                TRCAgentProxy agent = null;
                try {
                    agent = (TRCAgentProxy)UIPlugin.getDefault().getResourceSet().getEObject(URI.createURI((String)uri), true);
                }
                catch (Exception e) {
                    // empty catch block
                }
                logElement.setMergedAgent(agent);
            }
            XMLUtil.getChildrenByName((Element)prefElement, (String)"value");
            NodeList nodeList = XMLUtil.getChildrenByName((Element)prefElement, (String)"value");
            int i = 0;
            int maxi = nodeList.getLength();
            while (i < maxi) {
                if (nodeList.item(i) instanceof Element) {
                    logElement.getValues().add(XMLUtil.getValue((Element)((Element)nodeList.item(i)), (String)"val"));
                }
                ++i;
            }
            return logElement;
        }

        public void openLogSet(String name) {
            List logsList = (List)this.logSetsList.get(name);
            ImportLogWizardPage.this.logElements.clear();
            if (logsList != null) {
                ImportLogWizardPage.this.logElements.addAll(logsList);
            }
            ImportLogWizardPage.this.refresh();
        }

        public Map getLogSets() {
            return this.logSetsList;
        }

        public Map getLogSetsClone() {
            if (this.logSetsClone == null) {
                this.logSetsClone = new HashMap();
            }
            this.logSetsClone.clear();
            this.logSetsClone.putAll(this.logSetsList);
            return this.logSetsClone;
        }

        private void loadParserRegistry() {
            boolean max = true;
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hyades.logging.parsers", "logParser");
            int idx = 0;
            while (idx < config.length) {
                block6: {
                    IConfigurationElement elem = config[idx];
                    LogParserItem parser = new LogParserItem(elem.getAttribute("id"), elem.getAttribute("name"), elem.getAttribute("ui_name"), elem.getAttribute("description"));
                    parser.setConfigurationElement(elem);
                    parser.setClass(elem.getAttribute("class"));
                    parser.setUIType(elem.getAttribute("ui_type"));
                    String iconPath = elem.getAttribute("icon");
                    if (iconPath != null && iconPath.length() > 0) {
                        try {
                            URL url = new URL(Platform.getBundle((String)elem.getDeclaringExtension().getNamespace()).getEntry("/"), iconPath);
                            ImageDescriptor image = ImageDescriptor.createFromURL((URL)url);
                            parser.setImageDescriptor(image);
                        }
                        catch (Exception exc) {
                            Status status = new Status(4, LogUIPlugin.getPluginId(), 2, "exception.malformedURL", (Throwable)exc);
                            LogUIPlugin.getDefault().getLog().log((IStatus)status);
                            break block6;
                        }
                    }
                    IConfigurationElement[] felems = elem.getChildren("field");
                    int i = 0;
                    while (i < felems.length) {
                        IConfigurationElement felem = felems[i];
                        ParserField pfield = new ParserField(felem.getAttribute("id"), felem.getAttribute("name"));
                        pfield.setConfigurationElement(felem);
                        pfield.setDefaultValue(felem.getAttribute("defaultValue"));
                        pfield.setContextId(felem.getAttribute("helpContextId"));
                        pfield.setTooltip(felem.getAttribute("tooltip"));
                        pfield.setFilters(felem.getAttribute("browseType"));
                        pfield.useBrowse(felem.getAttribute("useBrowse").equals("true"));
                        pfield.setUiType(felem.getAttribute("ui_type"));
                        pfield.setListener(felem.getAttribute("listener"));
                        parser.addEntry(pfield);
                        ++i;
                    }
                    IConfigurationElement[] fparameters = elem.getChildren("parserParameter");
                    int i2 = 0;
                    while (i2 < fparameters.length) {
                        IConfigurationElement fparameter = fparameters[i2];
                        ParserParameter para = new ParserParameter(fparameter.getAttribute("name"), fparameter.getAttribute("value"));
                        parser.addParameter(para);
                        ++i2;
                    }
                    this.parsers.put(parser.getId(), parser);
                }
                ++idx;
            }
        }

        public LogParserItem getLogParser(String key) {
            return (LogParserItem)this.parsers.get(key);
        }

        public Map getParserRegistry() {
            return this.parsers;
        }

        public void saveLogSets() {
            StringBuffer xmlString = new StringBuffer();
            xmlString.append("<?xml");
            xmlString.append(XMLUtil.createXMLAttribute((String)"version", (String)"1.0", (boolean)false)).append(XMLUtil.createXMLAttribute((String)"encoding", (String)"UTF-8", (boolean)false));
            xmlString.append("?>");
            xmlString.append(" <");
            xmlString.append("logsets");
            xmlString.append("> ");
            Set keySet = this.logSetsList.keySet();
            String key = "";
            Iterator iter = keySet.iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                xmlString.append(this.generateLogSetPrefEntry(key));
            }
            xmlString.append(" </");
            xmlString.append("logsets");
            xmlString.append(">");
            this.preferenceStore.setValue("logsets", xmlString.toString());
        }

        private String generateLogSetPrefEntry(String name) {
            StringBuffer xmlString = new StringBuffer();
            xmlString.append(" <");
            xmlString.append("logset");
            xmlString.append(XMLUtil.createXMLAttribute((String)"name", (String)name, (boolean)false));
            xmlString.append(XMLUtil.createXMLAttribute((String)LogUIPlugin.getResourceString("STR_IMPORT_DEFAULT_LOGSET"), (String)(name.equals(this.defaultLogSet) ? "1" : "0"), (boolean)false));
            xmlString.append("> ");
            List logSet = (List)this.logSetsList.get(name);
            if (logSet != null) {
                LogFileElement element = null;
                Iterator iter = logSet.iterator();
                while (iter.hasNext()) {
                    element = (LogFileElement)iter.next();
                    xmlString.append(this.generateLogElementPrefEntry(element));
                }
            }
            xmlString.append(" </");
            xmlString.append("logset");
            xmlString.append("> ");
            return xmlString.toString();
        }

        private String generateLogElementPrefEntry(LogFileElement element) {
            StringBuffer xml = new StringBuffer();
            xml.append("<LogFileElement ");
            xml.append(XMLUtil.createXMLAttribute((String)"host", (String)element.getHost(), (boolean)false));
            xml.append(XMLUtil.createXMLAttribute((String)"port", (String)String.valueOf(element.getPort()), (boolean)false));
            xml.append(XMLUtil.createXMLAttribute((String)"monitor", (String)element.getMonitor(), (boolean)false));
            xml.append(XMLUtil.createXMLAttribute((String)"project", (String)element.getProject(), (boolean)false));
            xml.append(XMLUtil.createXMLAttribute((String)"isValid", (String)(element.isValid() ? "true" : "false"), (boolean)false));
            xml.append(XMLUtil.createXMLAttribute((String)"useLargeLogSupport", (String)(element.isUseLargeLogSupport() ? "true" : "false"), (boolean)false));
            xml.append(XMLUtil.createXMLAttribute((String)"parserId", (String)element.getParser().getId(), (boolean)false));
            xml.append(XMLUtil.createXMLAttribute((String)"mergedAgent", (String)(element.getMergedAgent() != null ? EcoreUtil.getURI((EObject)element.getMergedAgent()).toString() : ""), (boolean)false));
            xml.append(">");
            int i = 0;
            while (i < element.getValues().size()) {
                xml.append(" <value ");
                xml.append(XMLUtil.createXMLAttribute((String)"val", (String)((String)element.getValues().get(i)), (boolean)false));
                xml.append("/> ");
                ++i;
            }
            if (element.getFilter() != null) {
                xml.append(" <filter ");
                xml.append(XMLUtil.createXMLAttribute((String)"name", (String)element.getFilter().getName(), (boolean)false));
                xml.append(XMLUtil.createXMLAttribute((String)"type", (String)element.getFilter().getType(), (boolean)false));
                xml.append(" /> ");
            }
            xml.append("</LogFileElement>");
            return xml.toString();
        }

        public void setDefaultLogSet(String newValue) {
            this.defaultLogSet = newValue;
        }

        public String getDefaultLogSet() {
            if (this.defaultLogSet == null) {
                this.initDefault();
            }
            return this.defaultLogSet;
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Hashtable images = new Hashtable();

        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImageHelper(((LogFileElement)element).getParser());
            }
            return null;
        }

        private Image getImageHelper(LogParserItem parser) {
            Image img = (Image)this.images.get(parser.getDescription());
            if (img == null) {
                if (parser.getImageDescriptor() == null) {
                    return null;
                }
                img = parser.getImageDescriptor().createImage();
                this.images.put(parser.getDescription(), img);
            }
            return img;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 1) {
                return ((LogFileElement)element).getHost();
            }
            if (columnIndex == 2) {
                ArrayList fields = ((LogFileElement)element).getParser().getFields();
                int s = fields.size();
                ParserField field = null;
                int j = 0;
                while (j < s) {
                    field = (ParserField)fields.get(j);
                    if (field != null && field.getId().equals("file_path")) break;
                    ++j;
                }
                if (j >= 0 && j < ((LogFileElement)element).getValues().size()) {
                    return (String)((LogFileElement)element).getValues().get(j);
                }
            }
            return "";
        }

        public void dispose() {
            Enumeration enumeration = this.images.elements();
            while (enumeration.hasMoreElements()) {
                Image image = (Image)enumeration.nextElement();
                if (image.isDisposed()) continue;
                image.dispose();
            }
            this.images.clear();
            super.dispose();
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ImportLogWizardPage.this.logElements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

