/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;

public class LocalGLALogger
implements Log {
    private List events = new ArrayList();
    private XMLLoader xmlLoader = null;
    private final String NL = System.getProperties().getProperty("line.separator");
    private String detailMessage = null;
    private boolean first = true;
    public static final int TRACE_LEVEL = 0;
    public static final int DEBUG_LEVEL = 1;
    public static final int INFO_LEVEL = 2;
    public static final int WARN_LEVEL = 3;
    public static final int ERROR_LEVEL = 4;
    public static final int FATAL_LEVEL = 5;
    private int loggingLevel = 0;

    private void logXMLToModel(String xml) {
        byte[] xmlLogEntryBytes = null;
        try {
            xmlLogEntryBytes = xml.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException u) {
            xmlLogEntryBytes = xml.getBytes();
        }
        this.xmlLoader.loadEvent(xmlLogEntryBytes, xmlLogEntryBytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogDetails() {
        StringBuffer buffer = new StringBuffer();
        List list = this.events;
        synchronized (list) {
            int s = this.events.size();
            Object object = null;
            if (s > 0) {
                int i = 0;
                while (i < s) {
                    object = this.events.get(i);
                    if (object instanceof CommonBaseEvent && object != null) {
                        buffer.append(((CommonBaseEvent)object).getMsg());
                        buffer.append(this.NL);
                    }
                    ++i;
                }
                object = this.events.get(s - 1);
                if (object instanceof CommonBaseEvent && object != null) {
                    buffer.append(((CommonBaseEvent)object).getMsg());
                }
            }
        }
        this.detailMessage = buffer.toString();
        return this.detailMessage;
    }

    public void setXMLLoader(XMLLoader xmlLoader) {
        this.xmlLoader = xmlLoader;
    }

    public boolean isDebugEnabled() {
        return this.loggingLevel <= 1;
    }

    public boolean isErrorEnabled() {
        return this.loggingLevel <= 4;
    }

    public boolean isFatalEnabled() {
        return this.loggingLevel <= 5;
    }

    public boolean isInfoEnabled() {
        return this.loggingLevel <= 2;
    }

    public boolean isTraceEnabled() {
        return this.loggingLevel <= 0;
    }

    public boolean isWarnEnabled() {
        return this.loggingLevel <= 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(Object record) {
        if (this.isTraceEnabled()) {
            List list = this.events;
            synchronized (list) {
                if (!this.events.contains(record)) {
                    this.events.add(record);
                }
            }
        }
    }

    public void trace(Object record, Throwable arg1) {
        if (this.isTraceEnabled()) {
            this.events.add(record);
        }
    }

    public void debug(Object record) {
        if (this.isDebugEnabled()) {
            this.events.add(record);
        }
    }

    public void debug(Object record, Throwable arg1) {
        if (this.isDebugEnabled()) {
            // empty if block
        }
    }

    public void info(Object record) {
        if (this.isInfoEnabled()) {
            // empty if block
        }
    }

    public void info(Object record, Throwable arg1) {
        if (this.isInfoEnabled()) {
            // empty if block
        }
    }

    public void warn(Object record) {
        if (this.isWarnEnabled()) {
            // empty if block
        }
    }

    public void warn(Object record, Throwable arg1) {
        if (this.isWarnEnabled()) {
            // empty if block
        }
    }

    public void error(Object record) {
        if (this.isErrorEnabled()) {
            // empty if block
        }
    }

    public void error(Object record, Throwable arg1) {
        if (this.isErrorEnabled()) {
            // empty if block
        }
    }

    public void fatal(Object record) {
        if (this.isFatalEnabled()) {
            // empty if block
        }
    }

    public void fatal(Object record, Throwable arg1) {
        if (this.isFatalEnabled()) {
            // empty if block
        }
    }
}

