/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import java.util.Iterator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.trace.CallStackPerThread;
import org.eclipse.hyades.loaders.trace.TraceMethodBaseLoader;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TracePackage;

public class XMLmethodExitLoader
extends TraceMethodBaseLoader {
    protected static final String OVERHEAD = "overhead";
    protected static final String CPU_TIME = "cpuTime";
    protected static final String CONSUMED_CPU_TIME = "consumedCpuTime";
    protected double overhead;
    protected double cpuTime;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$trace$CallStackPerThread;

    public void addAttribute(String name, String value) {
        if (!this.loadToModel) {
            return;
        }
        switch (LoadersUtils.getHashCode((String)name)) {
            case 529694900: {
                this.overhead = Double.parseDouble(value);
                break;
            }
            case 985674901: 
            case 1624740749: {
                this.cpuTime = Double.parseDouble(value);
                break;
            }
            default: {
                super.addAttribute(name, value);
            }
        }
    }

    public void addYourselfInContext() {
        if (!this.loadToModel) {
            return;
        }
        if (this.context.isFilterOn() && this.context.getFilterEngine().isFiltered((EStructuralFeature)TracePackage.eINSTANCE.getTRCMethod_Name(), LoadersUtils.getLookUpKey((int)this.methodIdRef))) {
            return;
        }
        this.cs = (CallStackPerThread)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$loaders$trace$CallStackPerThread == null ? (class$org$eclipse$hyades$loaders$trace$CallStackPerThread = XMLmethodExitLoader.class$("org.eclipse.hyades.loaders.trace.CallStackPerThread")) : class$org$eclipse$hyades$loaders$trace$CallStackPerThread, LoadersUtils.getLookUpKey((int)this.threadIdRef));
        if (this.cs == null || this.cs.isEmpty()) {
            return;
        }
        this.invocationPool = this.cs.invocationPool;
        this.theProcess = this.getProcess();
        this.dispatchProcessMode(0);
    }

    public void initialize(HierarchyContext context, String name) {
        this.loadToModel = context.isLoadToModel();
        if (!this.loadToModel) {
            return;
        }
        super.initialize(context, name);
        this.overhead = 0.0;
        this.cpuTime = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEF(int step) {
        super.processEF(step);
        this.fullInvocation = ((TraceUtils.InvocationInfo)this.cs.peek()).getMethodInvocation();
        if (this.fullInvocation != null) {
            this.theThread = this.fullInvocation.getThread();
            this.fullInvocation.setExitTime(this.createDeltaTime());
            this.fullInvocation.setOverhead(this.overhead);
            this.addInputOutputValues();
            Object object = TraceMethodBaseLoader.REMOTE_INVOCATION_RESOLUTION_LOCK;
            synchronized (object) {
                this.updateForwardInvokes(this.fullInvocation);
            }
            if (this.context.getCustomData().containsKey("USE_updateStatisticalInfoOld")) {
                this.updateStatisticalInfo();
            } else {
                this.updateStatisticalInfoNew();
            }
            this.invocationPool.release((TraceUtils.InvocationInfo)this.cs.pop());
        }
    }

    protected void processES(int step) {
        super.processES(step);
        this.updateStatisticalInfoOnly();
    }

    protected void updateStatisticalInfoNew() {
        try {
            double deltaBaseTime1 = 0.0;
            Iterator iter = this.fullInvocation.getInvokes().iterator();
            while (iter.hasNext()) {
                TRCFullMethodInvocation element = (TRCFullMethodInvocation)iter.next();
                if (!(element.getExitTime() > 0.0)) continue;
                deltaBaseTime1 = deltaBaseTime1 + element.getExitTime() - element.getEntryTime() - element.getOverhead();
            }
            this.deltaCumulativeTime = this.fullInvocation.getExitTime() - this.fullInvocation.getEntryTime() - this.fullInvocation.getOverhead();
            this.deltaBaseTime = this.deltaCumulativeTime - deltaBaseTime1;
            this.invokerMethod = this.fullInvocation.getMethod();
            this.invokerObject = (TRCFullTraceObject)this.fullInvocation.getOwningObject();
            this.invokerClass = this.fullInvocation.getMethod().getDefiningClass();
            this.invokerObjectClass = this.getExtendedClass(this.invokerObject, this.invokerClass);
            this.updateCPUTime();
            this.updateTimeStatisticsNew();
            if (this.fullInvocation.getInvokedBy() != null && this.fullInvocation.eContainer() != this.fullInvocation.getInvokedBy().eContainer()) {
                this.updateBaseTimeIfRequired(this.fullInvocation, this.fullInvocation.getInvokedBy());
            }
        }
        catch (Exception e) {
            LoadersUtils.log((Throwable)e);
        }
    }

    protected void updateStatisticalInfo() {
        try {
            int size = this.fullInvocation.getInvokes().size();
            if (size > 0) {
                this.lastChildExitTime = ((TRCFullMethodInvocation)this.fullInvocation.getInvokes().get(size - 1)).getExitTime();
                this.deltaBaseTime = this.fullInvocation.getExitTime() - this.lastChildExitTime - this.fullInvocation.getOverhead();
            } else {
                this.deltaBaseTime = this.fullInvocation.getExitTime() - this.fullInvocation.getEntryTime() - this.fullInvocation.getOverhead();
            }
            this.invokerMethod = this.fullInvocation.getMethod();
            this.invokerObject = (TRCFullTraceObject)this.fullInvocation.getOwningObject();
            this.invokerClass = this.fullInvocation.getMethod().getDefiningClass();
            this.invokerObjectClass = this.getExtendedClass(this.invokerObject, this.invokerClass);
            this.updateCPUTime();
            this.updateTimeStatistics();
        }
        catch (Exception e) {
            LoadersUtils.log((Throwable)e);
        }
    }

    protected void updateCPUTime() {
        block3: {
            if (this.cpuTime == 0.0) break block3;
            try {
                double correctedCPUTime = this.cpuTime;
                if (this.fullInvocation != null) {
                    this.fullInvocation.setCpuTime(correctedCPUTime);
                }
                this.invokerMethod.setTotalCpuTime(this.invokerMethod.getTotalCpuTime() + correctedCPUTime);
                this.invokerClass.setTotalCpuTime(this.invokerClass.getTotalCpuTime() + correctedCPUTime);
                this.invokerClass.getPackage().setTotalCpuTime(this.invokerClass.getPackage().getTotalCpuTime() + correctedCPUTime);
                this.getProcess().setTotalCpuTime(this.getProcess().getTotalCpuTime() + correctedCPUTime);
            }
            catch (Exception e) {
                LoadersUtils.log((Throwable)e);
            }
        }
    }

    protected void updateStatisticalInfoOnly() {
        try {
            TraceUtils.InvocationInfo invoker;
            TraceUtils.InvocationInfo currentInvocation = (TraceUtils.InvocationInfo)this.cs.peek();
            double exitTime = this.createDeltaTime();
            this.lastChildExitTime = currentInvocation.getLastChildExitTime();
            this.deltaBaseTime = this.lastChildExitTime > 0.0 ? exitTime - this.lastChildExitTime - this.overhead : exitTime - currentInvocation.getEntryTime() - this.overhead;
            this.invokerObject = currentInvocation.getObject();
            this.invokerClass = currentInvocation.getTheClass();
            this.invokerObjectClass = currentInvocation.getObjectClass();
            this.invokerMethod = currentInvocation.getMethod();
            this.updateCPUTime();
            this.updateTimeStatistics();
            this.invocationPool.release((TraceUtils.InvocationInfo)this.cs.pop());
            if (!this.cs.isEmpty() && (invoker = (TraceUtils.InvocationInfo)this.cs.peek()) != null) {
                invoker.setLastChildExitTime(exitTime);
            }
            this.theProcess.setLastEventTime(exitTime);
        }
        catch (Exception e) {
            LoadersUtils.log((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

