/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.actions.internal;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;
import org.eclipse.hyades.trace.ui.filters.IFilterAttribute;
import org.eclipse.hyades.trace.ui.filters.internal.dialogs.FiltersAdvancedUI;
import org.eclipse.hyades.trace.ui.internal.filters.BasicFeatureFilterAttribute;
import org.eclipse.hyades.trace.ui.internal.filters.FilterTraceViewer;
import org.eclipse.hyades.trace.views.adapter.internal.MemoryStatisticViewer;
import org.eclipse.hyades.trace.views.adapter.internal.ProfilingAdvancedTabAttributeSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class FilterOutAction
implements IObjectActionDelegate {
    private EObject[] filterOutObjs;
    private FilterTraceViewer viewer;
    private static String FILTER_OUT_OPERATOR = BasicFeatureFilterAttribute.getOperatorString((RelationalOperators)RelationalOperators.get((int)5));

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.viewer = targetPart instanceof FilterTraceViewer ? (FilterTraceViewer)targetPart : null;
    }

    public void run(IAction action) {
        if (this.viewer == null) {
            return;
        }
        ProfilingAdvancedTabAttributeSet advancedSet = new ProfilingAdvancedTabAttributeSet();
        SimpleSearchQuery query = this.viewer.advancedQuery();
        int openIndex = -1;
        if (query.getWhereExpression() == null || !(query.getWhereExpression() instanceof LogicalExpression)) {
            return;
        }
        LogicalExpression logicalExpression = (LogicalExpression)query.getWhereExpression();
        EList arguments = logicalExpression.getArguments();
        openIndex += arguments.size();
        int i = 0;
        while (i < this.filterOutObjs.length) {
            IFilterAttribute filterAttribute;
            EAttribute attribute = null;
            String value = null;
            if (this.filterOutObjs[i] instanceof TRCPackage) {
                attribute = TracePackageImpl.init().getTRCPackage_Name();
                value = ((TRCPackage)this.filterOutObjs[i]).getName();
            } else if (this.filterOutObjs[i] instanceof TRCClass) {
                attribute = TracePackageImpl.init().getTRCClass_Name();
                value = ((TRCClass)this.filterOutObjs[i]).getName();
            } else if (this.filterOutObjs[i] instanceof TRCMethod && !(this.viewer instanceof MemoryStatisticViewer)) {
                attribute = TracePackageImpl.init().getTRCMethod_Name();
                value = ((TRCMethod)this.filterOutObjs[i]).getName();
            }
            if (attribute != null && value != null && (filterAttribute = advancedSet.getFilterAttribute((EStructuralFeature)attribute)) != null) {
                WhereExpression whereExpression = filterAttribute.getWhereExpression(FILTER_OUT_OPERATOR, value);
                whereExpression.setName(FiltersAdvancedUI.getWhereExpressionName((LogicalExpression)logicalExpression, (IFilterAttribute)filterAttribute));
                arguments.add((Object)whereExpression);
            }
            ++openIndex;
            ++i;
        }
        this.viewer.updateAdvancedQuery(query, openIndex);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection != null && selection instanceof IStructuredSelection) {
            Vector filterOutObjsV = new Vector();
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof TRCPackage) && !(obj instanceof TRCClass) && !(obj instanceof TRCMethod)) continue;
                filterOutObjsV.addElement(obj);
            }
            this.filterOutObjs = new EObject[filterOutObjsV.size()];
            int i = 0;
            while (i < this.filterOutObjs.length) {
                this.filterOutObjs[i] = (EObject)filterOutObjsV.elementAt(i);
                ++i;
            }
        } else {
            this.filterOutObjs = new EObject[0];
        }
    }
}

