/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.trace.ui.internal.filters.ModelUtils;
import org.eclipse.hyades.trace.views.adapter.internal.FilterEventsUI;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FiltersStandardTabTraceViewsUI
extends FiltersStandardTabUI {
    public static EAttribute ATTRIBUTE_PACKAGE_NAME = TracePackageImpl.init().getTRCPackage_Name();
    public static EAttribute ATTRIBUTE_CLASS_NAME = TracePackageImpl.init().getTRCClass_Name();
    public static EAttribute ATTRIBUTE_METHOD_NAME = TracePackageImpl.init().getTRCMethod_Name();
    public static RelationalOperators OPERATOR_LIKE = RelationalOperators.get((int)6);
    private boolean _showMethodLevel;
    private Text _filterText;
    private Button _packageLevel;
    private Button _classLevel;
    private Button _methodLevel;
    private Button _caseControl;
    private FilterEventsUI _eventsUI;

    public FiltersStandardTabTraceViewsUI(boolean showMethodLevel) {
        this._showMethodLevel = showMethodLevel;
    }

    public Control createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout());
        Composite filterContainer = new Composite(content, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        filterContainer.setLayout((Layout)layout);
        GridData data = GridUtil.createHorizontalFill();
        filterContainer.setLayoutData((Object)data);
        Label filter = new Label(filterContainer, 0);
        filter.setText(TraceUIPlugin.getString("STR_ST_FILTER"));
        Composite filterTextContainer = new Composite(filterContainer, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        filterTextContainer.setLayout((Layout)layout);
        data = GridUtil.createHorizontalFill();
        filterTextContainer.setLayoutData((Object)data);
        this._filterText = new Text(filterTextContainer, 2048);
        this._filterText.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent key) {
            }
        });
        this._caseControl = new Button(filterTextContainer, 32);
        this._caseControl.setLayoutData((Object)new GridData());
        this._caseControl.setText(TraceUIPlugin.getString("STR_ST_CASE_SENSITIVE"));
        Composite levelContainer = new Composite(filterContainer, 0);
        layout = new GridLayout();
        levelContainer.setLayout((Layout)layout);
        levelContainer.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label filterByLabel = new Label(levelContainer, 0);
        filterByLabel.setText(TraceUIPlugin.getString("STR_ST_FILTER_BY"));
        Composite buttonLevelContainer = new Composite(levelContainer, 0);
        layout = new GridLayout();
        buttonLevelContainer.setLayout((Layout)layout);
        buttonLevelContainer.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._packageLevel = new Button(buttonLevelContainer, 16);
        this._packageLevel.setText(TraceUIPlugin.getString("STR_ST_FILTER_PACKAGE_LEVEL"));
        this._packageLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this._classLevel = new Button(buttonLevelContainer, 16);
        this._classLevel.setText(TraceUIPlugin.getString("STR_ST_FILTER_CLASS_LEVEL"));
        this._classLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this._methodLevel = null;
        if (this._showMethodLevel) {
            this._methodLevel = new Button(buttonLevelContainer, 16);
            this._methodLevel.setText(TraceUIPlugin.getString("STR_ST_FILTER_METHOD_LEVEL"));
            this._methodLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                }
            });
        }
        this.createSpacer(content);
        this._eventsUI = new FilterEventsUI(this);
        this._eventsUI.createControl(content);
        return content;
    }

    protected void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    public void initializeFrom(SimpleSearchQuery filter) {
        this._filterText.setText("");
        this._caseControl.setSelection(true);
        this._eventsUI.initializeValues();
        boolean levelSet = false;
        if (filter.getWhereExpression() != null && filter.getWhereExpression() instanceof LogicalExpression) {
            LogicalExpression logicalExpression = (LogicalExpression)filter.getWhereExpression();
            EList filterElements = logicalExpression.getArguments();
            int i = 0;
            while (i < filterElements.size()) {
                BinaryExpression be = (BinaryExpression)filterElements.get(i);
                EStructuralFeature feature = ((SimpleOperand)be.getLeftOperand()).getFeature();
                if (feature != null) {
                    boolean validFeature = false;
                    if (feature.equals(ATTRIBUTE_PACKAGE_NAME)) {
                        this._packageLevel.setSelection(true);
                        validFeature = true;
                    } else if (feature.equals(ATTRIBUTE_CLASS_NAME)) {
                        this._classLevel.setSelection(true);
                        validFeature = true;
                    } else if (feature.equals(ATTRIBUTE_METHOD_NAME)) {
                        this._methodLevel.setSelection(true);
                        validFeature = true;
                    }
                    if (validFeature) {
                        this._filterText.setText(String.valueOf(((SimpleOperand)be.getRightOperands().get(0)).getRawValue()));
                        this._caseControl.setSelection(!be.isCaseInsensitive());
                        levelSet = true;
                    }
                }
                ++i;
            }
        }
        if (!levelSet) {
            this._packageLevel.setSelection(true);
        }
        this._eventsUI.initializeFrom(filter);
    }

    public SimpleSearchQuery performApply() {
        SimpleSearchQuery filter = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
        EList arguments = logicalExpression.getArguments();
        this._eventsUI.performApply(filter);
        if (this._filterText.getText().trim().length() > 0) {
            if (this._packageLevel.getSelection()) {
                arguments.add((Object)ModelUtils.createBinaryExpression((EStructuralFeature)ATTRIBUTE_PACKAGE_NAME, (RelationalOperators)OPERATOR_LIKE, (String)this._filterText.getText().trim(), (!this._caseControl.getSelection() ? 1 : 0) != 0));
            } else if (this._classLevel.getSelection()) {
                arguments.add((Object)ModelUtils.createBinaryExpression((EStructuralFeature)ATTRIBUTE_CLASS_NAME, (RelationalOperators)OPERATOR_LIKE, (String)this._filterText.getText().trim(), (!this._caseControl.getSelection() ? 1 : 0) != 0));
            } else if (this._methodLevel != null && this._methodLevel.getSelection()) {
                arguments.add((Object)ModelUtils.createBinaryExpression((EStructuralFeature)ATTRIBUTE_METHOD_NAME, (RelationalOperators)OPERATOR_LIKE, (String)this._filterText.getText().trim(), (!this._caseControl.getSelection() ? 1 : 0) != 0));
            }
        }
        filter.setWhereExpression((WhereExpression)logicalExpression);
        return filter;
    }
}

