/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.filters.internal.dialogs.FilterUIUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage2;
import org.eclipse.hyades.trace.views.internal.FilteringUtil;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticMethodView;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.ColumnExtensionValue;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class ExecutionStatisticView
extends MultiLevelStatisticMethodView {
    private static final int[] _numberOfColumns = new int[]{20, 20, 20, 20};
    private static int _level = 1;
    public static final int INSTANCE_LEVEL = 4;
    protected double _totalPackageCPUtime = 0.0;
    private final TRCPackageImpl.TRCPackageSnapshot pdelta1 = new TRCPackageImpl.TRCPackageSnapshot();
    private final TRCPackageImpl.TRCPackageSnapshot pdelta2 = new TRCPackageImpl.TRCPackageSnapshot();
    private final TRCClassImpl.TRCClassSnapshot cdelta1 = new TRCClassImpl.TRCClassSnapshot();
    private final TRCClassImpl.TRCClassSnapshot cdelta2 = new TRCClassImpl.TRCClassSnapshot();
    private final TRCMethodImpl.TRCMethodSnapshot mdelta1 = new TRCMethodImpl.TRCMethodSnapshot();
    private final TRCMethodImpl.TRCMethodSnapshot mdelta2 = new TRCMethodImpl.TRCMethodSnapshot();

    public ExecutionStatisticView(Composite parent, TraceViewerPage page) {
        super(parent, page);
    }

    protected int getClassPosForLevel(int pos) {
        if (this.getLevel() == 1) {
            switch (pos) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 6;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 8;
                }
                case 8: {
                    return 9;
                }
                case 9: {
                    return 10;
                }
            }
        } else if (this.getLevel() == 4) {
            switch (pos) {
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 6;
                }
                case 5: {
                    return 8;
                }
                case 6: {
                    return 10;
                }
            }
        }
        return pos;
    }

    protected int getMethodPosForLevel(int pos) {
        if (this.getLevel() == 1) {
            switch (pos) {
                case 2: {
                    return 4;
                }
                case 3: {
                    return 5;
                }
                case 4: {
                    return -1;
                }
                case 5: {
                    return 6;
                }
                case 6: {
                    return -1;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return -1;
                }
                case 9: {
                    return 8;
                }
            }
        } else if (this.getLevel() == 2) {
            switch (pos) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return -1;
                }
                case 6: {
                    return 6;
                }
                case 7: {
                    return -1;
                }
                case 8: {
                    return 7;
                }
                case 9: {
                    return -1;
                }
                case 10: {
                    return 8;
                }
            }
        }
        return pos;
    }

    public boolean isEmptyUpdate() {
        return (double)PerftraceUtil.getTotalCalls(this._page.getMOFObject()) <= 0.0;
    }

    protected String getDefaultColumnsTemplatePackageLevel() {
        return TraceUIPlugin.getString("STR_ST_PACKAGE") + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("") + ":1:" + String.valueOf(47) + ":14," + TraceUIPlugin.getString("STR_ST_CPU_TIME") + ":2:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_TIME_AVERAGE") + ":3:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_INHTIME") + ":4:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_TIME") + ":5:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_INHTIME") + ":6:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_CALLS") + ":7:" + String.valueOf(17) + ":right:50," + TraceUIPlugin.getString("STR_ST_INHCALLS") + ":8:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_REAL_CPU_TIME") + ":9:" + String.valueOf(16) + ":right:100";
    }

    protected String getDefaultColumnsTemplateClassLevel() {
        return TraceUIPlugin.getString("STR_ST_CLASS_NAME") + ":0:" + String.valueOf(7) + ":200," + TraceUIPlugin.getString("") + ":1:" + String.valueOf(47) + ":14," + TraceUIPlugin.getString("STR_ST_PACKAGE") + ":2:" + String.valueOf(1) + ":left:100," + TraceUIPlugin.getString("STR_ST_CPU_TIME") + ":3:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_TIME_AVERAGE") + ":4:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_INHTIME") + ":5:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_TIME") + ":6:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_INHTIME") + ":7:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_CALLS") + ":8:" + String.valueOf(17) + ":right:50," + TraceUIPlugin.getString("STR_ST_INHCALLS") + ":9:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_REAL_CPU_TIME") + ":10:" + String.valueOf(16) + ":right:100";
    }

    protected String getDefaultColumnsTemplateMethodLevel() {
        return TraceUIPlugin.getString("STR_ST_METHOD_NAME") + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("") + ":1:" + String.valueOf(47) + ":14," + TraceUIPlugin.getString("STR_ST_CLASS_NAME") + ":2:" + String.valueOf(1) + ":left:100," + TraceUIPlugin.getString("STR_ST_PACKAGE") + ":3:" + String.valueOf(1) + ":left:100," + TraceUIPlugin.getString("STR_ST_CPU_TIME") + ":4:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_TIME_AVERAGE") + ":5:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_TIME") + ":6:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_CALLS") + ":7:" + String.valueOf(17) + ":right:55," + TraceUIPlugin.getString("STR_ST_REAL_CPU_TIME") + ":8:" + String.valueOf(16) + ":right:100";
    }

    protected String getDefaultColumnsTemplateInstanceLevel() {
        return TraceUIPlugin.getString("STR_ST_CLASS_NAME") + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("") + ":1:" + String.valueOf(47) + ":14," + TraceUIPlugin.getString("STR_ST_PACKAGE") + ":2:" + String.valueOf(1) + ":left:100," + TraceUIPlugin.getString("STR_ST_CPU_TIME") + ":3:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_TIME") + ":4:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_ST_CALLS") + ":5:" + String.valueOf(1) + ":right:50," + TraceUIPlugin.getString("STR_ST_REAL_CPU_TIME") + ":6:" + "0:right:100";
    }

    public String getDefaultColumnsTemplate() {
        String columns = super.getDefaultColumnsTemplate();
        if (columns == null) {
            columns = this.getLevel() == 4 ? this.getDefaultColumnsTemplateInstanceLevel() : "";
        }
        columns = columns + this.getColumnsTemplateExtensions(_numberOfColumns[_level - 1], "org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2", false);
        return columns;
    }

    public void setLevel(int i) {
        _level = i;
    }

    public int getLevel() {
        return _level;
    }

    public String getColumnsPreferencesKey() {
        this.setLevel(this.getLevel());
        if (this.getLevel() == 1) {
            return MultiLevelStatisticView.PREFERENCE_KEY_PREFIX + "ExecStatsPack60";
        }
        if (this.getLevel() == 2) {
            return MultiLevelStatisticView.PREFERENCE_KEY_PREFIX + "ExecStatsClass60";
        }
        if (this.getLevel() == 3) {
            return MultiLevelStatisticView.PREFERENCE_KEY_PREFIX + "ExecStatsMethod60";
        }
        if (this.getLevel() == 4) {
            return MultiLevelStatisticView.PREFERENCE_KEY_PREFIX + "ExecStatsInstance60";
        }
        return "";
    }

    public IContentProvider getContentProvider() {
        return new ExecutionStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new ExecutionStatisticLabelProvider((StatisticView)this);
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new ExecutionStatisticSorter();
    }

    protected StatisticView.StatisticFilter getFilterInstance() {
        return new ExecutionStatisticFilter();
    }

    protected String getViewTypeStr() {
        return "viewoption.execution2";
    }

    public void updateButtons() {
        super.updateButtons();
        ((ExecutionStatisticPage2)this.getTraceViewerPage()).percentMode().setChecked(this.isShowPercent());
        if (this.getLevel() == 4) {
            ((ExecutionStatisticPage2)this.getTraceViewerPage()).deltaColumns().setChecked(false);
        } else {
            ((ExecutionStatisticPage2)this.getTraceViewerPage()).deltaColumns().setChecked(this.showingDeltaColumns());
        }
    }

    protected void showPercentUpdate() {
        if (this.isShowPercent()) {
            this._totalCalls = PerftraceUtil.getTotalCalls(this._page.getMOFObject());
            if (this._totalCalls == 0) {
                this._totalCalls = 1;
            }
            this._totalInst = PerftraceUtil.getTotalInstances(this._page.getMOFObject());
            if (this._totalInst == 0) {
                this._totalInst = 1;
            }
            this._activeInst = PerftraceUtil.getActiveInstances(this._page.getMOFObject());
            if (this._activeInst == 0) {
                this._activeInst = 1;
            }
            this._totalSize = PerftraceUtil.getTotalSize(this._page.getMOFObject());
            if (this._totalSize == 0L) {
                this._totalSize = 1L;
            }
            this._activeSize = PerftraceUtil.getActiveSize(this._page.getMOFObject());
            if (this._activeSize == 0L) {
                this._activeSize = 1L;
            }
            this._maxTime = PerftraceUtil.getMaximumTime(this._page.getMOFObject());
            if (this._maxTime == 0.0) {
                this._maxTime = 1.0;
            }
            this._totalPackageCPUtime = this.getTotalPackageCPUtime();
            if (this._totalPackageCPUtime == 0.0) {
                this._totalPackageCPUtime = 1.0;
            }
        }
    }

    protected double getTotalPackageCPUtime() {
        double totalPackageCPUtime = 0.0;
        ArrayList<TRCPackage> packagelist = null;
        if (FilterUIUtil.ENABLE_NEW_FILTERING) {
            packagelist = FilteringUtil.getFilteredPackages(this.getCurrentFilter(), FilteringUtil.getProcessList(this._page.getMOFObject()));
        } else {
            Object[] packages = PerftraceUtil.getAllPackages(this._page.getMOFObject());
            ArrayList<TRCPackage> list = new ArrayList<TRCPackage>();
            int idx = 0;
            while (idx < packages.length) {
                TRCPackage pack = (TRCPackage)packages[idx];
                if (pack.getClasses().size() > 0) {
                    list.add(pack);
                }
                ++idx;
            }
            packagelist = list;
        }
        int i = 0;
        while (i < packagelist.size()) {
            TRCPackage pack = (TRCPackage)packagelist.get(i);
            totalPackageCPUtime += pack.getTotalCpuTime();
            ++i;
        }
        return totalPackageCPUtime;
    }

    protected void searchInLevel(TableTree table, TableTreeItem item, TRCPackage pack, TRCClass cls, TRCMethod meth, TRCObject trcObj) {
        super.searchInLevel(table, item, pack, cls, meth, trcObj);
        switch (this.getLevel()) {
            case 4: {
                if (cls == null) break;
                this.searchInClassLevel(table, item, cls, null, trcObj);
            }
        }
    }

    private double getTRCFullTraceCPUtime(TRCFullTraceObject fullTraceObject) {
        double totalCPUtime = 0.0;
        Iterator methodInvocations = fullTraceObject.getInvocations().iterator();
        while (methodInvocations.hasNext()) {
            EObject methodInvo = (EObject)methodInvocations.next();
            if (methodInvo instanceof TRCFullMethodInvocation) {
                totalCPUtime += ((TRCFullMethodInvocation)methodInvo).getCpuTime();
                continue;
            }
            if (!(methodInvo instanceof TRCAggregatedMethodInvocation)) continue;
            totalCPUtime += ((TRCAggregatedMethodInvocation)methodInvo).getTotalCpuTime();
        }
        return totalCPUtime;
    }

    public class ExecutionStatisticFilter
    extends StatisticView.StatisticFilter {
        public ExecutionStatisticFilter() {
            super(ExecutionStatisticView.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            String compareText = "";
            switch (ExecutionStatisticView.this.getLevel()) {
                case 1: {
                    if (!(element instanceof TRCPackage)) {
                        return true;
                    }
                    if (((TRCPackage)element).getName().equals("")) {
                        compareText = TraceUIPlugin.getString("DEFAULT_PACKAGE");
                        break;
                    }
                    compareText = ((TRCPackage)element).getName();
                    break;
                }
                case 2: {
                    if (!(element instanceof TRCClass)) {
                        return true;
                    }
                    compareText = ((TRCClass)element).getName();
                    break;
                }
                case 3: {
                    if (!(element instanceof TRCMethod)) {
                        return true;
                    }
                    compareText = ((TRCMethod)element).getName();
                    break;
                }
                case 4: {
                    if (!(element instanceof TRCClass)) break;
                    compareText = ((TRCClass)element).getName();
                }
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }

    public class ExecutionStatisticSorter
    extends MultiLevelStatisticView.MultiLevelStatisticSorter {
        public ExecutionStatisticSorter() {
            super(ExecutionStatisticView.this);
        }

        protected int comparePackageLevel(Viewer viewer, Object e1, Object e2) {
            double d = 0.0;
            if (e1 instanceof TRCPackage && e2 instanceof TRCPackage) {
                TRCPackage p1 = (TRCPackage)e1;
                TRCPackage p2 = (TRCPackage)e2;
                TRCPackageImpl.TRCPackageSnapshot ps1 = (TRCPackageImpl.TRCPackageSnapshot)p1.retrieveSnapshot();
                TRCPackageImpl.TRCPackageSnapshot ps2 = (TRCPackageImpl.TRCPackageSnapshot)p2.retrieveSnapshot();
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * p1.getName().compareToIgnoreCase(p2.getName());
                    }
                    case 1: {
                        if (p1.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 8) < 0 && p2.computeDelta((IDelta)ExecutionStatisticView.this.pdelta2, 8) >= 0) {
                            return this._sortSequence;
                        }
                        if (p1.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 8) >= 0 && p2.computeDelta((IDelta)ExecutionStatisticView.this.pdelta2, 8) < 0) {
                            return this._sortSequence * -1;
                        }
                        return 0;
                    }
                    case 2: {
                        if (!this._info.isDeltaColumn()) {
                            d = ps1.getBaseTime() - ps2.getBaseTime();
                        } else {
                            p1.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 1);
                            p2.computeDelta((IDelta)ExecutionStatisticView.this.pdelta2, 1);
                            d = ExecutionStatisticView.this.pdelta1.getBaseTime() - ExecutionStatisticView.this.pdelta2.getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 3: {
                        int calls2;
                        int calls1 = ps1.getCalls();
                        if (calls1 == 0) {
                            calls1 = 1;
                        }
                        if ((calls2 = ps2.getCalls()) == 0) {
                            calls2 = 1;
                        }
                        if ((d = ps1.getBaseTime() / (double)calls1 - ps2.getBaseTime() / (double)calls2) < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 4: {
                        if (!this._info.isDeltaColumn()) {
                            d = ps1.getInheritedBaseTime() - ps2.getInheritedBaseTime();
                        } else {
                            p1.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 5);
                            p2.computeDelta((IDelta)ExecutionStatisticView.this.pdelta2, 5);
                            d = ExecutionStatisticView.this.pdelta1.getInheritedBaseTime() - ExecutionStatisticView.this.pdelta2.getInheritedBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 5: {
                        if (!this._info.isDeltaColumn()) {
                            d = ps1.getCumulativeTime() - ps2.getCumulativeTime();
                        } else {
                            p1.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 2);
                            p2.computeDelta((IDelta)ExecutionStatisticView.this.pdelta2, 2);
                            d = ExecutionStatisticView.this.pdelta1.getCumulativeTime() - ExecutionStatisticView.this.pdelta2.getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 6: {
                        if (!this._info.isDeltaColumn()) {
                            d = ps1.getInheritedCumulativeTime() - ps2.getInheritedCumulativeTime();
                        } else {
                            p1.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 6);
                            p2.computeDelta((IDelta)ExecutionStatisticView.this.pdelta2, 6);
                            d = ExecutionStatisticView.this.pdelta1.getInheritedCumulativeTime() - ExecutionStatisticView.this.pdelta2.getInheritedCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 7: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (ps1.getCalls() - ps2.getCalls());
                        }
                        p1.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 3);
                        p2.computeDelta((IDelta)ExecutionStatisticView.this.pdelta2, 3);
                        return this._sortSequence * (ExecutionStatisticView.this.pdelta1.getCalls() - ExecutionStatisticView.this.pdelta2.getCalls());
                    }
                    case 8: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (ps1.getInheritedCalls() - ps2.getInheritedCalls());
                        }
                        p1.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 4);
                        p2.computeDelta((IDelta)ExecutionStatisticView.this.pdelta2, 4);
                        return this._sortSequence * (ExecutionStatisticView.this.pdelta1.getInheritedCalls() - ExecutionStatisticView.this.pdelta2.getInheritedCalls());
                    }
                    case 9: {
                        if (!this._info.isDeltaColumn()) {
                            d = ps1.getTotalCpuTime() - ps2.getTotalCpuTime();
                        } else {
                            p1.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 11);
                            p2.computeDelta((IDelta)ExecutionStatisticView.this.pdelta2, 11);
                            d = ExecutionStatisticView.this.pdelta1.getTotalCpuTime() - ExecutionStatisticView.this.pdelta2.getTotalCpuTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                }
                if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                    ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(this._pos - _numberOfColumns[_level - 1]);
                    return this._sortSequence * elt.getClassOfColumnExtension().compare(elt.getInitialColumnPos(), e1, e2);
                }
            } else {
                return this.compareClassLevel(viewer, e1, e2);
            }
            return 0;
        }

        protected int compareClassLevel(Viewer viewer, Object e1, Object e2) {
            int pos = ExecutionStatisticView.this.getClassPosForLevel(this._pos);
            double d = 0.0;
            if (e1 instanceof TRCClass && e2 instanceof TRCClass) {
                TRCClass c1 = (TRCClass)e1;
                TRCClass c2 = (TRCClass)e2;
                TRCClassImpl.TRCClassSnapshot cs1 = (TRCClassImpl.TRCClassSnapshot)c1.retrieveSnapshot();
                TRCClassImpl.TRCClassSnapshot cs2 = (TRCClassImpl.TRCClassSnapshot)c2.retrieveSnapshot();
                switch (pos) {
                    case 0: {
                        return this._sortSequence * c1.getName().compareToIgnoreCase(c2.getName());
                    }
                    case 1: {
                        if (c1.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 14) < 0 && c2.computeDelta((IDelta)ExecutionStatisticView.this.cdelta2, 14) >= 0) {
                            return this._sortSequence;
                        }
                        if (c1.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 14) >= 0 && c2.computeDelta((IDelta)ExecutionStatisticView.this.cdelta2, 14) < 0) {
                            return this._sortSequence * -1;
                        }
                        return 0;
                    }
                    case 2: {
                        return this._sortSequence * c1.getPackage().getName().compareToIgnoreCase(c2.getPackage().getName());
                    }
                    case 3: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getBaseTime() - cs2.getBaseTime();
                        } else {
                            c1.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 7);
                            c2.computeDelta((IDelta)ExecutionStatisticView.this.cdelta2, 7);
                            d = ExecutionStatisticView.this.cdelta1.getBaseTime() - ExecutionStatisticView.this.cdelta2.getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 4: {
                        int calls2;
                        int calls1 = cs1.getCalls();
                        if (calls1 == 0) {
                            calls1 = 1;
                        }
                        if ((calls2 = cs2.getCalls()) == 0) {
                            calls2 = 1;
                        }
                        if ((d = cs1.getBaseTime() / (double)calls1 - cs2.getBaseTime() / (double)calls2) < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 5: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getInheritedBaseTime() - cs2.getInheritedBaseTime();
                        } else {
                            c1.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 11);
                            c2.computeDelta((IDelta)ExecutionStatisticView.this.cdelta2, 11);
                            d = ExecutionStatisticView.this.cdelta1.getInheritedBaseTime() - ExecutionStatisticView.this.cdelta2.getInheritedBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 6: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getCumulativeTime() - cs2.getCumulativeTime();
                        } else {
                            c1.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 8);
                            c2.computeDelta((IDelta)ExecutionStatisticView.this.cdelta2, 8);
                            d = ExecutionStatisticView.this.cdelta1.getCumulativeTime() - ExecutionStatisticView.this.cdelta2.getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 7: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getInheritedCumulativeTime() - cs2.getInheritedCumulativeTime();
                        } else {
                            c1.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 12);
                            c2.computeDelta((IDelta)ExecutionStatisticView.this.cdelta2, 12);
                            d = ExecutionStatisticView.this.cdelta1.getInheritedCumulativeTime() - ExecutionStatisticView.this.cdelta2.getInheritedCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 8: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getCalls() - cs2.getCalls());
                        }
                        c1.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 9);
                        c2.computeDelta((IDelta)ExecutionStatisticView.this.cdelta2, 9);
                        return this._sortSequence * (ExecutionStatisticView.this.cdelta1.getCalls() - ExecutionStatisticView.this.cdelta2.getCalls());
                    }
                    case 9: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getInheritedCalls() - cs2.getInheritedCalls());
                        }
                        c1.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 10);
                        c2.computeDelta((IDelta)ExecutionStatisticView.this.cdelta2, 10);
                        return this._sortSequence * (ExecutionStatisticView.this.cdelta1.getInheritedCalls() - ExecutionStatisticView.this.cdelta2.getInheritedCalls());
                    }
                    case 10: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getTotalCpuTime() - cs2.getTotalCpuTime();
                        } else {
                            c1.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 17);
                            c2.computeDelta((IDelta)ExecutionStatisticView.this.cdelta2, 17);
                            d = ExecutionStatisticView.this.cdelta1.getTotalCpuTime() - ExecutionStatisticView.this.cdelta2.getTotalCpuTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                }
                if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                    ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(this._pos - _numberOfColumns[_level - 1]);
                    return this._sortSequence * elt.getClassOfColumnExtension().compare(elt.getInitialColumnPos(), e1, e2);
                }
            } else {
                return this.compareMethodLevel(viewer, e1, e2);
            }
            return 0;
        }

        protected int compareMethodLevel(Viewer viewer, Object e1, Object e2) {
            int pos = ExecutionStatisticView.this.getMethodPosForLevel(this._pos);
            double d = 0.0;
            if (e1 instanceof TRCMethod && e2 instanceof TRCMethod) {
                TRCMethod m1 = (TRCMethod)e1;
                TRCMethod m2 = (TRCMethod)e2;
                TRCMethodImpl.TRCMethodSnapshot ms1 = (TRCMethodImpl.TRCMethodSnapshot)m1.retrieveSnapshot();
                TRCMethodImpl.TRCMethodSnapshot ms2 = (TRCMethodImpl.TRCMethodSnapshot)m2.retrieveSnapshot();
                switch (pos) {
                    case 0: {
                        StringBuffer buf1 = new StringBuffer();
                        StringBuffer buf2 = new StringBuffer();
                        return this._sortSequence * buf1.append(m1.getName()).append(m1.getSignature()).toString().compareToIgnoreCase(buf2.append(m2.getName()).append(m2.getSignature()).toString());
                    }
                    case 1: {
                        if (m1.computeDelta((IDelta)ExecutionStatisticView.this.mdelta1, 6) < 0 && m2.computeDelta((IDelta)ExecutionStatisticView.this.mdelta2, 6) >= 0) {
                            return this._sortSequence;
                        }
                        if (m1.computeDelta((IDelta)ExecutionStatisticView.this.mdelta1, 6) >= 0 && m2.computeDelta((IDelta)ExecutionStatisticView.this.mdelta2, 6) < 0) {
                            return this._sortSequence * -1;
                        }
                        return 0;
                    }
                    case 2: {
                        return this._sortSequence * m1.getDefiningClass().getName().compareToIgnoreCase(m2.getDefiningClass().getName());
                    }
                    case 3: {
                        return this._sortSequence * m1.getDefiningClass().getPackage().getName().compareToIgnoreCase(m2.getDefiningClass().getPackage().getName());
                    }
                    case 4: {
                        if (!this._info.isDeltaColumn()) {
                            d = ms1.getBaseTime() - ms2.getBaseTime();
                        } else {
                            m1.computeDelta((IDelta)ExecutionStatisticView.this.mdelta1, 6);
                            m2.computeDelta((IDelta)ExecutionStatisticView.this.mdelta2, 6);
                            d = ExecutionStatisticView.this.mdelta1.getBaseTime() - ExecutionStatisticView.this.mdelta2.getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 5: {
                        int calls2;
                        int calls1 = ms1.getCalls();
                        if (calls1 == 0) {
                            calls1 = 1;
                        }
                        if ((calls2 = ms2.getCalls()) == 0) {
                            calls2 = 1;
                        }
                        if ((d = ms1.getBaseTime() / (double)calls1 - ms2.getBaseTime() / (double)calls2) < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 6: {
                        if (!this._info.isDeltaColumn()) {
                            d = ms1.getCumulativeTime() - ms2.getCumulativeTime();
                        } else {
                            m1.computeDelta((IDelta)ExecutionStatisticView.this.mdelta1, 7);
                            m2.computeDelta((IDelta)ExecutionStatisticView.this.mdelta2, 7);
                            d = ExecutionStatisticView.this.mdelta1.getCumulativeTime() - ExecutionStatisticView.this.mdelta2.getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 7: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (ms1.getCalls() - ms2.getCalls());
                        }
                        m1.computeDelta((IDelta)ExecutionStatisticView.this.mdelta1, 8);
                        m2.computeDelta((IDelta)ExecutionStatisticView.this.mdelta2, 8);
                        return this._sortSequence * (ExecutionStatisticView.this.mdelta1.getCalls() - ExecutionStatisticView.this.mdelta2.getCalls());
                    }
                    case 8: {
                        if (!this._info.isDeltaColumn()) {
                            d = ms1.getTotalCpuTime() - ms2.getTotalCpuTime();
                        } else {
                            m1.computeDelta((IDelta)ExecutionStatisticView.this.mdelta1, 9);
                            m2.computeDelta((IDelta)ExecutionStatisticView.this.mdelta2, 9);
                            d = ExecutionStatisticView.this.mdelta1.getTotalCpuTime() - ExecutionStatisticView.this.mdelta2.getTotalCpuTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                }
                if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                    ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(this._pos - _numberOfColumns[_level - 1]);
                    return this._sortSequence * elt.getClassOfColumnExtension().compare(elt.getInitialColumnPos(), e1, e2);
                }
            }
            return 0;
        }

        protected int compareInstanceLevel(Viewer viewer, Object e1, Object e2) {
            double d = 0.0;
            if (e1 instanceof TRCClass) {
                return this.compareClassLevel(viewer, e1, e2);
            }
            TRCObject obj1 = (TRCObject)e1;
            TRCObject obj2 = (TRCObject)e2;
            switch (this._pos) {
                case 0: {
                    return this._sortSequence * (int)(obj1.getId() - obj2.getId());
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    d = 0.0;
                    if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCHeapObject) {
                        TRCHeapObject object2 = (TRCHeapObject)e2;
                        TRCClass class2 = PerftraceUtil.getClass((TRCObject)object2);
                        double baseTime1 = ((TRCFullTraceObject)obj1).getBaseTime();
                        double baseTime2 = class2.getBaseTime();
                        d = baseTime1 - baseTime2;
                    } else if (obj1 instanceof TRCHeapObject && obj2 instanceof TRCFullTraceObject) {
                        TRCHeapObject object1 = (TRCHeapObject)e1;
                        TRCClass class1 = PerftraceUtil.getClass((TRCObject)object1);
                        double baseTime2 = ((TRCFullTraceObject)obj2).getBaseTime();
                        double baseTime1 = class1.getBaseTime();
                        d = baseTime1 - baseTime2;
                    } else if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCFullTraceObject) {
                        d = ((TRCFullTraceObject)obj1).getBaseTime() - ((TRCFullTraceObject)obj2).getBaseTime();
                    }
                    if (d < 0.0) {
                        return -1 * this._sortSequence;
                    }
                    if (d > 0.0) {
                        return this._sortSequence;
                    }
                    return 0;
                }
                case 4: {
                    d = 0.0;
                    if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCHeapObject) {
                        TRCHeapObject object2 = (TRCHeapObject)e2;
                        TRCClass class2 = PerftraceUtil.getClass((TRCObject)object2);
                        double time1 = ((TRCFullTraceObject)obj1).getCumulativeTime();
                        double time2 = class2.getCumulativeTime();
                        d = time1 - time2;
                    } else if (obj1 instanceof TRCHeapObject && obj2 instanceof TRCFullTraceObject) {
                        TRCHeapObject object1 = (TRCHeapObject)e1;
                        TRCClass class1 = PerftraceUtil.getClass((TRCObject)object1);
                        double time2 = ((TRCFullTraceObject)obj2).getCumulativeTime();
                        double time1 = class1.getCumulativeTime();
                        d = time1 - time2;
                    } else if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCFullTraceObject) {
                        d = ((TRCFullTraceObject)obj1).getCumulativeTime() - ((TRCFullTraceObject)obj2).getCumulativeTime();
                    }
                    if (d < 0.0) {
                        return -1 * this._sortSequence;
                    }
                    if (d > 0.0) {
                        return this._sortSequence;
                    }
                    return 0;
                }
                case 5: {
                    if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCHeapObject) {
                        TRCHeapObject object2 = (TRCHeapObject)e2;
                        TRCClass class2 = PerftraceUtil.getClass((TRCObject)object2);
                        return this._sortSequence * (((TRCFullTraceObject)obj1).getCalls() - class2.getCalls());
                    }
                    if (obj1 instanceof TRCHeapObject && obj2 instanceof TRCFullTraceObject) {
                        TRCHeapObject object1 = (TRCHeapObject)e1;
                        TRCClass class1 = PerftraceUtil.getClass((TRCObject)object1);
                        return this._sortSequence * (class1.getCalls() - ((TRCFullTraceObject)obj2).getCalls());
                    }
                    if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCFullTraceObject) {
                        return this._sortSequence * (((TRCFullTraceObject)obj1).getCalls() - ((TRCFullTraceObject)obj2).getCalls());
                    }
                    return 0;
                }
                case 6: {
                    d = 0.0;
                    if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCHeapObject) {
                        TRCHeapObject object2 = (TRCHeapObject)e2;
                        TRCClass class2 = PerftraceUtil.getClass((TRCObject)object2);
                        double time1 = ExecutionStatisticView.this.getTRCFullTraceCPUtime((TRCFullTraceObject)obj1);
                        double time2 = class2.getTotalCpuTime();
                        d = time1 - time2;
                    } else if (obj1 instanceof TRCHeapObject && obj2 instanceof TRCFullTraceObject) {
                        TRCHeapObject object1 = (TRCHeapObject)e1;
                        TRCClass class1 = PerftraceUtil.getClass((TRCObject)object1);
                        double time2 = ExecutionStatisticView.this.getTRCFullTraceCPUtime((TRCFullTraceObject)obj2);
                        double time1 = class1.getTotalCpuTime();
                        d = time1 - time2;
                    } else if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCFullTraceObject) {
                        d = ExecutionStatisticView.this.getTRCFullTraceCPUtime((TRCFullTraceObject)obj1) - ExecutionStatisticView.this.getTRCFullTraceCPUtime((TRCFullTraceObject)obj2);
                    }
                    if (d < 0.0) {
                        return -1 * this._sortSequence;
                    }
                    if (d > 0.0) {
                        return this._sortSequence;
                    }
                    return 0;
                }
            }
            if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(this._pos - _numberOfColumns[_level - 1]);
                return this._sortSequence * elt.getClassOfColumnExtension().compare(elt.getInitialColumnPos(), e1, e2);
            }
            return 0;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (ExecutionStatisticView.this.getLevel() == 1) {
                return this.comparePackageLevel(viewer, e1, e2);
            }
            if (ExecutionStatisticView.this.getLevel() == 2) {
                return this.compareClassLevel(viewer, e1, e2);
            }
            if (ExecutionStatisticView.this.getLevel() == 3) {
                return this.compareMethodLevel(viewer, e1, e2);
            }
            if (ExecutionStatisticView.this.getLevel() == 4) {
                return this.compareInstanceLevel(viewer, e1, e2);
            }
            return 0;
        }
    }

    public class ExecutionStatisticLabelProvider
    extends MultiLevelStatisticView.MultiLevelStatisticLabelProvider {
        public ExecutionStatisticLabelProvider(StatisticView viewer) {
            super(ExecutionStatisticView.this, viewer);
        }

        protected String getColumnTextPackageLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (obj instanceof TRCPackage) {
                TRCPackage p = (TRCPackage)obj;
                TRCPackageImpl.TRCPackageSnapshot ps = (TRCPackageImpl.TRCPackageSnapshot)p.retrieveSnapshot();
                switch (pos) {
                    case 0: {
                        return PerftraceUtil.getPackageName(p, ExecutionStatisticView.this._page.getMOFObject()).toString();
                    }
                    case 1: {
                        return "";
                    }
                    case 2: {
                        if (!info.isDeltaColumn()) {
                            if (ExecutionStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(ps.getBaseTime() / ExecutionStatisticView.this._maxTime));
                            }
                            return TString.formatTimeValue((double)ps.getBaseTime());
                        }
                        p.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 1);
                        return TString.formatTimeValue((double)ExecutionStatisticView.this.pdelta1.getBaseTime());
                    }
                    case 3: {
                        int calls = ps.getCalls();
                        if (calls == 0) {
                            calls = 1;
                        }
                        if (ExecutionStatisticView.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)(ps.getBaseTime() / ((double)calls * ExecutionStatisticView.this._maxTime)));
                        }
                        return TString.formatTimeValue((double)(ps.getBaseTime() / (double)calls));
                    }
                    case 4: {
                        if (!info.isDeltaColumn()) {
                            if (ExecutionStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(ps.getInheritedBaseTime() / ExecutionStatisticView.this._maxTime));
                            }
                            return TString.formatTimeValue((double)ps.getInheritedBaseTime());
                        }
                        p.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 5);
                        return TString.formatTimeValue((double)ExecutionStatisticView.this.pdelta1.getInheritedBaseTime());
                    }
                    case 5: {
                        if (!info.isDeltaColumn()) {
                            if (ExecutionStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(ps.getCumulativeTime() / ExecutionStatisticView.this._maxTime));
                            }
                            return TString.formatTimeValue((double)ps.getCumulativeTime());
                        }
                        p.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 2);
                        return TString.formatTimeValue((double)ExecutionStatisticView.this.pdelta1.getCumulativeTime());
                    }
                    case 6: {
                        if (!info.isDeltaColumn()) {
                            if (ExecutionStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(ps.getInheritedCumulativeTime() / ExecutionStatisticView.this._maxTime));
                            }
                            return TString.formatTimeValue((double)ps.getInheritedCumulativeTime());
                        }
                        p.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 6);
                        return TString.formatTimeValue((double)ExecutionStatisticView.this.pdelta1.getInheritedCumulativeTime());
                    }
                    case 7: {
                        if (!info.isDeltaColumn()) {
                            if (ExecutionStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)ps.getCalls() / (double)ExecutionStatisticView.this._totalCalls));
                            }
                            return String.valueOf(ps.getCalls());
                        }
                        p.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 3);
                        return String.valueOf(ExecutionStatisticView.this.pdelta1.getCalls());
                    }
                    case 8: {
                        if (!info.isDeltaColumn()) {
                            if (ExecutionStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)ps.getInheritedCalls() / (double)ExecutionStatisticView.this._totalCalls));
                            }
                            return String.valueOf(ps.getInheritedCalls());
                        }
                        p.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 4);
                        return String.valueOf(ExecutionStatisticView.this.pdelta1.getInheritedCalls());
                    }
                    case 9: {
                        if (!info.isDeltaColumn()) {
                            if (ExecutionStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(ps.getTotalCpuTime() / ExecutionStatisticView.this._totalPackageCPUtime));
                            }
                            return TString.formatTimeValue((double)ps.getTotalCpuTime());
                        }
                        p.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 11);
                        return TString.formatTimeValue((double)ExecutionStatisticView.this.pdelta1.getTotalCpuTime());
                    }
                }
                if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                    ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(pos - _numberOfColumns[_level - 1]);
                    return elt.getClassOfColumnExtension().getColumnText(obj, elt.getInitialColumnPos());
                }
            } else {
                return this.getColumnTextClassLevel(obj, col);
            }
            return "";
        }

        protected String getColumnTextClassLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = ExecutionStatisticView.this.getClassPosForLevel(info.getColumnData().getInitalPos());
            if (obj instanceof TRCClass) {
                TRCClass clas = (TRCClass)obj;
                TRCClassImpl.TRCClassSnapshot cs = (TRCClassImpl.TRCClassSnapshot)clas.retrieveSnapshot();
                switch (pos) {
                    case 0: {
                        return ((TRCClass)obj).getName();
                    }
                    case 1: {
                        return "";
                    }
                    case 2: {
                        return PerftraceUtil.getPackageName(clas.getPackage(), ExecutionStatisticView.this._page.getMOFObject()).toString();
                    }
                    case 3: {
                        if (!info.isDeltaColumn()) {
                            if (ExecutionStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getBaseTime() / ExecutionStatisticView.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getBaseTime());
                        }
                        clas.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 7);
                        return TString.formatTimeValue((double)ExecutionStatisticView.this.cdelta1.getBaseTime());
                    }
                    case 4: {
                        int calls = cs.getCalls();
                        if (calls == 0) {
                            calls = 1;
                        }
                        if (ExecutionStatisticView.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)(cs.getBaseTime() / ((double)calls * ExecutionStatisticView.this._maxTime)));
                        }
                        return TString.formatTimeValue((double)(cs.getBaseTime() / (double)calls));
                    }
                    case 5: {
                        if (!info.isDeltaColumn()) {
                            if (ExecutionStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getInheritedBaseTime() / ExecutionStatisticView.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getInheritedBaseTime());
                        }
                        clas.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 11);
                        return TString.formatTimeValue((double)ExecutionStatisticView.this.cdelta1.getInheritedBaseTime());
                    }
                    case 6: {
                        if (!info.isDeltaColumn()) {
                            if (ExecutionStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getCumulativeTime() / ExecutionStatisticView.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getCumulativeTime());
                        }
                        clas.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 8);
                        return TString.formatTimeValue((double)ExecutionStatisticView.this.cdelta1.getCumulativeTime());
                    }
                    case 7: {
                        if (!info.isDeltaColumn()) {
                            if (ExecutionStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getInheritedCumulativeTime() / ExecutionStatisticView.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getInheritedCumulativeTime());
                        }
                        clas.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 12);
                        return TString.formatTimeValue((double)ExecutionStatisticView.this.cdelta1.getInheritedCumulativeTime());
                    }
                    case 8: {
                        if (!info.isDeltaColumn()) {
                            if (ExecutionStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)cs.getCalls() / (double)ExecutionStatisticView.this._totalCalls));
                            }
                            return String.valueOf(cs.getCalls());
                        }
                        clas.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 9);
                        return String.valueOf(ExecutionStatisticView.this.cdelta1.getCalls());
                    }
                    case 9: {
                        if (!info.isDeltaColumn()) {
                            if (ExecutionStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)cs.getInheritedCalls() / (double)ExecutionStatisticView.this._totalCalls));
                            }
                            return String.valueOf(cs.getInheritedCalls());
                        }
                        clas.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 10);
                        return String.valueOf(ExecutionStatisticView.this.cdelta1.getInheritedCalls());
                    }
                    case 10: {
                        if (!info.isDeltaColumn()) {
                            if (ExecutionStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getTotalCpuTime() / ExecutionStatisticView.this._totalPackageCPUtime));
                            }
                            return TString.formatTimeValue((double)cs.getTotalCpuTime());
                        }
                        clas.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 17);
                        return TString.formatTimeValue((double)ExecutionStatisticView.this.cdelta1.getTotalCpuTime());
                    }
                }
                if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                    ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(pos - _numberOfColumns[_level - 1]);
                    return elt.getClassOfColumnExtension().getColumnText(obj, elt.getInitialColumnPos());
                }
            } else {
                return this.getColumnTextMethodLevel(obj, col);
            }
            return "";
        }

        protected String getColumnTextMethodLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = ExecutionStatisticView.this.getMethodPosForLevel(info.getColumnData().getInitalPos());
            TRCMethod m = (TRCMethod)obj;
            TRCMethodImpl.TRCMethodSnapshot ms = (TRCMethodImpl.TRCMethodSnapshot)m.retrieveSnapshot();
            switch (pos) {
                case 0: {
                    StringBuffer buf = new StringBuffer();
                    return buf.append(m.getName()).append(m.getSignature()).toString();
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return m.getDefiningClass().getName();
                }
                case 3: {
                    return PerftraceUtil.getPackageName(m.getDefiningClass().getPackage(), ExecutionStatisticView.this._page.getMOFObject()).toString();
                }
                case 4: {
                    if (!info.isDeltaColumn()) {
                        if (ExecutionStatisticView.this.isShowPercent()) {
                            return PerftraceUtil.formatAsPercentage(ms.getBaseTime() / ExecutionStatisticView.this._maxTime);
                        }
                        return TString.formatTimeValue((double)ms.getBaseTime());
                    }
                    m.computeDelta((IDelta)ExecutionStatisticView.this.mdelta1, 6);
                    return TString.formatTimeValue((double)ExecutionStatisticView.this.mdelta1.getBaseTime());
                }
                case 5: {
                    int calls = ms.getCalls();
                    if (calls == 0) {
                        calls = 1;
                    }
                    if (ExecutionStatisticView.this.isShowPercent()) {
                        return TString.formatAsPercentage((double)(ms.getBaseTime() / ((double)calls * ExecutionStatisticView.this._maxTime)));
                    }
                    return TString.formatTimeValue((double)(ms.getBaseTime() / (double)calls));
                }
                case 6: {
                    if (!info.isDeltaColumn()) {
                        if (ExecutionStatisticView.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)(ms.getCumulativeTime() / ExecutionStatisticView.this._maxTime));
                        }
                        return TString.formatTimeValue((double)ms.getCumulativeTime());
                    }
                    m.computeDelta((IDelta)ExecutionStatisticView.this.mdelta1, 7);
                    return TString.formatTimeValue((double)ExecutionStatisticView.this.mdelta1.getCumulativeTime());
                }
                case 7: {
                    if (!info.isDeltaColumn()) {
                        if (ExecutionStatisticView.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)((double)ms.getCalls() / (double)ExecutionStatisticView.this._totalCalls));
                        }
                        return String.valueOf(ms.getCalls());
                    }
                    m.computeDelta((IDelta)ExecutionStatisticView.this.mdelta1, 8);
                    return String.valueOf(ExecutionStatisticView.this.mdelta1.getCalls());
                }
                case 8: {
                    if (!info.isDeltaColumn()) {
                        if (ExecutionStatisticView.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)(ms.getTotalCpuTime() / ExecutionStatisticView.this._totalPackageCPUtime));
                        }
                        return TString.formatTimeValue((double)ms.getTotalCpuTime());
                    }
                    m.computeDelta((IDelta)ExecutionStatisticView.this.mdelta1, 9);
                    return TString.formatTimeValue((double)ExecutionStatisticView.this.mdelta1.getTotalCpuTime());
                }
            }
            if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(pos - _numberOfColumns[_level - 1]);
                return elt.getClassOfColumnExtension().getColumnText(obj, elt.getInitialColumnPos());
            }
            return "";
        }

        protected String getColumnTextInstanceLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (obj instanceof TRCClass) {
                return this.getColumnTextClassLevel(obj, col);
            }
            if (info.isDeltaColumn()) {
                return "";
            }
            TRCObject object = (TRCObject)obj;
            switch (pos) {
                case 0: {
                    TRCClass clas = PerftraceUtil.getClass(object);
                    if (clas == object.getProcess().getClassClass()) {
                        return clas.getName();
                    }
                    return clas.getName() + "." + object.getId();
                }
                case 1: {
                    return "";
                }
                case 2: {
                    TRCClass clas = PerftraceUtil.getClass(object);
                    return PerftraceUtil.getPackageName(clas.getPackage(), ExecutionStatisticView.this._page.getMOFObject()).toString();
                }
                case 3: {
                    if (object instanceof TRCFullTraceObject) {
                        if (ExecutionStatisticView.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)(((TRCFullTraceObject)object).getBaseTime() / ExecutionStatisticView.this._maxTime));
                        }
                        return TString.formatTimeValue((double)((TRCFullTraceObject)object).getBaseTime());
                    }
                    return "";
                }
                case 4: {
                    if (object instanceof TRCFullTraceObject) {
                        if (ExecutionStatisticView.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)(((TRCFullTraceObject)object).getCumulativeTime() / ExecutionStatisticView.this._maxTime));
                        }
                        return TString.formatTimeValue((double)((TRCFullTraceObject)object).getCumulativeTime());
                    }
                    return "";
                }
                case 5: {
                    if (object instanceof TRCFullTraceObject) {
                        if (ExecutionStatisticView.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)((double)((TRCFullTraceObject)object).getCalls() / (double)ExecutionStatisticView.this._totalCalls));
                        }
                        return String.valueOf(((TRCFullTraceObject)object).getCalls());
                    }
                    return "";
                }
                case 6: {
                    if (object instanceof TRCFullTraceObject) {
                        double totalCPUtime = ExecutionStatisticView.this.getTRCFullTraceCPUtime((TRCFullTraceObject)object);
                        if (ExecutionStatisticView.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)(totalCPUtime / ExecutionStatisticView.this._totalPackageCPUtime));
                        }
                        return TString.formatTimeValue((double)totalCPUtime);
                    }
                    return "";
                }
            }
            if (ExecutionStatisticView.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue elt = (ColumnExtensionValue)ExecutionStatisticView.this._listOfColumExtension.get(pos - _numberOfColumns[_level - 1]);
                return elt.getClassOfColumnExtension().getColumnText(obj, elt.getInitialColumnPos());
            }
            return "";
        }

        public String getColumnText(Object obj, int col) {
            if (ExecutionStatisticView.this.getLevel() == 1) {
                return this.getColumnTextPackageLevel(obj, col);
            }
            if (ExecutionStatisticView.this.getLevel() == 2) {
                return this.getColumnTextClassLevel(obj, col);
            }
            if (ExecutionStatisticView.this.getLevel() == 3) {
                return this.getColumnTextMethodLevel(obj, col);
            }
            if (ExecutionStatisticView.this.getLevel() == 4) {
                return this.getColumnTextInstanceLevel(obj, col);
            }
            return "";
        }

        protected Image getColumnImagePackageLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (info.isDeltaColumn()) {
                return null;
            }
            int state = 0;
            double d = 0.0;
            if (obj instanceof TRCPackage) {
                TRCPackage p = (TRCPackage)obj;
                switch (pos) {
                    case 1: {
                        if (p.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 8) < 0) {
                            return TracePluginImages.getImage("newentry_obj.gif");
                        }
                        return null;
                    }
                    case 2: {
                        p.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 1);
                        d = ExecutionStatisticView.this.pdelta1.getBaseTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 3: {
                        p.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 5);
                        d = ExecutionStatisticView.this.pdelta1.getInheritedBaseTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 4: {
                        p.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 2);
                        d = ExecutionStatisticView.this.pdelta1.getCumulativeTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 5: {
                        p.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 6);
                        d = ExecutionStatisticView.this.pdelta1.getInheritedCumulativeTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 6: {
                        p.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 3);
                        state = ExecutionStatisticView.this.pdelta1.getCalls();
                        break;
                    }
                    case 7: {
                        p.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 4);
                        state = ExecutionStatisticView.this.pdelta1.getInheritedCalls();
                        break;
                    }
                    case 8: {
                        p.computeDelta((IDelta)ExecutionStatisticView.this.pdelta1, 11);
                        d = ExecutionStatisticView.this.pdelta1.getTotalCpuTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                    }
                }
            } else {
                return this.getColumnImageClassLevel(obj, col);
            }
            if (state < 0) {
                return TracePluginImages.getImage("decreasedvalue_obj.gif");
            }
            if (state > 0) {
                return TracePluginImages.getImage("increasedvalue_obj.gif");
            }
            return null;
        }

        protected Image getColumnImageClassLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = ExecutionStatisticView.this.getClassPosForLevel(info.getColumnData().getInitalPos());
            if (info.isDeltaColumn()) {
                return null;
            }
            int state = 0;
            double d = 0.0;
            if (obj instanceof TRCClass) {
                TRCClass clas = (TRCClass)obj;
                switch (pos) {
                    case 1: {
                        if (clas.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 14) < 0) {
                            return TracePluginImages.getImage("newentry_obj.gif");
                        }
                        return null;
                    }
                    case 2: {
                        return TracePluginImages.getImage("package_obj_col.gif");
                    }
                    case 3: {
                        clas.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 7);
                        d = ExecutionStatisticView.this.cdelta1.getBaseTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 4: {
                        clas.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 11);
                        d = ExecutionStatisticView.this.cdelta1.getInheritedBaseTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 5: {
                        clas.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 8);
                        d = ExecutionStatisticView.this.cdelta1.getCumulativeTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 6: {
                        clas.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 12);
                        d = ExecutionStatisticView.this.cdelta1.getInheritedCumulativeTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 7: {
                        clas.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 9);
                        state = ExecutionStatisticView.this.cdelta1.getCalls();
                        break;
                    }
                    case 8: {
                        clas.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 10);
                        state = ExecutionStatisticView.this.cdelta1.getInheritedCalls();
                        break;
                    }
                    case 10: {
                        clas.computeDelta((IDelta)ExecutionStatisticView.this.cdelta1, 17);
                        d = ExecutionStatisticView.this.cdelta1.getTotalCpuTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                    }
                }
            } else {
                return this.getColumnImageMethodLevel(obj, col);
            }
            if (state < 0) {
                return TracePluginImages.getImage("decreasedvalue_obj.gif");
            }
            if (state > 0) {
                return TracePluginImages.getImage("increasedvalue_obj.gif");
            }
            return null;
        }

        protected Image getColumnImageMethodLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = ExecutionStatisticView.this.getMethodPosForLevel(info.getColumnData().getInitalPos());
            if (info.isDeltaColumn()) {
                return null;
            }
            int state = 0;
            double d = 0.0;
            TRCMethod m = (TRCMethod)obj;
            switch (pos) {
                case 1: {
                    if (m.computeDelta((IDelta)ExecutionStatisticView.this.mdelta1, 6) < 0) {
                        return TracePluginImages.getImage("newentry_obj.gif");
                    }
                    return null;
                }
                case 2: {
                    return TracePluginImages.getImage("class_col.gif");
                }
                case 3: {
                    return TracePluginImages.getImage("package_obj_col.gif");
                }
                case 4: {
                    m.computeDelta((IDelta)ExecutionStatisticView.this.mdelta1, 6);
                    d = ExecutionStatisticView.this.mdelta1.getBaseTime();
                    if (d < 0.0) {
                        state = -1;
                        break;
                    }
                    if (!(d > 0.0)) break;
                    state = 1;
                    break;
                }
                case 5: {
                    state = 0;
                    break;
                }
                case 6: {
                    m.computeDelta((IDelta)ExecutionStatisticView.this.mdelta1, 7);
                    d = ExecutionStatisticView.this.mdelta1.getCumulativeTime();
                    if (d < 0.0) {
                        state = -1;
                        break;
                    }
                    if (!(d > 0.0)) break;
                    state = 1;
                    break;
                }
                case 7: {
                    m.computeDelta((IDelta)ExecutionStatisticView.this.mdelta1, 8);
                    state = ExecutionStatisticView.this.mdelta1.getCalls();
                    break;
                }
                case 8: {
                    m.computeDelta((IDelta)ExecutionStatisticView.this.mdelta1, 9);
                    d = ExecutionStatisticView.this.mdelta1.getTotalCpuTime();
                    if (d < 0.0) {
                        state = -1;
                        break;
                    }
                    if (!(d > 0.0)) break;
                    state = 1;
                }
            }
            if (state < 0) {
                return TracePluginImages.getImage("decreasedvalue_obj.gif");
            }
            if (state > 0) {
                return TracePluginImages.getImage("increasedvalue_obj.gif");
            }
            return null;
        }

        protected Image getColumnImageInstanceLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (info.isDeltaColumn()) {
                return null;
            }
            if (obj instanceof TRCClass) {
                return this.getColumnImageClassLevel(obj, col);
            }
            switch (pos) {
                case 1: {
                    return null;
                }
                case 2: {
                    return TracePluginImages.getImage("package_obj_col.gif");
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int col) {
            if (ExecutionStatisticView.this.getLevel() == 1) {
                return this.getColumnImagePackageLevel(obj, col);
            }
            if (ExecutionStatisticView.this.getLevel() == 2) {
                return this.getColumnImageClassLevel(obj, col);
            }
            if (ExecutionStatisticView.this.getLevel() == 3) {
                return this.getColumnImageMethodLevel(obj, col);
            }
            if (ExecutionStatisticView.this.getLevel() == 4) {
                return this.getColumnImageInstanceLevel(obj, col);
            }
            return null;
        }
    }

    public class ExecutionStatisticContentProvider
    extends MultiLevelStatisticView.MultiLevelStatisticContentProvider {
        public ExecutionStatisticContentProvider() {
            super(ExecutionStatisticView.this);
        }

        public Object[] getChildren(Object element) {
            ExecutionStatisticView.this.tmpList.clear();
            if (element instanceof TRCPackage) {
                if (FilterUIUtil.ENABLE_NEW_FILTERING) {
                    return FilteringUtil.getFilteredClasses(ExecutionStatisticView.this.getCurrentFilter(), (EObject)((TRCPackage)element)).toArray();
                }
                return ((TRCPackage)element).getClasses().toArray();
            }
            if (element instanceof TRCClass) {
                if (ExecutionStatisticView.this.getLevel() == 4) {
                    if (FilterUIUtil.ENABLE_NEW_FILTERING) {
                        Object[] elements = FilteringUtil.getFilteredFullTraceObjects(ExecutionStatisticView.this.getCurrentFilter(), (EObject)((TRCClass)element)).toArray();
                        if (elements.length > 0) {
                            return elements;
                        }
                        return FilteringUtil.getFilteredHeapObjects(ExecutionStatisticView.this.getCurrentFilter(), (EObject)((TRCClass)element)).toArray();
                    }
                    TRCClass cls = (TRCClass)element;
                    EList list = cls.getObjects();
                    Iterator iter = cls.getObjects().iterator();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        if (!(obj instanceof TRCFullTraceObject)) continue;
                        ExecutionStatisticView.this.tmpList.add(obj);
                    }
                    if (ExecutionStatisticView.this.tmpList.isEmpty()) {
                        ExecutionStatisticView.this.tmpList.addAll(list);
                    }
                    return ExecutionStatisticView.this.tmpList.toArray();
                }
                if (FilterUIUtil.ENABLE_NEW_FILTERING) {
                    return FilteringUtil.getFilteredMethods(ExecutionStatisticView.this.getCurrentFilter(), (EObject)((TRCClass)element)).toArray();
                }
                return ((TRCClass)element).getMethods().toArray();
            }
            return ExecutionStatisticView.this.tmpList.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (FilterUIUtil.ENABLE_NEW_FILTERING) {
                return this.getChildren(element).length > 0;
            }
            if (element instanceof TRCPackage) {
                return true;
            }
            if (element instanceof TRCClass) {
                if (ExecutionStatisticView.this.getLevel() == 4) {
                    TRCClass cls = (TRCClass)element;
                    return cls.getObjects().size() > 0;
                }
                return ((TRCClass)element).getMethods().size() > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (ExecutionStatisticView.this.getLevel() == 1) {
                if (FilterUIUtil.ENABLE_NEW_FILTERING) {
                    return FilteringUtil.getFilteredPackages(ExecutionStatisticView.this.getCurrentFilter(), FilteringUtil.getProcessList(ExecutionStatisticView.this._page.getMOFObject())).toArray();
                }
                Object[] packages = PerftraceUtil.getAllPackages(ExecutionStatisticView.this._page.getMOFObject());
                ArrayList<TRCPackage> list = new ArrayList<TRCPackage>();
                int idx = 0;
                while (idx < packages.length) {
                    TRCPackage pack = (TRCPackage)packages[idx];
                    if (pack.getClasses().size() > 0) {
                        list.add(pack);
                    }
                    ++idx;
                }
                return list.toArray();
            }
            if (ExecutionStatisticView.this.getLevel() == 2) {
                if (FilterUIUtil.ENABLE_NEW_FILTERING) {
                    return FilteringUtil.getFilteredClasses(ExecutionStatisticView.this.getCurrentFilter(), FilteringUtil.getProcessList(ExecutionStatisticView.this._page.getMOFObject())).toArray();
                }
                return PerftraceUtil.getAllClasses(ExecutionStatisticView.this._page.getMOFObject());
            }
            if (ExecutionStatisticView.this.getLevel() == 3) {
                if (FilterUIUtil.ENABLE_NEW_FILTERING) {
                    return FilteringUtil.getFilteredMethods(ExecutionStatisticView.this.getCurrentFilter(), FilteringUtil.getProcessList(ExecutionStatisticView.this._page.getMOFObject())).toArray();
                }
                Object[] classes = PerftraceUtil.getAllClasses(ExecutionStatisticView.this._page.getMOFObject());
                ArrayList methods = new ArrayList();
                int idx = 0;
                while (idx < classes.length) {
                    methods.addAll(((TRCClass)classes[idx]).getMethods());
                    ++idx;
                }
                return methods.toArray();
            }
            if (ExecutionStatisticView.this.getLevel() == 4) {
                if (FilterUIUtil.ENABLE_NEW_FILTERING) {
                    return FilteringUtil.getFilteredClasses(ExecutionStatisticView.this.getCurrentFilter(), FilteringUtil.getProcessList(ExecutionStatisticView.this._page.getMOFObject())).toArray();
                }
                return PerftraceUtil.getAllClasses(ExecutionStatisticView.this._page.getMOFObject());
            }
            return new ArrayList().toArray();
        }
    }
}

