/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.internal.GraphDrawStrategy;
import org.eclipse.hyades.trace.views.internal.JCanvas;
import org.eclipse.hyades.trace.views.internal.Pattern;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.LinearPattern;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.SpectrumColorMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.help.WorkbenchHelp;

public class PatternDrawStrategy
extends GraphDrawStrategy {
    protected ArrayList _visibleThreads = new ArrayList();
    protected ArrayList _popupThreads = new ArrayList();
    protected Object[] _tmpArray;
    private final int NRLABELS = 10;
    private final float MAG_STEP = 2.0f;
    private Pattern _parent;
    protected int _maxdepth = 0;
    protected long _maxtime = 0L;
    private float timescale = 0.1f;
    private boolean _hidedetails = true;
    protected boolean _collectedempty = false;
    private boolean _drawgc = false;
    private int _drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
    private Hashtable _foldedInvocations;
    protected float _canvasVisibleBottom;
    protected float _canvasVisibleTop;
    protected float _canvasVisibleLeft;
    protected float _canvasVisibleRight;
    protected static final int MAXINV = 256;
    protected TRCMethodInvocation[] _drawArray = new TRCMethodInvocation[256];
    protected float[] _x = new float[256];
    protected float[] _y = new float[256];
    protected float[] _w = new float[256];
    protected float[] _h = new float[256];
    private DetectAllRepetitionsdAction rep1;
    private HideAllRepetitionsAction rep2;
    private ShowAllThreadsAction _showAll;
    private HideAllThreadsAction _hideAll;
    private ThreadAction _gcThread;

    public PatternDrawStrategy(Pattern parent) {
        this._parent = parent;
        this.setNonPropZoom(true);
        this._foldedInvocations = new Hashtable();
        Object[] threads = PerftraceUtil.getAllThreads(this._parent.getPage().getMOFObject());
        int idx = 0;
        while (idx < threads.length) {
            this._visibleThreads.add(threads[idx]);
            ++idx;
        }
        this.rep1 = new DetectAllRepetitionsdAction(TraceUIPlugin.getString("STR_DETECT_REP"));
        this.rep2 = new HideAllRepetitionsAction(TraceUIPlugin.getString("STR_HIDE_REP"));
        this._showAll = new ShowAllThreadsAction(TraceUIPlugin.getString("STR_SHOW_THREADS"));
        this._hideAll = new HideAllThreadsAction(TraceUIPlugin.getString("STR_HIDE_THREADS"));
        this._gcThread = new ThreadAction();
        this._gcThread.setName(TraceUIPlugin.getString("STR_GC"));
    }

    public void bgRedraw(GC gc) {
        JCanvas c = this.jcanvas();
        if (c == null) {
            return;
        }
        int idx = 0;
        while (idx < this._visibleThreads.size()) {
            TRCThread thread = (TRCThread)this._visibleThreads.get(idx);
            float offx = idx * this.treeWidth() + this.gcWidth();
            if (offx + (float)this.treeWidth() > c.visibleLeft() && offx < c.visibleRight()) {
                this.drawThread(gc, thread, offx, 0.0f);
            }
            ++idx;
        }
        this._hidedetails = false;
        if (this._drawgc) {
            this.drawGC(gc, 0, 0);
        }
        int idx2 = 0;
        while (idx2 < this._visibleThreads.size()) {
            TRCThread thread = (TRCThread)this._visibleThreads.get(idx2);
            float offx = idx2 * this.treeWidth() + this.gcWidth();
            if (offx + (float)this.treeWidth() > c.visibleLeft() && offx < c.visibleRight()) {
                this.drawThread(gc, thread, offx, 0.0f);
            }
            ++idx2;
        }
        this.drawTimeMarks(gc, 0, 0);
    }

    protected int cellHeight() {
        return 20;
    }

    protected int cellWidth() {
        return 20;
    }

    protected void detectLinearPatterns() {
        int i = 0;
        while (i < this._visibleThreads.size()) {
            TRCThread thread = (TRCThread)this._visibleThreads.get(i);
            Object[] invocations = thread.getInitialInvocations().toArray();
            int idx = 0;
            while (idx < invocations.length) {
                this.detectLinearPatterns((TRCMethodInvocation)invocations[idx]);
                ++idx;
            }
            ++i;
        }
    }

    protected void detectLinearPatterns(TRCMethodInvocation root) {
        Object[] segments = root.getInvokes().toArray();
        int fanout = segments.length;
        LinearPattern lp = null;
        if (fanout > 2) {
            lp = new LinearPattern();
            int j = 0;
            while (j < fanout) {
                lp.add(((TRCMethodInvocation)segments[j]).getMethod());
                ++j;
            }
        } else {
            int j = 0;
            while (j < fanout) {
                this.detectLinearPatterns((TRCMethodInvocation)segments[j]);
                ++j;
            }
            return;
        }
        lp.compute();
        if (lp.hasRepetition()) {
            this._foldedInvocations.put(root, lp);
        }
        int i = 0;
        while (i < fanout) {
            TRCMethodInvocation kid = (TRCMethodInvocation)segments[i];
            int repet = lp.repetition(i);
            if (repet == 1) {
                this.detectLinearPatterns(kid);
            } else {
                int len = lp.length(i);
                if (repet == 0 || len == 0) {
                    System.err.println("linpattern impossible (fanout :" + fanout + ")");
                } else {
                    i += len * repet - 1;
                }
            }
            ++i;
        }
    }

    void drawExtension(GC gc, TRCMethodInvocation inv, float x, float y, float w, float h) {
        JCanvas c = this.jcanvas();
        if (c == null) {
            return;
        }
        String clss = inv.getMethod().getDefiningClass().getName();
        Color col = SpectrumColorMap.color(clss);
        if ((double)(c.xscale() * w) > 20.0) {
            c.fillRect(gc, x + 3.0f * w / 4.0f, y, w / 4.0f, h, col);
        } else {
            c.fillRect(gc, x + w * 7.0f / 8.0f, y, w / 8.0f, h, col);
        }
    }

    protected void drawGC(GC gc, int offx, int offy) {
        JCanvas c = this.jcanvas();
        if (this.isDirty() || c == null || (float)(offx + this.gcWidth()) < c.visibleLeft()) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        float yscale = c.yscale();
        float lasty = 0.0f;
        this._canvasVisibleBottom = c.visibleBottom();
        this._canvasVisibleTop = c.visibleTop();
        ITraceSelection selModel = UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject());
        Object[] classes = PerftraceUtil.getAllClasses(this._parent.getPage().getMOFObject());
        int idx = 0;
        while (idx < classes.length) {
            TRCClass clas = (TRCClass)classes[idx];
            ArrayList objects = new ArrayList();
            objects.addAll(clas.getObjects());
            objects.addAll(clas.getClassObjects());
            int i = 0;
            while (i < objects.size()) {
                TRCFullTraceObject o;
                float y;
                if (objects.get(i) instanceof TRCFullTraceObject && (y = (float)TString.getTime((double)(o = (TRCFullTraceObject)objects.get(i)).getCollectTime()) * this.timescale + (float)this.titleMargin()) != 0.0f) {
                    if (this.isDirty()) {
                        return;
                    }
                    if (y > this._canvasVisibleBottom) break;
                    if (!(y < this._canvasVisibleTop)) {
                        if (selModel.contains((Object)o)) {
                            c.fill3DRect(gc, offx, (float)offy + y, this.gcWidth(), this.cellHeight() * 2, SpectrumColorMap.getSelectionColor());
                        }
                        if (!((y - lasty) * yscale < 1.0f)) {
                            TRCClass cls = PerftraceUtil.getClass((TRCObject)o);
                            lasty = y;
                            Color ocolor = SpectrumColorMap.color(cls.toString());
                            c.fillRect(gc, offx, (float)offy + y, this.cellWidth() * 5, this.cellHeight() * 2, ocolor);
                        }
                    }
                }
                ++i;
            }
            ++idx;
        }
        float fontheight = (float)gc.getFontMetrics().getHeight() / c.yscale();
        c.drawString(gc, TraceUIPlugin.getString("STR_GC"), offx, c.visibleTop() + fontheight, display.getSystemColor(9));
    }

    void drawInvocation(GC gc, TRCMethodInvocation inv, float x, float y, float w, float h, boolean showString, boolean drawFaded) {
        JCanvas c = this.jcanvas();
        if (c == null) {
            return;
        }
        String msg = inv.getMethod().getName();
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        Color colmsg = display.getSystemColor(2);
        if ((inv.getMethod().getModifier() & 0x80) != 0) {
            colmsg = display.getSystemColor(3);
        }
        double collectTime = 0.0;
        TRCTraceObject obj = inv.getOwningObject();
        if (obj instanceof TRCFullTraceObject) {
            collectTime = ((TRCFullTraceObject)obj).getCollectTime();
        }
        TRCClass cls = PerftraceUtil.getClass(inv);
        String clss = cls.getName();
        Color col = SpectrumColorMap.color(clss);
        float xscale = c.xscale();
        if (showString && (double)xscale > 0.5 && !this._hidedetails) {
            int maxchars = (int)(w * xscale / 5.0f);
            if (msg.length() > maxchars) {
                msg = msg.substring(0, maxchars);
            }
            float fontheight = (float)gc.getFontMetrics().getHeight() / c.yscale();
            c.drawString(gc, msg, x, y + fontheight, colmsg);
        }
        if ((double)(xscale * w) > 20.0) {
            c.drawLine(gc, x, y, x + 3.0f * w / 4.0f, y, colmsg);
            if (!this._collectedempty) {
                c.fillRect(gc, x + 3.0f * w / 4.0f, y, w / 4.0f, h, col);
            } else if (collectTime > 0.0) {
                c.drawRect(gc, x + 3.0f * w / 4.0f, y, w / 4.0f, h, col);
            } else {
                c.fillRect(gc, x + 3.0f * w / 4.0f, y, w / 4.0f, h, col);
            }
        } else {
            c.fillRect(gc, x + w / 4.0f, y, w * 3.0f / 4.0f, h, col);
        }
    }

    void drawRepetition(GC gc, TRCMethodInvocation invocation, int depth, float offx, float offy, int starti, LinearPattern lp) {
        float endword;
        float heightword;
        float firstend;
        float endrec;
        JCanvas canvas = this.jcanvas();
        if (canvas == null || !(invocation instanceof TRCFullMethodInvocation)) {
            return;
        }
        TRCFullMethodInvocation inv = (TRCFullMethodInvocation)invocation;
        double maxtime = inv.getOwningObject().getProcess().getLastEventTime();
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        float yscale = canvas.yscale();
        int repet = lp.repetition(starti);
        int len = lp.length(starti);
        double time = ((TRCFullMethodInvocation)((TRCMethodInvocation)inv.getInvokes().get(starti))).getEntryTime();
        if (time == 0.0) {
            time = maxtime;
        }
        float startrec = (float)PerftraceUtil.getTime(time) * this.timescale + offy;
        time = ((TRCFullMethodInvocation)((TRCMethodInvocation)inv.getInvokes().get(starti + repet * len - 1))).getExitTime();
        if (time == 0.0) {
            time = maxtime;
        }
        if ((endrec = (float)PerftraceUtil.getTime(time) * this.timescale + offy) < startrec) {
            endrec = (float)PerftraceUtil.getTime(((TRCFullMethodInvocation)((TRCMethodInvocation)inv.getInvokes().get(starti + repet * len - 1))).getEntryTime()) * this.timescale + offy;
        }
        float heightrec = endrec - startrec;
        canvas.fill3DRect(gc, offx + (float)((4 * depth + 4) * this.cellWidth()), startrec, 8 * this.cellWidth(), heightrec, display.getSystemColor(15));
        canvas.fill3DRect(gc, offx + (float)((4 * depth + 6) * this.cellWidth()), startrec + heightrec / 40.0f, 5.5f * (float)this.cellWidth(), heightrec * 0.95f, display.getSystemColor(15));
        if (heightrec * yscale < 5.0f) {
            return;
        }
        canvas.drawLine(gc, offx + (float)((4 * depth + 5) * this.cellWidth()) + 5.0f, startrec, offx + (float)((4 * depth + 6) * this.cellWidth()), startrec + heightrec / 40.0f, display.getSystemColor(15));
        time = ((TRCFullMethodInvocation)((TRCMethodInvocation)inv.getInvokes().get(starti + len - 1))).getExitTime();
        if (time == 0.0) {
            time = maxtime;
        }
        if ((firstend = (float)PerftraceUtil.getTime(time) * this.timescale + offy) < startrec) {
            firstend = startrec;
        }
        canvas.drawLine(gc, offx + (float)((4 * depth + 5) * this.cellWidth()) + 5.0f, firstend, offx + (float)((4 * depth + 6) * this.cellWidth()), startrec + heightrec * 0.975f, display.getSystemColor(15));
        if (repet < 1000) {
            int k = 0;
            while (k < repet) {
                float heightsmall;
                float startsmall = (float)PerftraceUtil.getTime(((TRCFullMethodInvocation)((TRCMethodInvocation)inv.getInvokes().get(starti + k * len))).getEntryTime()) * this.timescale + offy;
                time = ((TRCFullMethodInvocation)((TRCMethodInvocation)inv.getInvokes().get(starti + k * len + len - 1))).getExitTime();
                if (time == 0.0) {
                    time = maxtime;
                }
                if ((heightsmall = (float)PerftraceUtil.getTime(time) * this.timescale + offy - startsmall) < 0.0f) {
                    heightsmall = 0.0f;
                }
                canvas.fill3DRect(gc, offx + (float)((4 * depth + 4) * this.cellWidth()) + 5.0f, startsmall, this.cellWidth(), heightsmall, display.getSystemColor(15));
                ++k;
            }
        }
        if ((time = ((TRCFullMethodInvocation)((TRCMethodInvocation)inv.getInvokes().get(starti + len - 1))).getExitTime()) == 0.0) {
            time = maxtime;
        }
        if ((heightword = (endword = (float)PerftraceUtil.getTime(time) * this.timescale + offy) - startrec) < 0.0f) {
            heightword = 0.0f;
        }
        float ratio = 1.0f;
        if (heightword > 0.0f) {
            ratio = (endrec - startrec) / heightword * 0.9f;
        }
        int j = 0;
        while (j < len) {
            TRCFullMethodInvocation kid1 = (TRCFullMethodInvocation)((TRCMethodInvocation)inv.getInvokes().get(starti + j));
            float start1 = (float)PerftraceUtil.getTime(kid1.getEntryTime()) * this.timescale + offy;
            time = kid1.getExitTime();
            if (time == 0.0) {
                time = maxtime;
            }
            float end1 = (float)PerftraceUtil.getTime(time) * this.timescale + offy;
            float h1 = end1 - start1;
            float startmag = startrec + (start1 - startrec) * ratio + heightrec / 20.0f;
            float hmag = h1 * ratio;
            this.drawInvocation(gc, (TRCMethodInvocation)kid1, offx + (float)((4 * depth + 7) * this.cellWidth()), startmag, this.cellWidth() * 4, hmag, true, false);
            ++j;
        }
        canvas.drawString(gc, " X " + Integer.toString(repet), offx + (float)((4 * depth + 6) * this.cellWidth()), startrec + heightrec * 0.97f, display.getSystemColor(2));
    }

    protected void drawThread(GC gc, TRCThread thread, float offx, float offy) {
        JCanvas canvas = this.jcanvas();
        if (canvas == null) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        float fontheight = (float)gc.getFontMetrics().getHeight() / canvas.yscale();
        canvas.drawLine(gc, offx, canvas.visibleTop(), offx, canvas.visibleBottom(), display.getSystemColor(2));
        int numCharsToShow = (int)(canvas.xscale() * (float)this.treeWidth() / (float)gc.getFontMetrics().getAverageCharWidth());
        String threadName = PerftraceUtil.getThreadName(thread);
        if (threadName.length() > numCharsToShow) {
            threadName = numCharsToShow > 4 ? threadName.substring(0, numCharsToShow - 3) + "..." : "";
        }
        canvas.drawString(gc, threadName, offx, canvas.visibleTop() + fontheight, display.getSystemColor(9));
        this._canvasVisibleBottom = canvas.visibleBottom();
        this._canvasVisibleTop = canvas.visibleTop();
        this._canvasVisibleLeft = canvas.visibleLeft();
        this._canvasVisibleRight = canvas.visibleRight();
        this.initDrawArray();
        Object[] invocations = thread.getInitialInvocations().toArray();
        int idx = 0;
        while (idx < invocations.length) {
            this.drawTree(gc, (TRCMethodInvocation)thread.getInitialInvocations().get(idx), 0, offx, offy + (float)this.titleMargin());
            ++idx;
        }
        this.flushDrawArray(gc);
    }

    protected void drawTimeMarks(GC gc, int offx, int offy) {
        JCanvas c = this.jcanvas();
        if (this.isDirty() || c == null) {
            return;
        }
        float margin = 50.0f / c.xscale();
        float rightvis = c.visibleRight();
        long toptime = (long)((c.visibleTop() - (float)this.titleMargin()) / this.timescale);
        long heighttime = (long)(c.visibleHeight() / this.timescale);
        long interval = heighttime / 10L;
        float x = rightvis - margin;
        float fontheight = (float)gc.getFontMetrics().getHeight() / c.yscale();
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (this._visibleThreads.size() == 0 && this._parent.getPage().isEmpty()) {
            return;
        }
        if (interval > 1L) {
            long niceinterval = (long)Math.pow(10.0, (int)(Math.log(interval) / Math.log(10.0)) + 1) / 2L;
            long newtoptime = niceinterval * (toptime / niceinterval + 1L);
            int i = 0;
            while (i < 20) {
                long timemark = newtoptime + (long)i * niceinterval;
                float y = (float)timemark * this.timescale + (float)this.titleMargin();
                c.drawString(gc, PerftraceUtil.formatTimeValue((double)timemark / 1000000.0), (float)offx + x, (float)offy + y, display.getSystemColor(2), display.getSystemColor(1));
                ++i;
            }
        }
        c.drawString(gc, TraceUIPlugin.getString("STR_GRAPH_UNIT"), (float)offx + x - 20.0f, c.visibleTop() + fontheight, display.getSystemColor(2), display.getSystemColor(1));
    }

    protected void drawTree(GC gc, TRCMethodInvocation invocation, int depth, float offx, float offy) {
        JCanvas canvas = this.jcanvas();
        if (invocation == null || !(invocation instanceof TRCFullMethodInvocation) || this.isDirty() || canvas == null) {
            return;
        }
        TRCFullMethodInvocation inv = (TRCFullMethodInvocation)invocation;
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        long start = PerftraceUtil.getTime(inv.getEntryTime());
        long end = PerftraceUtil.getTime(inv.getExitTime());
        if (end <= 0L) {
            end = this._maxtime;
        }
        if (offy + (float)start * this.timescale > this._canvasVisibleBottom || offy + (float)end * this.timescale < this._canvasVisibleTop) {
            return;
        }
        if (depth > this._maxdepth) {
            this._maxdepth = depth;
        }
        float height = (float)(end - start) * this.timescale;
        if (this._hidedetails && canvas.yscale() * height < 10.0f) {
            return;
        }
        boolean selected = false;
        ITraceSelection selmodel = UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject());
        if (selmodel.contains((Object)inv) || selmodel.contains((Object)inv.getMethod())) {
            canvas.fill3DRect(gc, offx + (float)(4 * depth * this.cellWidth()), offy + (float)start * this.timescale, this.treeWidth() - 4 * depth * this.cellWidth(), height, SpectrumColorMap.getSelectionColor());
            selected = true;
        } else if (selmodel.contains((Object)inv.getOwningObject())) {
            canvas.fill3DRect(gc, offx + (float)((4 * depth + 3) * this.cellWidth()) - 5.0f, offy + (float)start * this.timescale, (float)(this.treeWidth() - (4 * depth + 3) * this.cellWidth()) + 5.0f, height, SpectrumColorMap.getSelectionColor());
            selected = true;
        }
        if (offx + (float)((depth + 1) * this.cellWidth() * 4) < this._canvasVisibleRight) {
            Object[] segments = inv.getInvokes().toArray();
            LinearPattern lp = this.linearPattern((TRCMethodInvocation)inv);
            int i = 0;
            while (i < segments.length) {
                TRCMethodInvocation vkid = (TRCMethodInvocation)segments[i];
                if (vkid instanceof TRCFullMethodInvocation) {
                    int repet;
                    TRCFullMethodInvocation kid = (TRCFullMethodInvocation)vkid;
                    if (lp == null || (repet = lp.repetition(i)) == 1) {
                        if ((float)PerftraceUtil.getTime(kid.getEntryTime()) * this.timescale + offy > this._canvasVisibleBottom) break;
                        long kidend = PerftraceUtil.getTime(kid.getExitTime());
                        if (kidend <= 0L) {
                            kidend = this._maxtime;
                        }
                        if (!((float)kidend * this.timescale + offy < this._canvasVisibleTop)) {
                            this.drawTree(gc, (TRCMethodInvocation)kid, depth + 1, offx, offy);
                        }
                    } else if (!this._hidedetails) {
                        int len = lp.length(i);
                        if (repet == 0 || len == 0) {
                            System.err.println("linpattern impossible (fanout :" + segments.length + ")");
                        } else {
                            this.drawRepetition(gc, (TRCMethodInvocation)inv, depth, offx, offy, i, lp);
                            i += len * repet - 1;
                        }
                    }
                }
                ++i;
            }
        }
        if (depth < 256) {
            this.push(gc, depth, (TRCMethodInvocation)inv, offx + (float)(depth * this.cellWidth() * 4), offy + (float)start * this.timescale, this.cellWidth() * 4, height);
        } else {
            this.drawInvocation(gc, (TRCMethodInvocation)inv, offx + (float)(depth * this.cellWidth() * 4), offy + (float)start * this.timescale, this.cellWidth() * 4, height, true, !selected && UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject()).size() > 1);
        }
        this.extendToCanvas((TRCMethodInvocation)inv);
    }

    private void extendToCanvas(TRCMethodInvocation inv) {
        TRCThread thread = inv.getMethod().getDefiningClass().getLoadedBy();
        if (thread == null || !(inv instanceof TRCFullMethodInvocation)) {
            return;
        }
        TRCFullMethodInvocation curinv = (TRCFullMethodInvocation)inv;
        int column = this._visibleThreads.indexOf(thread);
        long start = PerftraceUtil.getTime(curinv.getEntryTime());
        long end = PerftraceUtil.getTime(curinv.getExitTime());
        float y = (float)start * this.timescale + (float)this.titleMargin();
        float maxX = (float)(this.treeWidth() * column + this.gcWidth()) + 1.0f;
        float maxY = y;
        Object tmp = curinv;
        int depth = -1;
        while (tmp != null) {
            ++depth;
            tmp = tmp.getInvokedBy() != null ? tmp.getInvokedBy() : null;
        }
        maxX = Math.max(maxX, (float)(this.treeWidth() * column + this.gcWidth() + (depth + 1) * this.cellWidth() * 4));
        this.jcanvas().extendedTo(maxX, maxY);
    }

    public void fillContextMenu(IMenuManager menu) {
        ThreadAction action;
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.rep1);
        menu.add((IAction)this.rep2);
        menu.add((IContributionItem)this.fSeparator);
        MenuManager popup1 = new MenuManager(TraceUIPlugin.getString("STR_THREADS"));
        menu.add((IContributionItem)popup1);
        popup1.add((IAction)this._showAll);
        popup1.add((IAction)this._hideAll);
        popup1.add((IContributionItem)this.fSeparator);
        this._gcThread.setText(this._gcThread.getName());
        this._gcThread.setChecked(this._drawgc);
        popup1.add((IAction)this._gcThread);
        Object[] threads = PerftraceUtil.getAllThreads(this._parent.getPage().getMOFObject());
        int i = 0;
        while (i < threads.length) {
            TRCThread thread = (TRCThread)threads[i];
            if (!this.hasThread(thread)) {
                action = new ThreadAction();
                action.setThread(thread);
                this._popupThreads.add(action);
            }
            ++i;
        }
        int idx = 0;
        while (idx < this._popupThreads.size()) {
            action = (ThreadAction)((Object)this._popupThreads.get(idx));
            action.setText(action.getName());
            action.setChecked(this._visibleThreads.contains(action.getThread()));
            popup1.add((IAction)action);
            ++idx;
        }
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IContributionItem)this.fSeparator);
        super.fillContextMenu(menu);
    }

    protected void flushDrawArray(GC gc) {
        ITraceSelection selModel = UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject());
        int i = 0;
        while (i < 256) {
            if (this._drawArray[i] != null) {
                this.drawInvocation(gc, this._drawArray[i], this._x[i], this._y[i], this._w[i], this._h[i], true, selModel.size() > 1 && !selModel.contains((Object)this._drawArray[i].getOwningObject()) && !selModel.contains((Object)this._drawArray[i].getMethod()));
                this._drawArray[i] = null;
            }
            ++i;
        }
    }

    protected int gcWidth() {
        return this._drawgc ? 300 : 100;
    }

    protected boolean hasThread(TRCThread thread) {
        int i = 0;
        while (i < this._popupThreads.size()) {
            ThreadAction action = (ThreadAction)((Object)this._popupThreads.get(i));
            if (action.getThread() == thread) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public float height() {
        double mt = PerftraceUtil.getMaximumTime(this._parent.getPage().getMOFObject());
        if (mt == 0.0) {
            mt = 1.0;
        }
        this._maxtime = PerftraceUtil.getTime(mt);
        return (float)this._maxtime * this.timescale + (float)this.titleMargin() + (float)(10 * this.cellHeight());
    }

    protected void initDrawArray() {
        int i = 0;
        while (i < 256) {
            this._drawArray[i] = null;
            this._h[i] = 0.0f;
            this._w[i] = 0.0f;
            this._y[i] = 0.0f;
            this._x[i] = 0.0f;
            ++i;
        }
    }

    public void keyPressed(KeyEvent e) {
        JCanvas canvas = this.jcanvas();
        if (canvas == null) {
            return;
        }
        if (e.keyCode == 262144) {
            this._controlDown = true;
        } else if (e.keyCode == 0x1000007) {
            canvas.zoomToFit();
        } else {
            float x = canvas.normX(canvas.getSize().width / 2);
            float y = canvas.normY(canvas.getSize().height / 2);
            if (e.character == ',' || e.character == '<') {
                canvas.zoom(1.0f, 0.5f, x, y);
            } else if (e.character == '.' || e.character == '>') {
                canvas.zoom(1.0f, 2.0f, x, y);
            }
        }
    }

    protected LinearPattern linearPattern(TRCMethodInvocation inv) {
        return (LinearPattern)this._foldedInvocations.get(inv);
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 3) {
            return;
        }
        super.mouseDown(e);
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 3) {
            return;
        }
        super.mouseUp(e);
    }

    public void moved(float x, float y) {
        if (x <= (float)this.gcWidth()) {
            Object[] classes = PerftraceUtil.getAllClasses(this._parent.getPage().getMOFObject());
            int idx = 0;
            while (idx < classes.length) {
                TRCClass clas = (TRCClass)classes[idx];
                ArrayList objects = new ArrayList();
                objects.addAll(clas.getObjects());
                objects.addAll(clas.getClassObjects());
                int i = 0;
                while (i < objects.size()) {
                    TRCFullTraceObject o;
                    if (objects.get(i) instanceof TRCFullTraceObject && (o = (TRCFullTraceObject)objects.get(i)).getCollectTime() != 0.0) {
                        float yo = (float)TString.getTime((double)o.getCollectTime()) * this.timescale + (float)this.titleMargin();
                        if (y >= yo) {
                            if (y <= yo + (float)(this.cellHeight() * 2)) {
                                String statusMsg = TraceUIPlugin.getString("GC_ED_OBJECT");
                                statusMsg = TString.change((String)statusMsg, (String)"%1", (String)(PerftraceUtil.getClass((TRCObject)o).getName() + "." + o.getId()));
                                this.status(statusMsg);
                                return;
                            }
                        } else {
                            this.status(TraceUIPlugin.getString("STR_GC"));
                            return;
                        }
                    }
                    ++i;
                }
                ++idx;
            }
            this.status(TraceUIPlugin.getString("STR_GC"));
            return;
        }
        int threadnumber = (int)((x -= (float)this.gcWidth()) / (float)this.treeWidth());
        if (threadnumber < 0 || threadnumber >= this._visibleThreads.size()) {
            long tm = (long)((y - (float)this.titleMargin()) / this.timescale);
            String statusMsg = TraceUIPlugin.getString("TIME_X");
            statusMsg = TString.change((String)statusMsg, (String)"%1", (String)String.valueOf(tm));
            this.status(statusMsg);
            return;
        }
        TRCThread thread = (TRCThread)this._visibleThreads.get(threadnumber);
        x %= (float)this.treeWidth();
        Object[] segments = thread.getInitialInvocations().toArray();
        int idx = 0;
        while (idx < segments.length) {
            TRCMethodInvocation inv = this.subtreeContains((TRCMethodInvocation)segments[idx], x, y, 0);
            if (inv != null && inv instanceof TRCFullMethodInvocation) {
                TRCFullMethodInvocation selinv = (TRCFullMethodInvocation)inv;
                TRCTraceObject obj = selinv.getOwningObject();
                String implname = selinv.getMethod().getDefiningClass().getName();
                String msgname = selinv.getMethod().getName();
                String objclname = obj.getIsA().getName();
                double time = selinv.getExitTime();
                if (time == 0.0) {
                    time = obj.getProcess().getLastEventTime();
                }
                String message = TraceUIPlugin.getString("THREAD_A_ON_B_AT_C_TIME");
                if (this._drawMode == 1) {
                    message = TraceUIPlugin.getString("THREAD_A_ON_B_AT_RAW_TIME");
                }
                message = TString.change((String)message, (String)"%1", (String)(PerftraceUtil.getThreadName(thread) + "   " + implname + "." + msgname));
                message = TString.change((String)message, (String)"%2", (String)(objclname + "." + obj.getId()));
                message = TString.change((String)message, (String)"%3", (String)TString.formatTimeValue((double)selinv.getEntryTime()));
                double raw = time - selinv.getEntryTime();
                double compensated = raw - selinv.getOverhead();
                message = TString.change((String)message, (String)"%4", (String)TString.formatTimeValue((double)(this._drawMode == 1 ? raw : compensated)));
                this.status(message);
                return;
            }
            ++idx;
        }
        long tm = (long)((y - (float)this.titleMargin()) / this.timescale);
        String message = TraceUIPlugin.getString("THREAD_A_TIME_X");
        message = TString.change((String)message, (String)"%1", (String)thread.getName());
        message = TString.change((String)message, (String)"%2", (String)TString.formatTimeValue((double)((double)tm / 1000000.0)));
        this.status(message);
    }

    protected void push(GC gc, int i, TRCMethodInvocation inv, float x, float y, float w, float h) {
        JCanvas canvas = this.jcanvas();
        if (i >= 256 || canvas == null) {
            return;
        }
        if (this._drawArray[i] != null) {
            float yscale = canvas.yscale();
            float spaceforstring = (y - this._y[i]) * yscale;
            float spaceforinvoc = (y + h - this._y[i]) * yscale;
            if ((double)spaceforinvoc < 1.0) {
                return;
            }
            this.drawInvocation(gc, this._drawArray[i], this._x[i], this._y[i], this._w[i], this._h[i], (double)spaceforstring > 8.0, true);
        }
        this._drawArray[i] = inv;
        this._x[i] = x;
        this._y[i] = y;
        this._w[i] = w;
        this._h[i] = h;
    }

    public void redraw() {
        this._visibleThreads.clear();
        Object[] threads = PerftraceUtil.getAllThreads(this._parent.getPage().getMOFObject());
        int idx = 0;
        while (idx < threads.length) {
            this._visibleThreads.add(threads[idx]);
            ++idx;
        }
        this.jcanvas().zoomToFill(1.0f, 1000.0f);
        this.jcanvas().redraw();
    }

    protected void removeLinearPatterns() {
        this._foldedInvocations.clear();
    }

    protected void removeLinearPatterns(TRCMethodInvocation root) {
        this._foldedInvocations.remove(root);
        Object[] segments = root.getInvokes().toArray();
        int i = 0;
        while (i < segments.length) {
            this.removeLinearPatterns((TRCMethodInvocation)segments[i]);
            ++i;
        }
    }

    public void selected(float x, float y, boolean shiftdown, boolean controldown, boolean metadown) {
        ITraceSelection _selectionmodel = UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject());
        float origx = x;
        float origy = y;
        if (x <= (float)this.gcWidth() && metadown) {
            return;
        }
        int threadnumber = (int)((x -= (float)this.gcWidth()) / (float)this.treeWidth());
        if (threadnumber < 0 || threadnumber >= this._visibleThreads.size()) {
            return;
        }
        TRCThread thread = (TRCThread)this._visibleThreads.get(threadnumber);
        x %= (float)this.treeWidth();
        Object[] invocations = thread.getInitialInvocations().toArray();
        int idx = 0;
        while (idx < invocations.length) {
            TRCMethodInvocation selinv = this.subtreeContains((TRCMethodInvocation)invocations[idx], x, y, 0);
            _selectionmodel.add((Object)selinv);
            ++idx;
        }
        ViewSelectionChangedEvent event = UIPlugin.getDefault().getViewSelectionChangedEvent();
        event.setSource((Object)this._parent.getPage().getMOFObject());
        UIPlugin.getDefault().notifyViewSelectionChangedListener(event);
    }

    public void shutdown() {
        this._parent = null;
        this._foldedInvocations.clear();
        this._hideAll = null;
        this._showAll = null;
        this.rep1 = null;
        this.rep2 = null;
        this._visibleThreads.clear();
        int idx = 0;
        while (idx < this._popupThreads.size()) {
            ((ThreadAction)((Object)this._popupThreads.get(idx))).setThread(null);
            ++idx;
        }
        this._popupThreads.clear();
        this._gcThread = null;
    }

    protected void status(String s) {
        this._parent.updateStatus(s);
    }

    protected TRCMethodInvocation subtreeContains(TRCMethodInvocation invocation, float xs, float ys, int d) {
        if (invocation == null || !(invocation instanceof TRCFullMethodInvocation)) {
            return null;
        }
        TRCFullMethodInvocation inv = (TRCFullMethodInvocation)invocation;
        int depth = (int)(xs / (float)this.cellWidth() / 4.0f);
        if (d == depth) {
            float startrec = (float)PerftraceUtil.getTime(inv.getEntryTime()) * this.timescale + (float)this.titleMargin();
            double time = inv.getExitTime();
            if (time == 0.0) {
                TRCTraceObject obj = inv.getOwningObject();
                time = obj.getProcess().getLastEventTime();
            }
            float endrec = (float)PerftraceUtil.getTime(time) * this.timescale + (float)this.titleMargin();
            if (ys >= startrec && ys <= endrec) {
                return inv;
            }
            return null;
        }
        if (d > depth) {
            return null;
        }
        LinearPattern lp = null;
        if (xs / (float)this.cellWidth() > (float)((d + 1) * 4 + 2)) {
            lp = this.linearPattern((TRCMethodInvocation)inv);
        }
        Object[] segments = inv.getInvokes().toArray();
        int i = 0;
        while (i < segments.length) {
            int repet;
            TRCFullMethodInvocation calleeinv = (TRCFullMethodInvocation)segments[i];
            if (ys < (float)PerftraceUtil.getTime(calleeinv.getEntryTime()) * this.timescale + (float)this.titleMargin()) {
                return null;
            }
            if (lp == null || (repet = lp.repetition(i)) == 1) {
                if (calleeinv.getExitTime() == 0.0 || (float)PerftraceUtil.getTime(calleeinv.getExitTime()) * this.timescale + (float)this.titleMargin() >= ys) {
                    return this.subtreeContains((TRCMethodInvocation)calleeinv, xs, ys, d + 1);
                }
            } else {
                int len = lp.length(i);
                if (i >= segments.length) {
                    return null;
                }
                float startrec = (float)PerftraceUtil.getTime(calleeinv.getEntryTime()) * this.timescale + (float)this.titleMargin();
                TRCFullMethodInvocation inv2 = (TRCFullMethodInvocation)segments[i + repet * len - 1];
                float endrec = (float)PerftraceUtil.getTime(inv2.getExitTime()) * this.timescale + (float)this.titleMargin();
                if (ys >= startrec && ys <= endrec) {
                    if (lp != null && repet > 1 && xs / (float)this.cellWidth() > (float)((d + 1) * 4 + 7)) {
                        return null;
                    }
                    float heightrec = endrec - startrec;
                    TRCFullMethodInvocation inv3 = (TRCFullMethodInvocation)segments[i + len - 1];
                    float endword = (float)PerftraceUtil.getTime(inv3.getExitTime()) * this.timescale + (float)this.titleMargin();
                    float heightword = endword - startrec;
                    if (heightword < 0.0f) {
                        heightword = 0.0f;
                    }
                    float ratio = 1.0f;
                    if (heightword > 0.0f) {
                        ratio = (endrec - startrec) / heightword * 0.9f;
                    }
                    int j = 0;
                    while (j < len) {
                        TRCFullMethodInvocation kid1 = (TRCFullMethodInvocation)segments[i + j];
                        float start1 = (float)PerftraceUtil.getTime(kid1.getEntryTime()) * this.timescale + (float)this.titleMargin();
                        float end1 = (float)PerftraceUtil.getTime(kid1.getExitTime()) * this.timescale + (float)this.titleMargin();
                        float h1 = end1 - start1;
                        float startmag = startrec + (start1 - startrec) * ratio + heightrec / 20.0f;
                        float hmag = h1 * ratio;
                        if (ys < startmag) {
                            return null;
                        }
                        if (ys < startmag + hmag) {
                            return kid1;
                        }
                        ++j;
                    }
                }
                i += len * repet - 1;
            }
            ++i;
        }
        return null;
    }

    public String title() {
        return "";
    }

    protected int titleMargin() {
        return 0;
    }

    protected int treeWidth() {
        if (this._maxdepth == 0) {
            int idx = 0;
            while (idx < this._visibleThreads.size()) {
                TRCThread thread = (TRCThread)this._visibleThreads.get(idx);
                if (this._maxdepth < thread.getMaxStackDepth()) {
                    this._maxdepth = thread.getMaxStackDepth();
                }
                ++idx;
            }
        }
        return this.cellWidth() * 4 * (10 + this._maxdepth / 10 * 10);
    }

    public float width() {
        float width = (float)(this.gcWidth() + this._visibleThreads.size() * this.treeWidth()) + 1.0f;
        return width;
    }

    public void setDrawMode(int drawMode) {
        this._drawMode = drawMode;
    }

    class ThreadAction
    extends Action {
        protected TRCThread _thread;
        protected String _name = "";

        public ThreadAction() {
            super("");
        }

        public void setThread(TRCThread thread) {
            this._thread = thread;
            if (this._thread != null) {
                this._name = PerftraceUtil.getThreadName(thread);
            }
        }

        public void setName(String name) {
            this._name = name;
        }

        public TRCThread getThread() {
            return this._thread;
        }

        public String getName() {
            return this._name;
        }

        public void run() {
            if (PatternDrawStrategy.this.jcanvas() == null) {
                return;
            }
            if (this.getName().equals(TraceUIPlugin.getString("STR_GC"))) {
                PatternDrawStrategy.this._drawgc = !PatternDrawStrategy.this._drawgc;
            } else if (PatternDrawStrategy.this._visibleThreads.contains(this._thread)) {
                PatternDrawStrategy.this._visibleThreads.remove(this._thread);
            } else {
                PatternDrawStrategy.this._visibleThreads.add(this._thread);
            }
            PatternDrawStrategy.this._maxdepth = 0;
            PatternDrawStrategy.this._maxtime = 0L;
            PatternDrawStrategy.this.resetArea();
            PatternDrawStrategy.this.jcanvas().zoomToFill(1.0f, 1000.0f);
            PatternDrawStrategy.this.jcanvas().redraw();
        }
    }

    class ShowAllThreadsAction
    extends Action {
        public ShowAllThreadsAction(String name) {
            super(name);
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".exef0006"));
        }

        public void run() {
            if (PatternDrawStrategy.this.jcanvas() == null) {
                return;
            }
            Object[] threads = PerftraceUtil.getAllThreads(PatternDrawStrategy.this._parent.getPage().getMOFObject());
            int idx = 0;
            while (idx < threads.length) {
                int i = 0;
                i = 0;
                while (i < PatternDrawStrategy.this._visibleThreads.size()) {
                    if (PatternDrawStrategy.this._visibleThreads.get(i) == threads[idx]) break;
                    ++i;
                }
                if (i == PatternDrawStrategy.this._visibleThreads.size()) {
                    PatternDrawStrategy.this._visibleThreads.add(threads[idx]);
                }
                ++idx;
            }
            PatternDrawStrategy.this._maxdepth = 0;
            PatternDrawStrategy.this._drawgc = true;
            PatternDrawStrategy.this.resetArea();
            PatternDrawStrategy.this.jcanvas().zoomToFill(1.0f, 1000.0f);
            PatternDrawStrategy.this.jcanvas().redraw();
        }
    }

    class HideAllThreadsAction
    extends Action {
        public HideAllThreadsAction(String name) {
            super(name);
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".exef0007"));
        }

        public void run() {
            if (PatternDrawStrategy.this.jcanvas() == null) {
                return;
            }
            PatternDrawStrategy.this._visibleThreads.clear();
            PatternDrawStrategy.this._drawgc = false;
            PatternDrawStrategy.this.jcanvas().zoomToFill(1.0f, 1000.0f);
            PatternDrawStrategy.this.jcanvas().redraw();
        }
    }

    class HideAllRepetitionsAction
    extends Action {
        public HideAllRepetitionsAction(String name) {
            super(name);
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".exef0005"));
        }

        public void run() {
            if (PatternDrawStrategy.this.jcanvas() == null) {
                return;
            }
            PatternDrawStrategy.this.removeLinearPatterns();
            PatternDrawStrategy.this.jcanvas().redraw();
        }
    }

    class DetectAllRepetitionsdAction
    extends Action {
        public DetectAllRepetitionsdAction(String name) {
            super(name);
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".exef0004"));
        }

        public void run() {
            if (PatternDrawStrategy.this.jcanvas() == null) {
                return;
            }
            PatternDrawStrategy.this.detectLinearPatterns();
            PatternDrawStrategy.this.jcanvas().redraw();
        }
    }
}

