/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.common.internal;

import java.io.IOException;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.utils.internal.DCAgentCommandUtil;
import org.eclipse.hyades.perfmon.utils.internal.SetVariableCommand;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDVariableLoader;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDVariableModifierProxy;
import org.eclipse.swt.widgets.Display;

public class CommonModifierProxy
implements SDVariableModifierProxy {
    public static final double DEFAULT_FREQUENCY = 1.0;
    DCAgentCommandUtil command;
    protected StatConInterface statcon;
    protected SDVariableLoader varloader;
    protected SDModifiableVariableRepresentation freq_var;
    protected double frequency = 1.0;
    protected TRCAgent agent;
    VariablePadder padder;
    public static final String ID_PERFMON_FREQUENCY = "PERFMON#FREQUENCY";

    public SDModifiableVariableRepresentation getFrequencyVariable() {
        return this.freq_var;
    }

    protected CommonModifierProxy(StatConInterface statcon, TRCAgent agent) {
        this.statcon = statcon;
        this.agent = agent;
    }

    public CommonModifierProxy(DCAgentCommandUtil command, StatConInterface statcon, TRCAgent agent) {
        this.command = command;
        this.statcon = statcon;
        this.agent = agent;
        this.init();
    }

    protected void init() {
        this.varloader = new SDVariableLoader(this.agent, PerfmonPlugin.getString("PERFMON_CONTROLS"));
        PerfmonPlugin.DBG.info("Creating frequency variable");
        this.freq_var = this.varloader.createSDModifiableVariable(ID_PERFMON_FREQUENCY, PerfmonPlugin.getString("FREQUENCY_SEC"), PerfmonPlugin.getString("FREQUENCY_DESCRIPTION"), null, false, 3, 3, PerfmonPlugin.getString("FREQUENCY"), PerfmonPlugin.getString("PERFMON_CONTROLS"), (SDVariableModifierProxy)this, 0.5, Double.MAX_VALUE);
        Display.getDefault().syncExec((Runnable)new DisplayInit());
    }

    public void requestValue(String unique_id, int i) throws ClassCastException {
        this.requestValue(unique_id, (double)i);
    }

    public void requestValue(String unique_id, long i) throws ClassCastException {
        this.requestValue(unique_id, (double)i);
    }

    public void requestValue(String unique_id, float i) throws ClassCastException {
        this.requestValue(unique_id, (double)i);
    }

    public void requestValue(String unique_id, double d) throws ClassCastException {
        block3: {
            if (!unique_id.equals(ID_PERFMON_FREQUENCY)) break block3;
            if (d < 0.5) {
                d = 0.5;
            }
            int i = (int)(d * 1000.0);
            try {
                SetVariableCommand fcommand = new SetVariableCommand("DC_WAITTIME", i);
                this.command.setVariable(fcommand);
                this.frequency = d;
                this.freq_var.setMeasuredValue(System.currentTimeMillis(), d);
            }
            catch (IOException e) {
                PerfmonPlugin.DBG.logVisibleError((Throwable)e, PerfmonPlugin.getString("ERROR_SETTING_FREQUENCY") + " " + i, false);
            }
        }
    }

    public void requestValue(String unique_id, Object newval) throws ClassCastException {
        this.requestValue(unique_id, ((Number)newval).doubleValue());
    }

    public void shutdown() {
        this.padder.die = true;
    }

    class DisplayInit
    implements Runnable {
        DisplayInit() {
        }

        public void run() {
            try {
                PerfmonPlugin.DBG.info("Setting requested frequency to 1.0");
                CommonModifierProxy.this.freq_var.setRequestedValue(System.currentTimeMillis(), 1.0);
                CommonModifierProxy.this.padder = new VariablePadder();
                CommonModifierProxy.this.padder.start();
            }
            catch (Throwable e) {
                PerfmonPlugin.DBG.logVisibleError(e, PerfmonPlugin.getString("ERROR_STATCON_UPDATE") + " (3)", true);
            }
        }
    }

    class VariablePadder
    extends Thread {
        boolean die = false;

        public VariablePadder() {
            this.setDaemon(true);
        }

        public void run() {
            while (!this.die) {
                try {
                    Thread.sleep(750L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    CommonModifierProxy.this.freq_var.padRequestedValue(System.currentTimeMillis());
                    CommonModifierProxy.this.freq_var.setMeasuredValue(System.currentTimeMillis(), CommonModifierProxy.this.freq_var.getLastMeasuredValue());
                }
                catch (Exception e) {
                    PerfmonPlugin.DBG.warning("unable to pad variable requested and measured - " + e);
                }
            }
        }
    }
}

