/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.utils.internal.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.utils.internal.launch.HostUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class HostTab
extends AbstractLaunchConfigurationTab {
    public static final String HOSTNAME = "ATTR_HOST";
    public static final String PORT = "ATTR_PORT";
    private String ATTR_HOSTNAME = "ATTR_HOST";
    private String ATTR_PORT = "ATTR_PORT";
    private int DEFAULT_PORT = 10002;
    private HostUI _ui;
    private String _oldHost;
    private int _oldPort = -1;
    private String agentname;

    public HostTab(String agentname) {
        this.agentname = agentname;
        this.ATTR_HOSTNAME = HOSTNAME + agentname;
        this.ATTR_PORT = PORT + agentname;
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite content = new Composite(parent, 0);
        this.setControl((Control)content);
        content.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(content, 1);
        this._ui = new HostUI(this.agentname);
        this._ui.createControl(content);
        this._ui.addListener(new Listener(){

            public void handleEvent(Event event) {
                String host = HostTab.this._ui.getHost();
                int port = HostTab.this._ui.getPort();
                HostTab.this._oldHost = host;
                HostTab.this._oldPort = port;
                HostTab.this.setDirty(true);
                HostTab.this.updateLaunchConfigurationDialog();
                HostTab.this.updatePreferences();
            }
        });
    }

    public boolean isValid(ILaunchConfiguration conf) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this._ui.getHost() == null) {
            this.setErrorMessage(PerfmonPlugin.getString("TAB_ERROR_HOST"));
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
        IPreferenceStore store = PerfmonPlugin.getDefault().getPreferenceStore();
        wc.setAttribute(this.ATTR_HOSTNAME, "localhost");
        wc.setAttribute(this.ATTR_PORT, this.DEFAULT_PORT);
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        IPreferenceStore store = PerfmonPlugin.getDefault().getPreferenceStore();
        try {
            String host = conf.getAttribute(this.ATTR_HOSTNAME, "localhost");
            int port = conf.getAttribute(this.ATTR_PORT, this.DEFAULT_PORT);
            String info = host + ":" + port;
            this._ui.addHost(info);
            this._ui.selectHost(info);
            this._oldHost = host;
            this._oldPort = port;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute(this.ATTR_HOSTNAME, this._ui.getHost());
        wc.setAttribute(this.ATTR_PORT, this._ui.getPort());
    }

    public String getName() {
        return PerfmonPlugin.getString("TAB_NAME_HOST");
    }

    public Image getImage() {
        return PerfmonPlugin.img.getImage("node.gif");
    }

    public boolean isLocal() {
        return this._ui.isLocalHost(this._ui.getHost());
    }

    private void updatePreferences() {
        IPreferenceStore store = PerfmonPlugin.getDefault().getPreferenceStore();
        StringBuffer buf = new StringBuffer();
        TableItem[] items = this._ui.getHosts();
        int idx = 0;
        while (idx < items.length) {
            buf.append(',');
            buf.append(items[idx].getText().trim());
            ++idx;
        }
        String hosts = buf.toString();
        if (hosts.startsWith(",") && hosts.length() > 1) {
            hosts = hosts.substring(1);
        }
        store.setValue(this.ATTR_HOSTNAME, hosts);
    }
}

