/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.ArithmeticExpression;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.NumericFunction;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.models.hierarchy.util.internal.QueryUtils;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.QueryStatement;

public class SimpleSearchQueryStatement
extends QueryStatement {
    protected JDBCHelper helper;
    protected SimpleSearchQuery query;
    protected Set processedAlready = new HashSet();
    protected boolean first = true;
    protected boolean all = false;
    protected Set fromSet = new HashSet();

    public SimpleSearchQueryStatement(JDBCHelper helper, DBMap dbMap, SimpleSearchQuery query) {
        super(helper.getDatabaseType(), dbMap, null);
        this.helper = helper;
        this.query = query;
    }

    protected void createOrderClause() {
        this.first = true;
        this.processedAlready.clear();
        this.processOrderByExpressionsInOrderByClause();
        this.processedAlready.clear();
    }

    protected void processOrderByExpressionsInOrderByClause() {
        Iterator iter = this.query.getOrderByExpresions().iterator();
        while (iter.hasNext()) {
            OrderByElement oe = (OrderByElement)iter.next();
            SimpleOperand op = (SimpleOperand)oe.getOperand();
            if (op == null || op.getFeature() == null || oe.getOperator() == null || this.processedAlready.contains(op.getFeature())) continue;
            this.processedAlready.add(op.getFeature());
            if (this.first) {
                this.statement.append(" ORDER BY ");
                this.first = false;
            } else {
                this.statement.append(", ");
            }
            DBMap.AttributeData data = (DBMap.AttributeData)this.dbMap.getDBRepresentation((EModelElement)op.getFeature());
            this.statement.append(this.addQuotes(data.getValueColumn().getName()));
            this.statement.append(" ");
            this.statement.append(oe.getOperator().getName());
        }
    }

    protected void createSelectFrom() {
        this.first = true;
        this.all = false;
        this.fromSet.clear();
        this.processedAlready.clear();
        this.processOutputElementsInSelectFrom();
        this.processOrderByInSelectFrom();
        this.processWhereClauseInSelectFrom();
        this.processedAlready.clear();
        this.first = true;
        this.processFromSet();
        this.processedAlready.clear();
    }

    protected void processWhereClauseInSelectFrom() {
        Iterator iter = QueryUtils.getClassPredicatesNoSubClassesIndex((SimpleSearchQuery)this.query).keySet().iterator();
        while (iter.hasNext()) {
            EClass type = (EClass)iter.next();
            String tableName = null;
            DBMap.ClassData data = (DBMap.ClassData)this.dbMap.getDBRepresentation((EModelElement)type);
            tableName = data.getTable().getName();
            if (tableName == null) continue;
            this.fromSet.add(tableName);
        }
    }

    protected void processFromSet() {
        Iterator iter = this.fromSet.iterator();
        while (iter.hasNext()) {
            String tableName = (String)iter.next();
            if (this.processedAlready.contains(tableName)) continue;
            if (this.first) {
                this.statement.append(" FROM ");
                this.first = false;
            } else {
                this.statement.append(", ");
            }
            this.statement.append(this.addQuotes(tableName));
        }
    }

    protected void processOutputElementsInSelectFrom() {
        Iterator iter = this.query.getOutputElements().iterator();
        while (iter.hasNext()) {
            SimpleOperand oe = (SimpleOperand)iter.next();
            if (this.processedAlready.contains(this.getOperandType(oe))) continue;
            if (this.first) {
                this.statement.append("SELECT ");
                if (this.query.isDistinct()) {
                    this.statement.append("DISTINCT ");
                }
                this.first = false;
            } else {
                this.statement.append(", ");
            }
            this.fromSet.add(this.addOperandName(oe));
        }
        if (this.first && this.query.isCount()) {
            this.statement.append("SELECT ");
            this.statement.append("COUNT(*) ");
            this.all = true;
            this.first = false;
        } else if (this.first) {
            this.statement.append("SELECT ");
            if (this.query.isDistinct()) {
                this.statement.append("DISTINCT ");
            }
            this.statement.append("* ");
            this.all = true;
            this.first = false;
        }
    }

    protected void processOrderByInSelectFrom() {
        if (!this.all && this.query.isDistinct()) {
            Iterator iter = this.query.getOrderByExpresions().iterator();
            while (iter.hasNext()) {
                OrderByElement oe = (OrderByElement)iter.next();
                if (this.processedAlready.contains(this.getOperandType((SimpleOperand)oe.getOperand()))) continue;
                if (this.first) {
                    this.statement.append("SELECT ");
                    if (this.query.isDistinct()) {
                        this.statement.append("DISTINCT ");
                    }
                    this.first = false;
                } else {
                    this.statement.append(", ");
                }
                this.fromSet.add(this.addOperandName((SimpleOperand)oe.getOperand()));
            }
        }
    }

    protected String addOperandName(SimpleOperand oe) {
        String tableName = "";
        String columnName = "";
        if (oe.getFeature() != null) {
            this.processedAlready.add(oe.getFeature());
            if (oe.getFeature() instanceof EAttribute) {
                DBMap.AttributeData data = (DBMap.AttributeData)this.dbMap.getDBRepresentation((EModelElement)oe.getFeature());
                tableName = data.getValueColumn().getTable().getName();
                columnName = data.getValueColumn().getName();
            } else {
                DBMap.ReferenceData data = (DBMap.ReferenceData)this.dbMap.getDBRepresentation((EModelElement)oe.getFeature());
                tableName = data.getTable().getName();
                columnName = data.getTargetColumn().getName();
            }
        } else if (oe.getType() != null) {
            this.processedAlready.add(oe.getType());
            DBMap.ClassData data = (DBMap.ClassData)this.dbMap.getDBRepresentation((EModelElement)oe.getType());
            tableName = data.getTable().getName();
            columnName = this.dbMap.getClassMetadata(oe.getType()).getPrimaryKey().getName();
        }
        if (this.query.isCount()) {
            this.statement.append("COUNT(");
        }
        this.statement.append(this.addQuotes(tableName));
        this.statement.append('.');
        this.statement.append(this.addQuotes(columnName));
        if (this.query.isCount()) {
            this.statement.append(")");
        }
        return tableName;
    }

    protected EObject getOperandType(SimpleOperand oe) {
        if (oe.getFeature() != null) {
            return oe.getFeature();
        }
        if (oe.getType() != null) {
            return oe.getType();
        }
        return null;
    }

    protected void createWhereClause(int begin) {
        this.first = true;
        this.processedAlready.clear();
        this.processWhereExpressions();
        this.appendWhereClauseForSources();
        this.processedAlready.clear();
    }

    protected void processWhereExpressions() {
        SimpleSearchQueryParser parser = new SimpleSearchQueryParser();
        StringBuffer whereExprString = parser.parse();
        if (whereExprString.length() > 0) {
            if (this.first) {
                this.statement.append(" WHERE ");
                this.first = false;
            }
            this.statement.append(whereExprString);
        }
    }

    protected void processRightOperand(BinaryExpression sbe) {
        SimpleOperand ro = this.getRightOperand(sbe);
        if (ro.getFeature() != null) {
            this.addRightOperand((EModelElement)ro.getFeature());
        } else if (ro.getType() != null) {
            this.addRightOperand((EModelElement)ro.getType());
        } else if (this.getRightOperandValue(sbe) instanceof String) {
            this.statement.append("'");
            this.statement.append(ro.toString());
            this.statement.append("'");
        } else if (this.getRightOperandValue(sbe) instanceof Boolean) {
            this.statement.append("'");
            this.statement.append((Boolean)this.getRightOperandValue(sbe) != false ? (char)'1' : '0');
            this.statement.append("'");
        } else {
            this.statement.append(this.getRightOperandValue(sbe).toString());
        }
    }

    protected Object getRightOperandValue(BinaryExpression sbe) {
        if (!sbe.getRightOperands().isEmpty() && sbe.getRightOperands().get(0) != null) {
            return ((SimpleOperand)sbe.getRightOperands().get(0)).getValue();
        }
        return null;
    }

    protected SimpleOperand getRightOperand(BinaryExpression sbe) {
        if (!sbe.getRightOperands().isEmpty() && sbe.getRightOperands().get(0) != null) {
            return (SimpleOperand)sbe.getRightOperands().get(0);
        }
        return null;
    }

    protected void addRightOperand(EModelElement classifier) {
        String tableName = "";
        String columnName = "";
        if (classifier instanceof EStructuralFeature) {
            if (classifier instanceof EAttribute) {
                DBMap.AttributeData data = (DBMap.AttributeData)this.dbMap.getDBRepresentation(classifier);
                tableName = data.getValueColumn().getTable().getName();
                columnName = data.getValueColumn().getName();
            } else {
                DBMap.ReferenceData data = (DBMap.ReferenceData)this.dbMap.getDBRepresentation(classifier);
                tableName = data.getTargetColumn().getTable().getName();
                columnName = data.getTargetColumn().getName();
            }
        } else if (classifier instanceof EClass) {
            DBMap.ClassData data = (DBMap.ClassData)this.dbMap.getDBRepresentation(classifier);
            tableName = data.getTable().getName();
            columnName = this.dbMap.getClassMetadata((EClass)classifier).getPrimaryKey().getName();
        }
        if (tableName.length() > 0 && columnName.length() > 0) {
            this.statement.append(this.addQuotes(tableName));
            this.statement.append('.');
            this.statement.append(this.addQuotes(columnName));
        }
    }

    protected void appendWhereClauseForSources() {
        boolean firstSource = true;
        boolean andBracket = false;
        Iterator iter = this.query.getSources().iterator();
        while (iter.hasNext()) {
            String source = (String)iter.next();
            if (this.first) {
                this.statement.append(" WHERE (");
                this.first = false;
                firstSource = false;
            } else if (firstSource) {
                this.statement.append(" AND (");
                if (this.query.getSources().size() > 1) {
                    this.statement.append(" (");
                    andBracket = true;
                }
                firstSource = false;
            } else {
                this.statement.append(") OR (");
            }
            String containerPath = this.getObjectCompressedURIFragment(source);
            this.addContainedIn(containerPath, this.isRootObject(source));
        }
        if (this.query.getSources().size() > 0) {
            this.statement.append(") ");
        }
        if (andBracket) {
            this.statement.append(") ");
        }
    }

    protected boolean isRootObject(String source) {
        int i = source.indexOf(35);
        return i != -1 && source.indexOf(i + 1, 47) == -1;
    }

    protected void addContainedIn(String containerPath, boolean rootObject) {
        boolean first = true;
        Iterator iter = this.query.getOutputElements().iterator();
        while (iter.hasNext()) {
            SimpleOperand output = (SimpleOperand)iter.next();
            EClass eClass = null;
            eClass = output.getFeature() != null ? output.getFeature().getEContainingClass() : output.getType();
            String tableName = this.dbMap.getClassMetadata(eClass).getTable().getName();
            if (first) {
                first = false;
            } else {
                this.statement.append(" AND ");
            }
            this.statement.append(this.addQuotes(tableName));
            this.statement.append(".");
            if (rootObject && tableName.equals("TRCAgent")) {
                this.statement.append(this.addQuotes(this.dbMap.getClassMetadata(eClass).getPrimaryKey().getName()));
                this.statement.append(" = ");
                this.statement.append(containerPath.substring(0, containerPath.indexOf(47)));
                continue;
            }
            this.statement.append(this.addQuotes("p_p"));
            this.statement.append(" LIKE ");
            this.statement.append("'" + containerPath + "%'");
        }
    }

    protected String getObjectCompressedURIFragment(String source) {
        PerfUtil p = new PerfUtil("SimpleSearchQueryStatement.getObjectCompressedURIFragment()", true);
        DBCommand command = DBCommandFactory.INSTANCE.createGetCommpressedPathByURICommand(this.helper, this.dbMap, source);
        String s = "";
        try {
            s = (String)command.execute();
        }
        catch (Exception e) {
            p.stopAndPrintStatus(e.getLocalizedMessage());
            throw new DBCollectedExceptions(e);
        }
        p.stopAndPrintStatus(s);
        return s;
    }

    public class SimpleSearchQueryParser {
        protected Map namesIndex;
        protected StringBuffer result;

        protected WhereExpression getExpression(String string) {
            return (WhereExpression)this.namesIndex.get(string);
        }

        protected Operand getOperand(String string) {
            return (Operand)this.namesIndex.get(string);
        }

        protected StringBuffer internalParse() {
            if (SimpleSearchQueryStatement.this.query.getWhereExpression() == null) {
                return this.getInternalBuffer();
            }
            this.parseWhereExpression(SimpleSearchQueryStatement.this.query.getWhereExpression());
            return this.getInternalBuffer();
        }

        protected void parseArithmeticExpression(ArithmeticExpression expression) {
            if (expression.getName() != null && expression.getName().startsWith("$")) {
                this.parseOperand(this.getOperand(expression.getName().substring(1)));
                return;
            }
            Iterator iter = expression.getArguments().iterator();
            while (iter.hasNext()) {
                Operand element = (Operand)iter.next();
                this.parseOperand(element);
            }
        }

        protected void parseBinaryExpression(BinaryExpression expression) {
            if (expression.getName() != null && expression.getName().startsWith("$")) {
                this.parseWhereExpression(this.getExpression(expression.getName().substring(1)));
                return;
            }
            Operand operand = expression.getLeftOperand();
            this.parseOperand(operand);
            this.getInternalBuffer().append(" " + RelationalOperators.getString((int)expression.getOperator().getValue()) + " ");
            if (expression.getOperator() == RelationalOperators.BETWEEN_LITERAL) {
                this.getInternalBuffer().append(" ");
                operand = (Operand)expression.getRightOperands().get(0);
                this.parseOperand(operand);
                this.getInternalBuffer().append(" AND ");
                operand = (Operand)expression.getRightOperands().get(1);
                this.parseOperand(operand);
            } else if (expression.getOperator() == RelationalOperators.IN_LITERAL) {
                boolean first = true;
                this.getInternalBuffer().append("(");
                Iterator iter = expression.getRightOperands().iterator();
                while (iter.hasNext()) {
                    if (first) {
                        first = false;
                    } else {
                        this.getInternalBuffer().append(",");
                    }
                    operand = (Operand)iter.next();
                    this.parseOperand(operand);
                }
                this.getInternalBuffer().append(") ");
            } else {
                operand = (Operand)expression.getRightOperands().get(0);
                this.parseOperand(operand);
            }
        }

        protected void parseLogicalExpression(LogicalExpression expression) {
            if (expression.getName() != null && expression.getName().startsWith("$")) {
                this.parseWhereExpression(this.getExpression(expression.getName().substring(1)));
                return;
            }
            if (expression.getOperator() == LogicalOperators.NOT_LITERAL) {
                if (!expression.getArguments().isEmpty()) {
                    this.getInternalBuffer().append(expression.getOperator().getName() + "(");
                    this.parseWhereExpression((WhereExpression)expression.getArguments().get(0));
                    this.getInternalBuffer().append(") ");
                }
            } else {
                boolean first = true;
                Iterator iter = expression.getArguments().iterator();
                while (iter.hasNext()) {
                    WhereExpression ex = (WhereExpression)iter.next();
                    if (first) {
                        this.getInternalBuffer().append("(");
                        first = false;
                    } else {
                        this.getInternalBuffer().append(" " + expression.getOperator().getName() + " ");
                    }
                    this.parseWhereExpression(ex);
                }
                if (!first) {
                    this.getInternalBuffer().append(") ");
                }
            }
        }

        protected void parseNumericFunction(NumericFunction function) {
            if (function.getName() != null && function.getName().startsWith("$")) {
                this.parseOperand(this.getOperand(function.getName().substring(1)));
                return;
            }
            Iterator iter = function.getArguments().iterator();
            while (iter.hasNext()) {
                Operand element = (Operand)iter.next();
                this.parseOperand(element);
            }
        }

        protected void parseOperand(Operand operand) {
            if (operand instanceof ArithmeticExpression) {
                this.parseArithmeticExpression((ArithmeticExpression)operand);
            } else if (operand instanceof NumericFunction) {
                this.parseNumericFunction((NumericFunction)operand);
            } else {
                this.parseSimpleOperand((SimpleOperand)operand);
            }
        }

        protected void parseSimpleOperand(SimpleOperand simpleOperand) {
            if (simpleOperand.getName() != null && simpleOperand.getName().startsWith("$")) {
                this.parseOperand(this.getOperand(simpleOperand.getName().substring(1)));
            }
            if (simpleOperand.getType() != null) {
                SimpleSearchQueryStatement.this.fromSet.add(this.addOperandName(simpleOperand));
            } else if (simpleOperand.getFeature() != null) {
                SimpleSearchQueryStatement.this.fromSet.add(this.addOperandName(simpleOperand));
            } else {
                Object v = simpleOperand.getValue();
                if (v instanceof String) {
                    this.getInternalBuffer().append("'");
                    if (simpleOperand.eContainer() instanceof BinaryExpression && ((BinaryExpression)simpleOperand.eContainer()).getOperator() == RelationalOperators.LIKE_LITERAL) {
                        this.getInternalBuffer().append(this.prepareLikeValue((String)v));
                    } else {
                        this.getInternalBuffer().append(v);
                    }
                    this.getInternalBuffer().append("'");
                } else if (v instanceof Boolean) {
                    this.getInternalBuffer().append("'");
                    this.getInternalBuffer().append((Boolean)v != false ? (char)'1' : '0');
                    this.getInternalBuffer().append("'");
                } else {
                    this.getInternalBuffer().append(v);
                }
            }
        }

        protected StringBuffer prepareLikeValue(String value) {
            StringBuffer r = new StringBuffer();
            char previous = ' ';
            int i = 0;
            while (i < value.length()) {
                if (value.charAt(i) == '*' || value.charAt(i) == '%') {
                    if (previous != '%') {
                        previous = '%';
                        r.append('%');
                    }
                } else if (value.charAt(i) == '?') {
                    previous = '_';
                    r.append('_');
                } else {
                    previous = value.charAt(i);
                    r.append(previous);
                }
                ++i;
            }
            return r;
        }

        protected void parseWhereExpression(WhereExpression expression) {
            if (expression instanceof LogicalExpression) {
                this.parseLogicalExpression((LogicalExpression)expression);
            } else {
                this.parseBinaryExpression((BinaryExpression)expression);
            }
        }

        public StringBuffer getResult() {
            return this.result;
        }

        public StringBuffer parse() {
            return this.internalParse();
        }

        protected String addOperandName(SimpleOperand oe) {
            String tableName = "";
            String columnName = "";
            if (oe.getFeature() != null) {
                SimpleSearchQueryStatement.this.processedAlready.add(oe.getFeature());
                if (oe.getFeature() instanceof EAttribute) {
                    DBMap.AttributeData data = (DBMap.AttributeData)SimpleSearchQueryStatement.this.dbMap.getDBRepresentation((EModelElement)oe.getFeature());
                    tableName = data.getValueColumn().getTable().getName();
                    columnName = data.getValueColumn().getName();
                } else {
                    DBMap.ReferenceData data = (DBMap.ReferenceData)SimpleSearchQueryStatement.this.dbMap.getDBRepresentation((EModelElement)oe.getFeature());
                    tableName = data.getTable().getName();
                    columnName = data.getTargetColumn().getName();
                }
            } else if (oe.getType() != null) {
                SimpleSearchQueryStatement.this.processedAlready.add(oe.getType());
                DBMap.ClassData data = (DBMap.ClassData)SimpleSearchQueryStatement.this.dbMap.getDBRepresentation((EModelElement)oe.getType());
                tableName = data.getTable().getName();
                columnName = SimpleSearchQueryStatement.this.dbMap.getClassMetadata(oe.getType()).getPrimaryKey().getName();
            }
            if (SimpleSearchQueryStatement.this.query.isCount()) {
                this.getInternalBuffer().append("COUNT(");
            }
            this.getInternalBuffer().append(SimpleSearchQueryStatement.this.addQuotes(tableName));
            this.getInternalBuffer().append('.');
            this.getInternalBuffer().append(SimpleSearchQueryStatement.this.addQuotes(columnName));
            if (SimpleSearchQueryStatement.this.query.isCount()) {
                this.getInternalBuffer().append(")");
            }
            return tableName;
        }

        protected StringBuffer getInternalBuffer() {
            if (this.result == null) {
                this.result = new StringBuffer();
            }
            return this.result;
        }

        protected EObject getOperandType(SimpleOperand oe) {
            if (oe.getFeature() != null) {
                return oe.getFeature();
            }
            if (oe.getType() != null) {
                return oe.getType();
            }
            return null;
        }

        public void setResultBuffer(StringBuffer result) {
            this.result = result;
        }
    }
}

