/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;

public class BasicExecutionOccurrence
extends GraphNode {
    protected Lifeline lifeline = null;
    public static final String EXEC_OCC_TAG = "Execution_Occ";

    public BasicExecutionOccurrence() {
        this.prefId = "PREF_EXEC";
    }

    public int getX() {
        if (this.lifeline == null) {
            return 0;
        }
        return this.lifeline.getX() + Metrics.getLifelineWidth() / 2 - 4;
    }

    public int getY() {
        if (this.lifeline == null) {
            return 0;
        }
        return this.lifeline.getY() + this.lifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.startEventOccurrence;
    }

    public int getWidth() {
        if (this.lifeline == null) {
            return 0;
        }
        return 8;
    }

    public int getHeight() {
        if (this.lifeline == null) {
            return 0;
        }
        return (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * (this.endEventOccurrence - this.startEventOccurrence);
    }

    public boolean contains(int _x, int _y) {
        int height;
        int width;
        int y;
        int x = this.getX();
        if (Frame.contains(x, y = this.getY(), width = this.getWidth(), height = this.getHeight(), _x, _y)) {
            return true;
        }
        return this.getNodeAt(_x, _y) != null;
    }

    public String getName() {
        if (super.getName() == null || super.getName().equals("")) {
            return this.lifeline.getToolTipText();
        }
        return super.getName();
    }

    public void setLifeline(Lifeline theLifeline) {
        this.lifeline = theLifeline;
    }

    public Lifeline getLifeline() {
        return this.lifeline;
    }

    public int getStartOccurrence() {
        return this.startEventOccurrence;
    }

    public int getEndOccurrence() {
        return this.endEventOccurrence;
    }

    public void setStartOccurrence(int occurrence) {
        this.startEventOccurrence = occurrence;
    }

    public void setEndOccurrence(int occurrence) {
        this.endEventOccurrence = occurrence;
    }

    public void draw(IGC context) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        IColor tempFillColor = null;
        IColor tempStrokeColor = null;
        Object tempImage = null;
        if (this.lifeline.isSelected() || this.isSelected()) {
            context.setBackground(Frame.getUserPref().getBackGroundColorSelection());
            context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
        } else {
            tempFillColor = this.setUnselectedFillColor(context);
        }
        if (Frame.getUserPref().useGradienColor()) {
            context.fillGradientRectangle(x, y, width, height, false);
        } else {
            context.fillRectangle(x, y, width, height);
        }
        tempStrokeColor = this.setUnselectedStrokeColor(context);
        context.drawRectangle(x, y, width, height);
        if (tempFillColor != null) {
            tempFillColor.dispose();
            tempFillColor = null;
        }
        if (tempStrokeColor != null) {
            tempStrokeColor.dispose();
            tempStrokeColor = null;
        }
        if (this.hasFocus()) {
            this.drawFocus(context);
        }
        super.drawChildsNodes(context);
    }

    protected IColor setUnselectedFillColor(IGC context) {
        if (Frame.getUserPref().useGradienColor()) {
            context.setGradientColor(Frame.getUserPref().getBackGroundColor("PREF_EXEC"));
            context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        } else {
            context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_EXEC"));
        }
        return null;
    }

    protected IColor setUnselectedStrokeColor(IGC context) {
        context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_EXEC"));
        return null;
    }

    public String getArrayId() {
        return EXEC_OCC_TAG;
    }

    public boolean positiveDistanceToPoint(int x, int y) {
        return this.getY() + this.getHeight() > y;
    }

    public boolean isVisible(int x, int y, int width, int height) {
        if (this.getLifeline() != null && this.getLifeline().isVisible(x, y, width, height)) {
            int ly = this.getY();
            int lh = this.getHeight();
            if (ly >= y && ly < y + height) {
                return true;
            }
            if (ly + lh > y && ly + lh <= y + height) {
                return true;
            }
            if (ly < y && ly + lh > y + height) {
                return true;
            }
        }
        return false;
    }
}

