/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.core.TimeEvent;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.ISDPreferences;
import org.eclipse.hyades.uml2sd.ui.preferences.SDViewPref;

public class BasicFrame
extends GraphNode {
    protected double maxTime = -50.0;
    protected double minTime = -50.0;
    protected boolean computeMinMax = true;
    protected boolean lastExternalTimePref = SDViewPref.getInstance().excludeExternalTime();
    protected int verticalIndex = 0;
    protected int horizontalIndex = 0;
    protected boolean timeInfo = false;
    private int visibleAreaX;
    private int visibleAreaY;
    private int visibleAreaWidth;
    private int visibleAreaHeight;
    protected static ISDPreferences userPref = null;
    protected String unitName = null;
    protected int forceEventOccurrenceSpacing;

    public BasicFrame() {
        Metrics.forcedEventSpacing = this.forceEventOccurrenceSpacing = -1;
    }

    protected int getMaxEventOccurrence() {
        return this.verticalIndex;
    }

    protected void setMaxEventOccurrence(int eventOccurrence) {
        this.verticalIndex = eventOccurrence;
    }

    protected int getNewHorizontalIndex() {
        return ++this.horizontalIndex;
    }

    protected int getHorizontalIndex() {
        return this.horizontalIndex;
    }

    public void addNode(GraphNode nodeToAdd) {
        this.computeMinMax = true;
        super.addNode(nodeToAdd);
    }

    public int getX() {
        return 10;
    }

    public int getY() {
        return 10;
    }

    public int getWidth() {
        if (this.horizontalIndex == 0) {
            return 3 * Metrics.swimmingLaneWidth() + 46 - 10 - 22;
        }
        return this.horizontalIndex * Metrics.swimmingLaneWidth() + 46 - 45;
    }

    public int getHeight() {
        if (this.verticalIndex == 0) {
            return 5 * (Metrics.getMessagesSpacing() + Metrics.getMessageFontHeigth()) + 14 + 4 + Metrics.getFrameFontHeigth() + 30 + 20 + 14 + 4 + Metrics.getLifelineFontHeigth() * 2;
        }
        if (this.forceEventOccurrenceSpacing >= 0) {
            Metrics.forcedEventSpacing = this.forceEventOccurrenceSpacing;
        }
        return this.verticalIndex * (Metrics.getMessagesSpacing() + Metrics.getMessageFontHeigth()) + 14 + 4 + Metrics.getFrameFontHeigth() + 30 + 20 + 14 + 4 + Metrics.getLifelineFontHeigth() * 2;
    }

    protected GraphNode getNodeFromListAt(int x, int y, List list, int fromIndex) {
        if (list == null) {
            return null;
        }
        int i = fromIndex;
        while (i < list.size()) {
            GraphNode node = (GraphNode)list.get(i);
            if (node instanceof Lifeline && node.getX() > this.visibleAreaX + this.visibleAreaWidth || (node.getHeight() >= 0 ? node.getY() > this.visibleAreaY + this.visibleAreaHeight : node.getY() + node.getHeight() > this.visibleAreaY + this.visibleAreaHeight)) break;
            if (node.contains(x, y)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    protected void drawFrame(IGC context) {
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME"));
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        context.fillRectangle(x, y, w, h);
        context.drawRectangle(x, y, w, h);
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME_NAME"));
        context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME_NAME"));
        context.setFont(Frame.getUserPref().getFont("PREF_FRAME_NAME"));
        int nameWidth = context.textExtent(this.getName()) + 16;
        int nameHeight = Metrics.getFrameFontHeigth() + 8;
        if (nameWidth > w) {
            nameWidth = w;
        }
        int[] points = new int[]{x, y, x + nameWidth, y, x + nameWidth, y - 11 + nameHeight, x - 11 + nameWidth, y + nameHeight, x, y + nameHeight, x, y + nameHeight};
        context.fillPolygon(points);
        context.drawPolygon(points);
        context.drawLine(x, y, x, y + nameHeight);
        context.setForeground(Frame.getUserPref().getFontColor("PREF_FRAME_NAME"));
        context.drawTextTruncatedCentred(this.getName(), x, y, nameWidth - 11, nameHeight, false);
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME"));
    }

    public void draw(IGC context) {
        this.draw(context, true);
    }

    protected void draw(IGC context, boolean drawFrame) {
        this.visibleAreaHeight = context.getVisibleHeight();
        this.visibleAreaWidth = context.getVisibleWidth();
        this.visibleAreaX = context.getContentsX();
        this.visibleAreaY = context.getContentsY();
        Metrics.forcedEventSpacing = this.forceEventOccurrenceSpacing >= 0 ? this.forceEventOccurrenceSpacing : -1;
        if (userPref == null) {
            return;
        }
        super.drawChildsNodes(context);
    }

    public static void setUserPref(ISDPreferences pref) {
        userPref = pref;
    }

    public static ISDPreferences getUserPref() {
        return userPref;
    }

    public void setTimeUnitName(String name) {
        this.unitName = name;
    }

    public String getTimeUnitName() {
        return this.unitName;
    }

    public void forceEventOccurrenceSpacing(int space) {
        this.forceEventOccurrenceSpacing = space;
    }

    public int getVisibleAreaX() {
        return this.visibleAreaX;
    }

    public int getVisibleAreaWidth() {
        return this.visibleAreaWidth;
    }

    public int getVisibleAreaHeight() {
        return this.visibleAreaHeight;
    }

    public int getVisibleAreaY() {
        return this.visibleAreaY;
    }

    public double getMinTime() {
        if (this.lastExternalTimePref != SDViewPref.getInstance().excludeExternalTime()) {
            this.lastExternalTimePref = SDViewPref.getInstance().excludeExternalTime();
            this.computeMinMax = true;
        }
        if (this.computeMinMax) {
            this.computeMinMax();
            this.computeMinMax = false;
        }
        return this.minTime;
    }

    public double getMaxTime() {
        if (this.lastExternalTimePref != SDViewPref.getInstance().excludeExternalTime()) {
            this.lastExternalTimePref = SDViewPref.getInstance().excludeExternalTime();
            this.computeMinMax = true;
        }
        if (this.computeMinMax) {
            this.computeMinMax();
            this.computeMinMax = false;
        }
        return this.maxTime;
    }

    protected void computeMinMax() {
        List timeArray = this.buildTimeArray();
        if (timeArray == null) {
            return;
        }
        int i = 0;
        while (i < timeArray.size() - 1) {
            TimeEvent m1 = (TimeEvent)timeArray.get(i);
            TimeEvent m2 = (TimeEvent)timeArray.get(i + 1);
            if (this.computeMinMax) {
                this.minTime = m2.getTime() - m1.getTime();
                if (this.minTime < 0.0) {
                    this.minTime = 0.0;
                }
                this.maxTime = this.minTime;
                this.computeMinMax = false;
            }
            if (m2.getTime() - m1.getTime() < this.minTime && m2.getTime() - m1.getTime() > 0.0) {
                this.minTime = m2.getTime() - m1.getTime();
            }
            if (m2.getTime() - m1.getTime() > this.maxTime && m2.getTime() - m1.getTime() > 0.0) {
                this.maxTime = m2.getTime() - m1.getTime();
            }
            ++i;
        }
    }

    protected List buildTimeArray() {
        if (!this.hasChilds) {
            return null;
        }
        Iterator it = this.fSort.keySet().iterator();
        ArrayList<TimeEvent> timeArray = new ArrayList<TimeEvent>();
        while (it.hasNext()) {
            Object nodeType = it.next();
            GraphNode node = (GraphNode)((List)this.nodes.get(nodeType)).get(0);
            List list = (List)this.nodes.get(nodeType);
            int i = 0;
            while (i < list.size()) {
                Object timedNode = list.get(i);
                if (timedNode instanceof ITimeRange && ((ITimeRange)timedNode).hasTimeInfo()) {
                    int event = ((GraphNode)list.get(i)).getStartOccurrence();
                    double time = ((ITimeRange)list.get(i)).getFirstTime();
                    TimeEvent f = new TimeEvent(time, event, (ITimeRange)list.get(i));
                    timeArray.add(f);
                    if (event != ((GraphNode)list.get(i)).getEndOccurrence()) {
                        event = ((AsyncMessage)list.get(i)).getEndOccurrence();
                        time = ((ITimeRange)list.get(i)).getLastTime();
                        f = new TimeEvent(time, event, (ITimeRange)list.get(i));
                        timeArray.add(f);
                    }
                }
                ++i;
            }
        }
        return timeArray;
    }

    public String getArrayId() {
        return null;
    }

    public boolean contains(int x, int y) {
        return false;
    }
}

