/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.load;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;

public class LoadersManager {
    private static LoadersManager loadersManager;
    private static HashMap map;
    private static SDView currentView;
    private String primaryViewId = null;

    private LoadersManager() {
        map = new HashMap();
    }

    public static LoadersManager getLoadersManager() {
        if (loadersManager == null) {
            loadersManager = new LoadersManager();
        }
        return loadersManager;
    }

    public IUml2SDLoader createLoader(String className, ClassLoader cl, SDView view) {
        IUml2SDLoader loader = this.createLoaderInstance(className, cl);
        this.associateLoader(loader, view);
        return loader;
    }

    public IUml2SDLoader createLoaderInstance(String className, ClassLoader cl) {
        IUml2SDLoader loader = null;
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            Class<?> clazz = cl.loadClass(className);
            loader = (IUml2SDLoader)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return loader;
    }

    public void associateLoader(IUml2SDLoader loader, SDView view) {
        if (view != null) {
            this.setCurrentLoader(loader, view.getViewSite().getId());
        }
        if (loader != null) {
            loader.setViewer(view);
        }
    }

    public void setCurrentLoader(IUml2SDLoader loader, String id) {
        IWorkbenchPage persp;
        if (id == null) {
            return;
        }
        IUml2SDLoader currentLoader = null;
        if (map.get(id) instanceof IUml2SDLoader) {
            currentLoader = (IUml2SDLoader)map.get(id);
        }
        if (currentLoader != null && currentLoader != loader) {
            if (loader != null) {
                persp = UIPlugin.getActivePage();
                try {
                    SDView sdview = null;
                    IViewReference viewref = persp.findViewReference(id);
                    if (viewref != null) {
                        sdview = (SDView)viewref.getView(false);
                    }
                    if (sdview != null) {
                        sdview.resetProviders();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            currentLoader.aboutToBeReplaced();
        }
        persp = UIPlugin.getActivePage();
        map.put(id, loader);
        if (loader != null && id != null) {
            SDViewerPlugin.getDefault().setLastLoader(loader.getClass().getName(), id);
        }
    }

    public void resetLoader(String viewId) {
        IUml2SDLoader loader = (IUml2SDLoader)map.get(viewId);
        if (loader != null) {
            loader.aboutToBeReplaced();
        }
        map.put(viewId, null);
    }

    public IUml2SDLoader getCurrentLoader(String viewId) {
        return this.getCurrentLoader(viewId, null);
    }

    public IUml2SDLoader getCurrentLoader(String viewId, SDView view) {
        if (viewId == null) {
            return null;
        }
        IWorkbenchPage persp = UIPlugin.getActivePage();
        try {
            Object loader;
            if (view == null) {
                SDView v = null;
                IViewReference viewref = persp.findViewReference(viewId);
                if (viewref != null) {
                    v = (SDView)viewref.getView(false);
                }
                if (v == null) {
                    return null;
                }
            }
            if ((loader = map.get(viewId)) == null) {
                this.createLastLoaderIfAny(viewId);
                loader = map.get(viewId);
            }
            if (loader instanceof IUml2SDLoader) {
                return (IUml2SDLoader)loader;
            }
            return null;
        }
        catch (Exception e) {
            block8: {
                if (!SDViewerPlugin.debug()) break block8;
                e.printStackTrace();
            }
            return null;
        }
    }

    private void createLastLoaderIfAny(String viewId) {
        String loader = SDViewerPlugin.getDefault().getSavedLoader(viewId);
        ConfigurationElement ce = null;
        List loaders = SDViewerPlugin.getLoaders(viewId);
        if (loader != null && loader.length() > 0) {
            Iterator i = loaders.iterator();
            while (i.hasNext()) {
                ce = (ConfigurationElement)i.next();
                if (!ce.getAttribute("class").equals(loader)) {
                    ce = null;
                    continue;
                }
                break;
            }
        } else {
            Iterator i = loaders.iterator();
            while (i.hasNext()) {
                ce = (ConfigurationElement)i.next();
                if (!Boolean.valueOf(ce.getAttribute("default")).booleanValue()) {
                    ce = null;
                    continue;
                }
                break;
            }
        }
        if (ce != null) {
            SDViewerPlugin.createLoaderForView(viewId, (IConfigurationElement)ce);
        }
    }
}

