/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.report.svg;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.util.ExecutionUtil;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.hyades.ui.sample.HyadesSamplePlugin;
import org.eclipse.hyades.ui.sample.report.svg.DayHelper;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.SVGLineChart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGReport
implements IReportGenerator {
    private String usedClasspath = null;

    public void setUsedClasspath(String fullPath) {
        this.usedClasspath = fullPath;
    }

    public String getReportFileExtension(ISelection selection) {
        return "html";
    }

    public boolean isAvailable(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            int numberOfTestSuites = 0;
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                Object s = iter.next();
                if (s instanceof TPFTestSuite || s instanceof ITestSuiteProxyNode) {
                    ++numberOfTestSuites;
                }
                if (numberOfTestSuites < 2) continue;
                return true;
            }
        }
        return false;
    }

    public InputStream generate(IFile reportFile, ISelection selection) throws Exception {
        int numberOfTestcaseInstancesWithData;
        if (selection == null) {
            return null;
        }
        Map executionResults = ExecutionUtil.findExecutionResults((List)((IStructuredSelection)selection).toList());
        DayHelper.GraphDay.reset();
        ArrayList dataDays = this.analyseTestcaseInstances(executionResults);
        if (dataDays.isEmpty()) {
            return null;
        }
        DayHelper.GraphDay[] graphDays = this.createGraphDays(dataDays);
        int numberOfTestcaseInstances = this.loadExpectedExecutionValues(reportFile.getParent(), graphDays);
        if (numberOfTestcaseInstances < (numberOfTestcaseInstancesWithData = this.countTestcaseWithData(executionResults))) {
            numberOfTestcaseInstances = numberOfTestcaseInstancesWithData;
        }
        return this.generate(reportFile, graphDays, numberOfTestcaseInstances);
    }

    protected ArrayList analyseTestcaseInstances(Map executionResults) {
        Hashtable<String, DayHelper.DataDay> dataDayByDay = new Hashtable<String, DayHelper.DataDay>();
        if (executionResults != null) {
            Iterator i = executionResults.values().iterator();
            while (i.hasNext()) {
                List executionResultsList = (List)i.next();
                Hashtable lastExecutionByDay = this.getLastExecutionByDay(executionResultsList);
                Iterator iter = lastExecutionByDay.keySet().iterator();
                while (iter.hasNext()) {
                    String day = (String)iter.next();
                    TPFExecutionResult executionResult = (TPFExecutionResult)lastExecutionByDay.get(day);
                    DayHelper.DataDay dataDay = (DayHelper.DataDay)dataDayByDay.get(day);
                    if (dataDay == null) {
                        dataDay = new DayHelper.DataDay(day);
                        dataDayByDay.put(day, dataDay);
                    }
                    dataDay.addVerdict((TPFTestSuite)executionResult.getTest(), executionResult.getVerdict());
                }
            }
        }
        return new ArrayList(dataDayByDay.values());
    }

    protected String getDayTime(long timestamp) {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(timestamp));
    }

    protected Hashtable getLastExecutionByDay(List executionResultsList) {
        Hashtable<String, TPFExecutionResult> executionByDayTime = new Hashtable<String, TPFExecutionResult>();
        Hashtable<String, String> latestTimeByDay = new Hashtable<String, String>();
        if (executionResultsList != null) {
            Iterator i = executionResultsList.iterator();
            while (i.hasNext()) {
                String dayTime;
                EList events;
                TPFExecutionHistory executionHistory;
                TPFExecutionResult executionResult = (TPFExecutionResult)i.next();
                if (executionResult == null || (executionHistory = executionResult.getExecutionHistory()) == null || (events = executionHistory.getExecutionEvents()) == null || events.isEmpty() || (dayTime = this.getDayTime(((TPFExecutionEvent)events.get(0)).getTimestamp())) == null) continue;
                String day = dayTime.substring(0, "yyyyMMdd".length());
                String time = dayTime.substring("yyyyMMdd".length());
                executionByDayTime.put(dayTime, executionResult);
                String latestTime = (String)latestTimeByDay.get(day);
                if (latestTime != null && time.compareTo(latestTime) <= 0) continue;
                latestTimeByDay.put(day, time);
            }
        }
        Hashtable lastExecutionByDay = new Hashtable();
        Iterator iter = latestTimeByDay.keySet().iterator();
        while (iter.hasNext()) {
            String day = (String)iter.next();
            String latestTime = (String)latestTimeByDay.get(day);
            lastExecutionByDay.put(day, executionByDayTime.get(day + latestTime));
        }
        return lastExecutionByDay;
    }

    protected DayHelper.GraphDay[] createGraphDays(ArrayList dataDays) {
        Object[] dataDayArray = dataDays.toArray(new DayHelper.DataDay[dataDays.size()]);
        Arrays.sort(dataDayArray);
        ArrayList<Object> graphDays = new ArrayList<Object>();
        Hashtable<TPFTestSuite, TPFVerdict> lastStatusByTestcaseInstance = new Hashtable<TPFTestSuite, TPFVerdict>();
        int i = 0;
        int max = dataDayArray.length;
        while (i < max) {
            Iterator iter = ((DayHelper.DataDay)dataDayArray[i]).testcaseIterator();
            while (iter.hasNext()) {
                TPFTestSuite testSuite = (TPFTestSuite)iter.next();
                lastStatusByTestcaseInstance.put(testSuite, ((DayHelper.DataDay)dataDayArray[i]).getVerdict(testSuite));
            }
            DayHelper.GraphDay graphDay = new DayHelper.GraphDay(((DayHelper.DataDay)dataDayArray[i]).getDay());
            graphDays.add(graphDay);
            Iterator iter2 = lastStatusByTestcaseInstance.values().iterator();
            while (iter2.hasNext()) {
                TPFVerdict executionVerdict = (TPFVerdict)iter2.next();
                graphDay.addStatistic(-104, 1);
                if (executionVerdict == TPFVerdict.ERROR_LITERAL) {
                    graphDay.addStatistic(-103, 1);
                    continue;
                }
                if (executionVerdict == TPFVerdict.PASS_LITERAL) {
                    graphDay.addStatistic(-102, 1);
                    continue;
                }
                if (executionVerdict == TPFVerdict.FAIL_LITERAL) {
                    graphDay.addStatistic(-101, 1);
                    continue;
                }
                if (executionVerdict != TPFVerdict.INCONCLUSIVE_LITERAL) continue;
                graphDay.addStatistic(-100, 1);
            }
            if (i < max - 1) {
                DayHelper.GraphDay repeatedGraphDay = ((DayHelper.GraphDay)graphDay.clone()).incrementDay();
                while (repeatedGraphDay.getDay().compareTo(((DayHelper.DataDay)dataDayArray[i + 1]).getDay()) < 0) {
                    graphDays.add(repeatedGraphDay.clone());
                    repeatedGraphDay.incrementDay();
                }
            }
            ++i;
        }
        return graphDays.toArray(new DayHelper.GraphDay[graphDays.size()]);
    }

    protected int loadExpectedExecutionValues(IContainer container, DayHelper.GraphDay[] graphDays) {
        IFile file = container.getFile((IPath)new Path("expected_execution.xml"));
        if (file == null || !file.exists()) {
            return 0;
        }
        Element topElement = null;
        Document document = XMLUtil.getXmlDom((String)file.getLocation().makeAbsolute().toOSString());
        NodeList list = document.getElementsByTagName("ComponentTest_ExpectedExecution");
        if (list.getLength() != 1 || !(list.item(0) instanceof Element)) {
            return 0;
        }
        int maxTestcaseInstaceCount = 0;
        int attempt = 0;
        int error = 0;
        int pass = 0;
        int fail = 0;
        int inconclusive = 0;
        int oldIndex = 0;
        topElement = (Element)list.item(0);
        list = topElement.getElementsByTagName("day");
        int i = 0;
        int max = list.getLength();
        while (i < max) {
            Element dayElement;
            int index;
            Node item = list.item(i);
            if (item instanceof Element && (index = XMLUtil.getIntValue((Element)(dayElement = (Element)item), (String)"index")) > 0) {
                if (--index >= graphDays.length) break;
                if (index < graphDays.length) {
                    int j = oldIndex;
                    while (j < index) {
                        graphDays[j].addStatistic(-109, attempt);
                        graphDays[j].addStatistic(-108, error);
                        graphDays[j].addStatistic(-107, pass);
                        graphDays[j].addStatistic(-106, fail);
                        graphDays[j].addStatistic(-105, inconclusive);
                        ++j;
                    }
                    attempt = XMLUtil.getIntValue((Element)dayElement, (String)"attempt");
                    if (maxTestcaseInstaceCount < attempt) {
                        maxTestcaseInstaceCount = attempt;
                    }
                    pass = XMLUtil.getIntValue((Element)dayElement, (String)"error");
                    if (maxTestcaseInstaceCount < error) {
                        maxTestcaseInstaceCount = error;
                    }
                    if (maxTestcaseInstaceCount < (pass = XMLUtil.getIntValue((Element)dayElement, (String)"pass"))) {
                        maxTestcaseInstaceCount = pass;
                    }
                    if (maxTestcaseInstaceCount < (fail = XMLUtil.getIntValue((Element)dayElement, (String)"fail"))) {
                        maxTestcaseInstaceCount = fail;
                    }
                    if (maxTestcaseInstaceCount < (inconclusive = XMLUtil.getIntValue((Element)dayElement, (String)"inconclusive"))) {
                        maxTestcaseInstaceCount = inconclusive;
                    }
                    oldIndex = index;
                }
            }
            ++i;
        }
        int j = oldIndex;
        while (j < graphDays.length) {
            graphDays[j].addStatistic(-109, attempt);
            graphDays[j].addStatistic(-108, error);
            graphDays[j].addStatistic(-107, pass);
            graphDays[j].addStatistic(-106, fail);
            graphDays[j].addStatistic(-105, inconclusive);
            ++j;
        }
        return maxTestcaseInstaceCount;
    }

    protected int countTestcaseWithData(Map executionResults) {
        HashSet<TPFTest> set = new HashSet<TPFTest>();
        Iterator i = executionResults.values().iterator();
        while (i.hasNext()) {
            Iterator ii = ((List)i.next()).iterator();
            while (ii.hasNext()) {
                TPFExecutionResult executionResult = (TPFExecutionResult)ii.next();
                TPFTest testSuite = executionResult.getTest();
                if (!(testSuite instanceof TPFTestSuite)) continue;
                set.add(testSuite);
            }
        }
        return set.size();
    }

    protected InputStream generate(IFile reportFile, DayHelper.GraphDay[] graphDays, int numberOfTestcaseInstances) throws Exception {
        String width = "750";
        String height = "500";
        ArrayList colourPalette = new ArrayList();
        Document newDoc = this.generateDataDocument(graphDays, numberOfTestcaseInstances, colourPalette);
        if (newDoc == null) {
            return null;
        }
        GraphicDocumentProperties properties = new GraphicDocumentProperties();
        properties.setDataDocument(newDoc);
        properties.setGraphicWidth(width);
        properties.setGraphicHeight(height);
        String preferenceDir = this.getSVGPreferencePageDirectory();
        if (preferenceDir != null) {
            properties.setResourcesFolder("file://" + preferenceDir.replace('\\', '/') + "/");
        }
        properties.addGraphicColorPalette("Test Status", colourPalette.toArray(new String[colourPalette.size()]));
        properties.setGraphicColorPaletteName("Test Status");
        SVGLineChart svgLineChart = new SVGLineChart();
        Document generatedDocument = svgLineChart.generateGraphicDocument(properties);
        String svgFileName = this.createFile(reportFile, "svg", svgLineChart.serializeGeneratedDocumentToString(generatedDocument)).getName();
        StringBuffer sb = new StringBuffer();
        sb.append("<html>\n").append("<head>\n").append("<title>").append(this.getUserText("chart.Title")).append("</title>").append("</head>\n");
        sb.append("<body>\n").append("<object type=\"image/svg+xml\" data=\"");
        sb.append(svgFileName).append("\" ").append("width=\"").append(width).append("\" ");
        sb.append("height=\"").append(height).append("\" ");
        sb.append("name=\"mySvgDocument\"");
        sb.append("/>\n");
        sb.append("</body>").append("</html>");
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    protected Document generateDataDocument(DayHelper.GraphDay[] graphDays, int numberOfTestcaseInstances, ArrayList colourPalette) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element root = document.createElement("configuration");
        document.appendChild(root);
        root.setAttribute("title", this.getUserText("chart.Title"));
        root.setAttribute("legendtitle", this.getUserText("chart.Legend"));
        root.setAttribute("timestampPrefix", this.getUserText("chart.timestampPrefix"));
        Element dataUpdateElement = document.createElement("dataUpdate");
        root.appendChild(dataUpdateElement);
        Date dateNow = new Date();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
        dataUpdateElement.setAttribute("timestamp", dateFormatter.format(dateNow));
        int position = 0;
        if (this.addLineData(document, dataUpdateElement, position, this.getUserText("chart.expectedAttempt"), -109, graphDays)) {
            colourPalette.add("#D3D3D3");
            ++position;
        }
        if (this.addLineData(document, dataUpdateElement, position, this.getUserText("chart.expectedPass"), -107, graphDays)) {
            colourPalette.add("#ADFF2F");
            ++position;
        }
        if (this.addLineData(document, dataUpdateElement, position, this.getUserText("chart.expectedFail"), -106, graphDays)) {
            colourPalette.add("#DB7093");
            ++position;
        }
        if (this.addLineData(document, dataUpdateElement, position, this.getUserText("chart.expectedError"), -108, graphDays)) {
            colourPalette.add("#DB9993");
            ++position;
        }
        if (this.addLineData(document, dataUpdateElement, position, this.getUserText("chart.expectedInconclusive"), -105, graphDays)) {
            colourPalette.add("#FAFAD2");
            ++position;
        }
        if (this.addLineData(document, dataUpdateElement, position, this.getUserText("chart.attempt"), -104, graphDays)) {
            colourPalette.add("#000000");
            ++position;
        }
        if (this.addLineData(document, dataUpdateElement, position, this.getUserText("chart.pass"), -102, graphDays)) {
            colourPalette.add("#008000");
            ++position;
        }
        if (this.addLineData(document, dataUpdateElement, position, this.getUserText("chart.fail"), -101, graphDays)) {
            colourPalette.add("#FF0000");
            ++position;
        }
        if (this.addLineData(document, dataUpdateElement, position, this.getUserText("chart.error"), -103, graphDays)) {
            colourPalette.add("#FFAA00");
            ++position;
        }
        if (this.addLineData(document, dataUpdateElement, position, this.getUserText("chart.inconclusive"), -100, graphDays)) {
            colourPalette.add("#FFFF00");
            ++position;
        }
        this.createXData(document, dataUpdateElement, graphDays);
        this.createYData(document, dataUpdateElement, numberOfTestcaseInstances);
        return document;
    }

    protected boolean addLineData(Document document, Element dataUpdateElement, int position, String name, int statisticFlag, DayHelper.GraphDay[] graphDays) {
        if (!DayHelper.GraphDay.hasStatistic(statisticFlag)) {
            return false;
        }
        Element dataset = document.createElement("dataSet");
        dataUpdateElement.appendChild(dataset);
        dataset.setAttribute("label", name);
        dataset.setAttribute("position", new Integer(position).toString());
        dataset.setAttribute("dataRange1Ref", "day");
        dataset.setAttribute("dataRange2Ref", "count");
        Element data = document.createElement("dataPoint");
        dataset.appendChild(data);
        data.setAttribute("value1", "0");
        data.setAttribute("value2", "0");
        int i = 0;
        while (i < graphDays.length) {
            data = document.createElement("dataPoint");
            dataset.appendChild(data);
            data.setAttribute("value1", Integer.toString(i + 1));
            data.setAttribute("value2", Integer.toString(graphDays[i].getStatistic(statisticFlag)));
            ++i;
        }
        return true;
    }

    protected void createXData(Document document, Element dataUpdateElement, DayHelper.GraphDay[] graphDays) {
        Element dataRangeElement = document.createElement("dataRange");
        dataUpdateElement.appendChild(dataRangeElement);
        StringBuffer xTitle = new StringBuffer();
        xTitle.append(this.getUserText("chart.Xtitle"));
        xTitle.append(" ").append(graphDays[0].getFormattedDay());
        dataRangeElement.setAttribute("id", "day");
        dataRangeElement.setAttribute("location", "S");
        dataRangeElement.setAttribute("label", xTitle.toString());
        Element segmentMarkerElement = document.createElement("segmentMarker");
        dataRangeElement.appendChild(segmentMarkerElement);
        segmentMarkerElement.setAttribute("value", "0");
        segmentMarkerElement.setAttribute("label", "0");
        int i = 0;
        while (i < graphDays.length) {
            segmentMarkerElement = document.createElement("segmentMarker");
            dataRangeElement.appendChild(segmentMarkerElement);
            String day = graphDays[i].getDayOfMonth();
            segmentMarkerElement.setAttribute("value", Integer.toString(i + 1));
            segmentMarkerElement.setAttribute("label", day);
            ++i;
        }
    }

    protected void createYData(Document document, Element dataUpdateElement, int numberOfTestcaseInstances) {
        Element dataRangeElement = document.createElement("dataRange");
        dataUpdateElement.appendChild(dataRangeElement);
        dataRangeElement.setAttribute("id", "count");
        dataRangeElement.setAttribute("location", "W");
        dataRangeElement.setAttribute("label", this.getUserText("chart.Ytitle"));
        int i = 0;
        while (i <= numberOfTestcaseInstances) {
            Element segmentMarkerElement = document.createElement("segmentMarker");
            dataRangeElement.appendChild(segmentMarkerElement);
            segmentMarkerElement.setAttribute("value", Integer.toString(i));
            segmentMarkerElement.setAttribute("label", Integer.toString(i));
            ++i;
        }
    }

    protected String createStyleSheet(IFile file) throws CoreException {
        StringBuffer sb = new StringBuffer();
        sb.append("rect.outline{stroke-width:0.75pt; stroke:#666666; fill:#ffffff; }\n");
        sb.append("polyline.keyline{stroke-width:0.75pt; stroke:#666666;}\n");
        sb.append("text.title{font-family:Arial; font-style:bold; font-size:11; text-anchor:left;}\n");
        sb.append("text.xtitle{font-family:Arial; font-style:regular; font-size:10; text-anchor:middle;}\n");
        sb.append("text.ytitle{font-family:Arial; font-style:regular; font-size:10; text-anchor:start; writing-mode:tb;}\n");
        sb.append("text.axislabel{font-family:Arial; font-style:regular; font-size:8; text-anchor:middle;}\n");
        sb.append("text.ydata{font-family:Arial; font-style:regular; font-size:8; text-anchor:middle;}\n");
        sb.append("text.legendtitle{font-family:Arial; font-style:regular; font-size:9; text-anchor:start;}\n");
        sb.append("text.legendlabel{font-family:Arial; font-style:regular; font-size:8; text-anchor:start;}\n");
        sb.append("polyline.grid{stroke-width:0.75pt; stroke:#000000;}\n");
        sb.append("polyline.gridline{stroke-width:0.75pt; stroke:#cccccc;}\n");
        sb.append("polyline.griddashline{stroke-width:0.75pt; stroke:#cccccc; stroke-dasharray:2; fill:none;}\n");
        sb.append("polyline.dataset0{stroke-width:0.75pt; stroke:#003399;}\n");
        sb.append("polyline.dataset1{stroke-width:0.75pt; stroke:#0066CC;}\n");
        sb.append("polyline.dataset2{stroke-width:0.75pt; stroke:#3399FF;}\n");
        sb.append("polyline.dataset3{stroke-width:0.75pt; stroke:#66CCFF;}\n");
        sb.append(".shape0{stroke:black; fill:#003399;}\n");
        sb.append(".shape1{stroke:black; fill:#0066CC;}\n");
        sb.append(".shape2{stroke:black; fill:#3399FF;}\n");
        sb.append(".shape3{stroke:black; fill:#66CCFF;}\n");
        return this.createFile(file, "css", sb.toString()).getName();
    }

    protected String getSVGPreferencePageDirectory() {
        File directory = this.getPluginDirectory();
        if (directory != null) {
            directory = new File(directory, "preferences");
        } else if (this.usedClasspath != null) {
            String classpath = this.usedClasspath;
            int index = classpath.indexOf(File.pathSeparator);
            if (index >= 0) {
                classpath = classpath.substring(0, index);
            }
            if ((index = classpath.lastIndexOf(File.separator)) >= 0) {
                classpath = classpath.substring(0, index);
            }
            directory = new File(classpath + "/preferences");
        }
        if (directory != null && directory.exists() && directory.isDirectory()) {
            return directory.getAbsolutePath();
        }
        return null;
    }

    protected File getPluginDirectory() {
        File pluginDir = null;
        try {
            URL pluginURL = new URL(HyadesSamplePlugin.getInstance().getBundle().getEntry("/"), "plugin.xml");
            File manifestFile = new File(Platform.asLocalURL((URL)pluginURL).getFile()).getAbsoluteFile();
            if (manifestFile.exists()) {
                pluginDir = manifestFile.getParentFile();
            }
        }
        catch (Throwable e) {}
        return pluginDir;
    }

    protected IFile createFile(IFile originalFile, String extension, String content) throws CoreException {
        IPath newPath = originalFile.getProjectRelativePath().removeFileExtension().addFileExtension(extension);
        IFile newFile = originalFile.getProject().getFile(newPath);
        if (newFile.exists()) {
            newFile.delete(true, true, null);
        }
        newFile.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, null);
        return newFile;
    }

    protected String getUserText(String key) {
        if ("chart.Title".equals(key)) {
            return "Test progress over time in days";
        }
        if ("chart.Legend".equals(key)) {
            return "Status";
        }
        if ("chart.timestampPrefix".equals(key)) {
            return "Last update:";
        }
        if ("chart.Xtitle".equals(key)) {
            return "Date starting at:";
        }
        if ("chart.Ytitle".equals(key)) {
            return "Tests";
        }
        if ("chart.attempt".equals(key)) {
            return "Attempt";
        }
        if ("chart.error".equals(key)) {
            return "Error";
        }
        if ("chart.pass".equals(key)) {
            return "Pass";
        }
        if ("chart.fail".equals(key)) {
            return "Fail";
        }
        if ("chart.inconclusive".equals(key)) {
            return "Inconclusive";
        }
        if ("chart.expectedAttempt".equals(key)) {
            return "Expected Attempt";
        }
        if ("chart.expectedError".equals(key)) {
            return "Expected Error";
        }
        if ("chart.expectedPass".equals(key)) {
            return "Expected Pass";
        }
        if ("chart.expectedFail".equals(key)) {
            return "Expected Fail";
        }
        if ("chart.expectedInconclusive".equals(key)) {
            return "Expected Inconclusive";
        }
        return key;
    }
}

