/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.util;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Enumeration;
import javax.net.ssl.TrustManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.security.ISecureClientParameters;
import org.eclipse.hyades.execution.security.KeystoreHelper;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.security.DuplicateUserException;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;
import org.eclipse.hyades.internal.execution.security.User;
import org.eclipse.hyades.internal.execution.security.UserFactory;
import org.eclipse.hyades.security.SecurityPlugin;
import org.eclipse.hyades.security.util.ConnectivityDialog;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ConnectUtil {
    public static final int CONNECTION_SUCCESS = 0;
    public static final int CONNECTION_CONTROLLER_ERROR = 1;
    public static final int CONNECTION_HOST_ERROR = 2;
    public static final int CONNECTION_PORT_ERROR = 3;
    public static final int CONNECTION_SECURITY_NOT_SUPPORTED = 4;
    private Application _app;
    private String _port;
    private String _hostName;
    private InetAddress _hostAddr;
    private String _userId;
    private Node _node;
    private ISecureClientParameters _parameters;
    private ConnectErrorMsg _connectErrorMessage;
    private ConnectivityDialog dlg;
    private int btnPressed = 0;
    private boolean okPressed = false;

    public ConnectUtil(String hostName, String port, Application app) {
        this(hostName, port, null, app);
    }

    public ConnectUtil(String hostName, String port, String userId, Application app) {
        this._hostName = hostName;
        this._port = port;
        this._userId = userId;
        this._app = app;
        this._connectErrorMessage = null;
    }

    public ConnectUtil(InetAddress hostAddr, String port, Application app) {
        this(hostAddr, port, null, app);
    }

    public ConnectUtil(InetAddress hostAddr, String port, String userId, Application app) {
        this._hostAddr = hostAddr;
        this._hostName = this._hostAddr.getHostName();
        this._port = port;
        this._userId = userId;
        this._app = app;
    }

    private ISecureClientParameters getClientParms() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(SecurityPlugin.getPluginId(), "JSSESecurityProviders");
        int idx = 0;
        while (idx < config.length) {
            IConfigurationElement elem = config[idx];
            String typeAttr = elem.getAttribute("name");
            String classAttr = elem.getAttribute("class");
            if (classAttr != null) {
                try {
                    Object realization = elem.createExecutableExtension("class");
                    if (realization instanceof ISecureClientParameters) {
                        ISecureClientParameters parms = (ISecureClientParameters)realization;
                        Security.addProvider(parms.getSecurityProvider());
                        parms.getKeystoreManager().setProvider(parms.getSecurityProvider());
                        return (ISecureClientParameters)realization;
                    }
                }
                catch (CoreException e) {
                    // empty catch block
                }
            }
            ++idx;
        }
        return null;
    }

    public void showErrorDialogForConnect() {
        if (this._connectErrorMessage != null) {
            this.openErrorDialog(SecurityPlugin.getResourceString("SEC_MSG"), this._connectErrorMessage.getErrorMessage(), this._connectErrorMessage.getErrorStatus());
        }
    }

    public final int connect() {
        return this.connect(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int connect(boolean showErrorMsgs) {
        X509Certificate cert;
        this._connectErrorMessage = null;
        try {
            if (this._hostAddr == null) {
                this._hostAddr = InetAddress.getByName(this._hostName);
            }
        }
        catch (UnknownHostException exc) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("TIMEOUT_NODE_ERROR_");
            text = TString.change(text, "%1", this._hostName);
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)exc);
            this._connectErrorMessage = new ConnectErrorMsg(msg, err);
            if (!showErrorMsgs) return 2;
            this.showErrorDialogForConnect();
            return 2;
        }
        try {
            if (this.checkConnectionExists()) {
                return 0;
            }
            if (this._node == null) {
                this._node = NodeFactory.createNode((InetAddress)this._hostAddr, (Principal)this._app);
            }
            this._node.connect(Integer.parseInt(this._port));
            return 0;
        }
        catch (UnknownHostException exc) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("TIMEOUT_NODE_ERROR_");
            text = TString.change(text, "%1", this._hostName);
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)exc);
            this._connectErrorMessage = new ConnectErrorMsg(msg, err);
            if (!showErrorMsgs) return 2;
            this.showErrorDialogForConnect();
            return 2;
        }
        catch (SecureConnectionRequiredException exc) {
            return this.connectUnderException((AgentControllerUnavailableException)((Object)exc), showErrorMsgs);
        }
        catch (LoginFailedException exc) {
            return this.connectUnderException((AgentControllerUnavailableException)((Object)exc), showErrorMsgs);
        }
        catch (UntrustedAgentControllerException exc) {
            TrustManager[] tManagers = this._node.getSecurityParameters().getKeystoreManager().getTrustManagers();
            cert = null;
            try {
                int i = 0;
                while (i < tManagers.length) {
                    Method getReceivedCerts = tManagers[i].getClass().getMethod("getReceivedCerts", null);
                    Object certs = getReceivedCerts.invoke((Object)tManagers[i], null);
                    if (certs != null) {
                        cert = (X509Certificate)((Object[])certs)[0];
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
        catch (AgentControllerUnavailableException exc) {
            String text2 = SecurityPlugin.getResourceString("STR_AGENT_CONTROLLER_UNAV_ERROR_");
            text2 = TString.change(text2, "%1", this._hostName);
            this.resetConnection();
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text2, (Throwable)exc);
            this._connectErrorMessage = new ConnectErrorMsg(msg, err);
            if (!showErrorMsgs) return 1;
            this.showErrorDialogForConnect();
            return 1;
        }
        catch (NumberFormatException exc) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("INVALID_PORT_ERROR_");
            text = TString.change(text, "%1", String.valueOf(this._port));
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)exc);
            this._connectErrorMessage = new ConnectErrorMsg(msg, err);
            if (!showErrorMsgs) return 3;
            this.showErrorDialogForConnect();
            return 3;
        }
        String text = SecurityPlugin.getResourceString("STR_CERTIF_UNAV_ERROR_");
        text = TString.change(text, "%1", this._hostName);
        String txt = TString.change(SecurityPlugin.getResourceString("STR_CERTIFICATE_ALERT"), "%1", this._hostName);
        int rc = 0;
        boolean ok = false;
        do {
            String[] btnLabels = new String[]{SecurityPlugin.getResourceString("STR_YES"), SecurityPlugin.getResourceString("STR_NO"), SecurityPlugin.getResourceString("STR_VIEW_DETAIL")};
            rc = this.openQuestionDialog(SecurityPlugin.getResourceString("SEC_MSG"), txt, btnLabels);
            if (rc == 0) {
                ok = this.openSaveCertificateDialog(cert);
                if (ok) continue;
                ok = this.openQuestionDialog(SecurityPlugin.getResourceString("STR_CERTIFICATE_PROP_TITLE"), SecurityPlugin.getResourceString("STR_UNTRUSTED_AGENT_CONTROLLER"), null) == 0;
                continue;
            }
            if (rc == 1) {
                ok = this.openQuestionDialog(SecurityPlugin.getResourceString("STR_CERTIFICATE_PROP_TITLE"), SecurityPlugin.getResourceString("STR_UNTRUSTED_AGENT_CONTROLLER"), null) == 0;
                continue;
            }
            this.openCertificateDetailDialog(cert);
        } while (rc == 2);
        if (!ok) {
            this.resetConnection();
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)exc);
            this._connectErrorMessage = new ConnectErrorMsg(msg, err);
            if (!showErrorMsgs) return 1;
            this.showErrorDialogForConnect();
            return 1;
        }
        ISecureClientParameters params = this._node.getSecurityParameters();
        if (params == null) return this.connect(showErrorMsgs);
        params.disableServerAuthentication();
        return this.connect(showErrorMsgs);
    }

    public String getUserId() {
        return this._userId;
    }

    public Node getNode() {
        return this._node;
    }

    private void resetConnection() {
        if (this._userId != null) {
            UserFactory.removeUser((Application)this._app, (String)this._userId);
        }
        if (this._node != null) {
            this._node.setSecurityParameters(null);
        }
    }

    private int connectUnderException(AgentControllerUnavailableException exc, boolean showErrorMsgs) {
        try {
            User user = null;
            if (this._userId != null && !this._userId.equals("")) {
                user = UserFactory.getUser((Application)this._app, (String)this._userId);
            }
            if (user == null) {
                if (exc instanceof SecureConnectionRequiredException && ((SecureConnectionRequiredException)((Object)exc)).isPasswordProtected()) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            ConnectUtil.this.dlg = new ConnectivityDialog(ConnectUtil.getValidShell(), ConnectUtil.this._hostName, ConnectUtil.this._userId, ConnectUtil.this._userId == null || ConnectUtil.this._userId.equals(""));
                            ConnectUtil.this.dlg.setDescription(SecurityPlugin.getResourceString("STR_PWD_REQ_INFO_"));
                            ConnectUtil.this.dlg.create();
                            ConnectUtil.this.openDialog(ConnectUtil.this.dlg);
                        }
                    });
                    if (this.dlg.getReturnCode() != 0) {
                        this.resetConnection();
                        String text = SecurityPlugin.getResourceString("STR_PWD_REQ_INFO_");
                        String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                        msg = TString.change(msg, "%1", this._hostName);
                        Status err = new Status(2, "org.eclipse.core.resources", 2, text, null);
                        this._connectErrorMessage = new ConnectErrorMsg(msg, err);
                        if (showErrorMsgs) {
                            this.showErrorDialogForConnect();
                        }
                        return 2;
                    }
                    this._userId = this.dlg.getUserId();
                    if (UserFactory.getUser((Application)this._app, (String)this._userId) != null) {
                        UserFactory.removeUser((Application)this._app, (String)this._userId);
                    }
                    user = UserFactory.createUser((Application)this._app, (String)this._userId, (String)this.dlg.getPassword());
                } else {
                    this._userId = "ignoredUserId";
                    user = UserFactory.createUser((Application)this._app, (String)this._userId, (String)"dummyPass");
                }
            } else if (exc instanceof LoginFailedException) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ConnectUtil.this.dlg = new ConnectivityDialog(ConnectUtil.getValidShell(), ConnectUtil.this._hostName, ConnectUtil.this._userId);
                        ConnectUtil.this.dlg.setDescription(SecurityPlugin.getResourceString("STR_LOGIN_FAILED_INFO_"));
                        ConnectUtil.this.dlg.create();
                        ConnectUtil.this.openDialog(ConnectUtil.this.dlg);
                    }
                });
                if (this.dlg.getReturnCode() != 0) {
                    this.resetConnection();
                    String text = SecurityPlugin.getResourceString("STR_PWD_REQ_INFO_");
                    String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                    msg = TString.change(msg, "%1", this._hostName);
                    Status err = new Status(2, "org.eclipse.core.resources", 2, text, null);
                    this._connectErrorMessage = new ConnectErrorMsg(msg, err);
                    if (showErrorMsgs) {
                        this.showErrorDialogForConnect();
                    }
                    return 2;
                }
                this._userId = this.dlg.getUserId();
                user = UserFactory.getUser((Application)this._app, (String)this._userId);
                if (user != null) {
                    user.setPassword(this.dlg.getPassword());
                } else {
                    try {
                        user = UserFactory.createUser((Application)this._app, (String)this._userId, (String)this.dlg.getPassword());
                    }
                    catch (DuplicateUserException e) {
                        // empty catch block
                    }
                }
            }
            if (exc instanceof SecureConnectionRequiredException) {
                this._port = new Long(((SecureConnectionRequiredException)((Object)exc)).getSecurePort()).toString();
            } else if (exc instanceof LoginFailedException) {
                this._port = new Long(((LoginFailedException)((Object)exc)).getSecurePort()).toString();
            }
            if (this._node.getSecurityParameters() == null) {
                ISecureClientParameters parms = this.getClientParms();
                if (parms == null) {
                    this.resetConnection();
                    String text = SecurityPlugin.getResourceString("STR_CLIENT_CANNOT_USE_SECURITY_ERROR_");
                    text = TString.change(text, "%1", this._hostName);
                    String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                    msg = TString.change(msg, "%1", this._hostName);
                    Status err = new Status(2, "org.eclipse.core.resources", 2, text, null);
                    this._connectErrorMessage = new ConnectErrorMsg(msg, err);
                    if (showErrorMsgs) {
                        this.showErrorDialogForConnect();
                    }
                    return 4;
                }
                this._node.setSecurityParameters(this.getClientParms());
                this._node.getSecurityParameters().getKeystoreManager().loadKeystore(this._node.getSecurityParameters().getKeystoreFileName(), this._node.getSecurityParameters().getKeystoreFilepassword());
            }
            this._node.setUser(user);
            return this.connect(showErrorMsgs);
        }
        catch (DuplicateUserException e) {
            this.resetConnection();
        }
        catch (IOException e) {
            try {
                if (this._node.getSecurityParameters() == null) {
                    this.resetConnection();
                    String text = SecurityPlugin.getResourceString("STR_CLIENT_CANNOT_USE_SECURITY_ERROR_");
                    text = TString.change(text, "%1", this._hostName);
                    String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                    msg = TString.change(msg, "%1", this._hostName);
                    Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)e);
                    this._connectErrorMessage = new ConnectErrorMsg(msg, err);
                    if (showErrorMsgs) {
                        this.showErrorDialogForConnect();
                    }
                    return 4;
                }
                KeystoreHelper.createKeyStore((String)SecurityPlugin.getKeyStoreLocation(), (String)SecurityPlugin.getWorkspaceName());
                this._node.setSecurityParameters(this.getClientParms());
                this._node.getSecurityParameters().getKeystoreManager().loadKeystore(this._node.getSecurityParameters().getKeystoreFileName(), this._node.getSecurityParameters().getKeystoreFilepassword());
                this._node.setUser(UserFactory.getUser((Application)this._app, (String)this._userId));
                return this.connect(showErrorMsgs);
            }
            catch (Exception e1) {
                this.resetConnection();
                String text = SecurityPlugin.getResourceString("STR_KEY_NOT_FOUND_ERROR_");
                text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
                String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
                msg = TString.change(msg, "%1", this._hostName);
                Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)e);
                this._connectErrorMessage = new ConnectErrorMsg(msg, err);
                if (showErrorMsgs) {
                    this.showErrorDialogForConnect();
                }
                return 2;
            }
        }
        catch (CertificateException e) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("STR_KEY_LOAD_ERROR_");
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)e);
            this._connectErrorMessage = new ConnectErrorMsg(msg, err);
            if (showErrorMsgs) {
                this.showErrorDialogForConnect();
            }
            return 2;
        }
        catch (KeyManagementException e) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("STR_KEY_MANAG_ERROR_");
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)e);
            this._connectErrorMessage = new ConnectErrorMsg(msg, err);
            if (showErrorMsgs) {
                this.showErrorDialogForConnect();
            }
            return 2;
        }
        catch (KeyStoreException e) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("STR_KEY_STORE_ERROR_");
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)e);
            this._connectErrorMessage = new ConnectErrorMsg(msg, err);
            if (showErrorMsgs) {
                this.showErrorDialogForConnect();
            }
            return 2;
        }
        catch (NoSuchAlgorithmException e) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("STR_ALGORITHM_ERROR_");
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)e);
            this._connectErrorMessage = new ConnectErrorMsg(msg, err);
            if (showErrorMsgs) {
                this.showErrorDialogForConnect();
            }
            return 2;
        }
        catch (UnrecoverableKeyException e) {
            this.resetConnection();
            String text = SecurityPlugin.getResourceString("STR_UNREC_KEY_ERROR_");
            text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
            String msg = SecurityPlugin.getResourceString("CONNECTION_FAIL_TEXT");
            msg = TString.change(msg, "%1", this._hostName);
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, (Throwable)e);
            this._connectErrorMessage = new ConnectErrorMsg(msg, err);
            if (showErrorMsgs) {
                this.showErrorDialogForConnect();
            }
            return 2;
        }
        return 0;
    }

    private boolean checkConnectionExists() {
        Node node = NodeFactory.getNode((InetAddress)this._hostAddr, (Principal)this._app);
        if (node != null && node.isConnected()) {
            this._node = node;
            return true;
        }
        return false;
    }

    private void openErrorDialog(final String title, final String msg, final Status err) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)ConnectUtil.getValidShell(), (String)title, (String)msg, (IStatus)err);
            }
        });
    }

    private void openDialog(final Dialog dialog) {
        dialog.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    private static Shell getValidShell() {
        Shell shell = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            if (workbench.getActiveWorkbenchWindow() != null && (shell = workbench.getActiveWorkbenchWindow().getShell()) != null && !shell.isDisposed()) {
                return shell;
            }
            if (workbench.getWorkbenchWindows().length > 0 && (shell = workbench.getWorkbenchWindows()[0].getShell()) != null && !shell.isDisposed()) {
                return shell;
            }
        }
        return null;
    }

    private int openQuestionDialog(final String title, final String msg, final String[] btnLabels) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (btnLabels != null) {
                    MessageDialog dialog = new MessageDialog(ConnectUtil.getValidShell(), title, null, msg, 3, btnLabels, 0);
                    ConnectUtil.this.btnPressed = dialog.open();
                } else {
                    ConnectUtil.this.btnPressed = MessageDialog.openQuestion((Shell)ConnectUtil.getValidShell(), (String)title, (String)msg) ? 0 : 1;
                }
            }
        });
        return this.btnPressed;
    }

    private void openCertificateDetailDialog(final X509Certificate certificate) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                CertificateDetails dlg = new CertificateDetails(ConnectUtil.getValidShell());
                dlg.init(certificate);
                dlg.open();
            }
        });
    }

    private boolean openSaveCertificateDialog(final X509Certificate cert) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                SaveCertificate dlg = new SaveCertificate(ConnectUtil.getValidShell());
                dlg.init(cert);
                ConnectUtil.this.okPressed = dlg.open() == 0;
            }
        });
        return this.okPressed;
    }

    private String toHexString(byte[] data) {
        StringBuffer hexString = new StringBuffer();
        int i = 0;
        while (i < data.length - 1) {
            hexString.append(Integer.toHexString(0xFF & data[i] | 0x100).substring(1));
            if ((i + 1) % 16 == 0) {
                hexString.append("\n");
            } else if ((i + 1) % 8 == 0) {
                hexString.append("    ");
            } else {
                hexString.append(" ");
            }
            ++i;
        }
        while (i < data.length) {
            hexString.append(Integer.toHexString(0xFF & data[i] | 0x100).substring(1));
            ++i;
        }
        return hexString.toString().toUpperCase();
    }

    private String getThumbprintFromCertificate(X509Certificate certificate) {
        String alg = certificate.getSigAlgName();
        try {
            alg = alg.toLowerCase().indexOf("sha") > -1 ? "SHA" : "MD5";
            MessageDigest md = MessageDigest.getInstance(alg);
            md.reset();
            byte[] encCertInfo = certificate.getEncoded();
            byte[] digest = md.digest(encCertInfo);
            return this.toHexString(digest);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean isLocalHost(String hostname) {
        String name = "localhost";
        if (name.equals(hostname)) {
            return true;
        }
        try {
            Node fnode = NodeFactory.createNode((String)name);
            name = fnode.getInetAddress().getHostName();
        }
        catch (UnknownHostException exc) {
            return false;
        }
        return hostname.equals(name);
    }

    class SaveCertificate
    extends Dialog {
        private X509Certificate cert = null;
        private String alias = null;
        private Text txtAliasValue = null;
        private Button okBtn = null;
        private String title = SecurityPlugin.getResourceString("STR_CERTIFICATE_PROP_TITLE");
        private Label lblErrMsg = null;
        private Label errorIcon = null;
        private KeyStore ks = null;

        public SaveCertificate(Shell shell) {
            super(shell);
        }

        protected void init(X509Certificate cer) {
            this.cert = cer;
            String storePath = SecurityPlugin.getKeyStoreLocation();
            String passw = SecurityPlugin.getWorkspaceName();
            try {
                this.ks = KeystoreHelper.createKeyStore((String)storePath, (String)passw);
            }
            catch (KeyStoreException exc) {
                String text = SecurityPlugin.getResourceString("STR_INITIALIZE_ERROR_");
                text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
                String msg = SecurityPlugin.getResourceString("STR_LOAD_KEYSTORE_ERROR_");
                Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc);
                ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            }
            catch (NoSuchAlgorithmException e) {
                String text = SecurityPlugin.getResourceString("STR_ALGORITHM_ERROR_");
                text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
                String msg = SecurityPlugin.getResourceString("STR_LOAD_KEYSTORE_ERROR_");
                Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)e);
                ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            }
            catch (CertificateException exc) {
                String text = SecurityPlugin.getResourceString("STR_KEY_LOAD_ERROR_");
                text = TString.change(text, "%1", storePath);
                String msg = SecurityPlugin.getResourceString("STR_LOAD_KEYSTORE_ERROR_");
                Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc);
                ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            }
            catch (NoSuchProviderException e) {
                String text = SecurityPlugin.getResourceString("STR_SECURITY_PROVIDER_ERROR_");
                String msg = SecurityPlugin.getResourceString("STR_INITIALIZE_ERROR_");
                msg = TString.change(msg, "%1", SecurityPlugin.getKeyStoreLocation());
                Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)e);
                ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            }
            catch (IOException e) {
                String text = SecurityPlugin.getResourceString("STR_LOAD_IO_EXC_");
                text = TString.change(text, "%1", storePath);
                String msg = SecurityPlugin.getResourceString("STR_LOAD_KEYSTORE_ERROR_");
                Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)e);
                ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            }
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(this.title);
            Composite content = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            GridData data = GridUtil.createFill();
            data.widthHint = 450;
            layout.numColumns = 2;
            content.setLayout((Layout)layout);
            content.setLayoutData((Object)data);
            this.errorIcon = new Label(content, 0);
            this.errorIcon.setImage(Display.getCurrent().getSystemImage(1));
            data = new GridData();
            data.horizontalIndent = 5;
            this.errorIcon.setLayoutData((Object)data);
            this.errorIcon.setVisible(false);
            this.lblErrMsg = new Label(content, 0);
            String text = SecurityPlugin.getResourceString("STR_ENTRY_IS_EMPTY");
            text = text.length() > SecurityPlugin.getResourceString("STR_ALIAS_REDUNDANT").length() ? text : SecurityPlugin.getResourceString("STR_ALIAS_REDUNDANT");
            this.lblErrMsg.setText(text);
            data = new GridData();
            data.horizontalIndent = 5;
            this.lblErrMsg.setLayoutData((Object)data);
            this.lblErrMsg.setVisible(false);
            Label lblAlias = new Label(content, 0);
            lblAlias.setText(SecurityPlugin.getResourceString("STR_PREF_ALIAS_NAME"));
            data = new GridData();
            data.verticalAlignment = 1;
            data.horizontalIndent = 5;
            lblAlias.setLayoutData((Object)data);
            this.txtAliasValue = new Text(content, 2048);
            this.txtAliasValue.addModifyListener(new ModifyListener(this){
                private final /* synthetic */ SaveCertificate this$1;
                {
                    this.this$1 = this$1;
                }

                public void modifyText(ModifyEvent e) {
                    String value = SaveCertificate.access$800(this.this$1).getText();
                    if (value == null || value.trim().length() == 0) {
                        SaveCertificate.access$900(this.this$1).setVisible(true);
                        SaveCertificate.access$900(this.this$1).setText(SecurityPlugin.getResourceString("STR_ENTRY_IS_EMPTY"));
                        SaveCertificate.access$1000(this.this$1).setVisible(true);
                        SaveCertificate.access$1100(this.this$1).setEnabled(false);
                    } else {
                        try {
                            Enumeration<String> enu = SaveCertificate.access$1200(this.this$1).aliases();
                            while (enu.hasMoreElements()) {
                                String entry = enu.nextElement();
                                if (!entry.equals(value.trim())) continue;
                                SaveCertificate.access$900(this.this$1).setVisible(true);
                                SaveCertificate.access$900(this.this$1).setText(SecurityPlugin.getResourceString("STR_ALIAS_REDUNDANT"));
                                SaveCertificate.access$1000(this.this$1).setVisible(true);
                                SaveCertificate.access$1100(this.this$1).setEnabled(false);
                            }
                        }
                        catch (Exception exp) {
                            // empty catch block
                        }
                        SaveCertificate.access$1302(this.this$1, value.trim());
                        SaveCertificate.access$900(this.this$1).setVisible(false);
                        SaveCertificate.access$1000(this.this$1).setVisible(false);
                        SaveCertificate.access$1100(this.this$1).setEnabled(true);
                    }
                }
            });
            data = new GridData(768);
            data.heightHint = 10;
            data.horizontalIndent = 5;
            this.txtAliasValue.setLayoutData((Object)data);
            return content;
        }

        protected void okPressed() {
            String storePath = SecurityPlugin.getKeyStoreLocation();
            String passw = SecurityPlugin.getWorkspaceName();
            try {
                this.ks.setCertificateEntry(this.alias, this.cert);
                KeystoreHelper.persistKeyStore((KeyStore)this.ks, (String)storePath, (String)passw);
            }
            catch (IOException e) {
                String text = SecurityPlugin.getResourceString("STR_IO_SAVE_ERROR_");
                text = TString.change(text, "%1", storePath);
                text = TString.change(text, "%1", storePath);
                String msg = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
                Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)e);
                ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            }
            catch (CertificateException exc) {
                String text = SecurityPlugin.getResourceString("STR_CERTIFICATE_STORE_ERROR_");
                text = TString.change(text, "%1", storePath);
                String msg = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
                Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc);
                ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            }
            catch (KeyStoreException exc) {
                String text = SecurityPlugin.getResourceString("STR_UNINIT_KEYSTORE_ERROR_");
                text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
                String msg = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
                Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc);
                ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            }
            catch (NoSuchAlgorithmException exc2) {
                String text = SecurityPlugin.getResourceString("STR_ALGORITHM_ERROR_");
                text = TString.change(text, "%1", SecurityPlugin.getKeyStoreLocation());
                String msg = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
                Status err = new Status(4, "org.eclipse.core.resources", 4, text, (Throwable)exc2);
                ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)msg, (IStatus)err);
            }
            this.setReturnCode(0);
            this.close();
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.okBtn = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.okBtn.setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        static /* synthetic */ Text access$800(SaveCertificate x0) {
            return x0.txtAliasValue;
        }

        static /* synthetic */ Label access$900(SaveCertificate x0) {
            return x0.lblErrMsg;
        }

        static /* synthetic */ Label access$1000(SaveCertificate x0) {
            return x0.errorIcon;
        }

        static /* synthetic */ Button access$1100(SaveCertificate x0) {
            return x0.okBtn;
        }

        static /* synthetic */ KeyStore access$1200(SaveCertificate x0) {
            return x0.ks;
        }

        static /* synthetic */ String access$1302(SaveCertificate x0, String x1) {
            x0.alias = x1;
            return x0.alias;
        }
    }

    class CertificateDetails
    extends Dialog {
        private X509Certificate cert;

        public CertificateDetails(Shell shell) {
            super(shell);
        }

        public void init(X509Certificate cer) {
            this.cert = cer;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(SecurityPlugin.getResourceString("STR_CERTIFICATE_PROP_TITLE"));
            Composite content = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            GridData data = GridUtil.createFill();
            data.widthHint = 450;
            layout.numColumns = 2;
            content.setLayout((Layout)layout);
            content.setLayoutData((Object)data);
            if (this.cert == null) {
                Label errorIcon = new Label(content, 0);
                errorIcon.setImage(Display.getCurrent().getSystemImage(1));
                data = new GridData();
                data.verticalAlignment = 2;
                data.horizontalIndent = 5;
                errorIcon.setLayoutData((Object)data);
                Label lblErrMsg = new Label(content, 0);
                lblErrMsg.setText(SecurityPlugin.getResourceString("No certificate to show"));
                data = new GridData();
                data.verticalAlignment = 8;
                data.horizontalIndent = 5;
                lblErrMsg.setLayoutData((Object)data);
                return content;
            }
            Label lblVersion = new Label(content, 0);
            lblVersion.setText(SecurityPlugin.getResourceString("STR_CERTIF_VERSION_LBL"));
            data = new GridData();
            data.horizontalIndent = 5;
            lblVersion.setLayoutData((Object)data);
            Label lblVersionValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblVersionValue.setLayoutData((Object)data);
            Label lblSubject = new Label(content, 0);
            lblSubject.setText(SecurityPlugin.getResourceString("STR_SUBJECT_LBL"));
            data = new GridData();
            data.horizontalIndent = 5;
            lblSubject.setLayoutData((Object)data);
            Label lblSubjectValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblSubjectValue.setLayoutData((Object)data);
            Label lblSigAlg = new Label(content, 0);
            lblSigAlg.setText(SecurityPlugin.getResourceString("STR_SIGALG_LBL"));
            data = new GridData();
            data.horizontalIndent = 5;
            lblSigAlg.setLayoutData((Object)data);
            Label lblSigAlgValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblSigAlgValue.setLayoutData((Object)data);
            Label lblKey = new Label(content, 0);
            lblKey.setText(SecurityPlugin.getResourceString("STR_KEY_LBL"));
            data = new GridData();
            data.horizontalIndent = 5;
            lblKey.setLayoutData((Object)data);
            Label lblKeyValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblKeyValue.setLayoutData((Object)data);
            Label lblPublicKey = new Label(content, 0);
            lblPublicKey.setText(SecurityPlugin.getResourceString("STR_PUBLIC_KEY_LBL"));
            data = new GridData();
            data.verticalAlignment = 1;
            data.horizontalIndent = 5;
            lblPublicKey.setLayoutData((Object)data);
            Text lblPublicKeyValue = new Text(content, 2632);
            data = new GridData(768);
            data.heightHint = 60;
            data.horizontalIndent = 5;
            lblPublicKeyValue.setLayoutData((Object)data);
            Label lblValidity = new Label(content, 0);
            lblValidity.setText(SecurityPlugin.getResourceString("STR_VALIDITY_LBL"));
            data = new GridData();
            data.horizontalIndent = 5;
            lblValidity.setLayoutData((Object)data);
            Label lblValidityValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblValidityValue.setLayoutData((Object)data);
            Label lblIssuedTo = new Label(content, 0);
            lblIssuedTo.setText(SecurityPlugin.getResourceString("STR_ISSUED_TO_LBL"));
            data = new GridData();
            data.verticalAlignment = 1;
            data.horizontalIndent = 5;
            lblIssuedTo.setLayoutData((Object)data);
            Label lblIssuedToValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblIssuedToValue.setLayoutData((Object)data);
            Label lblIssuedBy = new Label(content, 0);
            lblIssuedBy.setText(SecurityPlugin.getResourceString("STR_ISSUED_BY_LBL"));
            data = new GridData();
            data.horizontalIndent = 5;
            data.verticalAlignment = 1;
            lblIssuedBy.setLayoutData((Object)data);
            Label lblIssuedByValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblIssuedByValue.setLayoutData((Object)data);
            Label lblSerialNum = new Label(content, 0);
            lblSerialNum.setText(SecurityPlugin.getResourceString("STR_SERIAL_NUMBER_LBL"));
            data = new GridData();
            data.horizontalIndent = 5;
            lblSerialNum.setLayoutData((Object)data);
            Label lblSerialNumValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblSerialNumValue.setLayoutData((Object)data);
            Label lblAlgorithm = new Label(content, 0);
            lblAlgorithm.setText(SecurityPlugin.getResourceString("STR_ALGORITHM_LBL"));
            data = new GridData();
            data.horizontalIndent = 5;
            lblAlgorithm.setLayoutData((Object)data);
            Label lblAlgorithmValue = new Label(content, 0);
            data = new GridData(768);
            data.horizontalIndent = 5;
            lblAlgorithmValue.setLayoutData((Object)data);
            Label lblSignature = new Label(content, 0);
            lblSignature.setText(SecurityPlugin.getResourceString("STR_SIGNATURE_LBL"));
            data = new GridData();
            data.verticalAlignment = 1;
            data.horizontalIndent = 5;
            lblSignature.setLayoutData((Object)data);
            Text lblSignatureValue = new Text(content, 2632);
            data = new GridData(768);
            data.heightHint = 60;
            data.horizontalIndent = 5;
            lblSignatureValue.setLayoutData((Object)data);
            lblVersionValue.setText(this.cert.getType() + " V." + this.cert.getVersion());
            lblSubjectValue.setText(this.cert.getSubjectDN().getName());
            lblSigAlgValue.setText(this.cert.getSigAlgName() + ", OID = " + this.cert.getSigAlgOID());
            lblKeyValue.setText(this.cert.getPublicKey().getAlgorithm());
            lblPublicKeyValue.setText(ConnectUtil.this.toHexString(this.cert.getPublicKey().getEncoded()));
            lblIssuedToValue.setText(this.cert.getSubjectDN().getName());
            lblIssuedByValue.setText(this.cert.getIssuerDN().getName());
            DateFormat df = DateFormat.getDateInstance(1);
            String validity = SecurityPlugin.getResourceString("STR_VALIDITY_PERIOD");
            validity = TString.change(validity, "%1", df.format(this.cert.getNotBefore()));
            validity = TString.change(validity, "%2", df.format(this.cert.getNotAfter()));
            lblValidityValue.setText(validity);
            lblSerialNumValue.setText(this.cert.getSerialNumber().toString());
            lblAlgorithmValue.setText(this.cert.getSigAlgName());
            lblSignatureValue.setText(ConnectUtil.this.toHexString(this.cert.getSignature()));
            return content;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
    }

    private class ConnectErrorMsg {
        private String _errorMessage;
        private Status _status;

        public ConnectErrorMsg(String errorMessage, Status status) {
            this._errorMessage = errorMessage;
            this._status = status;
        }

        public String getErrorMessage() {
            return this._errorMessage;
        }

        public Status getErrorStatus() {
            return this._status;
        }
    }
}

