/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.security.SecurityPlugin;
import org.eclipse.hyades.security.util.ConnectivityUI;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConnectivityDialog
extends Dialog {
    private ConnectivityUI _connectivityUI;
    private String fHost;
    private String fUserId;
    private String fPassword;
    private String fDescription;
    private boolean fSelectUserField = true;

    public ConnectivityDialog(Shell shell, String host) {
        this(shell, host, "", "", true);
    }

    public ConnectivityDialog(Shell shell, String host, String userId) {
        this(shell, host, userId, "", true);
    }

    public ConnectivityDialog(Shell shell, String host, String userId, boolean selectUserField) {
        this(shell, host, userId, "", selectUserField);
    }

    public ConnectivityDialog(Shell shell, String host, String userId, String password, boolean selectUserField) {
        super(shell);
        this.fHost = host;
        this.fUserId = userId;
        this.fPassword = password;
        this.fSelectUserField = selectUserField;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(SecurityPlugin.getResourceString("SEC_MSG"));
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData data = GridUtil.createFill();
        layout.numColumns = 1;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)data);
        this._connectivityUI = new ConnectivityUI(this.getShell());
        this._connectivityUI.setUserSelection(this.fSelectUserField);
        this._connectivityUI.setDescription(this.fDescription);
        this._connectivityUI.createContents(content);
        this._connectivityUI.setHost(this.fHost);
        this._connectivityUI.setUserId(this.fUserId);
        this._connectivityUI.setPassword(this.fPassword);
        return content;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getShell().setDefaultButton(this.getButton(0));
        return control;
    }

    protected void okPressed() {
        this.fUserId = this._connectivityUI.getUserId();
        this.fPassword = this._connectivityUI.getPassword();
        if (this.fUserId.equals("")) {
            String text = SecurityPlugin.getResourceString("USER_TEXT_ERROR_");
            String info = SecurityPlugin.getResourceString("INVALID_SETTINGS");
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, null);
            ErrorDialog.openError((Shell)SecurityPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)info, (IStatus)err);
            return;
        }
        if (this.fPassword.equals("")) {
            String text = SecurityPlugin.getResourceString("PWD_TEXT_ERROR_");
            String info = SecurityPlugin.getResourceString("INVALID_SETTINGS");
            Status err = new Status(2, "org.eclipse.core.resources", 2, text, null);
            ErrorDialog.openError((Shell)SecurityPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)info, (IStatus)err);
            return;
        }
        super.okPressed();
    }

    public String getUserId() {
        return this.fUserId;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public void setDescription(String desc) {
        this.fDescription = desc;
    }
}

