/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.extension;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPartExtended;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.DataTableForm;
import org.eclipse.hyades.test.ui.internal.editor.form.DatapoolForm;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class DatapoolEditorExtension
extends BaseEditorExtension
implements IDatapoolPartExtended {
    private static final int PAGE_OVERVIEW = 0;
    public static final String EXTENSION_ID = "org.eclipse.hyades.test.ui.editor.extension.Datapool";
    private DatapoolForm datapoolForm;
    private ArrayList equivalenceClassPages = new ArrayList();
    IDatapoolListener datapoolListener = new DatapoolListener();

    public void dispose() {
        this.datapoolForm.getWidgetFactory().dispose();
        this.datapoolForm.dispose();
        Iterator it = this.equivalenceClassPages.iterator();
        while (it.hasNext()) {
            Object page = it.next();
            if (page == null) continue;
            ((DataTableForm)page).dispose();
        }
        this.equivalenceClassPages.clear();
        super.dispose();
    }

    public void createPages() {
        IHyadesEditorPart hyadesEditorPart = this.getHyadesEditorPart();
        WidgetFactory widgetFactory = new WidgetFactory();
        this.datapoolForm = new DatapoolForm(this, widgetFactory);
        hyadesEditorPart.addPage(this.datapoolForm.createControl());
        hyadesEditorPart.setPageText(0, TestUIPlugin.getString("W_OVERVIEW"));
        this.datapoolForm.updateTitle();
        DPLDatapool dp = this.getDatapool();
        int i = 0;
        while (i < dp.getEquivalenceClassCount()) {
            this.addEquivalenceClassPage(i);
            ++i;
        }
        if (dp.getEquivalenceClassCount() > 0) {
            int defaultIndex = dp.getDefaultEquivalenceClassIndex();
            defaultIndex = defaultIndex == -1 ? 0 : defaultIndex;
            hyadesEditorPart.setActivePage(this.getEquivalenceClassPageIndex(defaultIndex));
        }
        dp.addDatapoolListener(this.datapoolListener);
    }

    public void addEquivalenceClassPage(int newECIndex) {
        IDatapoolEquivalenceClass eqClass = (IDatapoolEquivalenceClass)this.getDatapool().getEquivalenceClass(newECIndex);
        IHyadesEditorPart hyadesEditorPart = this.getHyadesEditorPart();
        DataTableForm dataTableForm = new DataTableForm(this, new WidgetFactory(), eqClass);
        dataTableForm.initialize(eqClass);
        int index = hyadesEditorPart.addPage(dataTableForm.createControl());
        hyadesEditorPart.setPageText(index, eqClass.getName());
        this.equivalenceClassPages.add(newECIndex, dataTableForm);
    }

    public void removeEquivalenceClassPage(int equivalenceClassIndex) {
        DataTableForm tableForm = (DataTableForm)this.equivalenceClassPages.remove(equivalenceClassIndex);
        if (tableForm != null) {
            tableForm.dispose();
        }
        IHyadesEditorPart hyadesEditorPart = this.getHyadesEditorPart();
        int pageIndex = this.getEquivalenceClassPageIndex(equivalenceClassIndex);
        hyadesEditorPart.removePage(pageIndex);
    }

    private void moveEquivalenceClassPage(int sourceECIndex, int targetECIndex) {
        int start = Math.min(sourceECIndex, targetECIndex);
        int i = this.getDatapool().getEquivalenceClassCount() - 1;
        while (i >= start) {
            this.removeEquivalenceClassPage(i);
            --i;
        }
        int i2 = start;
        while (i2 < this.getDatapool().getEquivalenceClassCount()) {
            this.addEquivalenceClassPage(i2);
            ++i2;
        }
    }

    public int getEquivalenceClassPageIndex(int equivalenceClassIndex) {
        return 0 + equivalenceClassIndex + 1;
    }

    private int getEquivalenceClassIndexFromPageIndex(int pageIndex) {
        return pageIndex - 1;
    }

    public DPLDatapool getDatapool() {
        return (DPLDatapool)this.getHyadesEditorPart().getEditorObject();
    }

    public IStructuredSelection getSelection() {
        switch (this.getHyadesEditorPart().getActivePage()) {
            case 0: {
                return new StructuredSelection((Object)this.getDatapool());
            }
        }
        return StructuredSelection.EMPTY;
    }

    public boolean pageActivated(int index) {
        IWorkbenchPage activeWorkbenchPage = UIUtil.getActiveWorkbenchPage();
        if (activeWorkbenchPage != null) {
            try {
                activeWorkbenchPage.showView("org.eclipse.ui.views.PropertySheet", null, 2);
            }
            catch (PartInitException e) {
                // empty catch block
            }
        }
        if (index > 0) {
            int i = this.getEquivalenceClassIndexFromPageIndex(index);
            IDatapoolEquivalenceClass ec = (IDatapoolEquivalenceClass)this.getDatapool().getEquivalenceClass(i);
            if (ec != null) {
                StructuredSelection selection = new StructuredSelection((Object)ec);
                this.datapoolForm.setSelection((ISelection)selection);
            }
        }
        switch (index) {
            case 0: {
                return this.datapoolForm.activated();
            }
        }
        return false;
    }

    public void setSelection(IStructuredSelection structuredSelection) {
        Object object;
        if (structuredSelection.size() != 1 || (object = structuredSelection.getFirstElement()) == this.getDatapool()) {
            // empty if block
        }
    }

    public void refreshContent(Object data) {
        this.datapoolForm.load();
        this.datapoolForm.updateTitle();
        DPLDatapool dp = this.getDatapool();
        int i = 0;
        while (i < dp.getEquivalenceClassCount()) {
            DataTableForm dataTableForm = (DataTableForm)this.equivalenceClassPages.get(i);
            if (dataTableForm != null) {
                dataTableForm.load();
                dataTableForm.updateTitle();
                int pageIndex = this.getEquivalenceClassPageIndex(i);
                IDatapoolEquivalenceClass eqCls = (IDatapoolEquivalenceClass)dp.getEquivalenceClass(i);
                this.getHyadesEditorPart().setPageText(pageIndex, eqCls.getName());
            }
            ++i;
        }
    }

    public boolean isReadOnly() {
        return this.getHyadesEditorPart().isReadOnly();
    }

    public IActionBars getActionBars() {
        return this.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
    }

    public void notifyEdit() {
    }

    public IEditorPart getEditorPart() {
        return this.getHyadesEditorPart().getEditorPart();
    }

    protected class DatapoolListener
    implements IDatapoolListener {
        protected DatapoolListener() {
        }

        public void cellChanged(IDatapool datapool, int equivalenceClassIndex, int recordIndex, int variableIndex) {
        }

        public void equivalenceClassAdded(IDatapool datapool, int newEquivalenceClassIndex) {
            DatapoolEditorExtension.this.addEquivalenceClassPage(newEquivalenceClassIndex);
        }

        public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex, String oldName) {
        }

        public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex) {
            IDatapoolEquivalenceClass eqClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(equivalenceClassIndex);
            int pageIndex = DatapoolEditorExtension.this.getEquivalenceClassPageIndex(equivalenceClassIndex);
            DatapoolEditorExtension.this.getHyadesEditorPart().setPageText(pageIndex, eqClass.getName());
        }

        public void equivalenceClassMoved(IDatapool datapool, int sourceEquivalenceClassIndex, int targetEquivalenceClassIndex) {
            DatapoolEditorExtension.this.moveEquivalenceClassPage(sourceEquivalenceClassIndex, targetEquivalenceClassIndex);
        }

        public void equivalenceClassRemoved(IDatapool datapool, int equivalenceClassIndex) {
            DatapoolEditorExtension.this.removeEquivalenceClassPage(equivalenceClassIndex);
        }

        public void equivalenceClassReordered(IDatapool datapool, int equivalenceClassIndex) {
        }

        public void recordAdded(IDatapool datapool, int EquivClassIndex, int newRecordIndex) {
        }

        public void recordChanged(IDatapool datapool, int EquivClassIndex, int recordIndex) {
        }

        public void recordMoved(IDatapool datapool, int EquivClassIndex, int sourceRecordIndex, int targetRecordIndex) {
        }

        public void recordRemoved(IDatapool datapool, int EquivClassIndex, int recordIndex) {
        }

        public void save(IDatapool datapool) {
        }

        public void variableAdded(IDatapool datapool, int newVariableIndex) {
        }

        public void variableChanged(IDatapool datapool, int variableIndex, String oldName) {
        }

        public void variableChanged(IDatapool datapool, int variableIndex) {
        }

        public void variableMoved(IDatapool datapool, int sourceVariableIndex, int targetVariableIndex) {
        }

        public void variableRemoved(IDatapool datapool, int variableIndex) {
        }
    }
}

