/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.edit.datapool.INamedElement;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.adapter.DatapoolVariablePropertySource;
import org.eclipse.hyades.test.ui.adapter.NamedElementPropertySource;
import org.eclipse.hyades.test.ui.editor.form.util.DatapoolChildrenTreeSection;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.action.AddEquivalenceClassAction;
import org.eclipse.hyades.test.ui.internal.action.AddVariableAction;
import org.eclipse.hyades.test.ui.internal.action.MoveEquivalenceClassDown;
import org.eclipse.hyades.test.ui.internal.action.MoveEquivalenceClassUp;
import org.eclipse.hyades.test.ui.internal.action.MoveVariableDown;
import org.eclipse.hyades.test.ui.internal.action.MoveVariableUp;
import org.eclipse.hyades.test.ui.internal.action.OpenEquivalenceClassAction;
import org.eclipse.hyades.test.ui.internal.action.RemoveEquivalenceClassAction;
import org.eclipse.hyades.test.ui.internal.action.RemoveVariableAction;
import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;

public class DatapoolForm
extends EditorForm
implements ISelectionProvider,
ISelectionChangedListener {
    private NamedElementSection generalInfoSection;
    private DatapoolChildrenTreeSection variablesSection;
    private ArrayList variablePropertySourceItems = new ArrayList();
    private DatapoolChildrenTreeSection equivalenceClassSection;
    private ArrayList equivalenceClassPropertySourceItems = new ArrayList();
    private IDatapoolListener datapoolListener;
    private ListenerList selectionChangeListenerList = new ListenerList();
    private TreeViewer focusedViewer;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public DatapoolForm(DatapoolEditorExtension datapoolEditorExtension, WidgetFactory widgetFactory) {
        super(datapoolEditorExtension, widgetFactory);
        this.setHeadingText(TestUIPlugin.getString("W_DATAPOOL"));
    }

    public void dispose() {
        if (this.generalInfoSection != null) {
            this.generalInfoSection.dispose();
            this.generalInfoSection = null;
        }
        if (this.equivalenceClassSection != null) {
            this.equivalenceClassSection.dispose();
            this.equivalenceClassSection = null;
            this.equivalenceClassPropertySourceItems.clear();
            this.equivalenceClassPropertySourceItems = null;
        }
        if (this.variablesSection != null) {
            this.variablesSection.dispose();
            this.variablesSection = null;
            this.variablePropertySourceItems.clear();
            this.variablePropertySourceItems = null;
        }
        if (this.selectionChangeListenerList != null) {
            this.selectionChangeListenerList.clear();
            this.selectionChangeListenerList = null;
        }
        super.dispose();
    }

    protected DPLDatapool getDatapool() {
        return ((DatapoolEditorExtension)this.getBaseEditorExtension()).getDatapool();
    }

    public Control createControl() {
        Control control = super.createControl();
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)(TestUIPlugin.getID() + ".datf0001"));
        return control;
    }

    protected void createEditorFormContents(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        parent.setLayout((Layout)gridLayout);
        Composite leftColumn = this.createColumn(parent);
        Composite rightColumn = this.createColumn(parent);
        Control control = this.createGenericInformation(leftColumn);
        control.setLayoutData((Object)new GridData(1810));
        WorkbenchHelp.setHelp((Control)control, (String)(TestUIPlugin.getID() + ".datf0003"));
        this.createVariableSection(rightColumn);
        this.variablesSection.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.createEquivalenceClassSection(rightColumn);
        this.equivalenceClassSection.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().setSelectionProvider((ISelectionProvider)this);
    }

    protected Control createGenericInformation(Composite parent) {
        this.generalInfoSection = new NamedElementSection(this){
            private StyledText fileText;

            protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory) {
                Composite detailComposite = DatapoolForm.this.getWidgetFactory().createComposite(parent);
                GridLayout gridLayout = new GridLayout(2, false);
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
                detailComposite.setLayout((Layout)gridLayout);
                detailComposite.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                DatapoolForm.this.getWidgetFactory().createLabel(detailComposite, TestUIPlugin.getString("L_FILE"));
                this.fileText = DatapoolForm.this.getWidgetFactory().createStyledText(detailComposite, 65540);
                this.fileText.setEnabled(false);
                this.fileText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                WorkbenchHelp.setHelp((Control)this.fileText, (String)(TestUIPlugin.getID() + ".datf0002"));
            }

            public void setInput(Object object) {
                super.setInput(object);
                this.fileText.setText(EMFUtil.getFilePath((EObject)DatapoolForm.this.getDatapool()));
            }
        };
        this.registerSection(this.generalInfoSection);
        this.generalInfoSection.setHeaderText(TestUIPlugin.getString("EDT_GENERAL_INFO"));
        this.generalInfoSection.setDescription(TestUIPlugin.getString("EDT_GENERAL_DSC"));
        return this.generalInfoSection.createControl(parent, this.getWidgetFactory());
    }

    protected Control createEquivalenceClassSection(Composite parent) {
        IAction[] equivalenceClassActions = this.createEquivalenceClassActions();
        this.equivalenceClassSection = new DatapoolChildrenTreeSection(this, equivalenceClassActions, 4){

            public Object[] getChildren(IDatapool datapool) {
                if (datapool == null) {
                    return new Object[0];
                }
                if (DatapoolForm.this.equivalenceClassPropertySourceItems.size() != datapool.getEquivalenceClassCount()) {
                    DatapoolForm.this.equivalenceClassPropertySourceItems.clear();
                    IPropertySource[] eqClsPropSources = new IPropertySource[datapool.getEquivalenceClassCount()];
                    int i = 0;
                    while (i < eqClsPropSources.length) {
                        eqClsPropSources[i] = new NamedElementPropertySource((INamedElement)((IDatapoolEquivalenceClass)datapool.getEquivalenceClass(i)));
                        DatapoolForm.this.equivalenceClassPropertySourceItems.add(eqClsPropSources[i]);
                        ++i;
                    }
                }
                return DatapoolForm.this.equivalenceClassPropertySourceItems.toArray();
            }

            public Object[] getElements(IDatapool inputElement) {
                return this.getChildren(inputElement);
            }

            public Object getParent(Object element) {
                if (element instanceof IDatapoolEquivalenceClass) {
                    return ((IDatapoolEquivalenceClass)element).getDatapool();
                }
                return null;
            }

            public boolean hasChildren(IDatapool element) {
                return element != null && element.getEquivalenceClassCount() > 0;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            protected void adjustClient(Composite parent) {
                super.adjustClient(parent);
            }
        };
        this.registerSection(this.equivalenceClassSection);
        this.equivalenceClassSection.setHeaderText(TestUIPlugin.getString("DatapoolEditor.EquivalenceClasses"));
        this.equivalenceClassSection.setDescription(TestUIPlugin.getString("DatapoolEditor.EquivalenceClassesSectionDescription"));
        this.equivalenceClassSection.setCollapsable(true);
        Control control = this.equivalenceClassSection.createControl(parent, this.getWidgetFactory());
        control.setLayoutData((Object)new GridData(768));
        return control;
    }

    protected Control createVariableSection(Composite parent) {
        IAction[] variableActions = this.createVariableActions();
        this.variablesSection = new DatapoolChildrenTreeSection(this, variableActions, 4){

            public Object[] getChildren(IDatapool datapool) {
                if (datapool == null) {
                    return new Object[0];
                }
                if (DatapoolForm.this.variablePropertySourceItems.size() != datapool.getVariableCount()) {
                    DatapoolForm.this.variablePropertySourceItems.clear();
                    IPropertySource[] variablePropSources = new IPropertySource[datapool.getVariableCount()];
                    int i = 0;
                    while (i < variablePropSources.length) {
                        variablePropSources[i] = new DatapoolVariablePropertySource((IDatapoolVariable)datapool.getVariable(i));
                        DatapoolForm.this.variablePropertySourceItems.add(variablePropSources[i]);
                        ++i;
                    }
                }
                return DatapoolForm.this.variablePropertySourceItems.toArray();
            }

            public Object[] getElements(IDatapool inputElement) {
                return this.getChildren(inputElement);
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(IDatapool element) {
                return element != null && element.getVariableCount() > 0;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        this.registerSection(this.variablesSection);
        this.variablesSection.setHeaderText(TestUIPlugin.getString("DatapoolEditor.Variables"));
        this.variablesSection.setDescription(TestUIPlugin.getString("DatapoolEditor.VariablesSectionDescription"));
        this.variablesSection.setCollapsable(true);
        Control control = this.variablesSection.createControl(parent, this.getWidgetFactory());
        control.setLayoutData((Object)new GridData(768));
        return control;
    }

    private IAction[] createEquivalenceClassActions() {
        IAction[] actions = new IAction[5];
        DPLDatapool datapool = this.getDatapool();
        actions[0] = new AddEquivalenceClassAction((IDatapool)datapool, TestUIPlugin.getString("DatapoolEditor.Add"));
        actions[1] = new RemoveEquivalenceClassAction((IDatapool)this.getDatapool(), TestUIPlugin.getString("DatapoolEditor.Remove"));
        actions[2] = new MoveEquivalenceClassUp((IDatapool)this.getDatapool(), TestUIPlugin.getString("DatapoolEditor.Up"));
        actions[3] = new MoveEquivalenceClassDown((IDatapool)this.getDatapool(), TestUIPlugin.getString("DatapoolEditor.Down"));
        actions[4] = new OpenEquivalenceClassAction((DatapoolEditorExtension)this.getBaseEditorExtension(), (IDatapool)this.getDatapool(), TestUIPlugin.getString("DatapoolEditor.Open"));
        return actions;
    }

    private IAction[] createVariableActions() {
        IAction[] actions = new IAction[4];
        DPLDatapool datapool = this.getDatapool();
        actions[0] = new AddVariableAction((IDatapool)datapool, TestUIPlugin.getString("DatapoolEditor.Add"));
        actions[1] = new RemoveVariableAction((IDatapool)datapool, TestUIPlugin.getString("DatapoolEditor.Remove"));
        actions[2] = new MoveVariableUp((IDatapool)datapool, TestUIPlugin.getString("DatapoolEditor.Up"));
        actions[3] = new MoveVariableDown((IDatapool)datapool, TestUIPlugin.getString("DatapoolEditor.Down"));
        return actions;
    }

    protected IDatapoolListener getDatapoolListener() {
        if (this.datapoolListener == null) {
            this.datapoolListener = new DatapoolListener();
        }
        return this.datapoolListener;
    }

    public void load() {
        this.generalInfoSection.setInput(this.getDatapool());
        this.variablesSection.setInput(this.getDatapool());
        this.equivalenceClassSection.setInput(this.getDatapool());
        this.getDatapool().addDatapoolListener(this.getDatapoolListener());
    }

    public void updateTitle() {
        String title = ((IWorkbenchAdapter)this.getDatapool().getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = DatapoolForm.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)).getLabel((Object)this.getDatapool());
        if (title != null) {
            this.getBaseEditorExtension().getHyadesEditorPart().setTitle(title);
        }
    }

    public boolean activated() {
        return true;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() == this.variablesSection.getTreeViewer()) {
            this.focusedViewer = this.variablesSection.getTreeViewer();
        } else if (event.getSelectionProvider() == this.equivalenceClassSection.getTreeViewer()) {
            this.focusedViewer = this.equivalenceClassSection.getTreeViewer();
        }
        Object[] listeners = this.selectionChangeListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
            ++i;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListenerList.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.focusedViewer == null) {
            this.focusedViewer = this.variablesSection.getTreeViewer();
        }
        return this.focusedViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListenerList.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        int index;
        Object sel = ((IStructuredSelection)selection).getFirstElement();
        if (sel instanceof IDatapoolEquivalenceClass && (index = this.getDatapool().getEquivalenceClassIndexById(((IDatapoolEquivalenceClass)sel).getId())) > -1 && index < this.equivalenceClassPropertySourceItems.size()) {
            this.equivalenceClassSection.getTreeViewer().setSelection((ISelection)new StructuredSelection(this.equivalenceClassPropertySourceItems.get(index)));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DatapoolListener
    implements IDatapoolListener {
        DatapoolListener() {
        }

        public void cellChanged(IDatapool datapool, int equivalenceClassIndex, int recordIndex, int variableIndex) {
        }

        public void equivalenceClassAdded(IDatapool datapool, int newEquivalenceClassIndex) {
            ((DatapoolEditorExtension)DatapoolForm.this.getBaseEditorExtension()).markDirty();
            IDatapoolEquivalenceClass eqClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(newEquivalenceClassIndex);
            NamedElementPropertySource eqClsPropSource = new NamedElementPropertySource((INamedElement)eqClass);
            DatapoolForm.this.equivalenceClassSection.getTreeViewer().add((Object)datapool, (Object)eqClsPropSource);
            if (newEquivalenceClassIndex < DatapoolForm.this.equivalenceClassPropertySourceItems.size()) {
                DatapoolForm.this.equivalenceClassPropertySourceItems.add(newEquivalenceClassIndex, eqClsPropSource);
            } else if (newEquivalenceClassIndex == DatapoolForm.this.equivalenceClassPropertySourceItems.size()) {
                DatapoolForm.this.equivalenceClassPropertySourceItems.add(eqClsPropSource);
            } else {
                return;
            }
            DatapoolForm.this.equivalenceClassSection.getTreeViewer().refresh();
            DatapoolForm.this.equivalenceClassSection.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)eqClsPropSource));
        }

        public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex, String oldName) {
            DatapoolForm.this.equivalenceClassSection.getTreeViewer().refresh();
        }

        public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex) {
            ((DatapoolEditorExtension)DatapoolForm.this.getBaseEditorExtension()).markDirty();
            IPropertySource eqClsPropSource = (IPropertySource)DatapoolForm.this.equivalenceClassPropertySourceItems.get(equivalenceClassIndex);
            DatapoolForm.this.equivalenceClassSection.getTreeViewer().update((Object)eqClsPropSource, null);
            DatapoolForm.this.equivalenceClassSection.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)eqClsPropSource));
        }

        public void equivalenceClassMoved(IDatapool datapool, int sourceEquivalenceClassIndex, int targetEquivalenceClassIndex) {
            ((DatapoolEditorExtension)DatapoolForm.this.getBaseEditorExtension()).markDirty();
            Object obj = DatapoolForm.this.equivalenceClassPropertySourceItems.remove(sourceEquivalenceClassIndex);
            DatapoolForm.this.equivalenceClassPropertySourceItems.add(targetEquivalenceClassIndex, obj);
            DatapoolForm.this.equivalenceClassSection.getTreeViewer().refresh();
            DatapoolForm.this.equivalenceClassSection.getTreeViewer().setSelection((ISelection)new StructuredSelection(DatapoolForm.this.equivalenceClassPropertySourceItems.get(targetEquivalenceClassIndex)));
        }

        public void equivalenceClassRemoved(IDatapool datapool, int equivalenceClassIndex) {
            ((DatapoolEditorExtension)DatapoolForm.this.getBaseEditorExtension()).markDirty();
            Object eqClassPropSource = DatapoolForm.this.equivalenceClassPropertySourceItems.get(equivalenceClassIndex);
            if (eqClassPropSource != null) {
                DatapoolForm.this.equivalenceClassSection.getTreeViewer().remove(eqClassPropSource);
                DatapoolForm.this.equivalenceClassPropertySourceItems.remove(equivalenceClassIndex);
                DatapoolForm.this.equivalenceClassSection.getTreeViewer().refresh();
                int selection = equivalenceClassIndex < datapool.getEquivalenceClassCount() ? equivalenceClassIndex : equivalenceClassIndex - 1;
                DatapoolForm.this.equivalenceClassSection.getTreeViewer().setSelection((ISelection)new StructuredSelection(DatapoolForm.this.equivalenceClassPropertySourceItems.get(selection)));
            }
        }

        public void equivalenceClassReordered(IDatapool datapool, int equivalenceClassIndex) {
            DatapoolForm.this.equivalenceClassSection.getTreeViewer().refresh();
        }

        public void recordAdded(IDatapool datapool, int EquivClassIndex, int newRecordIndex) {
        }

        public void recordChanged(IDatapool datapool, int EquivClassIndex, int recordIndex) {
        }

        public void recordMoved(IDatapool datapool, int EquivClassIndex, int sourceRecordIndex, int targetRecordIndex) {
        }

        public void recordRemoved(IDatapool datapool, int EquivClassIndex, int recordIndex) {
        }

        public void save(IDatapool datapool) {
        }

        public void variableAdded(IDatapool datapool, int newVariableIndex) {
            IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(newVariableIndex);
            DatapoolVariablePropertySource variablePropSource = new DatapoolVariablePropertySource(variable);
            DatapoolForm.this.variablesSection.getTreeViewer().add((Object)datapool, (Object)variablePropSource);
            if (newVariableIndex < DatapoolForm.this.variablePropertySourceItems.size()) {
                DatapoolForm.this.variablePropertySourceItems.add(newVariableIndex, variablePropSource);
            } else if (newVariableIndex == DatapoolForm.this.variablePropertySourceItems.size()) {
                DatapoolForm.this.variablePropertySourceItems.add(variablePropSource);
            } else {
                return;
            }
            DatapoolForm.this.variablesSection.getTreeViewer().refresh();
            DatapoolForm.this.variablesSection.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)variablePropSource));
        }

        public void variableChanged(IDatapool datapool, int variableIndex, String oldName) {
            this.variableChanged(datapool, variableIndex);
        }

        public void variableChanged(IDatapool datapool, int variableIndex) {
            IPropertySource variablePropSource = (IPropertySource)DatapoolForm.this.variablePropertySourceItems.get(variableIndex);
            DatapoolForm.this.variablesSection.getTreeViewer().update((Object)variablePropSource, null);
            DatapoolForm.this.variablesSection.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)variablePropSource));
        }

        public void variableMoved(IDatapool datapool, int sourceVariableIndex, int targetVariableIndex) {
            Object obj = DatapoolForm.this.variablePropertySourceItems.remove(sourceVariableIndex);
            DatapoolForm.this.variablePropertySourceItems.add(targetVariableIndex, obj);
            DatapoolForm.this.variablesSection.getTreeViewer().refresh();
            DatapoolForm.this.variablesSection.getTreeViewer().setSelection((ISelection)new StructuredSelection(DatapoolForm.this.variablePropertySourceItems.get(targetVariableIndex)));
        }

        public void variableRemoved(IDatapool datapool, int variableIndex) {
            Object variablePropSource = DatapoolForm.this.variablePropertySourceItems.get(variableIndex);
            if (variablePropSource != null) {
                int selection;
                DatapoolForm.this.variablesSection.getTreeViewer().remove(variablePropSource);
                DatapoolForm.this.variablePropertySourceItems.remove(variableIndex);
                int n = selection = variableIndex < datapool.getVariableCount() ? variableIndex : variableIndex - 1;
                if (selection > -1) {
                    DatapoolForm.this.variablesSection.getTreeViewer().setSelection((ISelection)new StructuredSelection(DatapoolForm.this.variablePropertySourceItems.get(selection)));
                }
            }
        }
    }
}

